/*
 * Decompiled with CFR 0.152.
 */
package sos.configuration;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.configuration.SOSConfigurationItem;
import sos.configuration.SOSConfigurationRequiredItem;
import sos.connection.SOSConnection;
import sos.settings.SOSConnectionSettings;
import sos.settings.SOSProfileSettings;
import sos.settings.SOSXMLSettings;
import sos.util.SOSArguments;
import sos.util.SOSClassUtil;
import sos.util.SOSString;

public class SOSConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(SOSConfiguration.class);
    private SOSConfigurationItem[] sosConfigurationItem = new SOSConfigurationItem[0];
    private SOSConfigurationItem[] originParameterFromRequiredDefaults = new SOSConfigurationItem[0];
    private SOSConfigurationItem[] originParameterFromSettings = new SOSConfigurationItem[0];
    private SOSConfigurationItem[] originParameterFromScheduler = new SOSConfigurationItem[0];
    private SOSConfigurationItem[] originParameterFromArguments = new SOSConfigurationItem[0];
    private final SOSString sosString = new SOSString();
    private String[] arguments = null;
    private Properties argumentsAsProperties = null;
    private Properties schedulerParams = null;
    private String settingsFile = null;
    private String settingsTablename = null;
    private String settingsApplicationname = null;
    private String settingsProfilename = null;
    private SOSConnection sosConnection = null;
    private String requiredDefaultFile = null;
    private SOSConfigurationRequiredItem ri = null;

    public SOSConfiguration(String[] arguments, Properties schedulerParams, String settingsFile, String settingsProfilename, String requiredDefaultFile) throws Exception {
        try {
            this.arguments = arguments;
            this.schedulerParams = schedulerParams;
            this.settingsFile = settingsFile;
            this.settingsProfilename = settingsProfilename;
            this.requiredDefaultFile = requiredDefaultFile;
            this.init();
        }
        catch (Exception e) {
            throw new Exception("error in " + SOSClassUtil.getMethodName() + ": cause: " + e.getMessage(), e);
        }
    }

    public SOSConfiguration(String[] arguments, Properties schedulerParams, String settingsFile, String settingsApplicationname, String settingsProfilename, String requiredDefaultFile) throws Exception {
        try {
            this.arguments = arguments;
            this.schedulerParams = schedulerParams;
            this.settingsFile = settingsFile;
            this.settingsApplicationname = settingsApplicationname;
            this.settingsProfilename = settingsProfilename;
            this.requiredDefaultFile = requiredDefaultFile;
            this.init();
        }
        catch (Exception e) {
            throw new Exception("error in " + SOSClassUtil.getMethodName() + ": cause: " + e.getMessage(), e);
        }
    }

    public SOSConfiguration(String[] arguments, String settingsFile, String settingsProfilename) throws Exception {
        try {
            this.arguments = arguments;
            this.settingsFile = settingsFile;
            this.settingsProfilename = settingsProfilename;
            this.init();
        }
        catch (Exception e) {
            throw new Exception("error in " + SOSClassUtil.getMethodName() + ": cause: " + e.getMessage(), e);
        }
    }

    public SOSConfiguration(String[] arguments, SOSConnection sosConnection, String settingsTablename, String settingsApplicationname, String settingsProfilename) throws Exception {
        try {
            this.arguments = arguments;
            this.sosConnection = sosConnection;
            this.settingsTablename = settingsTablename;
            this.settingsApplicationname = settingsApplicationname;
            this.settingsProfilename = settingsProfilename;
            this.init();
        }
        catch (Exception e) {
            throw new Exception("error in " + SOSClassUtil.getMethodName() + ": cause: " + e.getMessage(), e);
        }
    }

    public SOSConfiguration(Properties arguments, String settingsFile, String settingsProfilename) throws Exception {
        try {
            this.argumentsAsProperties = arguments;
            this.settingsFile = settingsFile;
            this.settingsProfilename = settingsProfilename;
            this.init();
        }
        catch (Exception e) {
            throw new Exception("error in " + SOSClassUtil.getMethodName() + ": cause: " + e.getMessage(), e);
        }
    }

    public SOSConfiguration(String settingsFile, String settingsProfilename) throws Exception {
        try {
            this.settingsFile = settingsFile;
            this.settingsProfilename = settingsProfilename;
            this.init();
        }
        catch (Exception e) {
            throw new Exception("error in " + SOSClassUtil.getMethodName() + ": cause: " + e.getMessage(), e);
        }
    }

    public SOSConfiguration(String[] arguments, Properties schedulerParams, String settingsFile, String settingsProfilename) throws Exception {
        try {
            this.arguments = arguments;
            this.schedulerParams = schedulerParams;
            this.settingsFile = settingsFile;
            this.settingsProfilename = settingsProfilename;
            this.init();
        }
        catch (Exception e) {
            throw new Exception("error in " + SOSClassUtil.getMethodName() + ": cause: " + e.getMessage(), e);
        }
    }

    private void init() throws Exception {
        if (this.arguments != null) {
            this.readProgramArguments(this.arguments);
        } else {
            this.readProgramArguments(this.argumentsAsProperties);
        }
        this.readSchedulerParams(this.schedulerParams);
        this.readSettings();
        this.mergeConfigurationItem();
    }

    private void readSettings() throws Exception {
        try {
            if (this.sosConnection != null && !this.sosString.parseToString((Object)this.settingsProfilename).isEmpty()) {
                this.readConnectionSettings();
            } else if (!this.sosString.parseToString((Object)this.settingsFile).isEmpty() && !this.sosString.parseToString((Object)this.settingsProfilename).isEmpty()) {
                this.readProfileSettings();
            } else {
                this.originParameterFromSettings = new SOSConfigurationItem[0];
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void readConnectionSettings() throws Exception {
        try {
            if (this.sosConnection != null && !this.sosString.parseToString((Object)this.settingsProfilename).isEmpty()) {
                SOSConnectionSettings settings = new SOSConnectionSettings(this.sosConnection, this.settingsTablename, this.settingsApplicationname, this.settingsProfilename);
                Properties p = settings.getSection();
                this.originParameterFromSettings = new SOSConfigurationItem[p.size()];
                Iterator<Object> it = p.keySet().iterator();
                int i = 0;
                while (it.hasNext()) {
                    String key = this.sosString.parseToString(it.next());
                    this.originParameterFromSettings[i] = new SOSConfigurationItem();
                    this.originParameterFromSettings[i].setName(key);
                    this.originParameterFromSettings[i].setValue(p.getProperty(key));
                    ++i;
                }
            } else {
                this.originParameterFromSettings = new SOSConfigurationItem[0];
            }
        }
        catch (Exception e) {
            throw new Exception("error in " + SOSClassUtil.getMethodName() + ": cause: " + e.getMessage(), e);
        }
    }

    private void readProfileSettings() throws Exception {
        try {
            if (!this.sosString.parseToString((Object)this.settingsFile).isEmpty() && !this.sosString.parseToString((Object)this.settingsProfilename).isEmpty()) {
                SOSXMLSettings settings = null;
                Properties p = null;
                if (new File(this.settingsFile).getName().endsWith(".xml")) {
                    settings = new SOSXMLSettings(this.settingsFile, this.settingsProfilename);
                    p = settings.getSection(this.settingsApplicationname, this.settingsProfilename);
                } else {
                    settings = new SOSProfileSettings(this.settingsFile, this.settingsProfilename);
                    p = settings.getSection();
                }
                this.originParameterFromSettings = new SOSConfigurationItem[p.size()];
                Iterator<Object> it = p.keySet().iterator();
                int i = 0;
                while (it.hasNext()) {
                    String key = this.sosString.parseToString(it.next());
                    this.originParameterFromSettings[i] = new SOSConfigurationItem();
                    this.originParameterFromSettings[i].setName(key);
                    this.originParameterFromSettings[i].setValue(p.getProperty(key));
                    ++i;
                }
            } else {
                this.originParameterFromSettings = new SOSConfigurationItem[0];
            }
        }
        catch (Exception e) {
            throw new Exception("error in " + SOSClassUtil.getMethodName() + ": cause: " + e.getMessage(), e);
        }
    }

    private void readSchedulerParams(Properties schedulerParams) throws Exception {
        try {
            this.originParameterFromScheduler = new SOSConfigurationItem[0];
            if (schedulerParams != null) {
                this.originParameterFromScheduler = new SOSConfigurationItem[schedulerParams.size()];
                Iterator<Object> keys = schedulerParams.keySet().iterator();
                int i = 0;
                while (keys.hasNext()) {
                    String key = this.sosString.parseToString(keys.next());
                    LOGGER.debug("..scheduler param = " + key);
                    this.originParameterFromScheduler[i] = new SOSConfigurationItem();
                    this.originParameterFromScheduler[i].setName(key);
                    this.originParameterFromScheduler[i].setValue(schedulerParams.getProperty(key));
                    ++i;
                }
            } else {
                this.originParameterFromScheduler = new SOSConfigurationItem[0];
            }
        }
        catch (Exception e) {
            throw new Exception("error in " + SOSClassUtil.getMethodName() + ": cause: " + e.getMessage(), e);
        }
    }

    private void readProgramArguments(String[] arguments) throws Exception {
        try {
            if (arguments != null) {
                this.originParameterFromArguments = new SOSConfigurationItem[arguments.length];
                SOSArguments arguments_ = new SOSArguments(arguments, true);
                Iterator keys = arguments_.getArguments().keySet().iterator();
                int i = 0;
                while (keys.hasNext()) {
                    String key = this.sosString.parseToString(keys.next());
                    String newKey = key.trim().startsWith("-") && key.trim().endsWith("=") & !key.isEmpty() ? key.substring(1, key.length() - 1) : key;
                    this.originParameterFromArguments[i] = new SOSConfigurationItem();
                    this.originParameterFromArguments[i].setName(newKey);
                    this.originParameterFromArguments[i].setValue(arguments_.asString(key.toString()));
                    ++i;
                }
            } else {
                this.originParameterFromArguments = new SOSConfigurationItem[0];
            }
        }
        catch (Exception e) {
            throw new Exception("error in " + SOSClassUtil.getMethodName() + ": cause: " + e.getMessage(), e);
        }
    }

    private void readProgramArguments(Properties arguments) throws Exception {
        try {
            if (arguments != null) {
                this.originParameterFromArguments = new SOSConfigurationItem[arguments.size()];
                Iterator<Object> keys = arguments.keySet().iterator();
                int i = 0;
                while (keys.hasNext()) {
                    String key = this.sosString.parseToString(keys.next());
                    this.originParameterFromArguments[i] = new SOSConfigurationItem();
                    this.originParameterFromArguments[i].setName(key);
                    this.originParameterFromArguments[i].setValue(this.sosString.parseToString(arguments.get(key)));
                    ++i;
                }
            } else {
                this.originParameterFromArguments = new SOSConfigurationItem[0];
            }
        }
        catch (Exception e) {
            throw new Exception("error in " + SOSClassUtil.getMethodName() + ": cause: " + e.getMessage(), e);
        }
    }

    public SOSConfigurationItem[] mergeConfigurationItem() throws Exception {
        this.sosConfigurationItem = this.merge(new SOSConfigurationItem[0], this.originParameterFromSettings);
        this.sosConfigurationItem = this.merge(this.sosConfigurationItem, this.originParameterFromScheduler);
        this.sosConfigurationItem = this.merge(this.sosConfigurationItem, this.originParameterFromArguments);
        return this.sosConfigurationItem;
    }

    public SOSConfigurationItem[] getParameter() throws Exception {
        return this.sosConfigurationItem;
    }

    public Properties getParameterAsProperties() throws Exception {
        return this.getParameterAsProperties("");
    }

    public Properties getParameterAsProperties(String pstrPrefix) throws Exception {
        Properties p = new Properties();
        for (SOSConfigurationItem item : this.sosConfigurationItem) {
            String strName = item.getName();
            if (strName == null || strName.isEmpty()) continue;
            p.put(pstrPrefix + strName, item.getValue());
        }
        return p;
    }

    public void setParameter(SOSConfigurationItem[] parameter) {
        this.sosConfigurationItem = parameter;
    }

    public SOSConfigurationItem[] merge(SOSConfigurationItem[] p1, SOSConfigurationItem[] p2) throws Exception {
        String name;
        SOSConfigurationItem[] retVal = null;
        HashMap<String, SOSConfigurationItem> hp = new HashMap<String, SOSConfigurationItem>();
        for (SOSConfigurationItem element : p1) {
            name = this.sosString.parseToString((Object)element.getName());
            hp.put(name, element);
        }
        for (SOSConfigurationItem element : p2) {
            name = this.sosString.parseToString((Object)element.getName());
            hp.put(name, element);
        }
        Iterator it = hp.keySet().iterator();
        retVal = new SOSConfigurationItem[hp.keySet().size()];
        int i = 0;
        while (it.hasNext()) {
            Object key = it.next();
            retVal[i] = (SOSConfigurationItem)hp.get(key);
            ++i;
        }
        return retVal;
    }

    public SOSConfigurationItem[] checkConfigurationItems() throws Exception {
        return this.checkConfigurationItems(this.requiredDefaultFile);
    }

    public SOSConfigurationItem[] checkConfigurationItems(String requiredDefaultFile) throws Exception {
        try {
            this.ri = requiredDefaultFile == null ? new SOSConfigurationRequiredItem() : new SOSConfigurationRequiredItem(requiredDefaultFile);
            this.sosConfigurationItem = this.ri.check(this.sosConfigurationItem);
            return this.sosConfigurationItem;
        }
        catch (Exception e) {
            throw new Exception("error in " + SOSClassUtil.getMethodName() + ": cause: " + e.getMessage(), e);
        }
    }

    public SOSConfigurationItem getConfigurationItemByName(String name) throws Exception {
        try {
            SOSConfigurationItem item = null;
            if (this.ri != null && this.ri.getQuickConfigurationsItem() != null && this.ri.getQuickConfigurationsItem().containsKey(name)) {
                item = this.ri.getQuickConfigurationsItem().get(name);
            }
            if (item == null) {
                item = new SOSConfigurationItem();
            }
            return item;
        }
        catch (Exception e) {
            throw new Exception("error in " + SOSClassUtil.getMethodName() + ": cause: " + e.getMessage(), e);
        }
    }

    public Map<String, SOSConfigurationItem> getConfigurationsItems() {
        if (this.ri != null && this.ri.getQuickConfigurationsItem() != null) {
            return this.ri.getQuickConfigurationsItem();
        }
        return new HashMap<String, SOSConfigurationItem>();
    }

    public List<String> getPasswordnames() {
        if (this.ri != null && this.ri.getPasswordNames() != null) {
            return this.ri.getPasswordNames();
        }
        return new ArrayList<String>();
    }

    public SOSConfigurationItem[] getOriginParameterFromRequiredDefaults() {
        return this.originParameterFromRequiredDefaults;
    }

    public void setOriginParameterFromRequiredDefaults(SOSConfigurationItem[] originParameterFromRequiredDefaults) {
        this.originParameterFromRequiredDefaults = originParameterFromRequiredDefaults;
    }

    public SOSConfigurationItem[] getOriginParameterFromSettings() {
        return this.originParameterFromSettings;
    }

    public void setOriginParameterFromSettings(SOSConfigurationItem[] originParameterFromSettings) {
        this.originParameterFromSettings = originParameterFromSettings;
    }

    public SOSConfigurationItem[] getOriginParameterFromScheduler() {
        return this.originParameterFromScheduler;
    }

    public void setOriginParameterFromScheduler(SOSConfigurationItem[] originParameterFromScheduler) {
        this.originParameterFromScheduler = originParameterFromScheduler;
    }

    public SOSConfigurationItem[] getOriginParameterFromArguments() {
        return this.originParameterFromArguments;
    }

    public void setOriginParameterFromArguments(SOSConfigurationItem[] originParameterFromArguments) {
        this.originParameterFromArguments = originParameterFromArguments;
    }

    public void setConfigurationItem(SOSConfigurationItem[] configurationItem) {
        this.sosConfigurationItem = configurationItem;
    }

    public void setArguments(String[] arguments) throws Exception {
        this.arguments = arguments;
        try {
            this.readProgramArguments(arguments);
        }
        catch (Exception e) {
            throw new Exception("error in " + SOSClassUtil.getMethodName() + ": cause: " + e.getMessage(), e);
        }
    }

    public void setArguments(Properties arguments) throws Exception {
        this.argumentsAsProperties = arguments;
        try {
            this.readProgramArguments(this.argumentsAsProperties);
        }
        catch (Exception e) {
            throw new Exception("error in " + SOSClassUtil.getMethodName() + ": cause: " + e.getMessage(), e);
        }
    }

    public void setSchedulerParams(Properties schedulerParams) {
        this.schedulerParams = schedulerParams;
    }

    public void setSettingsFile(String settingsFile) {
        this.settingsFile = settingsFile;
    }

    public void setSettingsProfilename(String settingsProfilename) {
        this.settingsProfilename = settingsProfilename;
    }

    public void setRequiredDefaultFile(String requiredDefaultFile) {
        this.requiredDefaultFile = requiredDefaultFile;
    }

    public static void test1(String[] args, String requiredDefaultFile) {
        try {
            LOGGER.debug("~~~~~~~~~~~~~~~~~~ testen von SOSProfileSettings ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
            String settingsFile = "./testDateien/ftp_settings.ini";
            String profile = "remote_wilma";
            SOSConfiguration con = new SOSConfiguration(args, null, settingsFile, profile);
            SOSConfigurationItem[] p2 = con.getParameter();
            LOGGER.debug("*************************** Hier sind die Parameter ohne Defaults und \u00dcberpr\u00fcfung ***************************");
            for (int i = 0; i < p2.length; ++i) {
                LOGGER.debug(i + "'te Parameter \n\tname=" + p2[i].getName() + "\n\tvalue=" + p2[i].getValue() + "\n\tdefault=" + p2[i].getDefaults() + "\n\titemId=" + p2[i].getItemId() + "\n\tpassword=" + p2[i].isPassword());
            }
            LOGGER.debug("*************************** Start configuration Item nachdem \u00dcberpr\u00fcfung und ggf. mit Defaults ************************");
            SOSConfigurationItem[] p1 = con.checkConfigurationItems(requiredDefaultFile);
            for (int i = 0; i < p1.length; ++i) {
                LOGGER.debug(i + "'te Parameter \n\tname=" + p1[i].getName() + "\n\tvalue=" + p1[i].getValue() + "\n\tdefault=" + p1[i].getDefaults() + "\n\titemId=" + p1[i].getItemId() + "\n\tpassword=" + p1[i].isPassword());
            }
            LOGGER.debug("**********************************************************************************");
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    public static void test2(String[] args, String requiredDefaultFile) {
        try {
            LOGGER.debug("~~~~~~~~~~~~~~~~~~ testen von SOSXMLSettings ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
            String settingsFile = "./testDateien/test_settings.xml";
            String settingsApplication = "defaults";
            String profile = "remote_wilma";
            SOSConfiguration con = new SOSConfiguration(args, null, settingsFile, settingsApplication, profile, requiredDefaultFile);
            SOSConfigurationItem[] p2 = con.getParameter();
            LOGGER.debug("*************************** Hier sind die Parameter ohne Defaults und \u00dcberpr\u00fcfung ***************************");
            for (int i = 0; i < p2.length; ++i) {
                LOGGER.debug(i + "'te Parameter \n\tname=" + p2[i].getName() + "\n\tvalue=" + p2[i].getValue() + "\n\tdefault=" + p2[i].getDefaults() + "\n\titemId=" + p2[i].getItemId() + "\n\tpassword=" + p2[i].isPassword());
            }
            LOGGER.debug("*************************** Start configuration Item nachdem \u00dcberpr\u00fcfung und ggf. mit Defaults ************************");
            SOSConfigurationItem[] p1 = con.checkConfigurationItems(requiredDefaultFile);
            for (int i = 0; i < p1.length; ++i) {
                LOGGER.debug(i + "'te Parameter \n\tname=" + p1[i].getName() + "\n\tvalue=" + p1[i].getValue() + "\n\tdefault=" + p1[i].getDefaults() + "\n\titemId=" + p1[i].getItemId() + "\n\tpassword=" + p1[i].isPassword());
            }
            LOGGER.debug("**********************************************************************************");
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    public static void test3(String[] args, String iniSOSConnectionFile, String requiredDefaultFile) {
        try {
            LOGGER.debug("~~~~~~~~~~~~~~~~~~ testen von SOSConnectionSettings ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
            SOSConnection sosConnection = null;
            try {
                LOGGER.debug("DB Connecting.. .");
                sosConnection = SOSConnection.createInstance((String)iniSOSConnectionFile);
                sosConnection.connect();
                LOGGER.debug("DB Connected");
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
            String settingsTablename = "SETTINGS";
            String settingsApplication = "test_sosftp";
            String settingsProfilename = "test";
            SOSConfiguration con = new SOSConfiguration(args, sosConnection, settingsTablename, settingsApplication, settingsProfilename);
            SOSConfigurationItem[] p2 = con.getParameter();
            LOGGER.debug("*************************** Hier sind die Parameter ohne Defaults und \u00dcberpr\u00fcfung ***************************");
            for (int i = 0; i < p2.length; ++i) {
                LOGGER.debug(i + "'te Parameter \n\tname=" + p2[i].getName() + "\n\tvalue=" + p2[i].getValue() + "\n\tdefault=" + p2[i].getDefaults() + "\n\titemId=" + p2[i].getItemId() + "\n\tpassword=" + p2[i].isPassword());
            }
            SOSConfigurationItem[] p1 = con.checkConfigurationItems(requiredDefaultFile);
            LOGGER.debug("*************************** Start configuration Item nachdem \u00dcberpr\u00fcfung und ggf. mit Defaults ************************");
            for (int i = 0; i < p1.length; ++i) {
                LOGGER.debug(i + "'te Parameter \n\tname=" + p1[i].getName() + "\n\tvalue=" + p1[i].getValue() + "\n\tdefault=" + p1[i].getDefaults() + "\n\titemId=" + p1[i].getItemId() + "\n\tpassword=" + p1[i].isPassword());
            }
            LOGGER.debug("**********************************************************************************");
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    public static void main(String[] args) throws Exception {
        try {
            if (args == null || args.length == 0) {
                args = new String[]{"-operation=receive", "-remove_files=true", "-user=1234"};
            }
            if (args != null && args.length > 0) {
                LOGGER.debug("~~~~~~~~~ Programm argumente sind: ");
                for (String arg : args) {
                    LOGGER.debug(arg + ";");
                }
                LOGGER.debug("~~~~~~~~~~~~~~~");
            }
            String requiredDefaultFile = "./testDateien/Configuration.xml";
            SOSConfiguration.test1(args, requiredDefaultFile);
            SOSConfiguration.test2(args, requiredDefaultFile);
            SOSConfiguration.test3(args, "./testDateien/sos_settings.ini", requiredDefaultFile);
        }
        catch (Exception e) {
            LOGGER.error("error : " + e.getMessage(), (Throwable)e);
        }
    }
}

