/*
 * Decompiled with CFR 0.152.
 */
package com.sos.graphviz.jobchain.datasource.jobscheduler;

import com.sos.JSHelper.Options.SOSOptionString;
import com.sos.graphviz.jobchain.interfaces.IDataSourceOrders;
import com.sos.scheduler.model.SchedulerHotFolder;
import com.sos.scheduler.model.SchedulerHotFolderFileList;
import com.sos.scheduler.model.SchedulerObjectFactory;
import com.sos.scheduler.model.objects.JSObjBase;
import com.sos.scheduler.model.objects.JSObjJobChain;
import com.sos.scheduler.model.objects.JSObjOrder;
import com.sos.vfs.common.SOSVFSFactory;
import com.sos.vfs.common.interfaces.ISOSProvider;
import com.sos.vfs.common.interfaces.ISOSProviderFile;
import com.sos.vfs.common.options.SOSBaseOptions;
import java.io.File;
import java.util.ArrayList;

public class DataSourceOrders
implements IDataSourceOrders {
    private SchedulerObjectFactory schedulerObjectFactory;
    private ArrayList<JSObjOrder> listOfOrders;
    private File liveFolder;
    private int index;
    private JSObjJobChain jobChain;

    public DataSourceOrders(File liveFolder, SchedulerObjectFactory schedulerObjectFactory, String jobChainXml) {
        this.schedulerObjectFactory = schedulerObjectFactory;
        this.jobChain = schedulerObjectFactory.createJobChain();
        this.jobChain.loadObject(jobChainXml);
        this.liveFolder = liveFolder;
        this.reset();
        this.listOfOrders = new ArrayList();
    }

    public DataSourceOrders(File liveFolder, SchedulerObjectFactory schedulerObjectFactory, JSObjJobChain jobChain) {
        this.schedulerObjectFactory = schedulerObjectFactory;
        this.jobChain = jobChain;
        this.liveFolder = liveFolder;
        this.reset();
        this.listOfOrders = new ArrayList();
    }

    @Override
    public void getList() {
        this.reset();
        String liveFolderName = this.liveFolder.getAbsolutePath();
        try {
            SOSBaseOptions vfsOptions = new SOSBaseOptions();
            ISOSProvider objFileSystemHandler = SOSVFSFactory.getProvider((String)"local", (SOSOptionString)vfsOptions.ssh_provider, (SOSOptionString)vfsOptions.webdav_provider, (SOSOptionString)vfsOptions.smb_provider);
            ISOSProviderFile objHotFolder = objFileSystemHandler.getFile(liveFolderName);
            SchedulerHotFolder objSchedulerHotFolder = this.schedulerObjectFactory.createSchedulerHotFolder(objHotFolder);
            SchedulerHotFolderFileList objSchedulerHotFolderFileList = objSchedulerHotFolder.loadOrderObjects();
            for (JSObjBase hotFolderItem : objSchedulerHotFolderFileList.getOrderList()) {
                JSObjOrder order;
                String jobchainName;
                if (!(hotFolderItem instanceof JSObjOrder) || !(jobchainName = (order = (JSObjOrder)hotFolderItem).getJobChainName()).equalsIgnoreCase(this.getName())) continue;
                this.listOfOrders.add(order);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getName() {
        String name = this.jobChain.getObjectName();
        if (name == null || name.isEmpty()) {
            name = this.jobChain.getName();
        }
        return name;
    }

    @Override
    public boolean hasNext() {
        return this.index + 1 < this.listOfOrders.size();
    }

    @Override
    public JSObjOrder next() {
        ++this.index;
        return this.listOfOrders.get(this.index);
    }

    @Override
    public void reset() {
        this.index = -1;
    }

    @Override
    public JSObjJobChain getJobChain() {
        return this.jobChain;
    }

    public void setJobChain(JSObjJobChain jobChain) {
        this.jobChain = jobChain;
    }
}

