/*
 * Decompiled with CFR 0.152.
 */
package com.sos.scheduler.plugins.globalmonitor;

import com.sos.scheduler.plugins.globalmonitor.ConfigurationModifierFileFilter;
import com.sos.scheduler.plugins.globalmonitor.ConfigurationModifierFileSelectorOptions;
import com.sos.scheduler.plugins.globalmonitor.JobSchedulerFileElement;
import java.io.File;
import java.util.HashMap;

public class ConfigurationModifierFileSelector {
    private ConfigurationModifierFileSelectorOptions selectorOptions;
    private HashMap<String, JobSchedulerFileElement> listOfSelectedConfigurationFiles;
    private HashMap<String, JobSchedulerFileElement> listOfMonitorConfigurationFiles;
    private ConfigurationModifierFileFilter selectorFilter;

    public HashMap<String, JobSchedulerFileElement> getListOfMonitorConfigurationFiles() {
        return this.listOfMonitorConfigurationFiles;
    }

    public ConfigurationModifierFileSelector(ConfigurationModifierFileSelectorOptions selectorOptions_) {
        this.selectorOptions = selectorOptions_;
    }

    private void fillFiles(String directory) {
        if (directory != null) {
            File d = new File(directory);
            File[] files = null;
            files = this.selectorFilter != null ? d.listFiles(this.selectorFilter) : d.listFiles();
            if (files != null) {
                for (File file : files) {
                    if (file.isFile()) {
                        JobSchedulerFileElement jobSchedulerFileElement = new JobSchedulerFileElement(file);
                        this.listOfSelectedConfigurationFiles.put(jobSchedulerFileElement.getJobSchedulerElementName(), jobSchedulerFileElement);
                        continue;
                    }
                    if (!this.selectorOptions.isRecursive()) continue;
                    this.fillFiles(file.getAbsolutePath());
                }
            }
        }
    }

    public void fillSelectedFileList() {
        this.listOfSelectedConfigurationFiles = new HashMap();
        this.fillFiles(this.selectorOptions.getConfigurationDirectory() + "/cache");
        this.fillFiles(this.selectorOptions.getConfigurationDirectory() + "/live");
    }

    public HashMap<String, JobSchedulerFileElement> getSelectedFileList() {
        return this.listOfSelectedConfigurationFiles;
    }

    public boolean isInSelectedFileList(String elementName) {
        return this.listOfSelectedConfigurationFiles.get(elementName) != null;
    }

    public JobSchedulerFileElement getJobSchedulerElement(String jobName) {
        return this.listOfSelectedConfigurationFiles.get(jobName);
    }

    private void fillMonitorList(File d, String schedulerLivePath) {
        if (d != null) {
            if (this.selectorOptions.isRecursive() && d != null && d.getAbsolutePath().length() > 0 && !d.getAbsolutePath().replace('\\', '/').equals(schedulerLivePath)) {
                this.fillMonitorList(d.getParentFile(), schedulerLivePath);
            }
            File[] files = null;
            files = this.selectorFilter != null ? d.listFiles(this.selectorFilter) : d.listFiles();
            if (files != null) {
                for (File file : files) {
                    if (!file.isFile()) continue;
                    JobSchedulerFileElement jobSchedulerFileElement = new JobSchedulerFileElement(file);
                    this.listOfMonitorConfigurationFiles.put(jobSchedulerFileElement.getJobSchedulerElementName(), jobSchedulerFileElement);
                }
            }
        }
    }

    private void fillParentMonitorListFromBase(JobSchedulerFileElement jobSchedulerFileElement, String base) {
        String schedulerLivePath = jobSchedulerFileElement.getSchedulerLivePath();
        File d = jobSchedulerFileElement.getConfigurationFile();
        String s = d.getAbsolutePath();
        s = s.replace("\\", "/");
        s = "live".equals(base) ? s.replaceFirst("/cache", "/" + base) : s.replaceFirst("/live", "/" + base);
        File dLive = new File(s);
        this.fillMonitorList(dLive, schedulerLivePath + "/cache");
    }

    public void fillParentMonitorList(JobSchedulerFileElement jobSchedulerFileElement) {
        this.listOfMonitorConfigurationFiles = new HashMap();
        this.fillParentMonitorListFromBase(jobSchedulerFileElement, "live");
        this.fillParentMonitorListFromBase(jobSchedulerFileElement, "cache");
    }

    public void setSelectorFilter(ConfigurationModifierFileFilter selectorFilter) {
        this.selectorFilter = selectorFilter;
    }
}

