/*
 * Decompiled with CFR 0.152.
 */
package com.sos.scheduler.plugins.globalmonitor;

import java.io.File;
import java.util.ArrayList;

public class ConfigurationModifierFileSelectorOptions {
    private String configurationDirectory;
    private String regexSelector;
    private String fileExclusions = "";
    private String directoryExclusions = "";
    private boolean recursive;
    private ArrayList<String> listOfFileExclusions;
    private ArrayList<String> listOfDirectoryExclusions;

    public String getConfigurationDirectory() {
        return this.configurationDirectory;
    }

    public void setConfigurationDirectory(String directory) {
        this.configurationDirectory = directory;
    }

    public String getRegexSelector() {
        return this.regexSelector;
    }

    public void setRegexSelector(String regexSelector) {
        this.regexSelector = regexSelector;
    }

    public String getfileExclusions() {
        return this.fileExclusions;
    }

    private void fillExclusionsList() {
        this.listOfFileExclusions = new ArrayList();
        this.listOfDirectoryExclusions = new ArrayList();
        String[] filenames = this.fileExclusions.split(",");
        for (int i = 0; i < filenames.length; ++i) {
            this.listOfFileExclusions.add(filenames[i]);
        }
        String[] dirnames = this.directoryExclusions.split(",");
        for (int i = 0; i < dirnames.length; ++i) {
            this.listOfDirectoryExclusions.add(dirnames[i]);
        }
    }

    public void setFileExclusions(String fileExclusions_) {
        this.fileExclusions = fileExclusions_.replace('\\', '/');
        this.fillExclusionsList();
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    public void setRecursive(String recursive) {
        this.recursive = "true".equalsIgnoreCase(recursive);
    }

    public void setDirectoryExclusions(String directoryExclusions) {
        this.directoryExclusions = directoryExclusions.replace('\\', '/');
        this.fillExclusionsList();
    }

    public boolean isFileExclusions(File file) {
        if (this.listOfFileExclusions == null || this.listOfFileExclusions.isEmpty()) {
            return false;
        }
        String s = file.getAbsolutePath().replace('\\', '/');
        s = s.replaceAll("^.*" + this.configurationDirectory + "/(live|cache)(.*)\\.(job|monitor)\\.xml$", "$2");
        for (String exclusion : this.listOfFileExclusions) {
            if (!s.equals(exclusion)) continue;
            return true;
        }
        return false;
    }

    public boolean isDirExclusion(File directory) {
        if (this.listOfDirectoryExclusions == null || this.listOfDirectoryExclusions.isEmpty()) {
            return false;
        }
        for (String exclusion : this.listOfDirectoryExclusions) {
            if (exclusion.trim().length() <= 0 || !directory.getAbsolutePath().replace('\\', '/').endsWith(exclusion)) continue;
            return true;
        }
        return false;
    }
}

