/*
 * Decompiled with CFR 0.152.
 */
package com.sos.scheduler.plugins.globalmonitor;

import com.sos.scheduler.engine.common.javautils.ScalaInJava;
import com.sos.scheduler.engine.common.xml.XmlUtils;
import com.sos.scheduler.engine.data.filebased.AbsolutePath;
import com.sos.scheduler.engine.data.filebased.FileBasedType;
import com.sos.scheduler.engine.kernel.plugin.AbstractPlugin;
import com.sos.scheduler.engine.kernel.plugin.XmlConfigurationChangingPlugin;
import com.sos.scheduler.plugins.globalmonitor.ConfigurationModifierFileSelector;
import com.sos.scheduler.plugins.globalmonitor.ConfigurationModifierFileSelectorOptions;
import com.sos.scheduler.plugins.globalmonitor.ConfigurationModifierJobFileFilter;
import com.sos.scheduler.plugins.globalmonitor.ConfigurationModifierMonitorFileFilter;
import com.sos.scheduler.plugins.globalmonitor.JobConfigurationFileChanger;
import com.sos.scheduler.plugins.globalmonitor.JobSchedulerFileElement;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import javax.inject.Inject;
import javax.inject.Named;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import scala.collection.immutable.Set;

public class GlobalMonitorPlugin
extends AbstractPlugin
implements XmlConfigurationChangingPlugin {
    private static final Logger LOGGER = LoggerFactory.getLogger(GlobalMonitorPlugin.class);
    ConfigurationModifierFileSelectorOptions configurationModifierFileSelectorJobOptions;
    ConfigurationModifierFileSelectorOptions configurationModifierFileSelectorMonitorOptions;
    private HashMap<String, String> parameters;

    @Inject
    private GlobalMonitorPlugin(@Named(value="com.sos.scheduler.engine.kernel.plugin.Plugin.configurationXML") Element pluginElement) {
        this.configurationModifierFileSelectorJobOptions = this.setParameters(pluginElement, "jobparams");
        this.configurationModifierFileSelectorMonitorOptions = this.setParameters(pluginElement, "monitorparams");
    }

    public GlobalMonitorPlugin() {
    }

    public byte[] changeXmlConfiguration(FileBasedType typ, AbsolutePath path, byte[] xmlBytes) {
        LOGGER.debug("---------  changeXmlConfiguration");
        Document doc = null;
        if (typ == FileBasedType.Job) {
            doc = GlobalMonitorPlugin.xmlBytesToDom(xmlBytes);
        }
        doc = this.modifyJobElement(doc, path.string());
        return GlobalMonitorPlugin.domToXmlBytes(doc);
    }

    public Set<FileBasedType> fileBasedTypes() {
        return ScalaInJava.toScalaSet((Object[])new FileBasedType[]{FileBasedType.Job});
    }

    private String getStringFromDocument(Document doc) {
        try {
            DOMSource domSource = new DOMSource(doc);
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.transform(domSource, result);
            return writer.toString();
        }
        catch (TransformerException ex) {
            LOGGER.error(ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    private ConfigurationModifierFileSelectorOptions setParameters(Element e, String parent) {
        LOGGER.debug("---------  setParameters:" + parent);
        ConfigurationModifierFileSelectorOptions c = new ConfigurationModifierFileSelectorOptions();
        this.parameters = new HashMap();
        this.parameters.put("configuration_directory", "");
        this.parameters.put("exclude_dir", "");
        this.parameters.put("exclude_file", "");
        this.parameters.put("recursive", "true");
        this.parameters.put("regex_selector", "");
        NodeList listOfParams = null;
        NodeList paramsElement = e.getElementsByTagName(parent);
        if (paramsElement != null) {
            listOfParams = paramsElement.item(0).getChildNodes();
            for (int i = 0; i < listOfParams.getLength(); ++i) {
                Element elem;
                Node param = listOfParams.item(i);
                if (param.getNodeType() != 1 || (elem = (Element)param).getAttribute("name") == null) continue;
                String name = elem.getAttribute("name").toLowerCase();
                String value = elem.getAttribute("value");
                LOGGER.debug("---------  " + name + "=" + value);
                this.parameters.put(name, value);
            }
            c.setConfigurationDirectory(this.parameters.get("configuration_directory").replace('\\', '/'));
            c.setDirectoryExclusions(this.parameters.get("exclude_dir").replace('\\', '/'));
            c.setFileExclusions(this.parameters.get("exclude_file").replace('\\', '/'));
            c.setRecursive(this.parameters.get("recursive"));
            c.setRegexSelector(this.parameters.get("regex_selector"));
        }
        return c;
    }

    public ConfigurationModifierFileSelectorOptions setParametersTest(Element e, String parent) {
        return this.setParameters(e, parent);
    }

    private static Document xmlBytesToDom(byte[] xmlBytes) {
        String encoding = "";
        return XmlUtils.loadXml((byte[])xmlBytes, (String)encoding);
    }

    private static byte[] domToXmlBytes(Node node) {
        boolean indent = false;
        return XmlUtils.toXmlBytes((Node)node, (Charset)StandardCharsets.UTF_8, (boolean)indent);
    }

    private Document modifyJobElement(Document doc, String jobname) {
        JobSchedulerFileElement jobSchedulerFileElement;
        LOGGER.debug("---------  modifyJobElement:" + jobname);
        ConfigurationModifierFileSelector configurationModifierFileSelector = new ConfigurationModifierFileSelector(this.configurationModifierFileSelectorJobOptions);
        configurationModifierFileSelector.setSelectorFilter(new ConfigurationModifierJobFileFilter(this.configurationModifierFileSelectorJobOptions));
        LOGGER.debug("---------  fillSelectedFileList");
        configurationModifierFileSelector.fillSelectedFileList();
        boolean jobIsToBeHandled = configurationModifierFileSelector.isInSelectedFileList(jobname);
        LOGGER.debug("---------  jobIsToBeHandled:" + jobIsToBeHandled);
        if (jobIsToBeHandled && (jobSchedulerFileElement = configurationModifierFileSelector.getJobSchedulerElement(jobname)) != null) {
            configurationModifierFileSelector = new ConfigurationModifierFileSelector(this.configurationModifierFileSelectorMonitorOptions);
            configurationModifierFileSelector.setSelectorFilter(new ConfigurationModifierMonitorFileFilter(this.configurationModifierFileSelectorMonitorOptions));
            configurationModifierFileSelector.fillParentMonitorList(jobSchedulerFileElement);
            JobConfigurationFileChanger jobConfigurationFileChanger = new JobConfigurationFileChanger(doc);
            jobConfigurationFileChanger.setListOfMonitors(configurationModifierFileSelector.getListOfMonitorConfigurationFiles());
            doc = jobConfigurationFileChanger.addMonitorUse();
            LOGGER.debug(this.getStringFromDocument(doc));
            return doc;
        }
        return doc;
    }
}

