/*
 * Decompiled with CFR 0.152.
 */
package com.sos.scheduler.plugins.globalmonitor;

import java.io.File;

public class JobSchedulerFileElement {
    private File configurationFile;
    private String jobSchedulerElementName;

    public JobSchedulerFileElement(File configurationFile) {
        this.configurationFile = configurationFile;
        this.setJobSchedulerElementName();
    }

    private String getSchedulerLivePath(String filePath) {
        filePath = filePath.replace('\\', '/');
        String s = filePath.replaceFirst("^(.*/)(live|cache)/.*", "$1$2");
        return s;
    }

    public String getSchedulerLivePath() {
        return this.getSchedulerLivePath(this.configurationFile.getAbsolutePath());
    }

    public File getConfigurationFile() {
        return this.configurationFile;
    }

    public String getJobSchedulerElementName() {
        return this.jobSchedulerElementName;
    }

    private void setJobSchedulerElementName() {
        String filePath = this.configurationFile.getAbsolutePath();
        this.jobSchedulerElementName = filePath = filePath.replace('\\', '/');
        if (filePath.startsWith(this.getSchedulerLivePath(filePath))) {
            int l = this.getSchedulerLivePath(filePath).length();
            this.jobSchedulerElementName = filePath.substring(l);
        }
        this.jobSchedulerElementName = this.jobSchedulerElementName.replace('\\', '/');
        this.jobSchedulerElementName = this.jobSchedulerElementName.replaceAll("(^/.*)\\..*\\.xml$", "$1");
    }

    public String testGetSchedulerHome(String filePath) {
        return this.getSchedulerLivePath(filePath);
    }
}

