/*
 * Decompiled with CFR 0.152.
 */
package sos.scheduler.job;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import sos.connection.SOSConnection;
import sos.marshalling.SOSImport;
import sos.scheduler.job.JobSchedulerJob;
import sos.spooler.Variable_set;
import sos.util.SOSClassUtil;
import sos.util.SOSFile;
import sos.util.SOSString;

public class JobSchedulerImportJob
extends JobSchedulerJob {
    private static final Logger LOGGER = LoggerFactory.getLogger(JobSchedulerImportJob.class);
    private Variable_set parameters = null;
    private SOSConnection sosConnection = null;
    private SOSConnection sosUpdateStateConnection = null;
    private String sosSettingsFile = null;
    private String sosSettingsUpdateStateFile = null;
    private SOSString sosString = null;
    private Iterator listOfFiles = null;
    private String inputPath = "";
    private String regEx = "";
    private HashMap mappingTablenames = null;

    @Override
    public boolean spooler_init() {
        boolean rc = super.spooler_init();
        try {
            String filename = "";
            if (rc) {
                this.sosString = new SOSString();
                this.setParameters(this.spooler.create_variable_set());
                if (this.spooler_task.params() != null) {
                    this.getParameters().merge(this.spooler_task.params());
                }
                if (this.spooler_job.order_queue() != null) {
                    this.getParameters().merge(this.spooler_task.order().params());
                }
                if (this.getParameters().value("sos_settings_file") != null && !this.getParameters().value("sos_settings_file").isEmpty()) {
                    this.sosSettingsFile = this.getParameters().value("sos_settings_file");
                    this.spooler_log.debug1(".. parameter [sos_settings_file]: " + this.sosSettingsFile);
                }
                if (this.getParameters().value("sos_setting_file_status_update") != null && !this.getParameters().value("sos_setting_file_status_update").isEmpty()) {
                    this.sosSettingsUpdateStateFile = this.getParameters().value("sos_setting_file_status_update");
                    this.spooler_log.debug1(".. parameter [sos_setting_file_status_update]: " + this.sosSettingsUpdateStateFile);
                }
                if (this.getParameters().value("input_path") != null && !this.getParameters().value("input_path").isEmpty()) {
                    this.inputPath = this.getParameters().value("input_path");
                    this.spooler_log.debug1(".. parameter [sos_setting_file_status_update]: " + this.inputPath);
                }
                if (this.getParameters().value("reg_ex") != null && !this.getParameters().value("reg_ex").isEmpty()) {
                    this.regEx = this.getParameters().value("reg_ex");
                    this.spooler_log.debug1(".. parameter [reg_ex]: " + this.regEx);
                }
                if (this.getParameters().value("filename") != null && !this.getParameters().value("filename").isEmpty()) {
                    filename = this.getParameters().value("filename");
                    this.spooler_log.debug1(".. parameter [filename]: " + filename);
                }
                String mappingFilename = null;
                if (this.getParameters().value("mapping_table_names") != null && !this.getParameters().value("mapping_table_names").isEmpty()) {
                    mappingFilename = this.getParameters().value("mapping_table_names");
                    this.spooler_log.debug1(".. parameter [mapping_table_names]: " + mappingFilename);
                }
                if (!this.sosString.parseToString(mappingFilename).isEmpty()) {
                    this.mappingTablenames = this.getMappingFilename(mappingFilename);
                }
                this.sosConnection = this.getConnections(this.sosSettingsFile);
                this.sosConnection.setAutoCommit(false);
                this.sosUpdateStateConnection = this.getConnections(this.sosSettingsUpdateStateFile);
                ArrayList<String> list = new ArrayList<String>();
                Vector filelist = null;
                if (this.spooler_task.job().order_queue() == null) {
                    String[] split = this.spooler_task.trigger_files().split(";");
                    for (String element : split) {
                        if (this.sosString.parseToString((Object)element).isEmpty()) continue;
                        list.add(element);
                    }
                    if (!this.sosString.parseToString((Object)this.inputPath).isEmpty()) {
                        filelist = SOSFile.getFilelist((String)this.inputPath, (String)this.regEx, (int)2);
                        for (File filelistEntry : filelist) {
                            list.add(filelistEntry.getAbsolutePath());
                        }
                    }
                    if (!this.sosString.parseToString((Object)filename).isEmpty()) {
                        list.add(filename);
                    }
                    this.listOfFiles = list.iterator();
                    if (!this.listOfFiles.hasNext()) {
                        return false;
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            return false;
        }
        return rc;
    }

    public boolean spooler_process() {
        boolean rc = true;
        long timeInSec = System.currentTimeMillis();
        String signalId = "-1";
        String triggerfile = "";
        try {
            if (this.spooler_task.job().order_queue() != null) {
                this.setParameters(this.spooler.create_variable_set());
                if (this.spooler_task.params() != null) {
                    this.getParameters().merge(this.spooler_task.params());
                }
                if (this.spooler_job.order_queue() != null) {
                    this.getParameters().merge(this.spooler_task.order().params());
                }
                String filename = "";
                if (this.getParameters().value("filename") != null && !this.getParameters().value("filename").isEmpty()) {
                    filename = this.getParameters().value("filename");
                    this.spooler_log.debug1(".. parameter [filename]: " + filename);
                }
                if (!this.sosString.parseToString((Object)(triggerfile = this.spooler_task.trigger_files())).isEmpty()) {
                    this.spooler_log.debug3("order start cause trigger files: " + triggerfile);
                } else if (!this.sosString.parseToString((Object)filename).isEmpty()) {
                    triggerfile = this.sosString.parseToString((Object)this.getParameters().value("filename"));
                    this.spooler_log.debug3("order cause parameter [filename= " + triggerfile);
                }
            } else {
                triggerfile = this.sosString.parseToString(this.listOfFiles.next());
                if (triggerfile.isEmpty()) {
                    this.spooler_log.debug("there is no file to import.");
                    return false;
                }
            }
            if (triggerfile != null && !triggerfile.isEmpty()) {
                int iPos1 = triggerfile.lastIndexOf("_");
                int iPos2 = triggerfile.substring(0, iPos1).lastIndexOf("_");
                if (iPos2 > -1 && iPos1 > -1) {
                    signalId = triggerfile.substring(iPos2 + 1, iPos1);
                    this.spooler_log.debug7("signal_id is: " + signalId);
                }
                this.importfile(triggerfile);
                String upStr = "UPDATE SCHEDULER_SIGNAL_OBJECTS SET \"STATUS\" = 3 WHERE  \"SIGNAL_ID\" = " + signalId;
                this.sosUpdateStateConnection.executeUpdate(upStr);
                this.sosUpdateStateConnection.commit();
                String time = Math.round((System.currentTimeMillis() - timeInSec) / 1000L) + "s";
                String stateText = "successfully import Database to XML-File " + triggerfile + " (" + time + ")";
                this.spooler_job.set_state_text(stateText);
                this.spooler_log.info(stateText);
            }
            return this.spooler_job.order_queue() != null ? rc : this.listOfFiles.hasNext();
        }
        catch (Exception e) {
            try {
                if (this.sosConnection != null) {
                    this.sosConnection.rollback();
                }
                if (this.sosUpdateStateConnection != null) {
                    this.sosUpdateStateConnection.rollback();
                    String upStr = "UPDATE SCHEDULER_SIGNAL_OBJECTS SET \"STATUS\" = 1003 WHERE  \"SIGNAL_ID\" = " + signalId;
                    this.sosUpdateStateConnection.executeUpdate(upStr);
                    this.sosUpdateStateConnection.commit();
                }
            }
            catch (Exception upStr) {
                // empty catch block
            }
            String stateText = "could not import Database to XML-File " + triggerfile + " cause: " + e.getMessage();
            this.spooler_job.set_state_text(stateText);
            this.spooler_log.warn(stateText);
            return this.spooler_job.order_queue() != null ? rc : this.listOfFiles.hasNext();
        }
    }

    @Override
    public void spooler_exit() {
        super.spooler_exit();
        try {
            if (this.sosConnection != null) {
                this.sosConnection.disconnect();
            }
            if (this.sosUpdateStateConnection != null) {
                this.sosUpdateStateConnection.disconnect();
            }
        }
        catch (Exception e) {
            try {
                this.spooler_log.warn("spooler_exit(): disconnect failed: " + e.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void importfile(String triggerfile) throws Exception {
        try {
            SOSImport imp = new SOSImport(this.sosConnection, triggerfile, null, null, null);
            if (this.mappingTablenames != null && !this.mappingTablenames.isEmpty()) {
                imp.setMappingTablenames(this.mappingTablenames);
            }
            imp.doImport();
            this.sosConnection.commit();
        }
        catch (Exception e) {
            this.spooler_log.warn("error in " + SOSClassUtil.getClassName() + ". Could not import file : " + triggerfile + " cause:" + e.getMessage());
            throw new Exception("error in " + SOSClassUtil.getClassName() + " :" + e.getMessage(), e);
        }
    }

    public Variable_set getParameters() {
        return this.parameters;
    }

    public void setParameters(Variable_set parameters) {
        this.parameters = parameters;
    }

    private SOSConnection getConnections(String settingsfile) throws Exception {
        SOSConnection conn = null;
        if (!this.sosString.parseToString((Object)settingsfile).isEmpty()) {
            conn = this.getConnectionFromINIFile(settingsfile);
        }
        if (conn == null) {
            conn = this.getConnection();
        }
        return conn;
    }

    private SOSConnection getConnectionFromINIFile(String settingsfile) throws Exception {
        SOSConnection conn = null;
        try {
            this.spooler_log.debug3("DB Connecting.. .");
            conn = SOSConnection.createInstance((String)settingsfile);
            conn.connect();
            this.spooler_log.debug3("DB Connected");
        }
        catch (Exception e) {
            throw new Exception("error in " + SOSClassUtil.getMethodName() + ": connect to database failed: " + e.toString());
        }
        return conn;
    }

    private HashMap getMappingFilename(String mapFile) throws Exception {
        HashMap<String, String> retVal = new HashMap<String, String>();
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document dom = db.parse(mapFile);
            Element docEle = dom.getDocumentElement();
            NodeList nl = docEle.getElementsByTagName("tablename");
            if (nl != null && nl.getLength() > 0) {
                for (int i = 0; i < nl.getLength(); ++i) {
                    Element el = (Element)nl.item(i);
                    retVal.put(el.getAttribute("from"), el.getAttribute("to"));
                }
            }
            return retVal;
        }
        catch (Exception e) {
            throw new Exception("..error in " + SOSClassUtil.getClassName() + " :" + e.getMessage());
        }
    }
}

