/*
 * Decompiled with CFR 0.152.
 */
package sos.scheduler.job;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import sos.connection.SOSConnection;
import sos.scheduler.command.SOSSchedulerCommand;
import sos.scheduler.job.JobSchedulerJob;
import sos.settings.SOSConnectionSettings;
import sos.settings.SOSProfileSettings;
import sos.settings.SOSSettings;
import sos.spooler.Job_impl;
import sos.spooler.Variable_set;
import sos.util.SOSClassUtil;
import sos.util.SOSString;
import sos.xml.SOSXMLXPath;

public class JobSchedulerSignalJob
extends Job_impl {
    protected String application = new String("scheduler");
    protected String sectionname = new String("scheduler");
    private SOSConnection sosConnection = null;
    private String sosSettingsFile = null;
    private Iterator<Map<String, String>> listOfSignalObject = null;
    private int countProcessOk = 0;
    private int countProcessError = 0;
    private long timeInSec = 0L;
    private String host = "";
    private int port = 0;
    private int timeout = 0;
    private String protocol = "";
    private String command = "";
    private String jobName = "";
    private String orderId = "";
    private String at = "";
    private String webService = "";
    private String after = "";
    private boolean replace = true;
    private String jobChain = "";
    private String priority = "";
    private String state = "";
    private String title = "";
    private String runTime = "";
    private SOSString sosString = null;
    public static final String TABLE_SCHEDULER_SIGNAL_OBECTS = "SCHEDULER_SIGNAL_OBJECTS";
    public static final String TABLE_SCHEDULER_SIGNAL_PARAMETERS = "SCHEDULER_SIGNAL_PARAMETERS";

    public void initParameters() throws Exception {
        this.sosString = new SOSString();
        this.setHost("localhost");
        this.setPort(4444);
        this.setProtocol("tcp");
        this.setTimeout(15);
        this.setJobName("");
        this.setOrderId("");
        this.setCommand("");
        this.setAt("");
        this.setWebService("");
        this.setAfter("");
        this.setReplace(true);
        this.setJobChain("");
        this.setPriority("");
        this.setState("");
        this.setTitle("");
        this.setRunTime("");
        this.countProcessError = 0;
        this.countProcessOk = 0;
    }

    public void getTaskParameters(boolean logValue) throws Exception {
        try {
            if (this.spooler_task.params().var("scheduler_remote_host") != null && !this.spooler_task.params().var("scheduler_remote_host").isEmpty()) {
                this.setHost(this.spooler_task.params().var("scheduler_remote_host"));
                if (logValue) {
                    this.spooler_log.info(".. job parameter [scheduler_remote_host]: " + this.getHost());
                }
            }
            if (this.spooler_task.params().var("scheduler_remote_port") != null && !this.spooler_task.params().var("scheduler_remote_port").isEmpty()) {
                try {
                    this.setPort(Integer.parseInt(this.spooler_task.params().var("scheduler_remote_port")));
                    if (logValue) {
                        this.spooler_log.info(".. job parameter [scheduler_remote_port]: " + this.getPort());
                    }
                }
                catch (Exception e) {
                    throw new Exception("illegal value specified for parameter [scheduler_remote_port], numeric value expected, found: " + this.spooler_task.params().var("scheduler_remote_port"));
                }
            }
            if (this.spooler_task.params().var("scheduler_remote_protocol") != null && !this.spooler_task.params().var("scheduler_remote_protocol").isEmpty()) {
                if (!"tcp".equalsIgnoreCase(this.spooler_task.params().var("scheduler_remote_protocol")) && !"udp".equalsIgnoreCase(this.spooler_task.params().var("scheduler_remote_protocol"))) {
                    throw new Exception("illegal value specified for parameter [scheduler_remote_protocol], \"tcp\" or \"udp\" expected, found: " + this.spooler_task.params().var("scheduler_remote_protocol"));
                }
                this.setProtocol(this.spooler_task.params().var("scheduler_remote_protocol"));
                if (logValue) {
                    this.spooler_log.info(".. job parameter [scheduler_remote_protocol]: " + this.getProtocol());
                }
            }
            if (this.spooler_task.params().var("scheduler_remote_timeout") != null && !this.spooler_task.params().var("scheduler_remote_timeout").isEmpty()) {
                try {
                    this.setTimeout(Integer.parseInt(this.spooler_task.params().var("scheduler_remote_timeout")));
                    if (logValue) {
                        this.spooler_log.info(".. job parameter [scheduler_remote_timeout]: " + this.getTimeout());
                    }
                }
                catch (Exception e) {
                    throw new Exception("illegal value specified for parameter [scheduler_remote_timeout], numeric value expected, found: " + this.spooler_task.params().var("scheduler_remote_timeout"));
                }
            }
            if (this.spooler_task.params().var("scheduler_remote_start_at") != null && !this.spooler_task.params().var("scheduler_remote_start_at").isEmpty()) {
                this.setAt(this.spooler_task.params().var("scheduler_remote_start_at"));
                if (logValue) {
                    this.spooler_log.info(".. job parameter [scheduler_remote_start_at]: " + this.getAt());
                }
            }
            if (this.spooler_task.params().var("scheduler_remote_job_start_after") != null && !this.spooler_task.params().var("scheduler_remote_job_start_after").isEmpty()) {
                this.setAfter(this.spooler_task.params().var("scheduler_remote_job_start_after"));
                if (logValue) {
                    this.spooler_log.info(".. job parameter [scheduler_remote_job_start_after]: " + this.getAfter());
                }
            }
            if (this.spooler_task.params().var("scheduler_remote_order_replace") != null && !this.spooler_task.params().var("scheduler_remote_order_replace").isEmpty()) {
                if ("yes".equalsIgnoreCase(this.spooler_task.params().var("scheduler_remote_order_replace")) || "true".equalsIgnoreCase(this.spooler_task.params().var("scheduler_remote_order_replace")) || "1".equals(this.spooler_task.params().var("scheduler_remote_order_replace"))) {
                    this.setReplace(true);
                } else {
                    this.setReplace(false);
                }
                if (logValue) {
                    this.spooler_log.info(".. job parameter [scheduler_remote_order_replace]: " + this.isReplace());
                }
            }
            if (this.spooler_task.params().var("scheduler_remote_order_job_chain") != null && !this.spooler_task.params().var("scheduler_remote_order_job_chain").isEmpty()) {
                this.setJobChain(this.spooler_task.params().var("scheduler_remote_order_job_chain"));
                if (logValue) {
                    this.spooler_log.info(".. job parameter [scheduler_remote_order_job_chain]: " + this.getJobChain());
                }
            }
            if (this.spooler_task.params().var("scheduler_remote_order_priority") != null && !this.spooler_task.params().var("scheduler_remote_order_priority").isEmpty()) {
                this.setPriority(this.spooler_task.params().var("scheduler_remote_order_priority"));
                if (logValue) {
                    this.spooler_log.info(".. job parameter [scheduler_remote_order_priority]: " + this.getPriority());
                }
            }
            if (this.spooler_task.params().var("scheduler_remote_order_state") != null && !this.spooler_task.params().var("scheduler_remote_order_state").isEmpty()) {
                this.setState(this.spooler_task.params().var("scheduler_remote_order_state"));
                if (logValue) {
                    this.spooler_log.info(".. job parameter [scheduler_remote_order_state]: " + this.getState());
                }
            }
            if (this.spooler_task.params().var("scheduler_remote_order_title") != null && !this.spooler_task.params().var("scheduler_remote_order_title").isEmpty()) {
                this.setTitle(this.spooler_task.params().var("scheduler_remote_order_title"));
                if (logValue) {
                    this.spooler_log.info(".. job parameter [scheduler_remote_order_title]: " + this.getTitle());
                }
            }
            if (this.spooler_task.params().var("scheduler_remote_order_run_time") != null && !this.spooler_task.params().var("scheduler_remote_order_run_time").isEmpty()) {
                this.setRunTime(this.spooler_task.params().var("scheduler_remote_order_run_time"));
                if (logValue) {
                    this.spooler_log.info(".. job parameter [scheduler_remote_order_run_time]: " + this.getRunTime());
                }
            }
            if (this.spooler_task.params().var("sos_settings_file") != null && !this.spooler_task.params().var("sos_settings_file").isEmpty()) {
                this.setSosSettingsFile(this.spooler_task.params().var("sos_settings_file"));
                if (logValue) {
                    this.spooler_log.info(".. job parameter [sos_settings_file]: " + this.getSosSettingsFile());
                }
            }
        }
        catch (Exception e) {
            throw new Exception("error occurred processing task parameters: " + e.getMessage());
        }
    }

    public boolean spooler_init() {
        try {
            this.timeInSec = System.currentTimeMillis();
            this.initParameters();
            this.getTaskParameters(true);
            this.sosConnection = this.getConnection();
            String selStr = "SELECT \"SIGNAL_ID\",  \"JOB_CHAIN\",    \"OPERATION\"    FROM SCHEDULER_SIGNAL_OBJECTS  WHERE  \"STATUS\" = 0";
            List list = this.sosConnection.getArray(selStr);
            this.listOfSignalObject = list.iterator();
            if (this.listOfSignalObject.hasNext()) {
                return true;
            }
            this.spooler_log.debug1("There is no signalling entry in Table SCHEDULER_SIGNAL_OBJECTS");
            return false;
        }
        catch (Exception e) {
            this.spooler_log.error("error occurred initializing job: " + e.getMessage());
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean spooler_process() {
        String request = "";
        String response = "";
        Variable_set parameters = null;
        SOSSchedulerCommand remoteCommand = null;
        String signalId = null;
        Map<String, String> res = null;
        try {
            if (this.listOfSignalObject.hasNext()) {
                SOSConnectionSettings settings;
                Properties section;
                res = this.listOfSignalObject.next();
                parameters = this.spooler_task.params();
                if ((this.sosString.parseToString((Object)this.getHost()).isEmpty() || "localhost".equalsIgnoreCase(this.sosString.parseToString((Object)this.getHost()))) && this.getPort() == 4444 && !this.sosString.parseToString(section = (settings = new SOSConnectionSettings(this.sosConnection, "SETTINGS")).getSection(this.application, this.sectionname), "scheduler.host").isEmpty()) {
                    this.setHost(this.sosString.parseToString(section, "scheduler.host"));
                    this.spooler_log.info(".. settings [scheduler.host]: " + this.getHost());
                    if (!this.sosString.parseToString(section, "scheduler.port").isEmpty()) {
                        int sPort = 0;
                        try {
                            sPort = Integer.parseInt(this.sosString.parseToString(section, "scheduler.port"));
                            this.setPort(sPort);
                            this.spooler_log.info(".. settings [scheduler.port]: " + this.getPort());
                        }
                        catch (Exception e) {
                            this.spooler_log.warn("..error while reading settings[scheduler.port]: " + e.getMessage());
                        }
                    }
                }
                signalId = this.sosString.parseToString(res, "signal_id");
                this.spooler_log.debug("..signal Id: " + signalId);
                request = "<add_order";
                request = request + " replace=\"" + (this.isReplace() ? "yes" : "no") + "\"";
                if (this.getOrderId() != null && !this.getOrderId().isEmpty()) {
                    request = request + " id=\"" + this.getOrderId() + "\"";
                }
                if (this.getAt() != null && !this.getAt().isEmpty()) {
                    request = request + " at=\"" + this.getAt() + "\"";
                }
                if (!this.sosString.parseToString(res, "job_chain").isEmpty()) {
                    request = request + " job_chain=\"" + this.sosString.parseToString(res, "job_chain") + "\"";
                } else if (this.getJobChain() != null && !this.getJobChain().isEmpty()) {
                    request = request + " job_chain=\"" + this.getJobChain() + "\"";
                }
                if (this.getPriority() != null && !this.getPriority().isEmpty()) {
                    request = request + " priority=\"" + this.getPriority() + "\"";
                }
                if (this.getState() != null && !this.getState().isEmpty()) {
                    request = request + " state=\"" + this.getState() + "\"";
                }
                request = request + " title=\"" + (this.sosString.parseToString((Object)this.getTitle()).length() > 0 ? this.getTitle() + ":" + signalId : signalId) + "\"";
                if (this.getWebService() != null && !this.getWebService().isEmpty()) {
                    request = request + " web_service=\"" + this.getWebService() + "\"";
                }
                request = request + ">";
                request = request + "<params>";
                String[] params = parameters.names().split(";");
                for (int i = 0; i < params.length; ++i) {
                    if (params[i].startsWith("scheduler_remote_") || "sos_settings_file".equalsIgnoreCase(params[i])) continue;
                    request = request + "<param name=\"" + params[i] + "\" value=\"" + parameters.var(params[i]) + "\"/>";
                }
                String selParameters = "SELECT \"NAME\", \"VALUE\", \"LONG_VALUE\" FROM SCHEDULER_SIGNAL_PARAMETERS WHERE \"SIGNAL_ID\" = " + signalId;
                if (!this.sosString.parseToString((Object)res.get("operation")).isEmpty()) {
                    String value = this.sosString.parseToString((Object)res.get("operation")).toLowerCase();
                    request = request + "<param name=\"operation\" value=\"" + value + "\"/>";
                }
                List listOfParams = this.sosConnection.getArray(selParameters);
                for (int i = 0; i < listOfParams.size(); ++i) {
                    Map h = (Map)listOfParams.get(i);
                    String value = !this.sosString.parseToString(h.get("value")).isEmpty() ? this.sosString.parseToString(h.get("value")) : this.sosString.parseToString(h.get("long_value"));
                    request = request + "<param name=\"" + (String)h.get("name") + "\" value=\"" + value + "\"/>";
                }
                request = request + "</params>";
                if (this.getRunTime() != null && !this.getRunTime().isEmpty()) {
                    request = request + this.getRunTime();
                }
                request = request + "</add_order>";
                remoteCommand = new SOSSchedulerCommand(this.getHost(), this.getPort(), this.getProtocol());
                remoteCommand.connect();
                this.spooler_log.info("sending request to remote Job Scheduler [" + this.getHost() + ":" + this.getPort() + "]: " + request);
                remoteCommand.sendRequest(request);
                if ("tcp".equalsIgnoreCase(this.getProtocol())) {
                    response = remoteCommand.getResponse();
                    SOSXMLXPath xpath = new SOSXMLXPath(new StringBuffer(response));
                    String errCode = xpath.selectSingleNodeValue("//ERROR/@code");
                    String errMessage = xpath.selectSingleNodeValue("//ERROR/@text");
                    this.spooler_log.info("remote job scheduler response: " + response);
                    if (errCode != null && !errCode.isEmpty() || errMessage != null && !errMessage.isEmpty()) {
                        this.spooler_log.warn("remote Job Scheduler response reports error message: " + errMessage + " [" + errCode + "]");
                    }
                }
                String upStr = "UPDATE SCHEDULER_SIGNAL_OBJECTS SET \"STATUS\" = 1 WHERE  \"SIGNAL_ID\" = " + signalId;
                this.sosConnection.executeUpdate(upStr);
                this.sosConnection.commit();
            }
            ++this.countProcessOk;
            boolean params = this.listOfSignalObject.hasNext();
            return params;
        }
        catch (Exception e) {
            ++this.countProcessError;
            this.spooler_log.error("error occurred for remote execution: " + e.getMessage());
            if (this.sosConnection != null) {
                try {
                    this.sosConnection.rollback();
                    String upStr = "UPDATE SCHEDULER_SIGNAL_OBJECTS SET \"STATUS\" = 1001 WHERE  \"SIGNAL_ID\" = " + signalId;
                    this.sosConnection.executeUpdate(upStr);
                    this.sosConnection.commit();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (remoteCommand != null) {
                try {
                    remoteCommand.disconnect();
                }
                catch (Exception exception) {}
            }
        }
    }

    public String getAfter() {
        return this.after;
    }

    public void setAfter(String after) {
        this.after = after;
    }

    public String getAt() {
        return this.at;
    }

    public void setAt(String at) {
        this.at = at;
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getJobChain() {
        return this.jobChain;
    }

    public void setJobChain(String jobChain) {
        this.jobChain = jobChain;
    }

    public String getJobName() {
        return this.jobName;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public String getOrderId() {
        return this.orderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getPriority() {
        return this.priority;
    }

    public void setPriority(String priority) {
        this.priority = priority;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) throws Exception {
        if (protocol == null || protocol.isEmpty()) {
            throw new Exception("no value was given for protocol [tcp, udp]");
        }
        if (!"tcp".equalsIgnoreCase(protocol) && !"udp".equalsIgnoreCase(protocol)) {
            throw new Exception("illegal value specified for protocol [tcp, udp], found: " + protocol);
        }
        this.protocol = protocol.toLowerCase();
    }

    public String getRunTime() {
        return this.runTime;
    }

    public void setRunTime(String runTime) {
        this.runTime = runTime;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getWebService() {
        return this.webService;
    }

    public void setWebService(String webService) {
        this.webService = webService;
    }

    public boolean isReplace() {
        return this.replace;
    }

    public void setReplace(boolean replace) {
        this.replace = replace;
    }

    public String getSosSettingsFile() {
        return this.sosSettingsFile;
    }

    public void setSosSettingsFile(String sosSettingsFile) {
        this.sosSettingsFile = sosSettingsFile;
    }

    private SOSConnection getConnection() throws Exception {
        SOSConnection conn = null;
        if (!this.sosString.parseToString((Object)this.getSosSettingsFile()).isEmpty()) {
            conn = this.getConnectionFromINIFile();
        }
        if (conn == null) {
            conn = JobSchedulerJob.getSchedulerConnection((SOSSettings)new SOSProfileSettings(this.spooler.ini_path()));
        }
        return conn;
    }

    private SOSConnection getConnectionFromINIFile() throws Exception {
        SOSConnection conn = null;
        try {
            this.spooler_log.debug3("DB Connecting.. .");
            conn = SOSConnection.createInstance((String)this.getSosSettingsFile());
            conn.connect();
            this.spooler_log.debug3("DB Connected");
        }
        catch (Exception e) {
            throw new Exception("error in " + SOSClassUtil.getMethodName() + ": connect to database failed: " + e.toString());
        }
        return conn;
    }

    public void spooler_exit() throws Exception {
        if (this.sosConnection != null) {
            try {
                this.sosConnection.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            this.showSummary();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void showSummary() throws Exception {
        try {
            this.spooler_log.debug5("..end time in miliseconds: " + System.currentTimeMillis());
            this.spooler_log.info("---------------------------------------------------------------");
            this.spooler_log.info("..number of documents                             : " + (this.countProcessOk + this.countProcessError));
            this.spooler_log.info("..number of records processed successfully        : " + this.countProcessOk);
            this.spooler_log.info("..number of records processed with errors         : " + this.countProcessError);
            this.spooler_log.info("..time elapsed in seconds                         : " + Math.round((System.currentTimeMillis() - this.timeInSec) / 1000L) + "s");
            this.spooler_log.info("---------------------------------------------------------------");
            String stateText = "..number of create order: " + (this.countProcessOk + this.countProcessError) + "(error=" + this.countProcessError + ";successfully=" + this.countProcessOk + ")";
            this.spooler_log.info(stateText);
            this.spooler_job.set_state_text(stateText);
        }
        catch (Exception e) {
            throw new Exception("\n -> ..error occurred in " + SOSClassUtil.getMethodName() + ": " + e);
        }
    }
}

