/*
 * Decompiled with CFR 0.152.
 */
package sos.scheduler.misc;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import sos.connection.SOSConnection;
import sos.connection.SOSMSSQLConnection;
import sos.spooler.Job;
import sos.spooler.Job_chain;
import sos.spooler.Order;
import sos.spooler.Spooler;
import sos.xml.SOSXMLXPath;

public class JobSchedulerHelper {
    private Spooler spooler;
    private SimpleDateFormat schedulerDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");

    public JobSchedulerHelper(Spooler spo) {
        this.spooler = spo;
    }

    public Job_chain getJobChain(String jobChainName, Job currentJob) throws Exception {
        Job_chain jobChain = null;
        if (this.spooler.job_chain_exists(jobChainName)) {
            jobChain = this.spooler.job_chain(jobChainName);
        } else {
            String jobChainCompletePath = currentJob.folder_path() + "/" + jobChainName;
            if (!this.spooler.job_chain_exists(jobChainCompletePath)) {
                throw new Exception("Job Chain " + jobChainName + " does not exist");
            }
            jobChain = this.spooler.job_chain(jobChainCompletePath);
        }
        return jobChain;
    }

    public String getJobChainPath(String jobChainName, Job currentJob) throws Exception {
        Object jobChain = null;
        if (this.spooler.job_chain_exists(jobChainName)) {
            return jobChainName;
        }
        String jobChainCompletePath = currentJob.folder_path() + "/" + jobChainName;
        if (!this.spooler.job_chain_exists(jobChainCompletePath)) {
            throw new Exception("Job Chain " + jobChainName + " does not exist");
        }
        return jobChainCompletePath;
    }

    public Calendar getLastStartOfOrder(String jobChainName, String orderID, SOSConnection connection) throws Exception {
        GregorianCalendar cal;
        block20: {
            Calendar calendar;
            ResultSet rs = null;
            try {
                if (jobChainName.startsWith("/")) {
                    jobChainName = jobChainName.substring(1);
                }
                String maxQuery = "MAX(s.\"ERROR\")=0";
                if (connection instanceof SOSMSSQLConnection) {
                    maxQuery = "MAX(CAST(s.\"ERROR\" AS INT))=0";
                }
                connection.executeStatements("SELECT MAX(h.\"START_TIME\") st FROM SCHEDULER_ORDER_HISTORY h WHERE  h.\"SPOOLER_ID\"='" + this.spooler.id() + "' AND h.\"JOB_CHAIN\"='" + jobChainName + "' AND h.\"ORDER_ID\"='" + orderID + "' AND h.\"END_TIME\" IS NOT NULL AND h.\"HISTORY_ID\" IN (SELECT s.\"HISTORY_ID\" FROM SCHEDULER_ORDER_STEP_HISTORY s GROUP BY s.\"HISTORY_ID\" HAVING " + maxQuery + ")");
                rs = connection.getResultSet();
                if (rs == null) {
                    throw new Exception("Resultset is null");
                }
                if (rs.next()) {
                    Timestamp ts = rs.getTimestamp(1);
                    if (ts == null) {
                        Calendar calendar2 = null;
                        return calendar2;
                    }
                    long milliseconds = ts.getTime() + (long)(ts.getNanos() / 1000000);
                    cal = new GregorianCalendar();
                    cal.setTimeInMillis(milliseconds);
                    break block20;
                }
                calendar = null;
            }
            catch (Exception e) {
                throw new Exception("Error retrieving last start of order:" + e);
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (Exception exception) {}
                }
            }
            return calendar;
        }
        return cal;
    }

    public Calendar getStartOfOrder(Order order) throws Exception {
        String xml = order.xml();
        StringBuffer xmlBuf = new StringBuffer(xml);
        SOSXMLXPath xp = new SOSXMLXPath(xmlBuf);
        String startTime = xp.selectSingleNodeValue("/order/@start_time");
        if (startTime == null || startTime.isEmpty()) {
            throw new Exception("No start_time attribute was found for the current order");
        }
        Date dat = this.schedulerDateFormat.parse(startTime);
        Calendar cal = Calendar.getInstance();
        cal.setTime(dat);
        return cal;
    }
}

