/*
 * Decompiled with CFR 0.152.
 */
package com.sos.yade.commons;

import java.util.HashMap;
import java.util.Map;

public class Yade {
    public static final String JOB_ARGUMENT_NAME_RETURN_VALUES = "yade_return_values";
    public static final String DEFAULT_ACCOUNT = ".";

    public static enum TransferEntryState {
        UNKNOWN(1),
        WAITING(2),
        TRANSFERRING(3),
        IN_PROGRESS(4),
        TRANSFERRED(5),
        SKIPPED(6),
        FAILED(7),
        ABORTED(8),
        COMPRESSED(9),
        NOT_OVERWRITTEN(10),
        DELETED(11),
        RENAMED(12),
        IGNORED_DUE_TO_ZEROBYTE_CONSTRAINT(13),
        ROLLED_BACK(14),
        POLLING(15),
        MOVED(16),
        SUCCESS(17);

        private final Integer intValue;
        private static final Map<String, TransferEntryState> CONSTANTS;
        private static final Map<Integer, TransferEntryState> INTCONSTANTS;

        private TransferEntryState(Integer intValue) {
            this.intValue = intValue;
        }

        public String toString() {
            return this.name();
        }

        public String value() {
            return this.name().toLowerCase();
        }

        public Integer intValue() {
            return this.intValue;
        }

        public static TransferEntryState fromValue(String value) {
            TransferEntryState constant = CONSTANTS.get(value.toUpperCase());
            if (constant == null) {
                return UNKNOWN;
            }
            return constant;
        }

        public static TransferEntryState fromValue(Integer intValue) {
            TransferEntryState constant = INTCONSTANTS.get(intValue);
            if (constant == null) {
                return UNKNOWN;
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, TransferEntryState>();
            INTCONSTANTS = new HashMap<Integer, TransferEntryState>();
            for (TransferEntryState c : TransferEntryState.values()) {
                CONSTANTS.put(c.name(), c);
            }
            for (TransferEntryState c : TransferEntryState.values()) {
                INTCONSTANTS.put(c.intValue, c);
            }
        }
    }

    public static enum TransferState {
        UNKNOWN(0),
        SUCCESSFUL(1),
        INCOMPLETE(2),
        FAILED(3);

        private final Integer intValue;
        private static final Map<String, TransferState> CONSTANTS;
        private static final Map<Integer, TransferState> INTCONSTANTS;

        private TransferState(Integer intValue) {
            this.intValue = intValue;
        }

        public String toString() {
            return this.name();
        }

        public String value() {
            return this.name().toLowerCase();
        }

        public Integer intValue() {
            return this.intValue;
        }

        public static TransferState fromValue(String value) {
            TransferState constant = CONSTANTS.get(value.toUpperCase());
            if (constant == null) {
                return UNKNOWN;
            }
            return constant;
        }

        public static TransferState fromValue(Integer intValue) {
            TransferState constant = INTCONSTANTS.get(intValue);
            if (constant == null) {
                return UNKNOWN;
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, TransferState>();
            INTCONSTANTS = new HashMap<Integer, TransferState>();
            for (TransferState c : TransferState.values()) {
                CONSTANTS.put(c.name(), c);
            }
            for (TransferState c : TransferState.values()) {
                INTCONSTANTS.put(c.intValue, c);
            }
        }
    }

    public static enum TransferProtocol {
        UNKNOWN(0),
        LOCAL(1),
        FTP(2),
        FTPS(3),
        SFTP(4),
        HTTP(5),
        HTTPS(6),
        WEBDAV(7),
        WEBDAVS(8),
        SMB(9),
        SSH(100),
        ZIP(200),
        MQ(300),
        SMTP(400),
        IMAP(500);

        private final Integer intValue;
        private static final Map<String, TransferProtocol> CONSTANTS;
        private static final Map<Integer, TransferProtocol> INTCONSTANTS;

        private TransferProtocol(Integer intValue) {
            this.intValue = intValue;
        }

        public String toString() {
            return this.name();
        }

        public String value() {
            return this.name().toLowerCase();
        }

        public Integer intValue() {
            return this.intValue;
        }

        public static TransferProtocol fromValue(String value) {
            TransferProtocol constant = CONSTANTS.get(value.toUpperCase());
            if (constant == null) {
                return UNKNOWN;
            }
            return constant;
        }

        public static TransferProtocol fromValue(Integer intValue) {
            TransferProtocol constant = INTCONSTANTS.get(intValue);
            if (constant == null) {
                return UNKNOWN;
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, TransferProtocol>();
            INTCONSTANTS = new HashMap<Integer, TransferProtocol>();
            for (TransferProtocol c : TransferProtocol.values()) {
                CONSTANTS.put(c.name(), c);
            }
            for (TransferProtocol c : TransferProtocol.values()) {
                INTCONSTANTS.put(c.intValue, c);
            }
        }
    }

    public static enum TransferOperation {
        UNKNOWN(0),
        COPY(1),
        MOVE(2),
        GETLIST(3),
        RENAME(4),
        COPYTOINTERNET(5),
        COPYFROMINTERNET(6),
        REMOVE(7);

        private final Integer intValue;
        private static final Map<String, TransferOperation> CONSTANTS;
        private static final Map<Integer, TransferOperation> INTCONSTANTS;

        private TransferOperation(Integer intValue) {
            this.intValue = intValue;
        }

        public String toString() {
            return this.name();
        }

        public String value() {
            return this.name().toLowerCase();
        }

        public Integer intValue() {
            return this.intValue;
        }

        public static TransferOperation fromValue(String value) {
            TransferOperation constant = CONSTANTS.get(value.toUpperCase());
            if (constant == null) {
                return UNKNOWN;
            }
            return constant;
        }

        public static TransferOperation fromValue(Integer intValue) {
            TransferOperation constant = INTCONSTANTS.get(intValue);
            if (constant == null) {
                return UNKNOWN;
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, TransferOperation>();
            INTCONSTANTS = new HashMap<Integer, TransferOperation>();
            for (TransferOperation c : TransferOperation.values()) {
                CONSTANTS.put(c.name(), c);
            }
            for (TransferOperation c : TransferOperation.values()) {
                INTCONSTANTS.put(c.intValue, c);
            }
        }
    }
}

