/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.jobs.db.common;

import com.sos.commons.hibernate.SOSHibernateSQLExecutor;
import com.sos.commons.util.SOSDate;
import com.sos.commons.util.SOSPath;
import com.sos.commons.xml.SOSXML;
import com.sos.js7.job.OrderProcessStepLogger;
import java.io.BufferedWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.sql.ResultSet;
import java.time.Instant;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class Export2XML {
    private static final String NEW_LINE = "\r\n";
    private static final Pattern NUMERIC_PATTERN = Pattern.compile("-?\\d+(\\.\\d+)?");

    public static void export(ResultSet resultSet, Path outputFile, OrderProcessStepLogger logger) throws Exception {
        if (resultSet == null) {
            throw new Exception("missing ResultSet");
        }
        if (outputFile == null) {
            throw new Exception("missing outputFile");
        }
        BufferedWriter writer = null;
        boolean removeOutputFile = false;
        try {
            Instant start = Instant.now();
            Document dom = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            writer = Files.newBufferedWriter(outputFile, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n");
            writer.write("<RESULTSET>\r\n");
            int dataRows = 0;
            int columnCount = resultSet.getMetaData().getColumnCount();
            String[] columnLabels = Export2XML.normalizeLabels(SOSHibernateSQLExecutor.getColumnLabels((ResultSet)resultSet));
            while (resultSet.next()) {
                int count;
                writer.write("    <ROW>\r\n");
                for (int i = 1; i <= columnCount; ++i) {
                    String label = columnLabels[i - 1];
                    writer.write("        <" + label + ">" + Export2XML.getElementText(dom, resultSet.getObject(i)) + "</" + label + ">\r\n");
                }
                writer.write("    </ROW>\r\n");
                if ((count = ++dataRows) % 1000 != 0) continue;
                logger.info("[export]%s entries processed ...", new Object[]{count});
            }
            writer.write("</RESULTSET>");
            logger.info("[export][%s]total data rows written=%s, duration=%s", new Object[]{outputFile, dataRows, SOSDate.getDuration((Instant)start, (Instant)Instant.now())});
        }
        catch (Throwable e) {
            removeOutputFile = true;
            String f = outputFile.toString();
            try {
                f = outputFile.toAbsolutePath().toString();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw new Exception(String.format("[%s]%s", f, e.toString()), e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.flush();
                }
                catch (Exception start) {}
                try {
                    writer.close();
                }
                catch (Exception start) {}
            }
            if (removeOutputFile) {
                try {
                    SOSPath.deleteIfExists((Path)outputFile);
                }
                catch (Exception start) {}
            }
        }
    }

    private static String getElementText(Document dom, Object o) {
        if (o != null) {
            try {
                return SOSXML.nodeToString((Node)dom.createCDATASection(SOSHibernateSQLExecutor.sqlValueToString((Object)o)));
            }
            catch (Throwable e) {
                return "<![CDATA[" + o.toString() + "]]>";
            }
        }
        return "";
    }

    private static String[] normalizeLabels(String[] labels) {
        String[] r = new String[labels.length];
        for (int i = 0; i < labels.length; ++i) {
            r[i] = Export2XML.normalizeLabel(labels[i]);
        }
        return r;
    }

    private static String normalizeLabel(String label) {
        Object r = label.replaceAll("//s|'|:|\\.|,|<|>|-|\"", "");
        if (Export2XML.isNumeric((String)r)) {
            r = "Column" + (String)r;
        }
        return r;
    }

    private static boolean isNumeric(String val) {
        if (val == null) {
            return false;
        }
        return NUMERIC_PATTERN.matcher(val).matches();
    }
}

