/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.jobs.db.oracle;

import com.sos.commons.credentialstore.CredentialStoreArguments;
import com.sos.commons.hibernate.SOSHibernateFactory;
import com.sos.commons.hibernate.SOSHibernateSession;
import com.sos.commons.hibernate.exception.SOSHibernateConfigurationException;
import com.sos.commons.util.SOSString;
import com.sos.jitl.jobs.db.common.Export2CSV;
import com.sos.jitl.jobs.db.common.Export2JSON;
import com.sos.jitl.jobs.db.common.Export2XML;
import com.sos.jitl.jobs.db.oracle.DbmsOutput;
import com.sos.jitl.jobs.db.oracle.PLSQLJobArguments;
import com.sos.js7.job.Job;
import com.sos.js7.job.OrderProcessStep;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import js7.launcher.forjava.internal.BlockingInternalJob;

public class PLSQLJob
extends Job<PLSQLJobArguments> {
    private static final String STD_OUT_OUTPUT = "std_out_output";
    private static final String DBMS_OUTPUT = "dbms_output";

    public PLSQLJob(BlockingInternalJob.JobContext jobContext) {
        super(jobContext);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void processOrder(OrderProcessStep<PLSQLJobArguments> step) throws Exception {
        ((PLSQLJobArguments)step.getDeclaredArguments()).checkRequired();
        SOSHibernateFactory factory = null;
        SOSHibernateSession session = null;
        try {
            factory = this.getHibernateFactory(step);
            session = factory.openStatelessSession(PLSQLJob.class.getSimpleName());
            step.addCancelableResource(session);
            this.process(step, session);
            if (factory == null) return;
        }
        catch (Throwable e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                if (factory == null) throw throwable;
                try {
                    factory.close(session);
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        try {
            factory.close(session);
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }

    private SOSHibernateFactory getHibernateFactory(OrderProcessStep<PLSQLJobArguments> step) throws Exception {
        PLSQLJobArguments args = (PLSQLJobArguments)step.getDeclaredArguments();
        SOSHibernateFactory f = null;
        if (args.useHibernateFile()) {
            if (!Files.exists(args.getHibernateFile(), new LinkOption[0])) {
                throw new SOSHibernateConfigurationException(String.format("hibernate config file not found: %s", args.getHibernateFile()));
            }
            f = new SOSHibernateFactory(args.getHibernateFile());
        } else {
            Properties p = new Properties();
            p.put("hibernate.dialect", args.getDbDialect().getValue());
            p.put("jakarta.persistence.jdbc.driver", args.getDbDriverClass().getValue());
            p.put("jakarta.persistence.jdbc.url", args.getDbUrl().getValue());
            if (!SOSString.isEmpty((String)((String)args.getDbUser().getValue()))) {
                p.put("jakarta.persistence.jdbc.user", args.getDbUser().getValue());
            } else {
                p.put("jakarta.persistence.jdbc.user", "");
            }
            if (!SOSString.isEmpty((String)((String)args.getDbPassword().getValue()))) {
                p.put("jakarta.persistence.jdbc.password", args.getDbPassword().getValue());
            } else {
                p.put("jakarta.persistence.jdbc.password", "");
            }
            p.put("hibernate.connection.provider_class", "org.hibernate.hikaricp.internal.HikariCPConnectionProvider");
            p.put("hibernate.hikari.maximumPoolSize", "1");
            f = new SOSHibernateFactory();
            f.getConfigurationProperties().putAll((Map<?, ?>)p);
        }
        CredentialStoreArguments csArgs = (CredentialStoreArguments)step.getIncludedArguments(CredentialStoreArguments.class);
        if (csArgs != null) {
            Properties p = new Properties();
            if (!SOSString.isEmpty((String)((String)csArgs.getFile().getValue()))) {
                p.put("hibernate.sos.credential_store_file", csArgs.getFile().getValue());
            }
            if (!SOSString.isEmpty((String)((String)csArgs.getKeyFile().getValue()))) {
                p.put("hibernate.sos.credential_store_key_file", csArgs.getKeyFile().getValue());
            }
            if (!SOSString.isEmpty((String)((String)csArgs.getPassword().getValue()))) {
                p.put("hibernate.sos.credential_store_password", csArgs.getPassword().getValue());
            }
            if (!SOSString.isEmpty((String)((String)csArgs.getEntryPath().getValue()))) {
                p.put("hibernate.sos.credential_store_entry_path", csArgs.getEntryPath().getValue());
            }
            if (p.size() > 0) {
                f.getConfigurationProperties().putAll((Map<?, ?>)p);
            }
        }
        f.build();
        return f;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void process(OrderProcessStep<PLSQLJobArguments> step, SOSHibernateSession session) throws Exception {
        PLSQLJobArguments args = (PLSQLJobArguments)step.getDeclaredArguments();
        Object plsql = "";
        if (args.getCommand() != null && !args.getCommand().isEmpty()) {
            plsql = args.getCommand();
        }
        if (args.getCommandScriptFile() != null) {
            plsql = (String)plsql + args.getCommandScriptFileContent();
        }
        plsql = this.unescapeXML((String)plsql).replace("\r\n", "\n");
        step.getLogger().info((Object)String.format("substituted Statement: %s", plsql));
        step.getOutcome().putVariable(DBMS_OUTPUT, (Object)"");
        step.getOutcome().putVariable(STD_OUT_OUTPUT, (Object)"");
        DbmsOutput out = null;
        Statement cs = null;
        try {
            Connection connection = session.getConnection();
            out = new DbmsOutput(connection);
            out.enable(1000000);
            cs = connection.prepareCall((String)plsql);
            session.setCurrentStatement(cs);
            cs.execute();
            String output = out.getOutput();
            step.getLogger().info((Object)output);
            if (output != null) {
                String[] arr;
                step.getOutcome().putVariable(DBMS_OUTPUT, (Object)output);
                step.getOutcome().putVariable(STD_OUT_OUTPUT, (Object)output);
                int regExpFlags = 42;
                Pattern regExprPattern = Pattern.compile(args.getVariableParserRegExpr(), regExpFlags);
                boolean found = false;
                for (String string : arr = output.split("\n")) {
                    Matcher matcher = regExprPattern.matcher(string);
                    if (!matcher.matches() || matcher.group().length() < 2) continue;
                    step.getOutcome().putVariable(matcher.group(1), (Object)matcher.group(2).trim());
                    found = true;
                }
                out.close();
                out = null;
                if (!found) {
                    step.getLogger().debug((Object)String.format("no JS-variable definitions found using reg-exp '%1$s'.", args.getVariableParserRegExpr()));
                }
            }
            if (args.getResultSetAs() == null) return;
            ResultSet rs = cs.getResultSet();
            if (rs == null) {
                step.getLogger().info("[export][%s][skip]command did not generate a result set.", new Object[]{args.getResultFile().toString()});
                return;
            }
            switch (args.getResultSetAs()) {
                case CSV: {
                    Export2CSV.export(rs, args.getResultFile(), step.getLogger());
                    return;
                }
                case XML: {
                    Export2XML.export(rs, args.getResultFile(), step.getLogger());
                    return;
                }
                case JSON: {
                    Export2JSON.export(rs, args.getResultFile(), step.getLogger());
                    return;
                }
            }
            return;
        }
        catch (SQLException e) {
            String msg = String.format("SQL Exception raised. Msg='%1$s', Status='%2$s'", e.getMessage(), e.getSQLState());
            step.getLogger().debug((Object)msg);
            throw new Exception(msg, e);
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (cs != null) {
                cs.close();
                cs = null;
            }
            session.resetCurrentStatement();
        }
    }

    private String unescapeXML(String stringValue) {
        String newValue = stringValue;
        if (newValue.indexOf("&") != -1) {
            newValue = newValue.replaceAll("&quot;", "\"");
            newValue = newValue.replaceAll("&lt;", "<");
            newValue = newValue.replaceAll("&gt;", ">");
            newValue = newValue.replaceAll("&amp;", "&");
            newValue = newValue.replaceAll("&apos;", "'");
            newValue = newValue.replaceAll("&#13;", "\r");
            newValue = newValue.replaceAll("&#x0d;", "\r");
            newValue = newValue.replaceAll("&#xd;", "\r");
            newValue = newValue.replaceAll("&#09;", "\t");
            newValue = newValue.replaceAll("&#9;", "\t");
            newValue = newValue.replaceAll("&#10;", "\n");
            newValue = newValue.replaceAll("&#x0a;", "\n");
            newValue = newValue.replaceAll("&#xa;", "\n");
        }
        return newValue;
    }
}

