/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.jobs.ssh;

import com.sos.commons.credentialstore.CredentialStoreArguments;
import com.sos.commons.util.SOSParameterSubstitutor;
import com.sos.commons.util.SOSString;
import com.sos.commons.util.common.SOSCommandResult;
import com.sos.commons.util.common.SOSEnv;
import com.sos.commons.vfs.ssh.SSHProvider;
import com.sos.commons.vfs.ssh.common.SSHProviderArguments;
import com.sos.jitl.jobs.ssh.SSHJobArguments;
import com.sos.jitl.jobs.ssh.exception.SOSJobSSHException;
import com.sos.jitl.jobs.ssh.util.SSHJobUtil;
import com.sos.js7.job.Job;
import com.sos.js7.job.OrderProcessStep;
import com.sos.js7.job.OrderProcessStepLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SSHJob
extends Job<SSHJobArguments> {
    private SOSParameterSubstitutor parameterSubstitutor = new SOSParameterSubstitutor();

    public void processOrder(OrderProcessStep<SSHJobArguments> step) throws Exception {
        SOSCommandResult result;
        OrderProcessStepLogger logger;
        SSHJobArguments jobArgs;
        block31: {
            SSHProviderArguments providerArgs = (SSHProviderArguments)step.getIncludedArguments(SSHProviderArguments.class);
            SSHProvider provider = new SSHProvider(providerArgs, (CredentialStoreArguments)step.getIncludedArguments(CredentialStoreArguments.class));
            step.addCancelableResource(provider);
            jobArgs = (SSHJobArguments)step.getDeclaredArguments();
            SOSEnv envVars = new SOSEnv();
            logger = step.getLogger();
            String returnValuesFileName = "sos-ssh-return-values-" + UUID.randomUUID() + ".txt";
            String resolvedReturnValuesFileName = null;
            boolean isWindowsShell = false;
            String delimiter = null;
            ArrayList<String> tempFilesToDelete = new ArrayList<String>();
            ArrayList<Path> localTempFilesToDelete = new ArrayList<Path>();
            result = null;
            try {
                logger.info("[connect]%s:%s ...", new Object[]{providerArgs.getHost().getDisplayValue(), providerArgs.getPort().getDisplayValue()});
                provider.connect();
                logger.info("[connected][%s:%s]%s", new Object[]{providerArgs.getHost().getDisplayValue(), providerArgs.getPort().getDisplayValue(), provider.getServerInfo().toString()});
                isWindowsShell = provider.getServerInfo().hasWindowsShell();
                String string = delimiter = isWindowsShell ? "&" : ";";
                if (jobArgs.getCommandDelimiter().isDirty()) {
                    delimiter = (String)jobArgs.getCommandDelimiter().getValue();
                }
                Map<Object, Object> allEnvVars = Collections.emptyMap();
                if (((Boolean)jobArgs.getCreateEnvVars().getValue()).booleanValue()) {
                    Map<String, String> js7EnvVars = SSHJobUtil.getJS7EnvVars();
                    Map<String, String> envVarsOfWorkflowParameters = SSHJobUtil.getWorkflowParamsAsEnvVars(step, jobArgs);
                    Map<String, String> stepEnvVars = SSHJobUtil.getJobResourceEnvVars(step);
                    allEnvVars = Stream.of(js7EnvVars, envVarsOfWorkflowParameters, stepEnvVars).flatMap(map -> map.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                    Map<String, String> resolved = this.resolveReturnValuesFilename(jobArgs, tempFilesToDelete, returnValuesFileName, isWindowsShell, logger);
                    resolvedReturnValuesFileName = resolved.get(resolved.keySet().toArray()[0]);
                    allEnvVars.putAll(resolved);
                    envVars.setLocalEnvs(allEnvVars);
                    if (logger.isDebugEnabled()) {
                        this.logWorkflowCredentials(step);
                        logger.debug((Object)"Systems Environment Variables - JS7");
                        this.logSosEnvVars(js7EnvVars, logger);
                        logger.debug((Object)"Additional Environment Variables - workflow");
                        this.logSosEnvVars(envVarsOfWorkflowParameters, logger);
                    }
                } else {
                    Map<String, String> resolved = this.resolveReturnValuesFilename(jobArgs, tempFilesToDelete, returnValuesFileName, isWindowsShell, logger);
                    resolvedReturnValuesFileName = resolved.get(resolved.keySet().toArray()[0]);
                    envVars.setLocalEnvs(resolved);
                }
                String[] commands = new String[]{};
                if (!jobArgs.getCommand().isEmpty()) {
                    commands = this.splitCommands(jobArgs, logger);
                    if (!jobArgs.getCommandScriptFile().isEmpty()) {
                        String remoteCmdScriptFilepath = this.createRemoteCommandScript(provider, jobArgs, tempFilesToDelete, localTempFilesToDelete, isWindowsShell, logger);
                        envVars.getLocalEnvs().put("JS7_SSH_TMP_SCRIPT_FILE", remoteCmdScriptFilepath);
                        if (jobArgs.getCommandScriptParam().isDirty() && !jobArgs.getCommandScriptParam().isEmpty()) {
                            String cmdScriptParams = (String)jobArgs.getCommandScriptParam().getValue();
                            envVars.getLocalEnvs().put("JS7_SSH_SCRIPT_PARAMS", cmdScriptParams);
                        }
                    }
                } else {
                    commands = new String[]{this.createRemoteCommandScript(provider, jobArgs, tempFilesToDelete, localTempFilesToDelete, isWindowsShell, logger)};
                    if (jobArgs.getCommandScriptParam().isDirty() && !jobArgs.getCommandScriptParam().isEmpty()) {
                        commands[0] = commands[0] + " " + (String)jobArgs.getCommandScriptParam().getValue();
                    }
                }
                logger.info("command]%s", new Object[]{commands[0]});
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)String.format("createEnvironmentVariables=%s, simulateShell=%s", jobArgs.getCreateEnvVars().getValue(), providerArgs.getSimulateShell().getValue()));
                }
                for (String command : commands) {
                    StringBuilder preCommand = new StringBuilder();
                    SSHJobUtil.addPreCommand(jobArgs, preCommand, isWindowsShell, delimiter, resolvedReturnValuesFileName);
                    command = SSHJobUtil.substituteVariables(this.parameterSubstitutor, command);
                    if (preCommand.length() > 0) {
                        if (logger.isDebugEnabled() && preCommand.length() > 0) {
                            logger.debug((Object)String.format("[preCommand] %s", preCommand));
                        }
                        command = preCommand.append(command).toString();
                        if (logger.isTraceEnabled() && preCommand.length() > 0) {
                            logger.trace((Object)String.format("[full command] %s", command));
                        }
                    }
                    if (!SOSString.isEmpty((String)(result = provider.executeCommand(command, envVars)).getStdOut())) {
                        step.getOutcome().putVariable("std_out", (Object)result.getStdOut());
                        logger.info("[stdOut] %s", new Object[]{result.getStdOut()});
                    }
                    if (!SOSString.isEmpty((String)result.getStdErr())) {
                        step.getOutcome().putVariable("std_err", (Object)result.getStdErr());
                        logger.error("[stdErr] %s", new Object[]{result.getStdErr()});
                    }
                    logger.info("[returnCode] %s", new Object[]{result.getExitCode()});
                    step.getOutcome().putVariable("exit_code", (Object)result.getExitCode());
                    step.getOutcome().putVariable("returnCode", (Object)result.getExitCode());
                    if (result.getException() == null) continue;
                    step.getOutcome().putVariable("exception", (Object)result.getException());
                    logger.info("[exception] %s", new Object[]{SOSString.toString((Throwable)result.getException())});
                }
                if (resolvedReturnValuesFileName != null) {
                    step.getOutcome().putVariables(this.executePostCommand(jobArgs, provider, resolvedReturnValuesFileName, isWindowsShell, logger));
                }
                if (provider == null) break block31;
                this.deleteTempFiles(jobArgs, provider, tempFilesToDelete, isWindowsShell, logger);
            }
            catch (Throwable e) {
                try {
                    if (((Boolean)jobArgs.getRaiseExceptionOnError().getValue()).booleanValue()) {
                        if (((Boolean)jobArgs.getIgnoreError().getValue()).booleanValue()) {
                            logger.debug(e.toString(), new Object[]{e});
                        } else {
                            if (e instanceof SOSJobSSHException) {
                                throw e;
                            }
                            StringBuilder sb = new StringBuilder(e.getClass().getSimpleName());
                            sb.append(": ").append(e.getMessage());
                            if (e.getCause() != null) {
                                sb.append(" ").append(e.getCause());
                            }
                            throw new SOSJobSSHException(sb.toString(), e);
                        }
                    }
                    if (!((Boolean)jobArgs.getIgnoreStdErr().getValue()).booleanValue()) {
                        if (e instanceof SOSJobSSHException) {
                            throw e;
                        }
                        String msg = "error occurred processing ssh command: " + e.getMessage() + " " + e.getCause();
                        throw new SOSJobSSHException(msg, e);
                    }
                    throw e;
                }
                catch (Throwable throwable) {
                    if (provider != null) {
                        this.deleteTempFiles(jobArgs, provider, tempFilesToDelete, isWindowsShell, logger);
                        provider.disconnect();
                        this.deleteLocalTempFiles(localTempFilesToDelete, logger);
                        logger.info("[disconnected]%s:%s", new Object[]{providerArgs.getHost().getDisplayValue(), providerArgs.getPort().getDisplayValue()});
                    }
                    if (result != null) {
                        SSHJobUtil.checkStdErr(result.getStdErr(), jobArgs, logger);
                        SSHJobUtil.checkExitCode(result.getExitCode(), jobArgs, step.getOutcome(), logger);
                    }
                    throw throwable;
                }
            }
            provider.disconnect();
            this.deleteLocalTempFiles(localTempFilesToDelete, logger);
            logger.info("[disconnected]%s:%s", new Object[]{providerArgs.getHost().getDisplayValue(), providerArgs.getPort().getDisplayValue()});
        }
        if (result != null) {
            SSHJobUtil.checkStdErr(result.getStdErr(), jobArgs, logger);
            SSHJobUtil.checkExitCode(result.getExitCode(), jobArgs, step.getOutcome(), logger);
        }
    }

    private String[] splitCommands(SSHJobArguments jobArgs, OrderProcessStepLogger logger) {
        logger.info("[execute commands]%s", new Object[]{jobArgs.getCommand().getDisplayValue()});
        return ((String)jobArgs.getCommand().getValue()).split((String)jobArgs.getCommandDelimiter().getValue());
    }

    private String createRemoteCommandScript(SSHProvider provider, SSHJobArguments jobArgs, List<String> tempFilesToDelete, List<Path> localTempFilesToDelete, boolean isWindowsShell, OrderProcessStepLogger logger) throws Exception {
        if (!jobArgs.getCommandScript().isEmpty()) {
            logger.info("[execute command script]%s", new Object[]{jobArgs.getCommandScript().getDisplayValue()});
            return this.putCommandScriptFile(SSHJobUtil.substituteVariables(this.parameterSubstitutor, (String)jobArgs.getCommandScript().getValue()), provider, jobArgs, tempFilesToDelete, localTempFilesToDelete, isWindowsShell, logger);
        }
        if (!jobArgs.getCommandScriptFile().isEmpty()) {
            logger.info("[execute command script file]%s", new Object[]{jobArgs.getCommandScriptFile().getDisplayValue()});
            String commandScript = new String(Files.readAllBytes(Paths.get((String)jobArgs.getCommandScriptFile().getValue(), new String[0])));
            return this.putCommandScriptFile(SSHJobUtil.substituteVariables(this.parameterSubstitutor, commandScript), provider, jobArgs, tempFilesToDelete, localTempFilesToDelete, isWindowsShell, logger);
        }
        return null;
    }

    private void logSosEnvVars(Map<String, String> env, OrderProcessStepLogger logger) {
        logger.debug("%-30s | %s", new Object[]{"KEY", "VALUE"});
        for (Map.Entry<String, String> entry : env.entrySet()) {
            logger.debug("%-30s | %s", new Object[]{entry.getKey(), entry.getValue()});
        }
    }

    private void logWorkflowCredentials(OrderProcessStep<SSHJobArguments> step) throws Exception {
        step.getLogger().debug("Order ID that startet the Job: %s", new Object[]{step.getOrderId()});
        step.getLogger().debug("Workflow name the Job is running in: %s", new Object[]{step.getWorkflowName()});
        step.getLogger().debug("Workflow position of the Job: %s", new Object[]{step.getWorkflowPosition()});
        step.getLogger().debug("CommitID of the workflow: %s", new Object[]{step.getWorkflowVersionId()});
    }

    private String putCommandScriptFile(String content, SSHProvider provider, SSHJobArguments jobArgs, List<String> tempFilesToDelete, List<Path> localTempFilesToDelete, boolean isWindowsShell, OrderProcessStepLogger logger) throws Exception {
        if (!isWindowsShell) {
            content = content.replaceAll("(?m)\r", "");
        }
        File source = File.createTempFile("sos-ssh-script-", isWindowsShell ? ".cmd" : ".sh");
        this.addLocalTemporaryFilesToDelete(source.getPath(), localTempFilesToDelete, logger);
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(source)));
        out.write(content);
        out.flush();
        out.close();
        source.deleteOnExit();
        Object target = source.getName();
        if (jobArgs.getTmpDir().isDirty()) {
            target = Paths.get((String)jobArgs.getTmpDir().getValue(), new String[0]).resolve((String)target).toString().replace('\\', '/');
        } else if (!isWindowsShell) {
            target = "./" + (String)target;
        }
        logger.info((Object)String.format("[tmp commandScript file locally][tmp command script file remote] [%s] : [%s]", source.getCanonicalPath(), target));
        provider.put(source.getCanonicalPath(), (String)target, 448);
        this.addTemporaryFilesToDelete((String)target, tempFilesToDelete, logger);
        return target;
    }

    private void addLocalTemporaryFilesToDelete(String filepath, List<Path> localTempFilesToDelete, OrderProcessStepLogger logger) {
        if (!SOSString.isEmpty((String)filepath)) {
            localTempFilesToDelete.add(Paths.get(filepath, new String[0]));
            logger.debug((Object)String.format("local file %s marked for deletion", filepath));
        }
    }

    private void addTemporaryFilesToDelete(String filepath, List<String> tempFilesToDelete, OrderProcessStepLogger logger) {
        if (!SOSString.isEmpty((String)filepath)) {
            tempFilesToDelete.add(filepath);
            logger.debug((Object)String.format("remote file %s marked for deletion", filepath));
        }
    }

    private Map<String, String> resolveReturnValuesFilename(SSHJobArguments jobArgs, List<String> tempFilesToDelete, String returnValuesFileName, boolean isWindowsShell, OrderProcessStepLogger logger) {
        String resolvedReturnValuesFileName = SSHJobUtil.resolve(jobArgs, returnValuesFileName, isWindowsShell);
        this.addTemporaryFilesToDelete(resolvedReturnValuesFileName, tempFilesToDelete, logger);
        HashMap<String, String> retVal = new HashMap<String, String>();
        retVal.put("JS7_RETURN_VALUES", resolvedReturnValuesFileName);
        return retVal;
    }

    private Map<String, Object> executePostCommand(SSHJobArguments jobArgs, SSHProvider provider, String resolvedReturnValuesFileName, boolean isWindowsShell, OrderProcessStepLogger logger) {
        HashMap<String, Object> outcomes = new HashMap<String, Object>();
        try {
            SOSCommandResult result;
            String postCommandRead = null;
            postCommandRead = jobArgs.getPostCommandRead().isDirty() ? String.format((String)jobArgs.getPostCommandRead().getValue(), resolvedReturnValuesFileName) : (isWindowsShell ? String.format("if exist \"%s\" type \"%s\"", resolvedReturnValuesFileName, resolvedReturnValuesFileName) : String.format((String)jobArgs.getPostCommandRead().getDefaultValue(), resolvedReturnValuesFileName, resolvedReturnValuesFileName));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("[postCommandRead] %s", postCommandRead));
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("[postCommandRead] %s", postCommandRead));
            }
            if ((result = provider.executeCommand(postCommandRead)).getExitCode() == 0 && !result.getStdOut().toString().isEmpty()) {
                BufferedReader reader = new BufferedReader(new StringReader(new String(result.getStdOut())));
                String line = null;
                while ((line = reader.readLine()) != null) {
                    Matcher regExMatcher = Pattern.compile("^([^=]+)=(.*)").matcher(line);
                    if (!regExMatcher.find()) continue;
                    String key = regExMatcher.group(1).trim();
                    String value = regExMatcher.group(2).trim();
                    outcomes.put(key, value);
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)String.format("[return value added to outcomes] Key: %1$s = Value: %2$s", key, value));
                }
            }
            return outcomes;
        }
        catch (Exception e) {
            logger.warn(e.toString(), (Throwable)e);
            return outcomes;
        }
    }

    private void deleteTempFiles(SSHJobArguments jobArgs, SSHProvider provider, List<String> tempFilesToDelete, boolean isWindowsShell, OrderProcessStepLogger logger) {
        if (tempFilesToDelete != null && !tempFilesToDelete.isEmpty()) {
            for (String file : tempFilesToDelete) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("[deleteTempFiles]" + file));
                }
                String cmd = null;
                cmd = jobArgs.getPostCommandDelete().isDirty() ? String.format((String)jobArgs.getPostCommandDelete().getValue(), file) : (isWindowsShell ? String.format("del \"%s\"", file) : String.format((String)jobArgs.getPostCommandDelete().getDefaultValue(), file, file));
                try {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("[deleteTempFiles]" + cmd));
                    }
                    provider.executeCommand(cmd);
                }
                catch (Exception e) {
                    logger.warn(String.format("error ocurred deleting %1$s: ", file), (Throwable)e);
                }
            }
            tempFilesToDelete.clear();
        }
    }

    private void deleteLocalTempFiles(List<Path> localTempFilesToDelete, OrderProcessStepLogger logger) {
        if (localTempFilesToDelete != null && !localTempFilesToDelete.isEmpty()) {
            for (Path tempFile : localTempFilesToDelete) {
                try {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("[deleteLocalTempFiles]" + tempFile.toString()));
                    }
                    Files.delete(tempFile);
                }
                catch (IOException e) {
                    logger.warn(String.format("error ocurred deleting %1$s locally: ", tempFile.toString()), (Throwable)e);
                }
            }
        }
    }
}

