/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserAuth;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SOSRequiredAuth
extends UserAuth {
    public static final String JSCH_AUTH_CLASS_PASSWORD = "com.jcraft.jsch.UserAuthPassword";
    public static final String JSCH_AUTH_CLASS_PUBLIC_KEY = "com.jcraft.jsch.UserAuthPublicKey";
    public static final String JSCH_AUTH_CLASS_KEYBOARD_INTERACTIVE = "com.jcraft.jsch.UserAuthKeyboardInteractive";
    private static final Logger LOGGER = LoggerFactory.getLogger(SOSRequiredAuth.class);
    private String _jschClass;
    private UserAuth _jschUserAuth;

    public SOSRequiredAuth(String jschClass) throws Exception {
        try {
            this._jschClass = jschClass;
            this._jschUserAuth = (UserAuth)Class.forName(this._jschClass).newInstance();
        }
        catch (Throwable e) {
            LOGGER.error(String.format("failed to load %s", jschClass));
            throw e;
        }
    }

    public boolean start(Session session) throws Exception {
        boolean isPasswordMethod = this._jschClass.equals(JSCH_AUTH_CLASS_PASSWORD) || this._jschClass.equals(JSCH_AUTH_CLASS_KEYBOARD_INTERACTIVE);
        String preffered = session.getConfig("PreferredAuthentications");
        LOGGER.debug(String.format("preffered=%s, isPasswordMethod=%s", preffered, isPasswordMethod));
        boolean result = this._jschUserAuth.start(session);
        if (!result) {
            throw new JSchException("Auth fail");
        }
        if (preffered.startsWith("password") && isPasswordMethod) {
            return false;
        }
        return !preffered.startsWith("publickey") || isPasswordMethod;
    }
}

