/*
 * Decompiled with CFR 0.152.
 */
package com.sos.vfs.common;

import com.sos.JSHelper.Exceptions.JobSchedulerException;
import com.sos.JSHelper.Options.SOSOptionJadeOperation;
import com.sos.JSHelper.interfaces.IJobSchedulerEventHandler;
import com.sos.JSHelper.io.Files.JSFile;
import com.sos.i18n.annotation.I18NResourceBundle;
import com.sos.vfs.common.SOSCommonProvider;
import com.sos.vfs.common.SOSFileEntry;
import com.sos.vfs.common.SOSFileListEntry;
import com.sos.vfs.common.SOSTransferStateCounts;
import com.sos.vfs.common.SOSVFSMessageCodes;
import com.sos.vfs.common.interfaces.ISOSProvider;
import com.sos.vfs.common.interfaces.ISOSProviderFile;
import com.sos.vfs.common.options.SOSBaseOptions;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.util.SOSDate;
import sos.util.SOSString;

@I18NResourceBundle(baseName="SOSVirtualFileSystem", defaultLocale="en")
public class SOSFileList
extends SOSVFSMessageCodes {
    private static final Logger LOGGER = LoggerFactory.getLogger(SOSFileList.class);
    private static final Logger JADE_REPORT_LOGGER = LoggerFactory.getLogger((String)"JadeReportLog");
    private ISOSProvider sourceProvider = null;
    private ISOSProvider targetProvider = null;
    private SOSBaseOptions options = null;
    private IJobSchedulerEventHandler eventHandler = null;
    private List<SOSFileListEntry> fileListEntries = new ArrayList<SOSFileListEntry>();
    private final HashMap<String, String> subFolders = new HashMap();
    private String lastErrorMessage;
    private Boolean isFullPathSelection = null;
    private long sumFileSizes = 0L;
    private long counterSuccessfulTransfers = 0L;
    private long counterFailedTransfers = 0L;
    private long counterSkippedTransfers = 0L;
    private long counterSuccessZeroByteFiles = 0L;
    private long counterAbortedZeroByteFiles = 0L;
    private long counterSkippedZeroByteFiles = 0L;
    private long counterBytesTransferred = 0L;
    private long counterRecordsInResultSetFile = 0L;
    private int retryCountMax = 0;
    private int retryInterval = 0;
    private boolean transferCountersCounted = false;
    private boolean resultSetFileCreated = false;

    public SOSFileList(SOSBaseOptions opt, IJobSchedulerEventHandler handler) {
        super("SOSVirtualFileSystem");
        this.options = opt;
        this.eventHandler = handler;
        this.setRetrySettings();
    }

    public void create(List<SOSFileEntry> entries, int maxFiles) {
        this.fileListEntries.clear();
        if (maxFiles == 0) {
            return;
        }
        if (maxFiles > 0 && maxFiles < entries.size()) {
            int i = 0;
            for (SOSFileEntry entry : entries) {
                this.add(entry);
                if (++i != maxFiles) continue;
                break;
            }
        } else {
            for (SOSFileEntry entry : entries) {
                this.add(entry);
            }
        }
    }

    public SOSFileListEntry add(SOSFileEntry fileEntry) {
        if (this.fileListEntries == null) {
            this.fileListEntries = new ArrayList<SOSFileListEntry>();
        }
        SOSFileListEntry entry = new SOSFileListEntry(fileEntry);
        entry.setParent(this);
        this.fileListEntries.add(entry);
        if (this.options.skipTransfer.isFalse()) {
            entry.setStatus(SOSFileListEntry.TransferStatus.waiting4transfer);
        } else {
            entry.setStatus(SOSFileListEntry.TransferStatus.transfer_skipped);
        }
        return entry;
    }

    public boolean add2SubFolders(String name) {
        boolean result = false;
        String subFolder = this.getSubFolderList().get(name);
        if (subFolder == null) {
            result = true;
            this.getSubFolderList().put(name, "");
        }
        return result;
    }

    public long count() {
        return this.fileListEntries.size();
    }

    private void countStatus() {
        if (!this.transferCountersCounted) {
            this.transferCountersCounted = true;
            this.counterSuccessfulTransfers = 0L;
            this.counterFailedTransfers = 0L;
            this.counterSkippedTransfers = 0L;
            this.counterBytesTransferred = 0L;
            if (this.fileListEntries != null) {
                for (SOSFileListEntry entry : this.fileListEntries) {
                    if (entry == null) continue;
                    this.counterBytesTransferred += entry.getFileSize().longValue();
                    switch (entry.getTransferStatus()) {
                        case transferred: {
                            ++this.counterSuccessfulTransfers;
                            break;
                        }
                        case renamed: {
                            ++this.counterSuccessfulTransfers;
                            break;
                        }
                        case deleted: {
                            ++this.counterSuccessfulTransfers;
                            break;
                        }
                        case compressed: {
                            ++this.counterSuccessfulTransfers;
                            break;
                        }
                        case moved: {
                            ++this.counterSuccessfulTransfers;
                            break;
                        }
                        case transfer_has_errors: {
                            ++this.counterFailedTransfers;
                            break;
                        }
                        case transfer_aborted: {
                            ++this.counterFailedTransfers;
                            break;
                        }
                        case setBack: {
                            ++this.counterFailedTransfers;
                            break;
                        }
                        case notOverwritten: {
                            ++this.counterSkippedTransfers;
                            break;
                        }
                        case waiting4transfer: {
                            ++this.counterFailedTransfers;
                            break;
                        }
                        case transfer_skipped: {
                            ++this.counterSkippedTransfers;
                            break;
                        }
                    }
                }
            }
        }
    }

    public long getSuccessfulTransfers() {
        this.countStatus();
        return this.counterSuccessfulTransfers;
    }

    public long getFailedTransfers() {
        this.countStatus();
        return this.counterFailedTransfers;
    }

    public long getSkippedTransfers() {
        this.countStatus();
        return this.counterSkippedTransfers;
    }

    public SOSTransferStateCounts countTransfers() {
        this.countStatus();
        SOSTransferStateCounts counter = new SOSTransferStateCounts();
        counter.setSkipped(this.counterSkippedTransfers);
        counter.setSuccess(this.counterSuccessfulTransfers);
        counter.setFailed(this.counterFailedTransfers);
        counter.setSuccessZeroBytes(this.counterSuccessZeroByteFiles);
        counter.setAbortedZeroBytes(this.counterAbortedZeroByteFiles);
        counter.setSkippedZeroBytes(this.counterSkippedZeroByteFiles);
        return counter;
    }

    public List<SOSFileListEntry> getList() {
        if (this.fileListEntries == null) {
            this.fileListEntries = new ArrayList<SOSFileListEntry>();
        }
        return this.fileListEntries;
    }

    public void clearFileList() {
        this.fileListEntries = new ArrayList<SOSFileListEntry>();
    }

    public void resetTransferCountersCounted() {
        this.transferCountersCounted = false;
    }

    public void resetNoOfZeroByteSizeFiles() {
        this.counterSkippedZeroByteFiles = 0L;
        this.counterSuccessZeroByteFiles = 0L;
    }

    public long getCounterSuccessZeroByteFiles() {
        return this.counterSuccessZeroByteFiles;
    }

    public long getCounterAbortedZeroByteFiles() {
        return this.counterAbortedZeroByteFiles;
    }

    public long getCounterSkippedZeroByteFiles() {
        return this.counterSkippedZeroByteFiles;
    }

    public void deleteSourceFiles() throws Exception {
        if (this.options.removeFiles.isTrue()) {
            if (this.options.transactional.isFalse() && this.options.operation.value().equals((Object)SOSOptionJadeOperation.enuJadeOperations.move)) {
                return;
            }
            String msg = SOSVfs_D_208.get();
            LOGGER.info(msg);
            JADE_REPORT_LOGGER.info(msg);
            for (SOSFileListEntry entry : this.fileListEntries) {
                if (!entry.getTransferStatus().equals((Object)SOSFileListEntry.TransferStatus.transferred)) continue;
                entry.deleteSourceFile();
            }
        }
    }

    public void renameSourceFiles() {
        if (this.options.removeFiles.isFalse()) {
            for (SOSFileListEntry entry : this.fileListEntries) {
                entry.renameSourceFile();
            }
        }
    }

    public void logGetListOperation() {
        if (this.fileListEntries != null && this.fileListEntries.size() > 0) {
            StringBuilder sb = new StringBuilder();
            for (SOSFileListEntry entry : this.fileListEntries) {
                entry.setStatus(SOSFileListEntry.TransferStatus.transfer_skipped);
                sb.append("\n");
                sb.append(entry.getFileName4ResultList());
            }
            String msg = sb.toString();
            LOGGER.info(msg);
            JADE_REPORT_LOGGER.info(msg);
        }
    }

    public void createResultSetFile() {
        if (this.resultSetFileCreated) {
            return;
        }
        this.resultSetFileCreated = true;
        this.counterRecordsInResultSetFile = 0L;
        JSFile resultSetFile = null;
        try {
            if (this.options.resultSetFileName.isDirty() && this.options.resultSetFileName.isNotEmpty()) {
                resultSetFile = this.options.resultSetFileName.getJSFile();
                if ("getlist".equalsIgnoreCase(this.options.getDmzOption("operation")) && !this.options.getDmzOption("resultfile").isEmpty()) {
                    ISOSProviderFile jumpResultSetFile = this.sourceProvider.getFile(this.options.getDmzOption("resultfile"));
                    if (jumpResultSetFile.fileExists()) {
                        this.counterRecordsInResultSetFile = this.writeResultSetFileFromJumpFile(resultSetFile, jumpResultSetFile);
                    }
                } else {
                    for (SOSFileListEntry objListItem : this.fileListEntries) {
                        String strFileName = objListItem.getFileName4ResultList();
                        resultSetFile.writeLine(strFileName);
                        ++this.counterRecordsInResultSetFile;
                    }
                }
                if (this.counterRecordsInResultSetFile == 0L) {
                    resultSetFile.writeLine("");
                }
                LOGGER.info(String.format("ResultSet to '%1$s' is written", resultSetFile.getCanonicalPath()));
            }
        }
        catch (Exception e) {
            String msg = "";
            if (resultSetFile != null) {
                try {
                    msg = " '" + resultSetFile.getCanonicalPath() + "'";
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            throw new JobSchedulerException(String.format("Problems occured creating ResultSet file%s: %s", msg, e.toString()), (Throwable)e);
        }
        finally {
            if (resultSetFile != null) {
                try {
                    resultSetFile.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    private long writeResultSetFileFromJumpFile(JSFile localResultSetFile, ISOSProviderFile jumpResultSetFile) {
        byte[] buffer = new byte[this.options.bufferSize.value()];
        int bytesTransferred = 0;
        FileOutputStream fos = null;
        long countLines = 0L;
        try {
            fos = new FileOutputStream((File)localResultSetFile);
            while ((bytesTransferred = jumpResultSetFile.read(buffer)) != -1) {
                fos.write(buffer, 0, bytesTransferred);
                countLines += (long)new String(buffer).replaceAll("[^\n]*", "").length();
            }
        }
        catch (Exception e) {
            throw new JobSchedulerException((Throwable)e);
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException iOException) {}
            try {
                jumpResultSetFile.closeInput();
            }
            catch (Exception exception) {}
        }
        return countLines;
    }

    public void renameTargetAndSourceFiles() throws Exception {
        String methodName = "SOSFileList::renameAtomicTransferFiles";
        try {
            if (this.options.isAtomicTransfer() && this.options.transactional.isTrue()) {
                LOGGER.debug(SOSVfs_D_209.get());
                boolean skipRenameTarget = false;
                for (SOSFileListEntry entry : this.fileListEntries) {
                    if (!skipRenameTarget) {
                        entry.renameTargetFile();
                    }
                    entry.createTargetChecksumFile();
                    entry.renameSourceFile();
                    entry.executePostCommands();
                    if (!this.options.cumulateFiles.isTrue()) continue;
                    skipRenameTarget = true;
                }
            } else {
                for (SOSFileListEntry entry : this.fileListEntries) {
                    entry.executePostCommands();
                }
            }
        }
        catch (Exception e) {
            throw new JobSchedulerException(SOSVfs_E_210.params(new Object[]{"SOSFileList::renameAtomicTransferFiles", e.getMessage()}), (Throwable)e);
        }
    }

    public void rollback() {
        String msg;
        if (this.options.isAtomicTransfer()) {
            msg = "Rollback atomic transfer";
            LOGGER.info(msg);
            JADE_REPORT_LOGGER.info(msg);
            for (SOSFileListEntry entry : this.fileListEntries) {
                String path;
                SOSFileListEntry.TransferStatus transferStatus = entry.getTransferStatus();
                if (!this.options.transactional.value() && transferStatus.equals((Object)SOSFileListEntry.TransferStatus.transferred)) {
                    if (!LOGGER.isDebugEnabled()) continue;
                    String path2 = this.makeFullPathName(this.options.targetDir.getValue(), entry.getTargetFileName());
                    LOGGER.debug(String.format("[%s][target][%s][skip][transactional=false][%s]", new Object[]{entry.getTransferNumber(), SOSCommonProvider.normalizePath(path2), transferStatus}));
                    continue;
                }
                entry.setStatus(SOSFileListEntry.TransferStatus.transfer_aborted);
                String atomicFileName = entry.getTargetAtomicFileName();
                if (atomicFileName.isEmpty()) {
                    if (!LOGGER.isDebugEnabled()) continue;
                    path = this.makeFullPathName(this.options.targetDir.getValue(), entry.getTargetFileName());
                    LOGGER.debug(String.format("[%s][target][%s][skip][transactional=true]atomicFileName is empty", entry.getTransferNumber(), SOSCommonProvider.normalizePath(path)));
                    continue;
                }
                if (LOGGER.isDebugEnabled()) {
                    path = this.makeFullPathName(this.options.targetDir.getValue(), entry.getTargetFileName());
                    LOGGER.debug(String.format("[%s][target][%s][atomic=%s][%s]", new Object[]{entry.getTransferNumber(), SOSCommonProvider.normalizePath(path), entry.getTargetAtomicFileName(), transferStatus}));
                }
                atomicFileName = this.makeFullPathName(this.options.targetDir.getValue(), entry.getTargetAtomicFileName());
                if (this.isNotEmpty(entry.getTargetAtomicFileName())) {
                    try {
                        ISOSProviderFile atomicFile = this.targetProvider.getFile(atomicFileName);
                        if (atomicFile.fileExists()) {
                            atomicFile.delete(false);
                            msg = SOSVfs_D_212.params(new Object[]{atomicFileName});
                            LOGGER.info(msg);
                            JADE_REPORT_LOGGER.info(msg);
                        }
                        entry.setTargetAtomicFileName("");
                        entry.setStatus(SOSFileListEntry.TransferStatus.setBack);
                    }
                    catch (Exception e) {
                        LOGGER.error(e.toString(), (Throwable)e);
                    }
                }
                if (transferStatus.equals((Object)SOSFileListEntry.TransferStatus.transferred)) {
                    try {
                        path = this.makeFullPathName(this.options.targetDir.getValue(), entry.getTargetFileName());
                        ISOSProviderFile targetFile = this.targetProvider.getFile(path);
                        if (targetFile.fileExists()) {
                            targetFile.delete(false);
                        }
                        msg = SOSVfs_D_212.params(new Object[]{SOSCommonProvider.normalizePath(targetFile.getName())});
                        LOGGER.info(msg);
                        JADE_REPORT_LOGGER.info(msg);
                        entry.setStatus(SOSFileListEntry.TransferStatus.setBack);
                    }
                    catch (Exception e) {
                        LOGGER.error(e.toString(), (Throwable)e);
                    }
                }
                if (entry.hasTargetChecksumFile()) {
                    try {
                        ISOSProviderFile targetChecksumFile = entry.getTargetChecksumFile();
                        if (targetChecksumFile.fileExists()) {
                            targetChecksumFile.delete(false);
                        }
                        msg = SOSVfs_D_212.params(new Object[]{targetChecksumFile.getName()});
                        LOGGER.info(msg);
                        JADE_REPORT_LOGGER.info(msg);
                    }
                    catch (Exception e) {
                        LOGGER.error(e.toString(), (Throwable)e);
                    }
                }
                entry.rollbackRenameSourceFile();
            }
        } else {
            msg = "Set transfer status " + (Object)((Object)SOSFileListEntry.TransferStatus.transfer_aborted) + " for files not transferred";
            LOGGER.info(msg);
            JADE_REPORT_LOGGER.info(msg);
            for (SOSFileListEntry entry : this.fileListEntries) {
                if (entry.getTransferStatus().equals((Object)SOSFileListEntry.TransferStatus.transferred)) continue;
                entry.setStatus(SOSFileListEntry.TransferStatus.transfer_aborted);
            }
        }
        if (!this.options.transactional.value()) {
            try {
                this.deleteSourceFiles();
            }
            catch (Throwable e) {
                LOGGER.error(e.toString());
            }
        }
    }

    public long size() {
        long size = 0L;
        if (this.getList() != null) {
            size = this.getList().size();
        }
        return size;
    }

    public void handleZeroByteFiles() {
        this.counterSuccessZeroByteFiles = 0L;
        this.counterAbortedZeroByteFiles = 0L;
        this.counterSkippedZeroByteFiles = 0L;
        long total = this.size();
        if (total == 0L) {
            return;
        }
        long emptyFiles = this.getList().stream().filter(e -> e.getFileSize() <= 0L).count();
        switch (this.options.zeroByteTransfer.getEnum()) {
            case yes: {
                this.counterSuccessZeroByteFiles = emptyFiles;
                break;
            }
            case no: {
                if (emptyFiles == total) {
                    this.counterAbortedZeroByteFiles = emptyFiles;
                    int counter = 0;
                    for (SOSFileListEntry entry : this.getList()) {
                        entry.setTransferStatus(SOSFileListEntry.TransferStatus.transfer_aborted);
                        LOGGER.info(String.format("[%s][skip][TransferZeroByteFiles=false]Source=%s, Bytes=%s", ++counter, SOSCommonProvider.normalizePath(entry.getSourceFilename()), entry.getFileSize()));
                    }
                    throw new JobSchedulerException(String.format("All %s files have zero byte size, transfer aborted", emptyFiles));
                }
                this.counterSuccessZeroByteFiles = emptyFiles;
                break;
            }
            case relaxed: {
                if (emptyFiles <= 0L) break;
                for (SOSFileListEntry entry : this.getList()) {
                    if (entry.getFileSize() > 0L) continue;
                    entry.setIgnoredDueToZerobyteConstraint();
                    ++this.counterSkippedZeroByteFiles;
                }
                break;
            }
            case strict: {
                if (emptyFiles <= 0L) break;
                this.counterAbortedZeroByteFiles = emptyFiles;
                int counter = 0;
                for (SOSFileListEntry entry : this.getList()) {
                    entry.setTransferStatus(SOSFileListEntry.TransferStatus.transfer_aborted);
                    LOGGER.info(String.format("[%s][skip][TransferZeroByteFiles=strict]Source=%s, Bytes=%s", ++counter, SOSCommonProvider.normalizePath(entry.getSourceFilename()), entry.getFileSize()));
                }
                throw new JobSchedulerException(String.format("%s zero byte size file(s) detected", emptyFiles));
            }
        }
    }

    public boolean isEmpty() {
        return this.getList().isEmpty();
    }

    public long getSumFileSizes() {
        return this.sumFileSizes;
    }

    public void setSumFileSizes(long val) {
        this.sumFileSizes = val;
    }

    public HashMap<String, String> getSubFolderList() {
        return this.subFolders;
    }

    public SOSBaseOptions getBaseOptions() {
        return this.options;
    }

    public long getBytesTransferred() {
        return this.counterBytesTransferred;
    }

    public ISOSProvider getTargetProvider() {
        return this.targetProvider;
    }

    public void setTargetProvider(ISOSProvider val) {
        this.targetProvider = val;
    }

    public ISOSProvider getSourceProvider() {
        return this.sourceProvider;
    }

    public void setSourceProvider(ISOSProvider val) {
        this.sourceProvider = val;
    }

    public String getLastErrorMessage() {
        return this.lastErrorMessage;
    }

    public void setLastErrorMessage(String val) {
        this.lastErrorMessage = val;
    }

    public IJobSchedulerEventHandler getEventHandler() {
        return this.eventHandler;
    }

    private void setRetrySettings() {
        String val = this.options.connection_error_retry_interval.getValue();
        if (!SOSString.isEmpty((String)val)) {
            try {
                this.retryInterval = SOSDate.resolveAge((String)"s", (String)val).intValue();
            }
            catch (Exception ex) {
                LOGGER.warn(String.format("[serConnectionErrorRetryInterval]%s", ex.toString()), (Throwable)ex);
            }
        }
        this.retryCountMax = this.options.connection_error_retry_count_max.value() < 0 ? 0 : this.options.connection_error_retry_count_max.value();
    }

    public boolean isFullPathSelection() {
        if (this.isFullPathSelection == null) {
            this.isFullPathSelection = !SOSString.isEmpty((String)this.options.fileListName.getValue()) || !SOSString.isEmpty((String)this.options.filePath.getValue());
        }
        return this.isFullPathSelection;
    }

    public int getRetryCountMax() {
        return this.retryCountMax;
    }

    public int getRetryInterval() {
        return this.retryInterval;
    }
}

