/*
 * Decompiled with CFR 0.152.
 */
package com.sos.vfs.common;

import com.sos.vfs.common.SOSEnv;
import com.sos.vfs.common.SOSVFSMessageCodes;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.util.SOSString;

public class SOSShell
extends SOSVFSMessageCodes
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(SOSShell.class);
    private static final boolean isDebugEnabled = LOGGER.isDebugEnabled();
    private static final String CHARACTER_ENCODING = "Cp1252";
    private String stdOut = "";
    private String stdErr = "";
    private int exitValue = 0;
    private String command = "";
    private String osn = System.getProperty("os.name");

    public boolean isWindows() {
        return this.osn != null && this.osn.contains("Windows");
    }

    public String replaceCommand4Windows(String cmd) {
        String command = cmd;
        command = command.replaceAll("/(?=[^ ]*/)", "\\\\");
        command = command.replaceAll("(?<! )/", "\\\\");
        return command;
    }

    public int getExitValue() {
        return this.exitValue;
    }

    public String getStdOut() {
        return this.stdOut;
    }

    public String getStdErr() {
        return this.stdErr;
    }

    public int executeCommand(String[] commands, boolean showCommand) throws Exception {
        return this.executeCommand(commands, showCommand, null);
    }

    private int executeCommand(String[] commands, boolean showCommand, SOSEnv env) throws Exception {
        ByteArrayOutputStream bytStdOut = new ByteArrayOutputStream();
        ByteArrayOutputStream bytStdErr = new ByteArrayOutputStream();
        PrintStream psStdOut = new PrintStream((OutputStream)bytStdOut, true, CHARACTER_ENCODING);
        PrintStream psStdErr = new PrintStream((OutputStream)bytStdErr, true, CHARACTER_ENCODING);
        this.stdOut = "";
        this.stdErr = "";
        ProcessBuilder pb = null;
        if (showCommand) {
            LOGGER.debug(SOSVfs_D_0151.params(commands));
        }
        pb = new ProcessBuilder(commands);
        if (env != null) {
            if (env.getGlobalEnvs() != null) {
                if (isDebugEnabled) {
                    LOGGER.debug(String.format("[set global envs]%s", env.getGlobalEnvs()));
                }
                pb.environment().putAll(env.getGlobalEnvs());
            }
            if (env.getLocalEnvs() != null) {
                if (isDebugEnabled) {
                    LOGGER.debug(String.format("[set local envs]%s", env.getLocalEnvs()));
                }
                pb.environment().putAll(env.getLocalEnvs());
            }
        }
        Process p = pb.start();
        this.createOutputPipe(p.getInputStream(), psStdOut);
        this.createOutputPipe(p.getErrorStream(), psStdErr);
        this.pipein(System.in, p.getOutputStream());
        this.exitValue = p.waitFor();
        this.stdOut = bytStdOut.toString(CHARACTER_ENCODING);
        this.stdErr = bytStdErr.toString(CHARACTER_ENCODING);
        String cmd = pb.command().get(pb.command().size() - 1);
        if (!SOSString.isEmpty((String)this.stdOut)) {
            if (showCommand) {
                LOGGER.info(String.format("[%s][stdout]%s", cmd, this.stdOut.trim()));
            } else {
                LOGGER.info(String.format("[%s][stdout]%s", "***", this.stdOut.trim()));
            }
        }
        if (!SOSString.isEmpty((String)this.stdErr)) {
            if (showCommand) {
                LOGGER.info(String.format("[%s][stderr]%s", cmd, this.stdErr.trim()));
            } else {
                LOGGER.info(String.format("[%s][stderr]%s", "***", this.stdErr.trim()));
            }
        }
        return this.exitValue;
    }

    public void setCommand(String val) throws Exception {
        this.command = val;
    }

    public int executeCommand(String cmd) throws Exception {
        return this.executeCommand(this.createCommand(cmd), true);
    }

    public int executeCommand(String cmd, SOSEnv env) throws Exception {
        return this.executeCommand(this.createCommand(cmd), true, env);
    }

    private String[] createCommand(String cmd) {
        String[] command = new String[3];
        if (this.isWindows()) {
            String comSpec = System.getenv("comspec");
            LOGGER.debug(SOSVfs_D_230.params(new Object[]{comSpec}));
            command[0] = comSpec;
            command[1] = "/C";
            command[2] = cmd;
        } else {
            String comSpec = System.getenv("SHELL");
            if (comSpec == null) {
                comSpec = "/bin/sh";
            }
            LOGGER.debug(SOSVfs_D_230.params(new Object[]{comSpec}));
            command[0] = comSpec;
            command[1] = "-c";
            command[2] = cmd;
        }
        return command;
    }

    public int executeCommandWithoutDebugCommand(String cmd) throws Exception {
        return this.executeCommand(this.createCommand(cmd), false);
    }

    private void pipein(final InputStream is, final OutputStream os) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    int ret = -1;
                    while ((ret = is.read()) != -1) {
                        os.write(ret);
                        os.flush();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }).start();
    }

    private void createOutputPipe(InputStream in, PrintStream out) {
        new Thread(new OutputPipe(in, out)).start();
    }

    @Override
    public void run() {
        try {
            this.executeCommand(this.command);
        }
        catch (Exception e) {
            LOGGER.error(e.toString(), (Throwable)e);
        }
    }

    class OutputPipe
    implements Runnable {
        private final InputStream in;
        private final PrintStream out;

        OutputPipe(InputStream is, PrintStream ps) {
            this.in = is;
            this.out = ps;
        }

        @Override
        public void run() {
            try {
                byte[] buffer = new byte[1024];
                int n = 0;
                while (n != -1) {
                    this.out.write(buffer, 0, n);
                    n = this.in.read(buffer);
                }
            }
            catch (IOException ex) {
                LOGGER.error(ex.getMessage());
            }
        }
    }
}

