/*
 * Decompiled with CFR 0.152.
 */
package com.sos.vfs.ftp;

import com.sos.i18n.annotation.I18NResourceBundle;
import com.sos.vfs.ftp.common.SOSFTPBaseClass;
import com.sos.vfs.ftp.common.SOSFTPClientLogger;
import org.apache.commons.net.ProtocolCommandListener;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPHTTPClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.util.SOSString;

@I18NResourceBundle(baseName="SOSVirtualFileSystem", defaultLocale="en")
public class SOSFTP
extends SOSFTPBaseClass {
    private static final Logger LOGGER = LoggerFactory.getLogger(SOSFTP.class);

    @Override
    public final FTPClient getClient() {
        if (super.getClient() == null) {
            String addFTPProtocol;
            FTPClient client = null;
            if (this.usingProxy()) {
                LOGGER.info(String.format("using proxy: protocol = %s, host = %s, port = %s, user = %s, pass = ?", this.getProxyProtocol().getValue(), this.getProxyHost(), this.getProxyPort(), this.getProxyUser()));
                if (this.usingHttpProxy()) {
                    client = SOSString.isEmpty((String)this.getProxyUser()) ? new FTPHTTPClient(this.getProxyHost(), this.getProxyPort()) : new FTPHTTPClient(this.getProxyHost(), this.getProxyPort(), this.getProxyUser(), this.getProxyPassword());
                } else {
                    client = new FTPClient();
                    client.setProxy(this.getSocksProxy());
                }
            } else {
                client = new FTPClient();
            }
            this.setCommandListener(new SOSFTPClientLogger(this.getHostID("")));
            if (this.getProviderOptions() != null && this.getProviderOptions().protocolCommandListener.isTrue()) {
                client.addProtocolCommandListener((ProtocolCommandListener)this.getCommandListener());
                LOGGER.debug("ProtocolcommandListener added and activated");
            }
            if ((addFTPProtocol = System.getenv("AddFTPProtocol")) != null && "true".equalsIgnoreCase(addFTPProtocol)) {
                client.addProtocolCommandListener((ProtocolCommandListener)this.getCommandListener());
            }
            super.setClient(client);
        }
        return super.getClient();
    }
}

