/*
 * Decompiled with CFR 0.152.
 */
package com.sos.vfs.ftp.common;

import com.sos.JSHelper.Exceptions.JobSchedulerException;
import com.sos.JSHelper.Options.SOSOptionFolderName;
import com.sos.JSHelper.Options.SOSOptionProxyProtocol;
import com.sos.JSHelper.Options.SOSOptionTransferMode;
import com.sos.exception.SOSMissingDataException;
import com.sos.i18n.annotation.I18NResourceBundle;
import com.sos.vfs.common.SOSCommonProvider;
import com.sos.vfs.common.SOSEnv;
import com.sos.vfs.common.SOSFileEntry;
import com.sos.vfs.common.SOSVFSMessageCodes;
import com.sos.vfs.common.interfaces.ISOSProvider;
import com.sos.vfs.common.interfaces.ISOSProviderFile;
import com.sos.vfs.common.options.SOSBaseOptions;
import com.sos.vfs.common.options.SOSProviderOptions;
import com.sos.vfs.ftp.SOSFTPFile;
import com.sos.vfs.ftp.common.SOSFTPClientLogger;
import com.sos.vfs.ftp.common.SOSFTPServerReply;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.SocketException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Date;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.commons.net.io.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.util.SOSDate;
import sos.util.SOSString;

@I18NResourceBundle(baseName="SOSVirtualFileSystem", defaultLocale="en")
public class SOSFTPBaseClass
extends SOSVFSMessageCodes
implements ISOSProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(SOSFTPBaseClass.class);
    private static final String CLASS_NAME = SOSFTPBaseClass.class.getSimpleName();
    private SOSBaseOptions baseOptions = null;
    private SOSProviderOptions providerOptions = null;
    private SOSFTPServerReply ftpReply = null;
    private SOSOptionTransferMode transferMode = null;
    private SOSFTPClientLogger commandListener = null;
    private FTPClient ftpClient = null;
    private List<SOSFileEntry> directoryFiles = null;
    private int directoryFilesCount = 0;
    private boolean directoryFilesCountExceeded = false;
    private List<SOSFileEntry> directorySubFolders = null;
    private String host = "";
    private int port = 0;
    private String user = "";
    private String currentPath = "";
    private String reply = "";
    private SOSOptionProxyProtocol proxyProtocol = null;
    private String proxyHost = null;
    private int proxyPort = 0;
    private String proxyUser = null;
    private String proxyPassword = null;

    public SOSFTPBaseClass() {
        super("SOSVirtualFileSystem");
    }

    @Override
    public boolean isConnected() {
        boolean isConnected = false;
        if (this.getClient().isConnected()) {
            try {
                this.getClient().sendCommand("NOOP");
                isConnected = true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return isConnected;
    }

    @Override
    public void connect(SOSProviderOptions options) throws Exception {
        this.providerOptions = options;
        try {
            this.host = this.providerOptions.host.getValue();
            this.port = this.providerOptions.port.value();
            this.proxyProtocol = this.providerOptions.proxyProtocol;
            this.proxyHost = this.providerOptions.proxyHost.getValue();
            this.proxyPort = this.providerOptions.proxyPort.value();
            this.proxyUser = this.providerOptions.proxyUser.getValue();
            this.proxyPassword = this.providerOptions.proxyPassword.getValue();
            this.doConnect();
        }
        catch (JobSchedulerException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JobSchedulerException(e.toString(), (Throwable)e);
        }
        this.login();
    }

    private void login() throws Exception {
        block9: {
            if (this.providerOptions == null) {
                throw new Exception("providerOptions is null");
            }
            this.user = this.providerOptions.user.getValue();
            try {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(SOSVfs_D_132.params(new Object[]{this.user}));
                }
                this.getClient().login(this.user, this.providerOptions.password.getValue());
                this.logReply("login");
                if (this.ftpReply.isSuccessCode()) {
                    this.commandListener.setClientId(this.getHostID(""));
                    LOGGER.info(this.getHostID(SOSVfs_D_133.params(new Object[]{this.user})));
                    if (this.providerOptions.passiveMode.value()) {
                        this.passive();
                    }
                    this.transferMode(this.providerOptions.transferMode);
                    try {
                        this.doPostLoginOperations();
                    }
                    catch (Exception exception) {}
                    break block9;
                }
                LOGGER.info(SOSVfs_D_132.params(new Object[]{this.user}));
                throw new JobSchedulerException(SOSVfs_E_134.params(new Object[]{"Login"}) + " code:" + this.ftpReply.getCode() + " Message: " + this.ftpReply.getMessages()[0]);
            }
            catch (JobSchedulerException e) {
                throw e;
            }
            catch (Exception e) {
                throw new JobSchedulerException((Throwable)e);
            }
        }
    }

    @Override
    public void reconnect() {
        if (!this.isConnected()) {
            try {
                this.connect(this.providerOptions);
            }
            catch (JobSchedulerException e) {
                throw e;
            }
            catch (Exception e) {
                throw new JobSchedulerException((Throwable)e);
            }
        }
    }

    @Override
    public void disconnect() {
        try {
            if (this.getClient().isConnected()) {
                this.getClient().disconnect();
            }
        }
        catch (IOException e) {
            LOGGER.warn(SOSVfs_W_136.get() + e.toString(), (Throwable)e);
        }
    }

    protected void doConnect() {
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(SOSVfs_D_0101.params(new Object[]{this.host, this.port}));
            }
            this.setConnectTimeout();
            this.getClient().connect(this.host, this.port);
            this.logReply("connect");
            LOGGER.info(SOSVfs_D_0102.params(new Object[]{this.host, this.port}));
            this.getClient().setControlKeepAliveTimeout(Duration.ofSeconds(180L));
        }
        catch (JobSchedulerException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JobSchedulerException(e.toString(), (Throwable)e);
        }
    }

    private String ms2string(int val) {
        if (val <= 0) {
            return String.valueOf(val).concat("ms");
        }
        try {
            return String.valueOf(Math.round(val / 1000)).concat("s");
        }
        catch (Throwable e) {
            return String.valueOf(val).concat("ms");
        }
    }

    private void setConnectTimeout() throws Exception {
        String ct = this.providerOptions.connect_timeout.getValue();
        int timeout = 0;
        if (!SOSString.isEmpty((String)ct)) {
            timeout = SOSDate.resolveAge((String)"ms", (String)ct).intValue();
        }
        if (timeout > 0) {
            try {
                this.getClient().setConnectTimeout(timeout);
                LOGGER.info("ConnectTimeout=" + this.ms2string(this.getClient().getConnectTimeout()));
            }
            catch (Exception ex) {
                LOGGER.warn(String.format("[setConnectTimeout]%s", ex.toString()), (Throwable)ex);
            }
        }
    }

    @Override
    public ISOSProviderFile getFile(String filename) {
        SOSFTPFile file = new SOSFTPFile(SOSCommonProvider.normalizePath(filename));
        file.setProvider(this);
        return file;
    }

    @Override
    public SOSFileEntry getFileEntry(String pathname) throws Exception {
        Path parent;
        FTPFile file = this.getFTPFile(pathname);
        if (file == null) {
            return null;
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("[%s]found", pathname));
        }
        return this.getFileEntry(file, (parent = Paths.get(pathname, new String[0]).getParent()) == null ? null : parent.toString());
    }

    public SOSFileEntry getFileEntry(FTPFile file, String parentPath) {
        if (file == null) {
            return null;
        }
        SOSFileEntry entry = new SOSFileEntry(SOSFileEntry.EntryType.FILESYSTEM);
        entry.setDirectory(file.isDirectory());
        entry.setFilename(file.getName());
        entry.setFilesize(file.getSize());
        entry.setParentPath(parentPath);
        return entry;
    }

    @Override
    public List<SOSFileEntry> listNames(String path, int maxFiles, boolean checkIfExists, boolean checkIfIsDirectory) throws IOException {
        try {
            boolean isDebugEnabled = LOGGER.isDebugEnabled();
            boolean isTraceEnabled = LOGGER.isTraceEnabled();
            ArrayList<SOSFileEntry> result = new ArrayList<SOSFileEntry>();
            if (path.isEmpty()) {
                path = ".";
            }
            if (checkIfExists && !this.fileExists(path)) {
                return result;
            }
            if (checkIfIsDirectory && !this.isDirectory(path)) {
                this.reply = "ls OK";
                return result;
            }
            FTPFile[] list = null;
            try {
                list = this.getClient().listFiles(path);
            }
            catch (IOException e) {
                throw new JobSchedulerException("[" + path + "]" + e.toString(), (Throwable)e);
            }
            if (list == null || list.length <= 0) {
                if (this.isNegativeCommandCompletion()) {
                    throw new JobSchedulerException("[" + path + "]" + this.getReplyString());
                }
                return result;
            }
            if (isTraceEnabled) {
                LOGGER.trace(String.format("[%s][ls] %s files or folders", path, list.length));
            }
            int i = 0;
            for (FTPFile file : list) {
                ++i;
                String name = file.getName();
                if (isTraceEnabled) {
                    try {
                        LOGGER.trace(String.format("[%s][ls result][%s][%s]%s", path, i, name, SOSString.toString((Object)file)));
                    }
                    catch (Throwable e) {
                        LOGGER.trace(String.format("[%s][ls result][%s][%s]", path, i, name));
                        LOGGER.error(e.toString(), e);
                    }
                }
                if (name == null) {
                    LOGGER.warn(String.format("[%s][ls result][%s][file type=%s][skip][filename can't be evaluated]%s", path, i, this.getFTPFileType(file), SOSString.toString((Object)file)));
                    continue;
                }
                if (!name.trim().isEmpty() && this.isNotHiddenFile(name)) {
                    result.add(this.getFileEntry(file, path));
                    continue;
                }
                LOGGER.debug(String.format("[%s][ls result][%s][%s][skip]name is empty or is a hidden file", path, i, name));
            }
            if (isDebugEnabled) {
                LOGGER.debug(String.format("[%s][result] %s files or folders", path, result.size()));
            }
            this.reply = "ls OK";
            return result;
        }
        catch (JobSchedulerException e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.error(String.format("[%s]%s", path, e.toString()), (Throwable)e);
            this.reply = "[" + path + "]" + e.toString();
            return null;
        }
    }

    @Override
    public List<SOSFileEntry> getFileList(String folder, int maxFiles, boolean recursive, Pattern fileNamePattern, Pattern excludedDirectoriesPattern, boolean checkIfExists, String integrityHashType, int recLevel) throws Exception {
        boolean isDebugEnabled = LOGGER.isDebugEnabled();
        boolean isTraceEnabled = LOGGER.isTraceEnabled();
        if (recLevel == 0) {
            this.directoryFiles = new ArrayList<SOSFileEntry>();
            this.directoryFilesCount = 0;
            this.directoryFilesCountExceeded = false;
        } else if (maxFiles > 0 && this.directoryFilesCount >= maxFiles) {
            if (!this.directoryFilesCountExceeded) {
                LOGGER.info(String.format("[skip]maxFiles=%s exceeded", maxFiles));
                this.directoryFilesCountExceeded = true;
            }
            return this.directoryFiles;
        }
        List<SOSFileEntry> entries = null;
        String path = folder.trim();
        if (path.isEmpty()) {
            path = ".";
        }
        try {
            entries = this.listNames(path, maxFiles, checkIfExists, checkIfExists);
        }
        catch (IOException e) {
            LOGGER.error("[" + path + "]" + e.toString(), (Throwable)e);
        }
        if (entries == null) {
            if (isDebugEnabled) {
                LOGGER.debug(String.format("[%s]entries=null", path));
            }
            return this.directoryFiles;
        }
        for (SOSFileEntry entry : entries) {
            if (maxFiles > 0 && this.directoryFilesCount >= maxFiles) {
                if (!this.directoryFilesCountExceeded) {
                    LOGGER.info(String.format("[skip]maxFiles=%s exceeded", maxFiles));
                    this.directoryFilesCountExceeded = true;
                }
                return this.directoryFiles;
            }
            if (!this.isNotHiddenFile(entry.getFilename())) {
                if (!isDebugEnabled) continue;
                LOGGER.debug(String.format("[%s][entry is hidden]%s continue", path, entry.getFilename()));
                continue;
            }
            if (entry.isDirectory()) {
                if (isDebugEnabled) {
                    LOGGER.debug(String.format("[%s][directory]%s", path, SOSString.toString((Object)entry)));
                }
                if (!recursive) continue;
                if (excludedDirectoriesPattern != null && excludedDirectoriesPattern.matcher(entry.getDirectoryPath()).find()) {
                    if (!isDebugEnabled) continue;
                    LOGGER.debug(String.format("[%s][directory][match][excludedDirectories=%s]%s", path, excludedDirectoriesPattern.pattern(), entry.getFullPath()));
                    continue;
                }
                this.getFileList(entry.getFullPath(), maxFiles, recursive, fileNamePattern, excludedDirectoriesPattern, checkIfExists, integrityHashType, ++recLevel);
                continue;
            }
            if (isTraceEnabled) {
                LOGGER.trace(String.format("[%s][file]%s", path, SOSString.toString((Object)entry)));
            }
            if (integrityHashType != null && entry.getFilename().endsWith(integrityHashType) || !fileNamePattern.matcher(entry.getFilename()).find()) continue;
            this.directoryFiles.add(entry);
            ++this.directoryFilesCount;
        }
        return this.directoryFiles;
    }

    private String getFTPFileType(FTPFile file) {
        if (file != null) {
            if (file.isFile()) {
                return "file";
            }
            if (file.isDirectory()) {
                return "directory";
            }
            if (file.isSymbolicLink()) {
                return "symbolic link";
            }
            if (file.isUnknown()) {
                return "unknown";
            }
        }
        return null;
    }

    @Override
    public List<SOSFileEntry> getSubFolders(String folder, int maxFiles, boolean recursive, Pattern pattern, int recLevel) throws Exception {
        if (recLevel == 0) {
            this.directorySubFolders = new ArrayList<SOSFileEntry>();
        }
        List<SOSFileEntry> entries = null;
        String path = folder.trim();
        if (path.isEmpty()) {
            path = ".";
        }
        try {
            entries = this.listNames(path, maxFiles, false, false);
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        if (entries == null) {
            return this.directorySubFolders;
        }
        for (SOSFileEntry entry : entries) {
            if (!entry.isDirectory()) continue;
            if (pattern.matcher(entry.getFilename()).find()) {
                this.directorySubFolders.add(entry);
            }
            if (!recursive) continue;
            this.getSubFolders(entry.getFullPath(), maxFiles, recursive, pattern, ++recLevel);
        }
        return this.directorySubFolders;
    }

    private FTPFile getFTPFile(String fileName) {
        FTPFile file = null;
        try {
            FTPFile[] list = this.getClient().listFiles(fileName);
            if (this.isNotNull(list) && list.length > 0) {
                file = list[0];
            }
        }
        catch (JobSchedulerException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JobSchedulerException("[" + fileName + "]" + e.toString(), (Throwable)e);
        }
        return file;
    }

    private int cd(String directory) throws IOException {
        return this.getClient().cwd(directory);
    }

    private int doCD(String folderName) {
        int x = 0;
        try {
            String path = SOSCommonProvider.normalizePath(folderName);
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace(SOSVfs_D_127.params(new Object[]{path}));
            }
            x = this.cd(path);
            this.logReply("cd][" + path);
        }
        catch (JobSchedulerException e) {
            throw e;
        }
        catch (SocketException e) {
            throw new JobSchedulerException("[cd][" + folderName + "]" + e.toString(), (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.debug("[" + folderName + "]" + e.toString(), (Throwable)e);
        }
        return x;
    }

    public void completePendingCommand() {
        String method = CLASS_NAME + "::CompletePendingCommand";
        LOGGER.trace("completePendingCommand");
        try {
            if (!this.getClient().completePendingCommand()) {
                this.disconnect();
                throw new JobSchedulerException(this.getHostID(SOSVfs_E_0105.params(new Object[]{method})));
            }
        }
        catch (JobSchedulerException e) {
            throw e;
        }
        catch (IOException e) {
            throw new JobSchedulerException(e.toString(), (Throwable)e);
        }
        if (this.isNegativeCommandCompletion()) {
            throw new JobSchedulerException(SOSVfs_E_124.params(new Object[]{this.getReplyString()}));
        }
    }

    private void doPostLoginOperations() {
        this.getClient().setControlKeepAliveTimeout(Duration.ofSeconds(180L));
        try {
            String msg = this.getClient().getSystemType();
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace(String.format("System-Type = %1$s", msg));
            }
        }
        catch (IOException e) {
            LOGGER.info(e.toString(), (Throwable)e);
        }
        this.sendCommand("FEAT");
        if (this.ftpReply.getCode() == 211) {
            String[] lines = this.ftpReply.getMessages();
            for (int i = 1; i < lines.length - 1; ++i) {
                String feat = lines[i].trim().toUpperCase();
                if (!"UTF8".equals(feat)) continue;
                this.getClient().setControlEncoding("UTF-8");
                break;
            }
        } else {
            LOGGER.info("no valid response for FEAT command received: " + this.ftpReply.toString());
        }
        this.sendCommand("NOOP");
    }

    @Override
    public void executeCommand(String cmd) throws Exception {
        this.executeCommand(cmd, null);
    }

    @Override
    public void executeCommand(String cmd, SOSEnv env) throws Exception {
        String command = cmd.trim();
        try {
            this.getClient().sendCommand(command);
            String replyString = this.getClient().getReplyString().trim();
            int replyCode = this.getClient().getReplyCode();
            if (FTPReply.isNegativePermanent((int)replyCode) || FTPReply.isNegativeTransient((int)replyCode) || replyCode >= 10000) {
                throw new JobSchedulerException(SOSVfs_E_164.params(new Object[]{replyString + "[" + command + "]"}));
            }
            LOGGER.info(SOSVfs_D_151.params(new Object[]{command, replyString}));
        }
        catch (JobSchedulerException ex) {
            if (this.providerOptions.raiseExceptionOnError.value()) {
                throw ex;
            }
            LOGGER.info(SOSVfs_D_151.params(new Object[]{command, ex.toString()}), (Throwable)ex);
        }
        catch (Exception ex) {
            if (this.providerOptions.raiseExceptionOnError.value()) {
                throw new JobSchedulerException(SOSVfs_E_134.params(new Object[]{"ExecuteCommand"}), (Throwable)ex);
            }
            LOGGER.info(SOSVfs_D_151.params(new Object[]{command, ex.toString()}), (Throwable)ex);
        }
    }

    private void sendCommand(String command) {
        try {
            this.getClient().sendCommand(command);
        }
        catch (IOException e) {
            throw new JobSchedulerException("[sendCommand][" + command + "]" + e.toString(), (Throwable)e);
        }
        this.logReply("sendCommand][" + command);
    }

    private final String getCurrentPath() {
        String method = CLASS_NAME + "::getCurrentPath";
        try {
            this.getClient().pwd();
            String pwd = this.getReplyString();
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace(this.getHostID(SOSVfs_E_0106.params(new Object[]{method, "", pwd})));
            }
            return pwd.replaceFirst("^[^\"]*\"([^\"]*)\".*", "$1");
        }
        catch (IOException e) {
            throw new JobSchedulerException(e.toString(), (Throwable)e);
        }
    }

    @Override
    public final boolean isDirectory(String path) {
        boolean result = false;
        if (this.isNotHiddenFile(path)) {
            if (this.currentPath.isEmpty()) {
                this.currentPath = this.getCurrentPath();
            }
            if (this.currentPath.replaceFirst("/$", "").equals(path.replaceFirst("/$", ""))) {
                result = true;
            } else {
                this.doCD(path);
                if (this.isPositiveCommandCompletion()) {
                    this.doCD(this.currentPath);
                    result = true;
                }
            }
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("[%s]%s", path, result));
        }
        return result;
    }

    @Override
    public boolean directoryExists(String fileName) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("[%s]directoryExists", fileName));
        }
        return this.isDirectory(fileName);
    }

    @Override
    public boolean fileExists(String fileName) {
        boolean result = false;
        if (this.getFileSize(fileName) >= 0L) {
            result = true;
        }
        LOGGER.debug(String.format("[%s]%s", fileName, result));
        return result;
    }

    @Override
    public long getFileSize(String fileName) {
        long size = -1L;
        try {
            size = this.size(fileName);
        }
        catch (JobSchedulerException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JobSchedulerException("[" + fileName + "]" + e.toString(), (Throwable)e);
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("[%s]%s", fileName, size));
        }
        return size;
    }

    public long size(String path) throws Exception {
        long size = -1L;
        if (this.transferMode.isAscii()) {
            this.binary();
        }
        this.getClient().sendCommand("SIZE " + path);
        this.logReply("size][" + path);
        if (this.getClient().getReplyCode() == 213) {
            size = Long.parseLong(this.trimResponseCode(this.getReplyString()));
        }
        if (this.transferMode.isAscii()) {
            this.ascii();
        }
        return size;
    }

    @Override
    public String getModificationDateTime(String strFileName) {
        try {
            return this.getClient().getModificationTime(strFileName);
        }
        catch (Exception e) {
            throw new JobSchedulerException("[" + strFileName + "]" + e.toString(), (Throwable)e);
        }
    }

    @Override
    public InputStream getInputStream(String fileName) {
        InputStream is = null;
        try {
            fileName = fileName.replaceAll("\\\\", "/");
            is = this.getClient().retrieveFileStream(fileName);
            if (is == null) {
                throw new JobSchedulerException(String.format("unable to get inputstream for file '%1$s'", fileName));
            }
        }
        catch (JobSchedulerException e) {
            throw e;
        }
        catch (IOException e) {
            throw new JobSchedulerException("[" + fileName + "]" + e.toString(), (Throwable)e);
        }
        finally {
            this.logReply("getInputStream][" + fileName);
        }
        return is;
    }

    @Override
    public OutputStream getOutputStream(String fileName, boolean append, boolean resume) {
        OutputStream os = null;
        try {
            os = this.getClient().storeFileStream(fileName);
            this.logReply("getOutputStream][" + fileName);
        }
        catch (IOException e) {
            throw new JobSchedulerException("[" + fileName + "]" + e.toString(), (Throwable)e);
        }
        return os;
    }

    public OutputStream getAppendFileStream(String fileName) {
        OutputStream os = null;
        try {
            os = this.getClient().appendFileStream(fileName);
        }
        catch (IOException e) {
            throw new JobSchedulerException("[" + fileName + "]" + e.toString(), (Throwable)e);
        }
        return os;
    }

    @Override
    public void delete(String path, boolean checkIsDirectory) throws IOException {
        try {
            if (checkIsDirectory && this.isDirectory(path)) {
                throw new JobSchedulerException(SOSVfs_E_186.params(new Object[]{path}));
            }
            this.getClient().deleteFile(path);
            if (this.isNegativeCommandCompletion()) {
                throw new JobSchedulerException(SOSVfs_E_144.params(new Object[]{"delete()", path, this.getReplyString()}));
            }
        }
        catch (JobSchedulerException e) {
            throw e;
        }
        catch (IOException e) {
            throw new JobSchedulerException("[" + path + "]" + e.toString(), (Throwable)e);
        }
    }

    @Override
    public void mkdir(String path) {
        String method = CLASS_NAME + "::mkdir";
        try {
            if (this.isDirectory(path)) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace(SOSVfs_E_180.params(new Object[]{path}));
                }
            } else {
                SOSOptionFolderName folderName = new SOSOptionFolderName(path);
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace(this.getHostID(SOSVfs_D_179.params(new Object[]{"mkdir", path})));
                }
                String[] subfolders = folderName.getSubFolderArrayReverse();
                int idx = subfolders.length;
                for (String folder : folderName.getSubFolderArrayReverse()) {
                    if (this.isDirectory(folder)) {
                        if (!LOGGER.isTraceEnabled()) break;
                        LOGGER.trace(SOSVfs_E_180.params(new Object[]{folder}));
                        break;
                    }
                    --idx;
                }
                subfolders = folderName.getSubFolderArray();
                for (int i = idx; i < subfolders.length; ++i) {
                    this.getClient().makeDirectory(subfolders[i]);
                    if (!LOGGER.isTraceEnabled()) continue;
                    LOGGER.trace(this.getHostID(SOSVfs_E_0106.params(new Object[]{method, subfolders[i], this.getReplyString()})));
                }
            }
        }
        catch (JobSchedulerException e) {
            throw e;
        }
        catch (IOException e) {
            throw new JobSchedulerException("[mkdir][" + path + "]" + e.toString(), (Throwable)e);
        }
    }

    @Override
    public void rename(String from, String to) {
        try {
            this.getClient().rename(from, to);
            if (this.isNegativeCommandCompletion()) {
                throw new JobSchedulerException("[rename][from=" + from + "][to=" + to + "]" + this.getReplyString());
            }
            LOGGER.info(String.format(SOSVfs_I_150.params(new Object[]{from, to}), new Object[0]));
        }
        catch (JobSchedulerException e) {
            throw e;
        }
        catch (IOException e) {
            throw new JobSchedulerException("[rename][from=" + from + "][to=" + to + "]" + e.toString(), (Throwable)e);
        }
    }

    @Override
    public final void rmdir(String path) throws IOException {
        try {
            if (SOSString.isEmpty((String)path)) {
                throw new SOSMissingDataException("path");
            }
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace(String.format("[rmdir][%s]try to remove ...", path));
            }
            LinkedList<SOSFileEntry> toRemove = new LinkedList<SOSFileEntry>();
            this.dirInfo(path, toRemove, true);
            boolean isDebugEnabled = LOGGER.isDebugEnabled();
            while (!toRemove.isEmpty()) {
                SOSFileEntry resource = (SOSFileEntry)toRemove.pop();
                String resourcePath = resource.getFullPath();
                if (isDebugEnabled) {
                    LOGGER.debug(this.getHostID(SOSVfs_D_179.params(new Object[]{"rmdir", resourcePath})));
                }
                if (resource.isDirectory()) {
                    this.getClient().removeDirectory(resourcePath);
                } else {
                    this.getClient().deleteFile(resourcePath);
                }
                if (!isDebugEnabled) continue;
                LOGGER.debug(this.getHostID(SOSVfs_D_181.params(new Object[]{"rmdir", resourcePath, this.getReplyString()})));
            }
            this.getClient().removeDirectory(path);
            this.reply = "rmdir OK";
            LOGGER.info(this.getHostID(SOSVfs_D_181.params(new Object[]{"rmdir", path, this.getReplyString()})));
        }
        catch (JobSchedulerException e) {
            throw e;
        }
        catch (Exception e) {
            this.reply = e.toString();
            throw new JobSchedulerException(String.format("[rmdir][%s]%s", path, this.reply), (Throwable)e);
        }
    }

    private void dirInfo(String path, Deque<SOSFileEntry> result, boolean recursive) throws Exception {
        List<SOSFileEntry> infos = this.listNames(path, -1, false, false);
        for (SOSFileEntry resource : infos) {
            result.push(resource);
            if (!recursive || !resource.isDirectory()) continue;
            this.dirInfo(resource.getFullPath(), result, recursive);
        }
    }

    protected Proxy getSocksProxy() {
        if (!SOSString.isEmpty((String)this.getProxyUser())) {
            Authenticator.setDefault(new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(SOSFTPBaseClass.this.getProxyUser(), SOSFTPBaseClass.this.getProxyPassword().toCharArray());
                }
            });
        }
        return new Proxy(Proxy.Type.SOCKS, new InetSocketAddress(this.getProxyHost(), this.getProxyPort()));
    }

    protected Proxy getHTTPProxy() {
        if (!SOSString.isEmpty((String)this.getProxyUser())) {
            Authenticator.setDefault(new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(SOSFTPBaseClass.this.getProxyUser(), SOSFTPBaseClass.this.getProxyPassword().toCharArray());
                }
            });
        }
        return new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.getProxyHost(), this.getProxyPort()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeyStore loadKeyStore(String storeType, File storePath, String storePass) throws KeyStoreException, IOException, GeneralSecurityException {
        KeyStore ks = KeyStore.getInstance(storeType);
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(storePath);
            ks.load(stream, storePass.toCharArray());
        }
        catch (Throwable throwable) {
            Util.closeQuietly(stream);
            throw throwable;
        }
        Util.closeQuietly((Closeable)stream);
        return ks;
    }

    private final int passive() {
        try {
            int i = this.getClient().pasv();
            if (!this.isPositiveCommandCompletion()) {
                throw new JobSchedulerException(this.getHostID(SOSVfs_E_0106.params(new Object[]{"pasv", "", this.getReplyString()})));
            }
            LOGGER.info(this.getHostID(SOSVfs_E_0106.params(new Object[]{"pasv", "", this.getReplyString()})));
            this.getClient().enterLocalPassiveMode();
            return i;
        }
        catch (JobSchedulerException e) {
            throw e;
        }
        catch (IOException e) {
            throw new JobSchedulerException(e.toString(), (Throwable)e);
        }
    }

    private final ISOSProviderFile transferMode(SOSOptionTransferMode mode) {
        this.transferMode = mode;
        if (this.transferMode.isAscii()) {
            this.ascii();
        } else {
            this.binary();
        }
        LOGGER.info(SOSVfs_D_123.params(new Object[]{this.transferMode.getDescription(), this.getReplyString()}));
        return null;
    }

    private void ascii() {
        try {
            if (!this.getClient().setFileType(0)) {
                throw new JobSchedulerException(SOSVfs_E_149.params(new Object[]{this.getReplyString()}));
            }
        }
        catch (JobSchedulerException e) {
            throw e;
        }
        catch (IOException e) {
            throw new JobSchedulerException(e.toString(), (Throwable)e);
        }
    }

    private void binary() {
        try {
            if (!this.getClient().setFileType(2)) {
                throw new JobSchedulerException(SOSVfs_E_149.params(new Object[]{this.getReplyString()}));
            }
        }
        catch (JobSchedulerException e) {
            throw e;
        }
        catch (IOException e) {
            throw new JobSchedulerException(e.toString(), (Throwable)e);
        }
    }

    protected void closeInput(InputStream is) {
        try {
            if (is != null) {
                is.close();
                is = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void closeObject(OutputStream os) {
        try {
            if (os != null) {
                os.flush();
                os.close();
                os = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public final String getReplyString() {
        String msg = this.getClient().getReplyString();
        if (msg != null) {
            msg = msg.trim();
        }
        this.ftpReply = new SOSFTPServerReply(msg);
        return msg;
    }

    @Override
    public boolean isNegativeCommandCompletion() {
        int x = this.getClient().getReplyCode();
        return x > 300;
    }

    public long setModificationDateTime(String fileName, long millis) {
        if (millis <= 0L) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("[%s][skip]setModificationDateTime=%s", fileName, millis));
            }
            return millis;
        }
        try {
            Date d = new Date(millis);
            SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");
            this.getClient().setModificationTime(fileName, df.format(d));
            return millis;
        }
        catch (Throwable e) {
            LOGGER.error(String.format("[%s][%s]%s", fileName, millis, e.toString()), e);
            return -1L;
        }
    }

    public boolean isNotHiddenFile(String fileName) {
        return fileName != null && !".".equals(fileName) && !"..".equals(fileName) && !fileName.endsWith("/..") && !fileName.endsWith("/.");
    }

    protected boolean isPositiveCommandCompletion() {
        int x = this.getClient().getReplyCode();
        return x <= 300;
    }

    protected boolean logReply(String caller) {
        this.reply = this.getReplyString();
        if (LOGGER.isTraceEnabled() && this.providerOptions.protocolCommandListener.isFalse() && !SOSString.isEmpty((String)this.reply)) {
            LOGGER.trace(String.format("[%s]%s", caller, this.reply));
        }
        return true;
    }

    public String getResponse() {
        return this.getReplyString();
    }

    protected final String getHostID(String msg) {
        return "(" + this.user + "@" + this.host + ":" + this.port + ") " + msg;
    }

    protected boolean usingProxy() {
        return !SOSString.isEmpty((String)this.getProxyHost());
    }

    protected boolean usingHttpProxy() {
        return this.getProxyProtocol() != null && this.getProxyProtocol().isHttp();
    }

    private String trimResponseCode(String response) throws Exception {
        if (response.length() < 5) {
            return response;
        }
        return response.substring(4).trim();
    }

    @Override
    public boolean isSFTP() {
        return false;
    }

    public SOSOptionProxyProtocol getProxyProtocol() {
        return this.proxyProtocol;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public String getProxyUser() {
        return this.proxyUser;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    @Override
    public SOSProviderOptions getProviderOptions() {
        return this.providerOptions;
    }

    public SOSFTPServerReply getFtpReply() {
        return this.ftpReply;
    }

    public void setCurrentPath(String val) {
        this.currentPath = val;
    }

    public SOSFTPClientLogger getCommandListener() {
        return this.commandListener;
    }

    public void setCommandListener(SOSFTPClientLogger val) {
        this.commandListener = val;
    }

    public FTPClient getClient() {
        return this.ftpClient;
    }

    public void setClient(FTPClient val) {
        this.ftpClient = val;
    }

    @Override
    public SOSBaseOptions getBaseOptions() {
        return this.baseOptions;
    }

    @Override
    public void setBaseOptions(SOSBaseOptions val) {
        this.baseOptions = val;
    }

    @Override
    public boolean isHTTP() {
        return false;
    }
}

