/*
 * Decompiled with CFR 0.152.
 */
package com.sos.vfs.http;

import com.sos.JSHelper.Exceptions.JobSchedulerException;
import com.sos.i18n.annotation.I18NResourceBundle;
import com.sos.vfs.common.SOSCommonProvider;
import com.sos.vfs.common.SOSCommonProviderFile;
import java.io.InputStream;

@I18NResourceBundle(baseName="SOSVirtualFileSystem", defaultLocale="en")
public class SOSHTTPFile
extends SOSCommonProviderFile {
    public SOSHTTPFile(String path) {
        this.fileName = SOSCommonProvider.normalizePath(path);
    }

    @Override
    public int read(byte[] buffer) {
        try {
            InputStream is = this.getFileInputStream();
            if (is == null) {
                throw new JobSchedulerException(SOSVfs_E_177.get());
            }
            return is.read(buffer);
        }
        catch (Exception e) {
            throw new JobSchedulerException(SOSVfs_E_173.params(new Object[]{"read", this.fileName}), (Throwable)e);
        }
    }

    @Override
    public void write(byte[] buffer, int offset, int length) {
        try {
            if (this.getOutputStream() == null) {
                this.setOutputStream(this.getProvider().getOutputStream(this.fileName, this.isModeAppend(), this.isModeRestart()));
            }
            if (this.getOutputStream() == null) {
                throw new Exception(SOSVfs_E_147.get());
            }
            this.getOutputStream().write(buffer, offset, length);
        }
        catch (Exception e) {
            throw new JobSchedulerException(SOSVfs_E_173.params(new Object[]{"write", this.fileName}), (Throwable)e);
        }
    }

    @Override
    public void write(byte[] buffer) {
        try {
            if (this.getOutputStream() == null) {
                this.setOutputStream(this.getProvider().getOutputStream(this.fileName, this.isModeAppend(), this.isModeRestart()));
            }
            if (this.getOutputStream() == null) {
                throw new Exception(SOSVfs_E_147.get());
            }
            this.getOutputStream().write(buffer);
        }
        catch (Exception e) {
            throw new JobSchedulerException(SOSVfs_E_173.params(new Object[]{"write", this.fileName}), (Throwable)e);
        }
    }
}

