/*
 * Decompiled with CFR 0.152.
 */
package com.sos.vfs.http.common;

import com.sos.vfs.common.SOSProxySelector;
import com.sos.vfs.common.options.SOSProviderOptions;
import com.sos.vfs.http.common.SOSHTTPClientSSL;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.http.HttpHost;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.HttpContext;
import org.apache.jackrabbit.webdav.client.methods.HttpPropfind;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.util.SOSKeyStoreReader;
import sos.util.SOSString;

public class SOSHTTPClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(SOSHTTPClient.class);
    private CloseableHttpClient client = null;
    private HttpClientContext context;
    private final String user;
    private final String password;
    private URI baseURI;
    private String baseURIPath;
    private boolean isHTTPS;

    public SOSHTTPClient(SOSProviderOptions options, boolean ntCredentials) throws Exception {
        this.baseURI = this.getBaseURI(options);
        this.baseURIPath = this.baseURI.getPath();
        this.user = this.normalizeValue(options.user.getValue());
        this.password = this.normalizeValue(options.password.getValue());
        this.create(this.getProxySelector(options), this.getSSL(options), ntCredentials);
    }

    private void create(SOSProxySelector proxy, SOSHTTPClientSSL ssl, boolean ntCredentials) throws Exception {
        if (this.baseURI == null) {
            return;
        }
        this.close();
        HttpClientBuilder builder = HttpClientBuilder.create();
        BasicCredentialsProvider provider = new BasicCredentialsProvider();
        if (this.user != null && this.password != null) {
            String domain = null;
            String userName = null;
            String[] arr = this.user.split("\\\\");
            if (arr.length > 1) {
                domain = arr[0];
                userName = arr[1];
            } else {
                userName = this.user;
            }
            if (ntCredentials) {
                provider.setCredentials(AuthScope.ANY, (Credentials)new NTCredentials(userName, this.password, this.getWorkstation(), domain));
            } else {
                HttpHost targetHost = new HttpHost(this.baseURI.getHost(), this.baseURI.getPort(), this.baseURI.getScheme());
                provider.setCredentials(new AuthScope(targetHost), (Credentials)new UsernamePasswordCredentials(userName, this.password));
                BasicAuthCache authCache = new BasicAuthCache();
                authCache.put(targetHost, (AuthScheme)new BasicScheme());
                this.context = HttpClientContext.create();
                this.context.setCredentialsProvider((CredentialsProvider)provider);
                this.context.setAuthCache((AuthCache)authCache);
            }
        }
        if (proxy != null) {
            provider.setCredentials(proxy.getAuthScope(), proxy.getCredentials());
            builder.setProxy(proxy.getHttpHost());
        }
        builder.setDefaultCredentialsProvider((CredentialsProvider)provider);
        this.isHTTPS = false;
        if (this.baseURI.getScheme().equalsIgnoreCase("https")) {
            this.isHTTPS = true;
            if (ssl != null) {
                builder.setSSLContext(ssl.getSSLContext());
                builder.setSSLHostnameVerifier(ssl.getHostnameVerifier());
            }
        }
        builder.setDefaultRequestConfig(RequestConfig.custom().setCookieSpec("standard").build());
        this.client = builder.build();
    }

    public CloseableHttpResponse execute(HttpRequestBase request) throws Exception {
        if (this.client == null) {
            throw new Exception("HTTPClient is null");
        }
        return this.client.execute((HttpUriRequest)request, (HttpContext)this.context);
    }

    public void setBaseUriOnNotExists() {
        if (this.baseURI != null && this.baseURIPath != null) {
            try {
                String bu = this.baseURI.toString();
                this.baseURI = this.createURI(bu.substring(0, bu.indexOf(this.baseURIPath)) + "/");
                this.baseURIPath = this.baseURI.getPath();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(String.format("[setBaseUriOnNotExists][old=%s][new=%s]baseURIPath=%s", bu, this.baseURI, this.baseURIPath));
                }
            }
            catch (URISyntaxException e) {
                LOGGER.error(String.format("[setBaseUriOnNotExists][%s]%s", this.baseURI, e.toString()), (Throwable)e);
            }
        }
    }

    private String normalizeValue(String val) {
        return SOSString.isEmpty((String)val) ? null : val;
    }

    public int getPort() {
        int p = this.baseURI.getPort();
        if (p == -1) {
            p = this.isHTTPS ? 443 : 80;
        }
        return p;
    }

    private URI getBaseURI(SOSProviderOptions options) throws URISyntaxException {
        StringBuilder sb = new StringBuilder();
        String hostParam = options.host.getValue();
        if (options.authMethod.isURL()) {
            sb.append(hostParam);
            if (!hostParam.endsWith("/")) {
                sb.append("/");
            }
        } else if (hostParam.toLowerCase().startsWith("https://") || hostParam.toLowerCase().startsWith("http://")) {
            sb.append(hostParam);
            if (!hostParam.endsWith("/")) {
                sb.append("/");
            }
        } else {
            sb.append("http://").append(hostParam);
            if (!SOSString.isEmpty((String)options.port.getValue())) {
                sb.append(":").append(options.port.getValue());
            }
            sb.append("/");
        }
        return this.createURI(sb.toString());
    }

    private SOSHTTPClientSSL getSSL(SOSProviderOptions options) {
        SOSKeyStoreReader ksr;
        SOSHTTPClientSSL ssl = null;
        if (this.baseURI.getScheme().equalsIgnoreCase("https") && !(ssl = new SOSHTTPClientSSL(ksr = this.getKeyStoreReader(options), ksr, options.verifyCertificateHostname.value(), options.acceptUntrustedCertificate.value())).getCheckHostname()) {
            LOGGER.info("*********************** Security warning *********************************************************************");
            LOGGER.info("Yade option \"verify_certificate_hostname\" is currently \"false\". ");
            LOGGER.info("The certificate verification process will not verify the DNS name of the certificate presented by the server,");
            LOGGER.info("with the hostname of the server in the URL used by the Yade client.");
            LOGGER.info("**************************************************************************************************************");
        }
        return ssl;
    }

    private SOSKeyStoreReader getKeyStoreReader(SOSProviderOptions options) {
        SOSKeyStoreReader ksr = null;
        if (!options.acceptUntrustedCertificate.value()) {
            String kf = options.keystoreFile.getValue();
            String kp = options.keystorePassword.getValue();
            String kt = options.keystoreType.getValue();
            Path path = SOSString.isEmpty((String)kf) ? null : Paths.get(kf, new String[0]);
            String password = SOSString.isEmpty((String)kp) ? null : kp;
            String type = SOSString.isEmpty((String)kt) ? null : kt;
            ksr = new SOSKeyStoreReader(SOSKeyStoreReader.Type.KeyTrustStore, path, password, type);
        }
        return ksr;
    }

    private SOSProxySelector getProxySelector(SOSProviderOptions options) {
        SOSProxySelector selector = null;
        String host = options.proxyHost.getValue();
        if (!SOSString.isEmpty((String)host)) {
            int port = options.proxyPort.value();
            String user = options.proxyUser.getValue();
            String password = options.proxyPassword.getValue();
            selector = new SOSProxySelector(options.proxyProtocol.getValue(), host, port, SOSString.isEmpty((String)user) ? null : user, SOSString.isEmpty((String)password) ? null : password);
            LOGGER.info(String.format("[using proxy]protocol=%s, host=%s:%s, user=%s", options.proxyProtocol.getValue(), host, port, user));
        }
        return selector;
    }

    public void close() {
        if (this.client != null) {
            try {
                this.client.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.context = null;
    }

    public CloseableHttpClient getClient() {
        return this.client;
    }

    public URI getBaseURI() {
        return this.baseURI;
    }

    public String getBaseURIPath() {
        return this.baseURIPath;
    }

    public boolean isAbsolute(String fileName) {
        if (fileName == null) {
            return false;
        }
        String f = fileName.toLowerCase();
        return f.startsWith("https://") || f.startsWith("http://");
    }

    public URI normalizeURI(String rel) throws URISyntaxException {
        URI uri = null;
        uri = this.isAbsolute(rel) ? this.createURI(rel).normalize() : this.baseURI.resolve(this.createURI(rel)).normalize();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("[normalizeURI]" + uri);
        }
        return uri;
    }

    private URI createURI(String uri) throws URISyntaxException {
        try {
            return new URI(uri);
        }
        catch (Throwable e) {
            return new URI(uri.replaceAll(" ", "%20"));
        }
    }

    public HttpPropfind getConnectRequestMethod() throws IOException {
        return new HttpPropfind(this.baseURI, null, 0);
    }

    public String getRelativeDirectoryPath(URI uri) {
        String u;
        String p;
        int bul = this.baseURI.toString().length();
        String string = p = bul >= (u = uri.toString()).length() ? "/" : "/" + u.substring(bul);
        if (!p.equals("/")) {
            if (p.endsWith("/")) {
                p = p.substring(0, p.length() - 1);
            } else {
                int i = p.lastIndexOf("/");
                p = i >= 0 ? p.substring(0, i) : "";
                p = SOSString.isEmpty((String)p) ? "/" : p;
            }
        }
        return p;
    }

    private String getWorkstation() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (Throwable e) {
            return "unknown";
        }
    }

    public static boolean isSuccessStatusCode(StatusLine statusLine) {
        int sc = statusLine.getStatusCode();
        return sc >= 200 && sc < 300;
    }

    public static void checkForServerError(String uri, CloseableHttpResponse response) throws Exception {
        StatusLine statusLine = response.getStatusLine();
        int sc = statusLine.getStatusCode();
        if (sc >= 500) {
            throw new Exception(SOSHTTPClient.getResponseStatus(uri, statusLine));
        }
    }

    public static String getResponseStatus(String uri, StatusLine statusLine) throws Exception {
        return SOSHTTPClient.getResponseStatus(uri, statusLine, null);
    }

    public static String getResponseStatus(URI uri, StatusLine statusLine) throws Exception {
        String u = uri == null ? "" : uri.toString();
        return SOSHTTPClient.getResponseStatus(u, statusLine, null);
    }

    public static String getResponseStatus(URI from, URI to, StatusLine statusLine) throws Exception {
        String u;
        String string = u = from == null ? "" : from.toString();
        if (to != null) {
            u = u + "-" + to.toString();
        }
        return SOSHTTPClient.getResponseStatus(u, statusLine, null);
    }

    public static String getResponseStatus(String uri, StatusLine statusLine, Exception ex) throws Exception {
        int code = -1;
        String text = "";
        try {
            code = statusLine.getStatusCode();
            text = statusLine.getReasonPhrase();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (ex == null) {
            return String.format("[%s][%s]%s", uri, code, text);
        }
        return String.format("[%s][%s][%s]%s", uri, code, text, ex);
    }

    public static int checkConnectResponse(URI uri, CloseableHttpResponse response) throws Exception {
        StatusLine sl = response.getStatusLine();
        int sc = sl.getStatusCode();
        if (sc >= 500) {
            throw new Exception(SOSHTTPClient.getResponseStatus(uri, sl));
        }
        return sc;
    }
}

