/*
 * Decompiled with CFR 0.152.
 */
package com.sos.vfs.sftp.sshj;

import com.google.common.base.Joiner;
import com.sos.JSHelper.Exceptions.JobSchedulerException;
import com.sos.JSHelper.Options.SOSOptionProxyProtocol;
import com.sos.JSHelper.Options.SOSOptionTransferType;
import com.sos.exception.SOSException;
import com.sos.exception.SOSMissingDataException;
import com.sos.exception.SOSNoSuchFileException;
import com.sos.i18n.annotation.I18NResourceBundle;
import com.sos.vfs.common.SOSCommandResult;
import com.sos.vfs.common.SOSCommonProvider;
import com.sos.vfs.common.SOSEnv;
import com.sos.vfs.common.SOSFileEntry;
import com.sos.vfs.common.SOSFileEntryFile;
import com.sos.vfs.common.interfaces.ISOSProviderFile;
import com.sos.vfs.common.options.SOSProviderOptions;
import com.sos.vfs.exception.SOSAuthenticationFailedException;
import com.sos.vfs.sftp.SOSSFTP;
import com.sos.vfs.sftp.common.ISOSSFTP;
import com.sos.vfs.sftp.common.SOSSSHServerInfo;
import com.sos.vfs.sftp.exception.SOSSFTPClientNotInitializedException;
import com.sos.vfs.sftp.exception.SOSSSHCommandExitViolentlyException;
import com.sos.vfs.sftp.sshj.SOSSFTPFileSSHJ;
import com.sos.vfs.sftp.sshj.common.SSHProviderUtil;
import com.sos.vfs.sftp.sshj.common.proxy.Proxy;
import com.sos.vfs.sftp.sshj.common.proxy.ProxySocketFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Proxy;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.Deque;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.net.SocketFactory;
import net.schmizz.keepalive.KeepAlive;
import net.schmizz.keepalive.KeepAliveProvider;
import net.schmizz.keepalive.KeepAliveRunner;
import net.schmizz.sshj.Config;
import net.schmizz.sshj.DefaultConfig;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.Service;
import net.schmizz.sshj.common.IOUtils;
import net.schmizz.sshj.connection.channel.direct.Session;
import net.schmizz.sshj.sftp.FileAttributes;
import net.schmizz.sshj.sftp.FileMode;
import net.schmizz.sshj.sftp.OpenMode;
import net.schmizz.sshj.sftp.RemoteFile;
import net.schmizz.sshj.sftp.RemoteResourceInfo;
import net.schmizz.sshj.sftp.Response;
import net.schmizz.sshj.sftp.SFTPClient;
import net.schmizz.sshj.sftp.SFTPException;
import net.schmizz.sshj.transport.TransportException;
import net.schmizz.sshj.transport.verification.HostKeyVerifier;
import net.schmizz.sshj.transport.verification.PromiscuousVerifier;
import net.schmizz.sshj.userauth.UserAuthException;
import net.schmizz.sshj.userauth.keyprovider.KeyProvider;
import net.schmizz.sshj.userauth.method.AuthKeyboardInteractive;
import net.schmizz.sshj.userauth.method.AuthMethod;
import net.schmizz.sshj.userauth.method.AuthPassword;
import net.schmizz.sshj.userauth.method.AuthPublickey;
import net.schmizz.sshj.userauth.method.ChallengeResponseProvider;
import net.schmizz.sshj.userauth.method.PasswordResponseProvider;
import net.schmizz.sshj.xfer.FileSystemFile;
import net.schmizz.sshj.xfer.LocalDestFile;
import net.schmizz.sshj.xfer.LocalSourceFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.util.SOSDate;
import sos.util.SOSString;

@I18NResourceBundle(baseName="SOSVirtualFileSystem", defaultLocale="en")
public class SOSSFTPSSHJ
extends SOSCommonProvider
implements ISOSSFTP {
    private static final Logger LOGGER = LoggerFactory.getLogger(SOSSFTPSSHJ.class);
    private Config config;
    private SSHClient sshClient;
    private SFTPClient sftpClient;
    private Session.Command sshClientCommand;
    private Integer exitCode;
    private String exitSignal;
    private String stdOut;
    private String stdErr;
    private boolean simulateShell = false;
    private SOSSSHServerInfo serverInfo;
    private String serverVersion;

    @Override
    public boolean isConnected() {
        if (this.sshClient == null) {
            return false;
        }
        return this.sshClient.isConnected();
    }

    @Override
    public void connect(SOSProviderOptions options) throws Exception {
        super.connect(options);
        LOGGER.info("[" + this.getProviderOptions().protocol.getValue() + "]" + SOSVfs_D_0101.params(new Object[]{this.getProviderOptions().host.getValue(), this.getProviderOptions().port.value()}));
        try {
            this.createSSHClient();
            this.sshClient.connect(options.host.getValue(), options.port.value());
            this.authenticate();
            this.serverVersion = this.sshClient.getTransport().getServerVersion();
            this.createSFTPClient();
            this.printConnectionInfos();
        }
        catch (JobSchedulerException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new JobSchedulerException(ex);
        }
    }

    private void printConnectionInfos() {
        KeepAlive r;
        ArrayList<String> msg = new ArrayList<String>();
        if (this.sshClient.getTimeout() > 0 || this.sshClient.getConnectTimeout() > 0) {
            msg.add("ConnectTimeout=" + this.ms2string(this.sshClient.getConnectTimeout()) + ", SocketTimeout=" + this.ms2string(this.sshClient.getTimeout()));
        }
        if (this.sshClient.getConnection() != null && (r = this.sshClient.getConnection().getKeepAlive()).getKeepAliveInterval() > 0) {
            if (r instanceof KeepAliveRunner) {
                msg.add("KeepAliveInterval=" + r.getKeepAliveInterval() + "s, MaxAliveCount=" + ((KeepAliveRunner)r).getMaxAliveCount());
            } else {
                msg.add("KeepAliveInterval=" + r.getKeepAliveInterval() + "s");
            }
        }
        if (msg.size() > 0) {
            LOGGER.info(Joiner.on((String)", ").join(msg));
        }
    }

    private String ms2string(int val) {
        if (val <= 0) {
            return String.valueOf(val).concat("ms");
        }
        try {
            return String.valueOf(Math.round(val / 1000)).concat("s");
        }
        catch (Throwable e) {
            return String.valueOf(val).concat("ms");
        }
    }

    @Override
    public void disconnect() {
        this.reply = "disconnect OK";
        if (this.sftpClient != null) {
            try {
                this.sftpClient.close();
                LOGGER.debug("[sftp client]disconnected");
            }
            catch (Throwable e) {
                this.reply = "[sftp client][disconnect]" + e.toString();
            }
        }
        if (this.sshClient != null) {
            try {
                this.sshClient.close();
                LOGGER.debug("[ssh client]disconnected");
            }
            catch (Throwable e) {
                this.reply = "[ssh client][disconnect]" + e.toString();
            }
        }
        LOGGER.info(this.reply);
    }

    @Override
    public void mkdir(String path) {
        try {
            if (this.sftpClient == null) {
                throw new SOSSFTPClientNotInitializedException();
            }
            if (SOSString.isEmpty((String)path)) {
                throw new SOSMissingDataException("path");
            }
            String p = path.replaceAll("//+", "/").replaceFirst("/$", "");
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace(String.format("[mkdir][%s]try to create ...", p));
            }
            this.sftpClient.mkdirs(path);
            this.reply = "mkdir OK";
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("[mkdir][%s]created", p));
            }
        }
        catch (Throwable e) {
            this.reply = e.toString();
            throw new JobSchedulerException(String.format("[%s] mkdir failed", path), e);
        }
    }

    @Override
    public void rmdir(String path) {
        try {
            if (this.sftpClient == null) {
                throw new SOSSFTPClientNotInitializedException();
            }
            if (SOSString.isEmpty((String)path)) {
                throw new SOSMissingDataException("path");
            }
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace(String.format("[rmdir][%s]try to remove ...", path));
            }
            LinkedList<RemoteResourceInfo> toRemove = new LinkedList<RemoteResourceInfo>();
            this.dirInfo(this.sftpClient, path, toRemove, true);
            boolean isDebugEnabled = LOGGER.isDebugEnabled();
            while (!toRemove.isEmpty()) {
                RemoteResourceInfo resource = (RemoteResourceInfo)toRemove.pop();
                String resourcePath = resource.getPath();
                if (isDebugEnabled) {
                    LOGGER.debug(this.getHostID(SOSVfs_D_179.params(new Object[]{"rmdir", resourcePath})));
                }
                if (resource.isDirectory()) {
                    this.sftpClient.rmdir(resourcePath);
                    if (!isDebugEnabled) continue;
                    LOGGER.debug(this.getHostID(SOSVfs_D_181.params(new Object[]{"rmdir", resourcePath, "rmdir OK"})));
                    continue;
                }
                if (!resource.isRegularFile()) continue;
                this.sftpClient.rm(resourcePath);
                if (!isDebugEnabled) continue;
                LOGGER.debug(this.getHostID(SOSVfs_D_181.params(new Object[]{"rmdir", resourcePath, "rm OK"})));
            }
            this.sftpClient.rmdir(path);
            this.reply = "rmdir OK";
            LOGGER.info(this.getHostID(SOSVfs_D_181.params(new Object[]{"rmdir", path, this.getReplyString()})));
        }
        catch (Throwable e) {
            this.reply = e.toString();
            throw new JobSchedulerException(String.format("[%s]rmdir failed", path), e);
        }
    }

    private void dirInfo(SFTPClient client, String path, Deque<RemoteResourceInfo> result, boolean recursive) throws Exception {
        List infos = client.ls(path);
        for (RemoteResourceInfo resource : infos) {
            result.push(resource);
            if (!recursive || !resource.isDirectory()) continue;
            this.dirInfo(client, resource.getPath(), result, recursive);
        }
    }

    @Override
    public boolean fileExists(String path) {
        boolean result;
        block8: {
            result = false;
            try {
                FileAttributes attributes = this.getFileAttributes(path);
                if (attributes == null) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("[fileExists][" + path + "]FileAttributes is null");
                    }
                } else {
                    result = attributes.getType().equals((Object)FileMode.Type.REGULAR) || attributes.getType().equals((Object)FileMode.Type.DIRECTORY);
                }
            }
            catch (SFTPException e) {
                if (!this.isNoSuchFileException(e) && LOGGER.isDebugEnabled()) {
                    LOGGER.debug("[fileExists][" + path + "]" + e.toString(), (Throwable)e);
                }
            }
            catch (Throwable e) {
                if (!LOGGER.isDebugEnabled()) break block8;
                LOGGER.debug("[fileExists][" + path + "]" + e.toString(), e);
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("[%s]fileExists=%s", path, result));
        }
        return result;
    }

    @Override
    public boolean directoryExists(String path) {
        return this.isDirectory(path);
    }

    @Override
    public boolean isDirectory(String path) {
        boolean result;
        block8: {
            result = false;
            try {
                FileAttributes attributes = this.getFileAttributes(path);
                if (attributes == null) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("[isDirectory][" + path + "]FileAttributes is null");
                    }
                } else {
                    result = attributes.getType().equals((Object)FileMode.Type.DIRECTORY);
                }
            }
            catch (SFTPException e) {
                if (!this.isNoSuchFileException(e) && LOGGER.isDebugEnabled()) {
                    LOGGER.debug("[isDirectory][" + path + "]" + e.toString(), (Throwable)e);
                }
            }
            catch (Throwable e) {
                if (!LOGGER.isDebugEnabled()) break block8;
                LOGGER.debug("[isDirectory][" + path + "]" + e.toString(), e);
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("[%s]isDirectory=%s", path, result));
        }
        return result;
    }

    @Override
    public long size(String path) throws Exception {
        long size;
        block6: {
            size = -1L;
            try {
                path = SOSSFTPSSHJ.normalizePath(path);
                FileAttributes attr = this.getFileAttributes(path);
                if (attr != null) {
                    size = attr.getSize();
                }
            }
            catch (SFTPException e) {
                try {
                    this.throwException(e, path);
                }
                catch (SOSNoSuchFileException ex) {
                    if (!LOGGER.isDebugEnabled()) break block6;
                    LOGGER.debug(String.format("[%s]%s", path, e.getMessage()));
                }
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("[%s]size=%s", path, size));
        }
        return size;
    }

    protected FileAttributes getFileAttributes(String path) throws Exception {
        if (this.sftpClient == null) {
            throw new SOSSFTPClientNotInitializedException();
        }
        if (SOSString.isEmpty((String)path)) {
            throw new SOSMissingDataException("path");
        }
        return this.sftpClient.stat(path);
    }

    private void createSSHClient() throws Exception {
        this.setConfig();
        this.sshClient = new SSHClient(this.config);
        this.setHostKeyVerifier();
        this.setCompression();
        this.setTimeout();
        this.setProxy();
        this.setKeepAlive();
    }

    private void createSFTPClient() throws Exception {
        if (this.sshClient == null || !this.getProviderOptions().protocol.getValue().equals(SOSOptionTransferType.TransferTypes.sftp.name())) {
            return;
        }
        this.sftpClient = this.sshClient.newSFTPClient();
    }

    private void setConfig() {
        this.config = new DefaultConfig();
        if (!SOSString.isEmpty((String)this.getProviderOptions().server_alive_interval.getValue())) {
            this.config.setKeepAliveProvider(KeepAliveProvider.KEEP_ALIVE);
        }
    }

    private void setKeepAlive() {
        String sai = this.getProviderOptions().server_alive_interval.getValue();
        if (!SOSString.isEmpty((String)sai)) {
            try {
                KeepAliveRunner r = (KeepAliveRunner)this.sshClient.getConnection().getKeepAlive();
                r.setKeepAliveInterval(SOSDate.resolveAge((String)"s", (String)sai).intValue());
                String sacm = this.getProviderOptions().server_alive_count_max.getValue();
                if (!SOSString.isEmpty((String)sacm)) {
                    r.setMaxAliveCount(Integer.parseInt(sacm));
                }
            }
            catch (Throwable ex) {
                LOGGER.warn(String.format("[setKeepAlive]%s", ex.toString()), ex);
            }
        }
    }

    private void setHostKeyVerifier() throws Exception {
        if (this.getProviderOptions().strictHostKeyChecking.isTrue()) {
            this.sshClient.loadKnownHosts();
        } else {
            this.sshClient.addHostKeyVerifier((HostKeyVerifier)new PromiscuousVerifier());
        }
    }

    private void setCompression() throws TransportException {
        if (this.getProviderOptions().useZlibCompression.value()) {
            this.sshClient.useCompression();
        }
    }

    private void setTimeout() {
        String t = this.getProviderOptions().connect_timeout.getValue();
        if (!SOSString.isEmpty((String)t)) {
            try {
                int connectTimeout = SOSDate.resolveAge((String)"ms", (String)t).intValue();
                if (connectTimeout > 0) {
                    this.sshClient.setConnectTimeout(connectTimeout);
                }
            }
            catch (Throwable ex) {
                LOGGER.warn(String.format("[setConnectTimeout][%s]%s", t, ex.toString()), ex);
            }
        }
        if (!SOSString.isEmpty((String)(t = this.getProviderOptions().channel_connect_timeout.getValue()))) {
            try {
                int socketTimeout = SOSDate.resolveAge((String)"ms", (String)t).intValue();
                if (socketTimeout > 0) {
                    this.sshClient.setTimeout(socketTimeout);
                    this.sshClient.getTransport().setTimeoutMs(socketTimeout);
                }
            }
            catch (Throwable ex) {
                LOGGER.warn(String.format("[setTimeout][%s]%s", t, ex.toString()), ex);
            }
        }
    }

    public void setProxy() {
        String proxyHost = this.getProviderOptions().proxyHost.getValue();
        if (!SOSString.isEmpty((String)proxyHost)) {
            SOSOptionProxyProtocol proxyProtocol = this.getProviderOptions().proxyProtocol;
            String proxyUser = this.getProviderOptions().proxyUser.getValue();
            String proxyPassword = this.getProviderOptions().proxyPassword.getValue();
            int proxyPort = this.getProviderOptions().proxyPort.value();
            int proxyConnectTimeout = 30000;
            String t = this.getProviderOptions().connect_timeout.getValue();
            if (!SOSString.isEmpty((String)t)) {
                try {
                    proxyConnectTimeout = SOSDate.resolveAge((String)"ms", (String)t).intValue();
                }
                catch (Exception ex) {
                    LOGGER.warn(String.format("[proxyConnectTimeout][%s]%s", t, ex.toString()), (Throwable)ex);
                }
            }
            LOGGER.info(String.format("using proxy: protocol=%s, host=%s, port=%d, user=%s, pass=?", proxyProtocol.getValue(), proxyHost, proxyPort, proxyUser));
            Proxy.Type type = proxyProtocol.isHttp() ? Proxy.Type.HTTP : Proxy.Type.SOCKS;
            Proxy proxy = new Proxy(type, proxyHost, proxyPort, proxyUser, proxyPassword, proxyConnectTimeout);
            this.sshClient.setSocketFactory((SocketFactory)((Object)new ProxySocketFactory(proxy)));
        }
    }

    private List<String> toList(String s) {
        if (SOSString.isEmpty((String)s)) {
            return null;
        }
        return Stream.of(s.trim().replaceAll(";", ",").split(",")).map(String::trim).collect(Collectors.toList());
    }

    private void authenticate() throws Exception {
        if (this.getProviderOptions().preferred_authentications.isNotEmpty()) {
            this.usePreferredAuthentications();
        } else if (this.getProviderOptions().required_authentications.isNotEmpty()) {
            this.useRequiredAuthentications();
        } else {
            this.useAuthMethodAuthentication();
        }
    }

    private void usePreferredAuthentications() throws Exception {
        LinkedList<Object> methods = new LinkedList<Object>();
        List<String> list = this.toList(this.getProviderOptions().preferred_authentications.getValue().toLowerCase());
        if (list == null) {
            return;
        }
        Iterator<String> iterator = list.iterator();
        while (iterator.hasNext()) {
            String am;
            switch (am = iterator.next()) {
                case "publickey": {
                    methods.add(this.getAuthPublickey());
                    break;
                }
                case "password": {
                    methods.add(this.getAuthPassword());
                    break;
                }
                case "keyboardinteractive": 
                case "keyboard_interactive": {
                    methods.add(this.getAuthKeyboardInteractive());
                }
            }
        }
        this.sshClient.auth(this.getProviderOptions().user.getValue(), methods);
    }

    private void useRequiredAuthentications() throws Exception {
        List<String> list = this.toList(this.getProviderOptions().required_authentications.getValue().toLowerCase());
        if (list == null) {
            return;
        }
        Iterator<String> iterator = list.iterator();
        while (iterator.hasNext()) {
            String am;
            switch (am = iterator.next()) {
                case "publickey": {
                    this.partialAuthentication((AuthMethod)this.getAuthPublickey());
                    break;
                }
                case "password": {
                    this.partialAuthentication((AuthMethod)this.getAuthPassword());
                    break;
                }
                case "keyboardinteractive": 
                case "keyboard_interactive": {
                    this.partialAuthentication((AuthMethod)this.getAuthKeyboardInteractive());
                }
            }
        }
    }

    private void useAuthMethodAuthentication() throws Exception {
        if (SOSString.isEmpty((String)this.getProviderOptions().authMethod.getValue())) {
            throw new SOSException("missing required argument \"auth_method\"");
        }
        AuthPublickey method = null;
        switch (this.getProviderOptions().authMethod.getValue().toLowerCase()) {
            case "publickey": {
                method = this.getAuthPublickey();
                break;
            }
            case "password": {
                method = this.getAuthPassword();
                break;
            }
            case "keyboardinteractive": 
            case "keyboard_interactive": {
                method = this.getAuthKeyboardInteractive();
            }
        }
        if (method == null) {
            throw new SOSException(String.format("unknown method=%s", this.getProviderOptions().authMethod.getValue()));
        }
        this.sshClient.auth(this.getProviderOptions().user.getValue(), new AuthMethod[]{method});
    }

    private void partialAuthentication(AuthMethod method) throws SOSAuthenticationFailedException, UserAuthException, TransportException {
        if (!this.sshClient.getUserAuth().authenticate(this.getProviderOptions().user.getValue(), (Service)this.sshClient.getConnection(), method, this.sshClient.getTransport().getTimeoutMs()) && !this.sshClient.getUserAuth().hadPartialSuccess()) {
            throw new SOSAuthenticationFailedException();
        }
    }

    private AuthPassword getAuthPassword() throws SOSException, UserAuthException, TransportException {
        if (SOSString.isEmpty((String)this.getProviderOptions().password.getValue())) {
            throw new SOSException("missing required argument \"password\"");
        }
        return new AuthPassword(SSHProviderUtil.getPasswordFinder(this.getProviderOptions().password.getValue()));
    }

    private AuthKeyboardInteractive getAuthKeyboardInteractive() throws SOSException, UserAuthException, TransportException {
        if (SOSString.isEmpty((String)this.getProviderOptions().password.getValue())) {
            throw new SOSException("missing required argument \"password\"");
        }
        return new AuthKeyboardInteractive((ChallengeResponseProvider)new PasswordResponseProvider(SSHProviderUtil.getPasswordFinder(this.getProviderOptions().password.getValue())));
    }

    private AuthPublickey getAuthPublickey() throws Exception {
        KeyProvider keyProvider = null;
        if (this.getProviderOptions().keepass_database.value() != null && this.getProviderOptions().keepass_database_entry.value() != null && !SOSString.isEmpty((String)this.getProviderOptions().keepass_attachment_property_name.getValue())) {
            keyProvider = SSHProviderUtil.getKeyProviderFromKeepass(this.sshClient, this.getProviderOptions());
        } else {
            if (SOSString.isEmpty((String)this.getProviderOptions().authFile.getValue())) {
                throw new SOSException("missing required argument \"auth_file\"");
            }
            Path authFile = Paths.get(this.getProviderOptions().authFile.getValue(), new String[0]);
            keyProvider = SOSString.isEmpty((String)this.getProviderOptions().passphrase.getValue()) ? this.sshClient.loadKeys(authFile.toFile().getCanonicalPath()) : this.sshClient.loadKeys(authFile.toFile().getCanonicalPath(), this.getProviderOptions().passphrase.getValue());
        }
        return new AuthPublickey(keyProvider);
    }

    @Override
    public SOSFileEntry getFileEntry(String pathname) throws Exception {
        try {
            FileAttributes attrs = this.getFileAttributes(pathname);
            if (attrs != null && !FileMode.Type.DIRECTORY.equals((Object)attrs.getType())) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace(String.format("[%s]found", pathname));
                }
                SOSFileEntryFile f = new SOSFileEntryFile(pathname);
                return this.getFileEntry(attrs, f.getName(), f.getParent());
            }
        }
        catch (Throwable e) {
            throw new Exception(String.format("[getFileEntry][%s]%s", pathname, e.toString()), e);
        }
        return null;
    }

    private SOSFileEntry getFileEntry(FileAttributes attrs, String fileName, String parentPath) {
        SOSFileEntry entry = new SOSFileEntry(SOSFileEntry.EntryType.FILESYSTEM);
        entry.setDirectory(FileMode.Type.DIRECTORY.equals((Object)attrs.getType()));
        entry.setFilename(fileName);
        entry.setFilesize(attrs.getSize());
        entry.setParentPath(parentPath);
        if (parentPath != null && SOSSFTP.hasWindowsOpenSSHDriverLetterSpecifier(parentPath)) {
            entry.setFullPath("/" + entry.getFullPath());
        }
        return entry;
    }

    @Override
    public List<SOSFileEntry> listNames(String path, int maxFiles, boolean checkIfExists, boolean checkIfIsDirectory) {
        try {
            path = SOSSFTPSSHJ.normalizePath(path);
            if (this.sftpClient == null) {
                throw new SOSSFTPClientNotInitializedException();
            }
            if (SOSString.isEmpty((String)path)) {
                throw new SOSMissingDataException("path");
            }
            ArrayList<SOSFileEntry> result = new ArrayList<SOSFileEntry>();
            if (path.isEmpty()) {
                path = ".";
            }
            if (checkIfExists && !this.fileExists(path)) {
                return result;
            }
            if (checkIfIsDirectory && !this.isDirectory(path)) {
                this.reply = "ls OK";
                return result;
            }
            List infos = this.sftpClient.ls(path);
            if (infos != null && infos.size() > 0) {
                for (RemoteResourceInfo resource : infos) {
                    String name = resource.getName();
                    if (name.equals(".") || name.equals("..")) continue;
                    result.add(this.getFileEntry(resource.getAttributes(), name, path));
                }
            }
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace(String.format("[%s][ls] %s files or folders", path, result.size()));
            }
            this.reply = "ls OK";
            return result;
        }
        catch (Throwable e) {
            this.reply = e.toString();
            return null;
        }
    }

    @Override
    public void delete(String path, boolean checkIsDirectory) {
        try {
            if (this.sftpClient == null) {
                throw new SOSSFTPClientNotInitializedException();
            }
            if (SOSString.isEmpty((String)path)) {
                throw new SOSMissingDataException("path");
            }
            if (checkIsDirectory && this.isDirectory(path)) {
                throw new JobSchedulerException(SOSVfs_E_186.params(new Object[]{path}));
            }
            try {
                this.sftpClient.rm(this.sftpClient.canonicalize(path));
            }
            catch (SFTPException e) {
                this.throwException(e, path);
            }
        }
        catch (Throwable ex) {
            this.reply = ex.toString();
            throw new JobSchedulerException(SOSVfs_E_187.params(new Object[]{"delete", path}), ex);
        }
        this.reply = "rm OK";
        LOGGER.info(this.getHostID(SOSVfs_D_181.params(new Object[]{"delete", path, this.getReplyString()})));
    }

    @Override
    public void rename(String oldpath, String newpath) {
        try {
            oldpath = SOSSFTPSSHJ.normalizePath(oldpath);
            newpath = SOSSFTPSSHJ.normalizePath(newpath);
            if (this.sftpClient == null) {
                throw new SOSSFTPClientNotInitializedException();
            }
            if (SOSString.isEmpty((String)oldpath) || SOSString.isEmpty((String)newpath)) {
                throw new SOSMissingDataException("oldpath or newpath");
            }
            try {
                this.sftpClient.rename(this.sftpClient.canonicalize(oldpath), newpath);
            }
            catch (SFTPException e) {
                this.throwException(e, oldpath);
            }
        }
        catch (Throwable e) {
            this.reply = e.toString();
            throw new JobSchedulerException(SOSVfs_E_188.params(new Object[]{"rename", oldpath, newpath}), e);
        }
        this.reply = "mv OK";
        LOGGER.info(this.getHostID(SOSVfs_I_189.params(new Object[]{oldpath, newpath, this.getReplyString()})));
    }

    @Override
    public void executeCommand(String cmd) {
        this.executeCommand(cmd, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeCommand(String command, SOSEnv env) {
        if (this.sshClient == null || command == null) {
            return;
        }
        command = command.trim().replaceAll("\u0000", "\\\\\\\\").replaceAll("\"", "\\\"");
        SOSCommandResult result = new SOSCommandResult(command);
        this.sshClientCommand = null;
        this.exitCode = null;
        this.stdOut = null;
        this.stdErr = null;
        boolean isDebugEnabled = LOGGER.isDebugEnabled();
        try (Session session2 = this.sshClient.startSession();){
            if (this.isSimulateShell()) {
                session2.allocateDefaultPTY();
            }
            command = this.handleEnvs(command, session2, env, isDebugEnabled);
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace(String.format("[cmd]%s", command));
            }
            this.sshClientCommand = session2.exec(command);
            result.addStdOut(IOUtils.readFully((InputStream)this.sshClientCommand.getInputStream()).toString());
            result.addStdErr(IOUtils.readFully((InputStream)this.sshClientCommand.getErrorStream()).toString());
            this.sshClientCommand.join();
            result.setExitCode(this.sshClientCommand.getExitStatus());
            if (result.getExitCode() == null && this.sshClientCommand.getExitSignal() != null) {
                throw new SOSSSHCommandExitViolentlyException(this.sshClientCommand.getExitSignal(), this.sshClientCommand.getExitErrorMessage());
            }
        }
        catch (Throwable e) {
            result.setException(e);
        }
        finally {
            if (this.sshClientCommand != null) {
                try {
                    this.sshClientCommand.close();
                }
                catch (Throwable session2) {}
                this.sshClientCommand = null;
            }
        }
        this.exitCode = result.getExitCode();
        this.stdOut = result.getStdOut();
        this.stdErr = result.getStdErr();
        if (result.hasError(false)) {
            this.reply = result.toString();
            if (this.getProviderOptions().raiseExceptionOnError.value()) {
                if (result.getException() == null) {
                    throw new JobSchedulerException(this.reply);
                }
                throw new JobSchedulerException(result.getException());
            }
            LOGGER.info(String.format("[%s][error]%s", command, this.reply));
        } else {
            LOGGER.info(String.format("[%s][std:out]%s", command, result.getStdOut().trim()));
        }
    }

    private String handleEnvs(String command, Session session, SOSEnv env, boolean isDebugEnabled) throws Exception {
        if (env == null) {
            return command;
        }
        if (env.getGlobalEnvs() != null && env.getGlobalEnvs().size() > 0) {
            if (isDebugEnabled) {
                LOGGER.debug(String.format("[set global envs]%s", env.getGlobalEnvs()));
            }
            for (Map.Entry<String, String> entry : env.getGlobalEnvs().entrySet()) {
                try {
                    session.setEnvVar(entry.getKey(), entry.getValue());
                }
                catch (Throwable e) {
                    LOGGER.debug(String.format("[session.setEnvVar failed][%s=%s]%s", entry.getKey(), entry.getValue(), e.toString()));
                }
            }
        }
        if (env.getLocalEnvs() != null && env.getLocalEnvs().size() > 0) {
            this.getSSHServerInfo();
            StringBuilder envs = new StringBuilder();
            for (Map.Entry<String, String> entry : env.getLocalEnvs().entrySet()) {
                if (this.serverInfo.hasWindowsShell()) {
                    envs.append(String.format("set %s=%s&", entry.getKey(), entry.getValue()));
                    continue;
                }
                envs.append(String.format("export \"%s=%s\";", entry.getKey(), entry.getValue()));
            }
            if (isDebugEnabled) {
                LOGGER.debug(String.format("[set local envs]%s", envs));
            }
            command = envs.toString() + command;
        }
        return command;
    }

    @Override
    public SOSSSHServerInfo getSSHServerInfo() {
        if (this.serverInfo == null) {
            this.serverInfo = new SOSSSHServerInfo(this.serverVersion, this.executeResultCommand("uname"));
        }
        return this.serverInfo;
    }

    @Override
    public boolean isExecSessionExists() {
        return this.sshClientCommand != null;
    }

    @Override
    public boolean isExecSessionConnected() {
        return this.sshClientCommand != null && this.sshClientCommand.isOpen();
    }

    @Override
    public void execSessionSendSignalContinue() throws Exception {
        if (this.sshClientCommand != null && this.sshClient != null) {
            this.sshClient.getConnection().sendGlobalRequest("keepalive@openssh.com", false, new byte[0]);
        }
    }

    @Override
    public InputStream getInputStream(String fileName) {
        try {
            return this.createInputStream(this.sftpClient.open(fileName));
        }
        catch (Throwable ex) {
            throw new JobSchedulerException(SOSVfs_E_193.params(new Object[]{"getInputStream()", fileName}), ex);
        }
    }

    @Override
    public OutputStream getOutputStream(String fileName, boolean append, boolean resume) {
        try {
            EnumSet<OpenMode> set = EnumSet.of(OpenMode.WRITE, OpenMode.CREAT);
            if (append) {
                set.add(OpenMode.APPEND);
            } else {
                set.add(OpenMode.TRUNC);
            }
            RemoteFile remoteFile = this.sftpClient.open(fileName, set);
            return SOSSFTPSSHJ.createOutputStream(remoteFile);
        }
        catch (Throwable ex) {
            throw new JobSchedulerException(SOSVfs_E_193.params(new Object[]{"getOutputStream()", fileName}), ex);
        }
    }

    private InputStream createInputStream(final RemoteFile remoteFile) throws IOException {
        RemoteFile remoteFile2 = remoteFile;
        remoteFile2.getClass();
        return new RemoteFile.ReadAheadRemoteFileInputStream(remoteFile2, 16){
            private final AtomicBoolean close;
            {
                RemoteFile remoteFile2 = x0;
                remoteFile2.getClass();
                super(remoteFile2, x1);
                this.close = new AtomicBoolean();
            }

            public void close() throws IOException {
                if (this.close.get()) {
                    return;
                }
                try {
                    super.close();
                }
                finally {
                    remoteFile.close();
                    this.close.set(true);
                }
            }
        };
    }

    private static OutputStream createOutputStream(final RemoteFile remoteFile) {
        RemoteFile remoteFile2 = remoteFile;
        remoteFile2.getClass();
        return new RemoteFile.RemoteFileOutputStream(remoteFile2, 0L, 16){
            private boolean isClosed;
            {
                RemoteFile remoteFile2 = x0;
                remoteFile2.getClass();
                super(remoteFile2, x1, x2);
                this.isClosed = false;
            }

            public synchronized void close() throws IOException {
                if (!this.isClosed) {
                    remoteFile.close();
                    this.isClosed = true;
                }
            }
        };
    }

    @Override
    public ISOSProviderFile getFile(String fileName) {
        fileName = this.adjustFileSeparator(fileName);
        SOSSFTPFileSSHJ file = new SOSSFTPFileSSHJ(fileName);
        file.setProvider(this);
        return file;
    }

    @Override
    public String getModificationDateTime(String path) {
        String dateTime = null;
        try {
            if (SOSString.isEmpty((String)path)) {
                throw new SOSMissingDataException("path");
            }
            try {
                FileAttributes attr = this.getFileAttributes(path);
                if (attr != null) {
                    SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    dateTime = df.format(new Date(attr.getMtime() * 1000L));
                }
            }
            catch (SFTPException e) {
                this.throwException(e, path);
            }
        }
        catch (Throwable e) {
            LOGGER.error(e.toString(), e);
        }
        return dateTime;
    }

    @Override
    public String getStdErr() {
        return this.stdErr;
    }

    @Override
    public void resetStdErr() {
        this.stdErr = null;
    }

    @Override
    public String getStdOut() {
        return this.stdOut;
    }

    @Override
    public void resetStdOut() {
        this.stdOut = null;
    }

    @Override
    public Integer getExitCode() {
        return this.exitCode;
    }

    @Override
    public String getExitSignal() {
        return this.exitSignal;
    }

    @Override
    public long putFile(String source, String target) {
        try {
            if (this.sftpClient == null) {
                throw new SOSSFTPClientNotInitializedException();
            }
            Instant start = Instant.now();
            this.sftpClient.put((LocalSourceFile)new FileSystemFile(source), SOSSFTPSSHJ.normalizePath(target));
            Instant end = Instant.now();
            this.reply = "put OK (" + SOSDate.getDuration((Instant)start, (Instant)end) + ")";
            LOGGER.info(this.getHostID(SOSVfs_I_183.params(new Object[]{"putFile", source, target, this.getReplyString()})));
            long size = this.size(target);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("[put][%s]size=%s", target, size));
            }
            return size;
        }
        catch (Throwable e) {
            this.reply = e.toString();
            throw new JobSchedulerException(SOSVfs_E_185.params(new Object[]{"putFile()", source, target}), e);
        }
    }

    @Override
    public void putFile(File source, String target, int chmod) throws Exception {
        this.putFile(source.getCanonicalPath(), target);
        this.sftpClient.chmod(target, chmod);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("[put][%s]chmod=%s", target, chmod));
        }
    }

    @Override
    public void get(String source, String target) {
        try {
            if (this.sftpClient == null) {
                throw new SOSSFTPClientNotInitializedException();
            }
            Instant start = Instant.now();
            this.sftpClient.getFileTransfer().setPreserveAttributes(false);
            this.sftpClient.get(SOSSFTPSSHJ.normalizePath(source), (LocalDestFile)new FileSystemFile(target));
            Instant end = Instant.now();
            this.reply = "get OK (" + SOSDate.getDuration((Instant)start, (Instant)end) + ")";
            LOGGER.info(this.getHostID(SOSVfs_I_183.params(new Object[]{"get", source, target, this.getReplyString()})));
        }
        catch (Throwable e) {
            this.reply = e.toString();
            throw new JobSchedulerException(SOSVfs_E_185.params(new Object[]{"get()", source, target}), e);
        }
    }

    @Override
    public SOSCommandResult executeResultCommand(String command) {
        SOSCommandResult result = new SOSCommandResult(command);
        if (this.sshClient == null) {
            return result;
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("[cmd]%s", command));
        }
        try (Session session = this.sshClient.startSession();){
            if (this.isSimulateShell()) {
                session.allocateDefaultPTY();
            }
            Session.Command cmd = session.exec(command);
            result.addStdOut(IOUtils.readFully((InputStream)cmd.getInputStream()).toString());
            result.addStdErr(IOUtils.readFully((InputStream)cmd.getErrorStream()).toString());
            cmd.join();
            result.setExitCode(cmd.getExitStatus());
            if (result.getExitCode() == null && cmd.getExitSignal() != null) {
                throw new SOSSSHCommandExitViolentlyException(cmd.getExitSignal(), cmd.getExitErrorMessage());
            }
        }
        catch (Throwable e) {
            result.setException(e);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(result.toString());
        }
        return result;
    }

    private void throwException(SFTPException e, String msg) throws Exception {
        if (this.isNoSuchFileException(e)) {
            throw new SOSNoSuchFileException(msg, (Throwable)e);
        }
        throw e;
    }

    private boolean isNoSuchFileException(SFTPException e) {
        if (e == null) {
            return false;
        }
        Response.StatusCode sc = e.getStatusCode();
        return sc != null && (sc.equals((Object)Response.StatusCode.NO_SUCH_FILE) || sc.equals((Object)Response.StatusCode.NO_SUCH_PATH));
    }

    @Override
    public boolean isSFTP() {
        return true;
    }

    @Override
    public boolean isSimulateShell() {
        return this.simulateShell;
    }

    @Override
    public void setSimulateShell(boolean val) {
        this.simulateShell = val;
    }

    protected SFTPClient getSFTPClient() {
        return this.sftpClient;
    }
}

