/*
 * Decompiled with CFR 0.152.
 */
package com.sos.vfs.sftp.sshj.common.proxy.http;

import com.sos.vfs.sftp.sshj.common.proxy.Proxy;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.Base64;
import org.apache.commons.io.IOUtils;
import sos.util.SOSString;

public class HttpProxySocket
extends Socket {
    private static final String SYSTEM_PROPERTY_CONNECT_HTTP_VERSION = "yade.sshj.proxy.http.connect_http_version";
    private static final String DEFAULT_CONNECT_HTTP_VERSION = "1.0";
    private static final String NEW_LINE = "\r\n";
    private final Proxy proxy;
    private final String connectHttpVersion;

    public HttpProxySocket(Proxy proxy) throws UnknownHostException, IOException {
        this.proxy = proxy;
        this.connectHttpVersion = this.getConnectHttpVersion();
    }

    @Override
    public void connect(SocketAddress endpoint, int timeout) throws IOException {
        super.connect(this.proxy.getProxy().address(), this.proxy.getConnectTimeout());
        String basicAuth = null;
        if (!SOSString.isEmpty((String)this.proxy.getUser())) {
            basicAuth = new String(Base64.getEncoder().encode(new String(this.proxy.getUser() + ":" + this.proxy.getPassword()).getBytes()));
        }
        InetSocketAddress address = (InetSocketAddress)endpoint;
        OutputStream out = this.getOutputStream();
        IOUtils.write((String)String.format("CONNECT %s:%s HTTP/%s%s", address.getHostName(), address.getPort(), this.connectHttpVersion, NEW_LINE), (OutputStream)out, (Charset)this.proxy.getCharset());
        if (basicAuth != null) {
            IOUtils.write((String)"Proxy-Authorization: Basic ", (OutputStream)out, (Charset)this.proxy.getCharset());
            IOUtils.write((String)basicAuth, (OutputStream)out, (Charset)this.proxy.getCharset());
            IOUtils.write((String)NEW_LINE, (OutputStream)out, (Charset)this.proxy.getCharset());
        }
        IOUtils.write((String)NEW_LINE, (OutputStream)out, (Charset)this.proxy.getCharset());
        out.flush();
        InputStream in = this.getInputStream();
        String response = new LineNumberReader(new InputStreamReader(in)).readLine();
        if (response == null) {
            throw new SocketException(String.format("[%s]missing response", ((InetSocketAddress)this.proxy.getProxy().address()).getHostName()));
        }
        if (!response.contains("200")) {
            throw new SocketException(String.format("[%s][invalid response]%s", ((InetSocketAddress)this.proxy.getProxy().address()).getHostName(), response));
        }
        in.skip(in.available());
    }

    private String getConnectHttpVersion() {
        String v = null;
        try {
            v = System.getProperty(SYSTEM_PROPERTY_CONNECT_HTTP_VERSION);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (SOSString.isEmpty((String)v)) {
            v = DEFAULT_CONNECT_HTTP_VERSION;
        }
        return v;
    }
}

