/*
 * Decompiled with CFR 0.152.
 */
package com.sos.vfs.smb;

import com.sos.JSHelper.Options.SOSOptionString;
import com.sos.i18n.annotation.I18NResourceBundle;
import com.sos.vfs.common.SOSCommonProvider;
import com.sos.vfs.common.SOSEnv;
import com.sos.vfs.common.SOSFileEntry;
import com.sos.vfs.common.interfaces.ISOSProviderFile;
import com.sos.vfs.common.options.SOSBaseOptions;
import com.sos.vfs.common.options.SOSProviderOptions;
import com.sos.vfs.smb.common.ISOSSMB;
import com.sos.vfs.smb.jcifs.SOSSMBJCIFS;
import com.sos.vfs.smb.smbj.SOSSMBJ;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@I18NResourceBundle(baseName="SOSVirtualFileSystem", defaultLocale="en")
public class SOSSMB
extends SOSCommonProvider
implements ISOSSMB {
    private static final Logger LOGGER = LoggerFactory.getLogger(SOSSMB.class);
    private ISOSSMB provider;

    public SOSSMB(SOSOptionString providerOption) {
        this.setProvider(providerOption);
    }

    private void setProvider(SOSOptionString providerOption) {
        String smbProvider;
        if (providerOption == null) {
            SOSBaseOptions baseOptions = new SOSBaseOptions();
            providerOption = baseOptions.smb_provider;
        }
        this.provider = (smbProvider = providerOption.getValue().toUpperCase()).equals(SMBProvider.JCIFS.name()) ? new SOSSMBJCIFS() : new SOSSMBJ();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("provider=%s", this.provider.getClass().getName()));
        }
    }

    @Override
    public boolean isConnected() {
        return this.provider.isConnected();
    }

    @Override
    public void connect(SOSProviderOptions options) throws Exception {
        this.provider.connect(options);
    }

    @Override
    public void disconnect() {
        this.provider.disconnect();
    }

    @Override
    public void mkdir(String path) {
        this.provider.mkdir(path);
    }

    @Override
    public void rmdir(String path) {
        this.provider.rmdir(path);
    }

    @Override
    public boolean fileExists(String filename) {
        return this.provider.fileExists(filename);
    }

    @Override
    public boolean directoryExists(String filename) {
        return this.provider.directoryExists(filename);
    }

    @Override
    public boolean isDirectory(String filename) {
        return this.provider.isDirectory(filename);
    }

    @Override
    public long size(String filename) throws Exception {
        return this.provider.size(filename);
    }

    @Override
    public SOSFileEntry getFileEntry(String pathname) throws Exception {
        return this.provider.getFileEntry(pathname);
    }

    @Override
    public List<SOSFileEntry> listNames(String path, int maxFiles, boolean checkIfExists, boolean checkIfIsDirectory) {
        return this.provider.listNames(path, maxFiles, checkIfExists, checkIfIsDirectory);
    }

    @Override
    public void delete(String path, boolean checkIsDirectory) {
        this.provider.delete(path, checkIsDirectory);
    }

    @Override
    public void rename(String from, String to) {
        this.provider.rename(from, to);
    }

    @Override
    public void executeCommand(String cmd) throws Exception {
        this.provider.executeCommand(cmd);
    }

    @Override
    public void executeCommand(String cmd, SOSEnv env) throws Exception {
        this.provider.executeCommand(cmd, env);
    }

    @Override
    public InputStream getInputStream(String fileName) {
        return this.provider.getInputStream(fileName);
    }

    @Override
    public OutputStream getOutputStream(String fileName, boolean append, boolean resume) {
        return this.provider.getOutputStream(fileName, append, resume);
    }

    @Override
    public ISOSProviderFile getFile(String fileName) {
        return this.provider.getFile(fileName);
    }

    @Override
    public String getModificationDateTime(String path) {
        return this.provider.getModificationDateTime(path);
    }

    @Override
    public boolean isSFTP() {
        return false;
    }

    @Override
    public long getModificationTimeStamp(String path) throws Exception {
        return this.provider.getModificationTimeStamp(path);
    }

    @Override
    public void setModificationTimeStamp(String path, long timeStamp) throws Exception {
        this.provider.setModificationTimeStamp(path, timeStamp);
    }

    @Override
    public void setBaseOptions(SOSBaseOptions val) {
        this.provider.setBaseOptions(val);
    }

    public static enum SMBProvider {
        JCIFS,
        SMBJ;

    }
}

