/*
 * Decompiled with CFR 0.152.
 */
package com.sos.vfs.smb.jcifs;

import com.sos.JSHelper.Exceptions.JobSchedulerException;
import com.sos.i18n.annotation.I18NResourceBundle;
import com.sos.vfs.common.SOSFileEntry;
import com.sos.vfs.smb.common.ASOSSMB;
import com.sos.vfs.smb.common.ISOSSMB;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import jcifs.CIFSContext;
import jcifs.CIFSException;
import jcifs.Configuration;
import jcifs.Credentials;
import jcifs.DialectVersion;
import jcifs.SmbResource;
import jcifs.config.PropertyConfiguration;
import jcifs.context.BaseContext;
import jcifs.smb.NtlmPasswordAuthenticator;
import jcifs.smb.SmbFile;
import jcifs.smb.SmbFileInputStream;
import jcifs.smb.SmbFileOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.util.SOSString;

@I18NResourceBundle(baseName="SOSVirtualFileSystem", defaultLocale="en")
public class SOSSMBJCIFS
extends ASOSSMB
implements ISOSSMB {
    private static final Logger LOGGER = LoggerFactory.getLogger(SOSSMBJCIFS.class);
    private CIFSContext context = null;

    @Override
    public void doConnect() throws Exception {
        try {
            this.createContext(this.getDomain(), this.host, this.port, this.user, this.getProviderOptions().password.getValue());
        }
        catch (Throwable ex) {
            throw new JobSchedulerException(ex);
        }
        this.checkConnection();
    }

    private void checkConnection() throws Exception {
        block2: {
            try {
                this.getFileEntry("/");
            }
            catch (Throwable e) {
                Exception ex = SOSSMBJCIFS.findConnectionException(e);
                if (ex == null) break block2;
                throw e;
            }
        }
    }

    private static Exception findConnectionException(Throwable cause) {
        for (Throwable e = cause; e != null; e = e.getCause()) {
            if (e instanceof UnknownHostException) {
                return (UnknownHostException)e;
            }
            if (!(e instanceof ConnectException)) continue;
            return (ConnectException)e;
        }
        return null;
    }

    @Override
    public void doDisconnect() {
        if (this.context != null) {
            block3: {
                try {
                    this.context.close();
                }
                catch (CIFSException e) {
                    if (!LOGGER.isDebugEnabled()) break block3;
                    LOGGER.debug(String.format("%s[disconnect]%s", this.getLogPrefix(), e.toString()), (Throwable)e);
                }
            }
            this.context = null;
        }
    }

    private void createContext(String domain, String host, int port, String user, String password) throws Exception {
        Properties p = new Properties();
        p.put("jcifs.smb.client.minVersion", DialectVersion.SMB202.name());
        p.put("jcifs.smb.client.maxVersion", DialectVersion.SMB311.name());
        PropertyConfiguration pc = new PropertyConfiguration(this.getConfigFromFiles(p));
        BaseContext bc = new BaseContext((Configuration)pc);
        if (LOGGER.isDebugEnabled()) {
            List<String> excluded = Arrays.asList("minVersion;maxVersion;localTimeZone;random;machineId".split(";"));
            LOGGER.debug(String.format("%s[createContext][config][minVersion=%s,maxVersion=%s]%s", this.getLogPrefix(), pc.getMinimumVersion(), pc.getMaximumVersion(), SOSString.toString((Object)pc, excluded)));
        }
        this.context = bc.withCredentials((Credentials)new NtlmPasswordAuthenticator(domain, user, password));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean fileExists(String path) {
        try (SmbFile smbFile = this.getSmbFile(SOSSMBJCIFS.normalizePath(path));){
            boolean result = smbFile.exists();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("%s[fileExists][%s]%s", this.getLogPrefix(), path, result));
            }
            boolean bl = result;
            return bl;
        }
        catch (JobSchedulerException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new JobSchedulerException(SOSVfs_E_226.params(new Object[]{path}), e);
        }
    }

    @Override
    public boolean directoryExists(String path) {
        return this.isDirectory(path);
    }

    @Override
    public long size(String path) throws Exception {
        long size = -1L;
        try (SmbFile smbFile = this.getSmbFile(SOSSMBJCIFS.normalizePath(path));){
            if (smbFile.exists()) {
                size = smbFile.length();
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("%s[size][%s]%s", this.getLogPrefix(), path, size));
            }
        }
        catch (JobSchedulerException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new JobSchedulerException(String.format("%s[size][%s][failed]%s", this.getLogPrefix(), path, e.toString()), e);
        }
        return size;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isDirectory(String path) {
        try (SmbFile smbFile = this.getSmbFile(SOSSMBJCIFS.normalizePath(path));){
            boolean r = smbFile.isDirectory();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("%s[isDirectory][%s]%s", this.getLogPrefix(), path, r));
            }
            boolean bl = r;
            return bl;
        }
        catch (Throwable e) {
            if (!LOGGER.isDebugEnabled()) return false;
            LOGGER.debug(String.format("%s[isDirectory][%s][exception]%s", this.getLogPrefix(), path, e.toString()));
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isHidden(String path) {
        try (SmbFile smbFile = this.getSmbFile(SOSSMBJCIFS.normalizePath(path));){
            boolean result = smbFile.isHidden();
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace(String.format("%s[isHidden][%s]%s", this.getLogPrefix(), path, result));
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (!LOGGER.isDebugEnabled()) return false;
            LOGGER.debug(String.format("%s[isHidden][%s][exception]%s", this.getLogPrefix(), path, e.toString()));
            return false;
        }
    }

    @Override
    public void mkdir(String path) {
        boolean isDebugEnabled = LOGGER.isDebugEnabled();
        this.reply = "OK";
        try (SmbFile smbFile = this.getSmbFile(SOSSMBJCIFS.normalizePath(path));){
            if (smbFile.exists()) {
                if (isDebugEnabled) {
                    LOGGER.debug(String.format("%s[mkdir][%s]already exists", this.getLogPrefix(), path));
                }
                return;
            }
            smbFile.mkdirs();
            if (isDebugEnabled) {
                LOGGER.debug(String.format("%s[mkdir][%s]created", this.getLogPrefix(), path));
            }
        }
        catch (JobSchedulerException e) {
            this.reply = e.toString();
            throw e;
        }
        catch (Throwable e) {
            this.reply = e.toString();
            throw new JobSchedulerException(String.format("%s[mkdir][%s]%s", this.getLogPrefix(), path, this.reply), e);
        }
    }

    @Override
    public void rmdir(String path) {
        this.reply = "rmdir OK";
        if (!(path = SOSSMBJCIFS.normalizePath(path)).endsWith("/")) {
            path = path + "/";
        }
        try (SmbFile smbFile = this.getSmbFile(path);){
            if (!smbFile.exists()) {
                throw new JobSchedulerException(String.format("%s[rmdir][%s][failed]filepath does not exist", this.getLogPrefix(), smbFile.getPath()));
            }
            if (!smbFile.isDirectory()) {
                throw new JobSchedulerException(String.format("%s[rmdir][%s][failed]filepath is not a directory", this.getLogPrefix(), smbFile.getPath()));
            }
            smbFile.delete();
            LOGGER.info(String.format("%s[rmdir][%s]%s", this.getLogPrefix(), path, this.getReplyString()));
        }
        catch (JobSchedulerException e) {
            this.reply = e.toString();
            throw e;
        }
        catch (Throwable e) {
            this.reply = e.toString();
            throw new JobSchedulerException(String.format("%s[rmdir][%s]%s", this.getLogPrefix(), path, this.reply), e);
        }
    }

    @Override
    public SOSFileEntry getFileEntry(String path) throws Exception {
        SmbFile file = this.getSmbFile(SOSSMBJCIFS.normalizePath(path));
        if (file == null) {
            return null;
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("[%s]found", path));
        }
        SOSFileEntry entry = this.getFileEntry(file, this.getParent(path));
        return entry;
    }

    private SOSFileEntry getFileEntry(SmbFile file, String parentPath) throws Exception {
        SOSFileEntry entry = new SOSFileEntry(SOSFileEntry.EntryType.SMB);
        entry.setDirectory(file.isDirectory());
        entry.setFilename(file.getName());
        entry.setFilesize(file.length());
        entry.setParentPath(parentPath);
        return entry;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<SOSFileEntry> listNames(String path, int maxFiles, boolean checkIfExists, boolean checkIfIsDirectory) {
        ArrayList<SOSFileEntry> result = new ArrayList<SOSFileEntry>();
        if (path.isEmpty()) {
            path = ".";
        }
        try (SmbFile smbFile = this.getSmbFile(SOSSMBJCIFS.normalizePath(path));){
            if (checkIfExists && !smbFile.exists()) {
                ArrayList<SOSFileEntry> arrayList = result;
                return arrayList;
            }
            if (checkIfIsDirectory && !smbFile.isDirectory()) {
                this.reply = "ls OK";
                ArrayList<SOSFileEntry> arrayList = result;
                return arrayList;
            }
            path = path.endsWith("/") ? path : path + "/";
            SmbFile[] list = smbFile.listFiles();
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace(String.format("[%s][listNames]%s files or folders", path, list.length));
            }
            for (int i = 0; i < list.length; ++i) {
                SmbFile file = list[i];
                result.add(this.getFileEntry(file, path));
            }
            this.reply = "ls OK";
            ArrayList<SOSFileEntry> arrayList = result;
            return arrayList;
        }
        catch (JobSchedulerException e) {
            this.reply = e.toString();
            throw e;
        }
        catch (Throwable e) {
            this.reply = e.toString();
            throw new JobSchedulerException(this.reply, e);
        }
    }

    @Override
    public void delete(String path, boolean checkIsDirectory) {
        try (SmbFile smbFile = this.getSmbFile(SOSSMBJCIFS.normalizePath(path));){
            if (checkIsDirectory && smbFile.isDirectory()) {
                throw new JobSchedulerException(SOSVfs_E_186.params(new Object[]{path}));
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("%s[delete]%s", this.getLogPrefix(), path));
            }
            smbFile.delete();
        }
        catch (JobSchedulerException e) {
            this.reply = e.toString();
            throw e;
        }
        catch (Throwable e) {
            this.reply = e.toString();
            throw new JobSchedulerException(String.format("%s[rm][%s]%s", this.getLogPrefix(), path, this.reply), e);
        }
        this.reply = "rm OK";
        LOGGER.info(String.format("%s[delete][%s]%s", this.getLogPrefix(), path, this.getReplyString()));
    }

    @Override
    public void rename(String from, String to) {
        SmbFile smbFileFrom = null;
        SmbFile smbFileTo = null;
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("%s[rename][%s]%s", this.getLogPrefix(), from, to));
            }
            smbFileFrom = this.getSmbFile(SOSSMBJCIFS.normalizePath(from));
            smbFileTo = this.getSmbFile(SOSSMBJCIFS.normalizePath(to));
            smbFileFrom.renameTo((SmbResource)smbFileTo);
        }
        catch (JobSchedulerException e) {
            this.reply = e.toString();
            throw e;
        }
        catch (Throwable e) {
            this.reply = e.toString();
            throw new JobSchedulerException(String.format("%s[rename][%s][%s]%s", this.getLogPrefix(), from, to, this.reply), e);
        }
        finally {
            if (smbFileFrom != null) {
                smbFileFrom.close();
            }
            if (smbFileTo != null) {
                smbFileTo.close();
            }
        }
        this.reply = "OK";
        LOGGER.info(String.format("%s[rename][%s][%s]%s", this.getLogPrefix(), from, to, this.getReplyString()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public InputStream getInputStream(String path) {
        try (SmbFile smbFile = this.getSmbFile(SOSSMBJCIFS.normalizePath(path));){
            SmbFileInputStream smbFileInputStream = new SmbFileInputStream(smbFile);
            return smbFileInputStream;
        }
        catch (JobSchedulerException e) {
            throw e;
        }
        catch (Throwable ex) {
            throw new JobSchedulerException(String.format("%s[getInputStream][%s][failed]%s", this.getLogPrefix(), path, ex.toString()), ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public OutputStream getOutputStream(String path, boolean append, boolean resume) {
        try (SmbFile smbFile = this.getSmbFile(SOSSMBJCIFS.normalizePath(path));){
            SmbFileOutputStream smbFileOutputStream = new SmbFileOutputStream(smbFile);
            return smbFileOutputStream;
        }
        catch (JobSchedulerException e) {
            throw e;
        }
        catch (Throwable ex) {
            throw new JobSchedulerException(String.format("%s[getOutputStream][%s][failed]%s", this.getLogPrefix(), path, ex.toString()), ex);
        }
    }

    @Override
    public String getModificationDateTime(String path) {
        String r = null;
        try (SmbFile smbFile = this.getSmbFile(SOSSMBJCIFS.normalizePath(path));){
            if (smbFile.exists()) {
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                r = df.format(new Date(smbFile.getLastModified()));
            }
        }
        catch (Throwable e) {
            LOGGER.error(String.format("%s[getModificationDateTime][%s]%s", this.getLogPrefix(), path, e.toString()), e);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("%s[%s]getModificationDateTime=%s", this.getLogPrefix(), path, r));
        }
        return r;
    }

    @Override
    public long getModificationTimeStamp(String path) throws Exception {
        long r = -1L;
        try (SmbFile smbFile = this.getSmbFile(SOSSMBJCIFS.normalizePath(path));){
            if (smbFile.exists()) {
                r = smbFile.getLastModified();
            }
        }
        catch (Throwable e) {
            LOGGER.error(String.format("%s[getModificationTimeStamp][%s]%s", this.getLogPrefix(), path, e.toString()), e);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("[%s]getModificationTimeStamp=%s", path, r));
        }
        return r;
    }

    @Override
    public void setModificationTimeStamp(String path, long timeStamp) throws Exception {
        if (timeStamp <= 0L) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("[%s][skip]setModificationTimeStamp=%s", path, timeStamp));
            }
            return;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("[%s]setModificationTimeStamp=%s", path, timeStamp));
        }
        try (SmbFile smbFile = this.getSmbFile(SOSSMBJCIFS.normalizePath(path));){
            if (smbFile.exists()) {
                smbFile.setLastModified(timeStamp);
            }
        }
        catch (Throwable e) {
            LOGGER.error(String.format("%s[setModificationTimeStamp][%s][%s]%s", this.getLogPrefix(), path, timeStamp, e.toString()), e);
        }
    }

    private String getSmbFilePath(String path) {
        path = path.startsWith("/") ? path.substring(1) : path;
        return "smb://" + this.host + "/" + path;
    }

    private SmbFile getSmbFile(String path) throws Exception {
        try {
            return new SmbFile(this.getSmbFilePath(path), this.context);
        }
        catch (Exception ex) {
            throw new JobSchedulerException(String.format("%s[getSmbFile][%s][failed]%s", this.getLogPrefix(), path, ex.toString()), (Throwable)ex);
        }
    }
}

