/*
 * Decompiled with CFR 0.152.
 */
package com.sos.vfs.webdav.jackrabbit.common;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Date;
import org.apache.commons.httpclient.util.DateUtil;
import org.apache.jackrabbit.webdav.MultiStatusResponse;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertySet;
import org.w3c.dom.Node;
import sos.util.SOSDate;

public class SOSWebDAVResource {
    private String href;
    private String name;
    private Date lastModified;
    private boolean isDirectory = false;
    private long size = 0L;

    public SOSWebDAVResource(MultiStatusResponse response) {
        this(response, false);
    }

    public SOSWebDAVResource(MultiStatusResponse response, boolean onlyLastModified) {
        DavPropertySet found = response.getProperties(200);
        if (onlyLastModified) {
            this.lastModified = this.getLastModified(found);
        } else {
            this.href = this.getHref(response);
            this.name = this.getName(this.href);
            this.isDirectory = this.isDirectory(found);
            if (!this.isDirectory) {
                this.size = this.getSize(found);
            }
        }
    }

    private Date getLastModified(DavPropertySet set) {
        Date result = null;
        DavProperty p = set.get("getlastmodified");
        if (p != null) {
            try {
                result = DateUtil.parseDate((String)p.getValue().toString());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return result;
    }

    private String getHref(MultiStatusResponse response) {
        try {
            return URLDecoder.decode(response.getHref(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return response.getHref();
        }
    }

    private boolean isDirectory(DavPropertySet set) {
        Node node;
        DavProperty p = set.get("resourcetype");
        if (p != null && (node = (Node)p.getValue()) != null && node.getLocalName() != null) {
            return node.getLocalName().equals("collection");
        }
        return false;
    }

    private long getSize(DavPropertySet set) {
        DavProperty p = set.get("getcontentlength");
        return p == null ? 0L : Long.parseLong(p.getValue().toString());
    }

    private String getName(String href) {
        int i;
        if (href.equals("/")) {
            return "";
        }
        String path = href;
        if (href.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return (i = path.lastIndexOf("/")) >= 0 ? path.substring(i + 1) : path;
    }

    public String getHref() {
        return this.href;
    }

    public String getName() {
        return this.name;
    }

    public Date getLastModified() {
        return this.lastModified;
    }

    public String getLastModifiedAsString() {
        try {
            return SOSDate.getDateTimeAsString((Date)this.lastModified, (String)"yyyy-MM-dd HH:mm:ss");
        }
        catch (Exception e) {
            return null;
        }
    }

    public long getLastModifiedAsLong() {
        return this.lastModified == null ? -1L : this.lastModified.getTime();
    }

    public boolean isDirectory() {
        return this.isDirectory;
    }

    public long getSize() {
        return this.size;
    }
}

