/*
 * Decompiled with CFR 0.152.
 */
package sos.net;

import com.sos.JSHelper.Exceptions.JobSchedulerException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Vector;
import org.apache.commons.net.PrintCommandListener;
import org.apache.commons.net.ProtocolCommandListener;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.net.SOSFileTransfer;

public class SOSFTP
extends FTPClient
implements SOSFileTransfer {
    private static final Logger LOGGER = LoggerFactory.getLogger(SOSFTP.class);
    protected static final String conRegExpBackslash = "\\\\";
    private ProtocolCommandListener listener = null;

    public SOSFTP() {
    }

    public SOSFTP(String host) throws SocketException, IOException, UnknownHostException {
        this.connect(host);
    }

    public SOSFTP(String host, int port) throws SocketException, IOException, UnknownHostException {
        this.connect(host, port);
    }

    public SOSFTP(String ftpHost, int ftpPort, String proxyHost, int proxyPort) throws SocketException, IOException, UnknownHostException {
        this.connect(ftpHost, ftpPort);
    }

    public void connect(String host, int port) throws SocketException, IOException, UnknownHostException {
        if (!this.isConnected()) {
            this.listener = new PrintCommandListener(new PrintWriter(System.out));
            String strAddFTPProtocol = System.getenv("AddFTPProtocol");
            if (strAddFTPProtocol != null && "true".equalsIgnoreCase(strAddFTPProtocol)) {
                this.addProtocolCommandListener(this.listener);
            }
            super.connect(host, port);
            this.logReply();
        }
    }

    public void connect(String hostname) throws SocketException, IOException, UnknownHostException {
        if (!this.isConnected()) {
            super.connect(hostname);
        }
        this.logReply();
    }

    @Override
    public boolean mkdir(String pathname) throws IOException {
        int intPosixPermissions = 484;
        return this.mkdir(pathname, intPosixPermissions);
    }

    @Override
    public boolean mkdir(String pathname, int pintPosixPermissions) throws IOException {
        boolean flgRet = this.makeDirectory(pathname);
        this.sendCommand("CHMOD " + Integer.toOctalString(pintPosixPermissions) + " " + pathname);
        return flgRet;
    }

    public boolean rmdir(String pathname) throws IOException {
        return this.removeDirectory(pathname);
    }

    public int passive() throws IOException {
        return this.pasv();
    }

    @Override
    public Vector<String> nList(String pathname) throws Exception {
        return this.getFilenames(pathname);
    }

    private Vector<String> getFilenames(String pathname) throws IOException {
        return this.getFilenames(pathname, false);
    }

    private Vector<String> getFilenames(String pstrPathName, boolean flgRecurseSubFolders) throws IOException {
        Vector<String> vecListFileItems = new Vector<String>();
        String[] fileList = null;
        String strCurrentDirectoryName = this.doPWD();
        String lstrPathName = pstrPathName.trim();
        if (lstrPathName.isEmpty()) {
            lstrPathName = ".";
        }
        if (".".equals(lstrPathName)) {
            lstrPathName = strCurrentDirectoryName;
        }
        LOGGER.debug("nlist with " + lstrPathName);
        fileList = this.listNames(lstrPathName);
        if (fileList == null) {
            return vecListFileItems;
        }
        for (String strCurrentFileName : fileList) {
            Vector<String> vecNames;
            if (!this.isNotHiddenFile(strCurrentFileName)) continue;
            this.doCD(strCurrentFileName);
            if (this.isNegativeCommandCompletion()) {
                if (flgRecurseSubFolders && !strCurrentFileName.startsWith(strCurrentDirectoryName) && !strCurrentDirectoryName.isEmpty()) {
                    strCurrentFileName = strCurrentDirectoryName + "/" + strCurrentFileName;
                }
                strCurrentFileName = strCurrentFileName.replaceAll(conRegExpBackslash, "/");
                vecListFileItems.add(strCurrentFileName);
                continue;
            }
            this.doCDUP();
            if (!flgRecurseSubFolders || (vecNames = this.getFilenames(strCurrentFileName)) == null) continue;
            vecListFileItems.addAll(vecNames);
        }
        LOGGER.debug("strCurrentDirectory = " + strCurrentDirectoryName);
        this.doCD(strCurrentDirectoryName);
        this.doPWD();
        return vecListFileItems;
    }

    public String doPWD() {
        String strCurrentPathName = "";
        try {
            this.pwd();
            strCurrentPathName = this.getReplyString();
            int idx = strCurrentPathName.indexOf(34);
            if (idx >= 0 && (idx = (strCurrentPathName = strCurrentPathName.substring(idx + 1, strCurrentPathName.length() - idx + 1)).indexOf(34)) > 0) {
                strCurrentPathName = strCurrentPathName.substring(0, idx);
            }
            this.logReply();
        }
        catch (IOException e) {
            this.raiseException("Problems with pwd", e);
        }
        return strCurrentPathName;
    }

    private int doCDUP() {
        try {
            LOGGER.debug("Try cdup .");
            this.cdup();
            this.logReply();
            this.doPWD();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return 0;
    }

    private int doCD(String strFolderName) {
        int x = 0;
        try {
            x = this.cd(strFolderName);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return x;
    }

    private boolean logReply() {
        LOGGER.debug(this.getReplyString());
        return true;
    }

    private boolean isNegativeCommandCompletion() {
        return this.getReplyCode() > 300;
    }

    private boolean isPositiveCommandCompletion() {
        return this.getReplyCode() <= 300;
    }

    public boolean isNotHiddenFile(String strFileName) {
        return !"..".equalsIgnoreCase(strFileName) && !".".equalsIgnoreCase(strFileName);
    }

    @Override
    public Vector<String> nList(String pathname, boolean flgRecurseSubFolder) throws Exception {
        return this.getFilenames(pathname, flgRecurseSubFolder);
    }

    @Override
    public Vector<String> nList() throws Exception {
        return this.getFilenames();
    }

    private Vector<String> getFilenames() throws Exception {
        return this.getFilenames("", false);
    }

    private Vector<String> getFilenames(boolean flgRecurseSubFolders) throws Exception {
        return this.getFilenames("", flgRecurseSubFolders);
    }

    @Override
    public Vector<String> nList(boolean recursive) throws Exception {
        return this.getFilenames(recursive);
    }

    public Vector<String> dir(String pathname) throws Exception {
        return this.getFilenames(pathname);
    }

    @Deprecated
    public Vector<String> dir(String pathname, int flag) throws Exception {
        FTPFile[] listFiles;
        Vector<String> fileList = new Vector<String>();
        for (FTPFile listFile : listFiles = this.listFiles(pathname)) {
            if (flag > 0 && listFile.isDirectory()) {
                fileList.addAll(this.dir(pathname + "/" + listFile.toString(), flag >= 1024 ? flag : flag + 1024));
                continue;
            }
            if (flag >= 1024) {
                fileList.add(pathname + "/" + listFile.toString());
                continue;
            }
            fileList.add(listFile.toString());
        }
        return fileList;
    }

    public Vector<String> dir() throws Exception {
        return this.dir(".");
    }

    public String getResponse() {
        return this.getReplyString();
    }

    @Override
    public int size(String remoteFile) {
        try {
            this.sendCommand("SIZE " + remoteFile);
            if (this.getReplyCode() == 213) {
                return Integer.parseInt(this.trimResponseCode(this.getReplyString()));
            }
            return -1;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    private String trimResponseCode(String response) throws Exception {
        if (response.length() < 5) {
            return response;
        }
        return response.substring(4).trim();
    }

    public boolean get(String remoteFile, String localFile) throws Exception {
        FileOutputStream out = null;
        boolean rc = false;
        try {
            out = new FileOutputStream(localFile);
            boolean bl = rc = this.retrieveFile(remoteFile, out);
            return bl;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public long getFile(String remoteFile, String localFile) throws Exception {
        boolean flgAppendLocalFile = false;
        return this.getFile(remoteFile, localFile, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getFile(String remoteFile, String localFile, boolean append) throws Exception {
        InputStream in = null;
        OutputStream out = null;
        long totalBytes = 0L;
        try {
            in = this.retrieveFileStream(remoteFile);
            if (in == null) {
                throw new JobSchedulerException("Could not open stream for " + remoteFile + ". Perhaps the file does not exist. Reply from ftp server: " + this.getReplyString());
            }
            if (!this.isPositiveCommandCompletion()) {
                throw new JobSchedulerException("..error occurred in getFile() [retrieveFileStream] on the FTP server for file [" + remoteFile + "]: " + this.getReplyString());
            }
            byte[] buffer = new byte[4096];
            out = new FileOutputStream(new File(localFile), append);
            int bytes_read = 0;
            SOSFTP sOSFTP = this;
            synchronized (sOSFTP) {
                while ((bytes_read = in.read(buffer)) != -1) {
                    out.write(buffer, 0, bytes_read);
                    out.flush();
                    totalBytes += (long)bytes_read;
                }
            }
            in.close();
            out.close();
            if (!this.completePendingCommand()) {
                this.logout();
                this.disconnect();
                throw new JobSchedulerException("File transfer failed.");
            }
            if (this.isNegativeCommandCompletion()) {
                throw new JobSchedulerException("..error occurred in getFile() on the FTP server for file [" + remoteFile + "]: " + this.getReplyString());
            }
            if (totalBytes > 0L) {
                long l = totalBytes;
                return l;
            }
            long l = -1L;
            return l;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (out != null) {
                    out.flush();
                }
            }
            catch (Exception exception) {}
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public boolean put(String localFile, String remoteFile) throws Exception {
        FileInputStream in = null;
        boolean rc = false;
        try {
            in = new FileInputStream(localFile);
            boolean bl = rc = this.storeFile(remoteFile, in);
            return bl;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public long putFile(String localFile, String remoteFile) throws Exception {
        OutputStream outputStream = this.storeFileStream(remoteFile);
        if (this.isNegativeCommandCompletion()) {
            throw new JobSchedulerException("..error occurred in storeFileStream() on the FTP server for file [" + remoteFile + "]: " + this.getReplyString());
        }
        return this.putFile(localFile, outputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long putFile(String localFile, OutputStream out) throws Exception {
        FileInputStream in = null;
        long totalBytes = 0L;
        try {
            if (out == null) {
                throw new JobSchedulerException("output stream has null value.");
            }
            byte[] buffer = new byte[4096];
            in = new FileInputStream(new File(localFile));
            SOSFTP sOSFTP = this;
            synchronized (sOSFTP) {
                int bytesWritten;
                while ((bytesWritten = in.read(buffer)) != -1) {
                    out.write(buffer, 0, bytesWritten);
                    totalBytes += (long)bytesWritten;
                }
            }
            in.close();
            out.close();
            if (!this.completePendingCommand()) {
                this.logout();
                this.disconnect();
                throw new JobSchedulerException("File transfer failed.");
            }
            if (this.isNegativeCommandCompletion()) {
                throw new JobSchedulerException("..error occurred in putFile() on the FTP server for file [" + localFile + "]: " + this.getReplyString());
            }
            long l = totalBytes;
            return l;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
            try {
                out.flush();
            }
            catch (Exception exception) {}
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public long appendFile(String localFile, String remoteFile) throws Exception {
        return this.putFile(localFile, this.appendFileStream(remoteFile));
    }

    public boolean ascii() throws IOException {
        return this.setFileType(0);
    }

    public boolean binary() throws IOException {
        return this.setFileType(2);
    }

    public int cd(String directory) throws IOException {
        return this.cwd(directory);
    }

    @Override
    public boolean delete(String pathname) throws IOException {
        return this.deleteFile(pathname);
    }

    public boolean login(String strUserName, String strPassword) {
        try {
            super.login(strUserName, strPassword);
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        this.logReply();
        return true;
    }

    protected void raiseException(Exception e, String pstrM) {
        if (e != null) {
            LOGGER.error(pstrM, (Throwable)e);
            throw new JobSchedulerException(pstrM, (Throwable)e);
        }
        LOGGER.error(pstrM);
        throw new JobSchedulerException(pstrM);
    }

    protected void raiseException(String pstrM, Exception e) {
        this.raiseException(e, pstrM);
    }

    protected void raiseException(String pstrM) {
        this.raiseException(null, pstrM);
    }
}

