/*
 * Decompiled with CFR 0.152.
 */
package sos.net;

import com.sos.JSHelper.Exceptions.JobSchedulerException;
import java.util.Properties;
import javax.mail.Authenticator;
import javax.mail.Folder;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Store;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.net.SOSMailAuthenticator;

public class SOSMailReceiver {
    protected SOSMailAuthenticator authenticator = null;
    protected int timeout = 5000;
    private static final Logger LOGGER = LoggerFactory.getLogger(SOSMailReceiver.class);
    private Store store;
    private Folder folder = null;
    private String protocol = "POP3";
    private String folderName = "INBOX";
    private final String host;
    private final String port;
    private final String user;
    private Session session;
    private boolean ssl;
    private final String password;
    public int READ_ONLY = 1;
    public int READ_WRITE = 2;

    public SOSMailReceiver(String host, String port, String user, String password, boolean ssl, String protocol) throws Exception {
        this.host = host;
        this.port = port;
        this.user = user;
        this.password = password;
        this.protocol = protocol;
        this.ssl = ssl;
        this.createSession();
    }

    public SOSMailReceiver(String host, String port, String user, String password) throws Exception {
        this.host = host;
        this.port = port;
        this.user = user;
        this.password = password;
        this.protocol = "POP3";
        this.ssl = false;
        this.createSession();
    }

    public Session createSession() throws Exception {
        Properties props = System.getProperties();
        if ("imap".equalsIgnoreCase(this.protocol)) {
            props.put("mail.imap.host", this.host);
            props.put("mail.imap.port", this.port);
            if (this.ssl) {
                props.put("mail.imap.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
                props.setProperty("mail.imap.socketFactory.fallback", "false");
                props.setProperty("mail.imap.ssl.trust", this.host);
                props.setProperty("mail.imap.socketFactory.port", this.port);
            }
        } else if ("pop3".equalsIgnoreCase(this.protocol)) {
            props.put("mail.host", this.host);
            props.put("mail.port", this.port);
            props.put("mail.pop3.host", this.host);
            props.put("mail.pop3.port", this.port);
            if (this.ssl) {
                props.setProperty("mail.pop3.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
                props.setProperty("mail.pop3.socketFactory.fallback", "false");
                props.setProperty("mail.pop3.ssl.trust", this.host);
                props.setProperty("mail.pop3.socketFactory.port", this.port);
            }
        } else {
            LOGGER.warn("unknown protocol: " + this.protocol);
        }
        this.authenticator = new SOSMailAuthenticator(this.user, this.password);
        this.session = Session.getInstance((Properties)props, (Authenticator)this.authenticator);
        return this.session;
    }

    public void connect(String mailProtocolName) throws Exception {
        mailProtocolName = mailProtocolName.toLowerCase();
        this.session.getProperties().put("mail." + mailProtocolName + ".timeout", String.valueOf(this.timeout));
        this.store = this.session.getStore(mailProtocolName);
        this.store.connect(this.host, this.user, this.password);
        LOGGER.debug("..connected to host [" + this.host + ":" + this.port + "] successfully done.");
    }

    public Folder openFolder(String folderName1, int mode) throws Exception {
        this.folder = this.store.getFolder(folderName1);
        if (this.folder == null) {
            throw new JobSchedulerException("An error occured opening [" + folderName1 + "]");
        }
        this.folder.open(mode);
        this.folderName = folderName1;
        return this.folder;
    }

    public Folder openFolder(int mode) throws Exception {
        this.folder = this.store.getDefaultFolder();
        if (this.folder == null) {
            throw new JobSchedulerException("An error occured opening default folder");
        }
        this.folderName = this.folder.getName();
        this.folder.open(mode);
        return this.folder;
    }

    public void closeFolder(boolean expunge) throws MessagingException {
        if (this.folder != null && this.folder.isOpen()) {
            this.folder.close(expunge);
            this.folder = null;
        }
    }

    public void disconnect() throws MessagingException {
        if (this.store != null) {
            this.store.close();
            this.store = null;
        }
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getFolderName() {
        return this.folderName;
    }

    public void setFolderName(String folderName) {
        this.folderName = folderName;
    }

    public Session getSession() {
        return this.session;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }
}

