/*
 * Decompiled with CFR 0.152.
 */
package com.sos.js7.job;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.sos.commons.util.SOSDate;
import com.sos.commons.util.SOSReflection;
import com.sos.commons.util.SOSString;
import com.sos.js7.job.JobArgument;
import com.sos.js7.job.JobArguments;
import com.sos.js7.job.OrderProcessStepOutcomeVariable;
import com.sos.js7.job.exception.JobProblemException;
import io.vavr.control.Either;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import js7.base.problem.Problem;
import js7.data.value.BooleanValue;
import js7.data.value.ListValue;
import js7.data.value.NumberValue;
import js7.data.value.ObjectValue;
import js7.data.value.StringValue;
import js7.data.value.Value;

public class JobHelper {
    public static ObjectMapper OBJECT_MAPPER = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(DeserializationFeature.FAIL_ON_READING_DUP_TREE_KEY, true).configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false).configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, false);
    public static final String NAMED_NAME_RETURN_CODE = "returnCode";
    public static final Integer DEFAULT_RETURN_CODE_SUCCEEDED = 0;
    public static final Integer DEFAULT_RETURN_CODE_FAILED = 99;
    public static final String VAR_NAME_CONTROLLER_ID = "js7ControllerId";
    public static final String VAR_NAME_ORDER_ID = "js7OrderId";
    public static final String VAR_NAME_WORKFLOW_PATH = "js7WorkflowPath";
    public static final String VAR_NAME_WORKFLOW_POSITION = "js7WorkflowPosition";
    public static final String VAR_NAME_JOB_INSTRUCTION_LABEL = "js7Label";
    public static final String VAR_NAME_JOB_NAME = "js7JobName";
    public static final String ENV_NAME_AGENT_HOME = "JS7_AGENT_HOME";
    public static final String ENV_NAME_AGENT_CONFIG_DIR = "JS7_AGENT_CONFIG_DIR";
    public static final String ENV_NAME_AGENT_WORK_DIR = "JS7_AGENT_WORK_DIR";
    public static final String ENV_NAME_AGENT_LIB_DIR = "JS7_AGENT_LIBDIR";

    public static Path getAgentHome() {
        return JobHelper.getPath(System.getenv(ENV_NAME_AGENT_HOME));
    }

    public static Path getAgentConfigDir() {
        return JobHelper.getPath(System.getenv(ENV_NAME_AGENT_CONFIG_DIR));
    }

    public static Path getAgentWorkDir() {
        return JobHelper.getPath(System.getenv(ENV_NAME_AGENT_WORK_DIR));
    }

    public static Path getAgentLibDir() {
        return JobHelper.getPath(System.getenv(ENV_NAME_AGENT_LIB_DIR));
    }

    public static Path getAgentPrivateConfFile() {
        return JobHelper.getAgentConfigDir().resolve("private").resolve("private.conf").normalize();
    }

    public static Path getAgentHibernateFile() {
        return JobHelper.getAgentConfigDir().resolve("hibernate.cfg.xml").normalize();
    }

    public static Map<String, Object> asJavaValues(Map<String, Value> map) {
        if (map == null || map.size() == 0) {
            return Collections.emptyMap();
        }
        return map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> JobHelper.asJavaValue((Value)e.getValue())));
    }

    public static Object asJavaValue(Value o) {
        if (o == null) {
            return null;
        }
        if (o instanceof StringValue) {
            return o.convertToString();
        }
        if (o instanceof NumberValue) {
            return ((NumberValue)o).toJava();
        }
        if (o instanceof BooleanValue) {
            return Boolean.parseBoolean(o.convertToString());
        }
        if (o instanceof ListValue) {
            ArrayList l = new ArrayList();
            ((ListValue)o).toJava().forEach(item -> {
                if (item instanceof ObjectValue) {
                    LinkedHashMap m = new LinkedHashMap();
                    ((ObjectValue)item).toJava().forEach((k1, v1) -> m.put(k1, v1.toJava()));
                    l.add(m);
                } else {
                    l.add(item.toJava());
                }
            });
            return l;
        }
        if (o instanceof ObjectValue) {
            LinkedHashMap m = new LinkedHashMap();
            ((ObjectValue)o).toJava().forEach((k1, v1) -> m.put(k1, v1.toJava()));
            return m;
        }
        return o;
    }

    public static Map<String, Value> asEngineValues(Map<String, Object> map) {
        HashMap<String, Value> result = new HashMap<String, Value>();
        if (map == null || map.size() == 0) {
            return result;
        }
        map.entrySet().forEach(e -> result.put((String)e.getKey(), JobHelper.asEngineValue(e.getValue())));
        return result;
    }

    private static Value asEngineValue(Object o) {
        if (o == null) {
            return StringValue.of((String)"");
        }
        if (o instanceof Value) {
            return (Value)o;
        }
        if (o instanceof String) {
            return StringValue.of((String)((String)o));
        }
        if (o instanceof Boolean) {
            return BooleanValue.of((boolean)((Boolean)o));
        }
        if (o instanceof Integer) {
            return NumberValue.of((Integer)((Integer)o));
        }
        if (o instanceof Long) {
            return NumberValue.of((long)((Long)o));
        }
        if (o instanceof Double) {
            return NumberValue.of((BigDecimal)BigDecimal.valueOf((Double)o));
        }
        if (o instanceof BigDecimal) {
            return NumberValue.of((BigDecimal)((BigDecimal)o));
        }
        if (o instanceof Date) {
            return JobHelper.getDateAsStringValue((Date)o);
        }
        if (SOSReflection.isList(o.getClass())) {
            List l = (List)o;
            String s = l.stream().map(e -> e.toString()).collect(Collectors.joining(";"));
            return StringValue.of((String)s);
        }
        return StringValue.of((String)o.toString());
    }

    public static Map<String, Object> asNameValueMap(Map<String, JobArgument<?>> map) {
        if (map == null || map.size() == 0) {
            return Collections.emptyMap();
        }
        return map.entrySet().stream().filter(a -> ((JobArgument)((Object)((Object)a.getValue()))).getValue() != null).collect(Collectors.toMap(a -> (String)a.getKey(), a -> ((JobArgument)((Object)((Object)a.getValue()))).getValue()));
    }

    private static Map<String, Object> asNameValueMap(JobArguments o) {
        List<Field> fields = JobHelper.getJobArgumentFields(o);
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Field field : fields) {
            try {
                field.setAccessible(true);
                JobArgument arg = (JobArgument)((Object)field.get(o));
                if (arg == null || arg.getName() == null) continue;
                if (arg.getValue() == null || SOSString.isEmpty((String)arg.getValue().toString())) {
                    map.put(arg.getName(), arg.getDefaultValue());
                    continue;
                }
                map.put(arg.getName(), arg.getValue());
            }
            catch (Throwable throwable) {}
        }
        return map;
    }

    public static List<Field> getJobArgumentFields(JobArguments o) {
        return SOSReflection.getAllDeclaredFields(o.getClass()).stream().filter(f -> f.getType().equals(JobArgument.class)).collect(Collectors.toList());
    }

    private static List<Field> getOrderProcessStepOutcomeVariableFields(JobArguments o) {
        return SOSReflection.getAllDeclaredFields(o.getClass()).stream().filter(f -> f.getType().equals(OrderProcessStepOutcomeVariable.class)).collect(Collectors.toList());
    }

    public static <T> T getFromEither(Either<Problem, T> either) throws JobProblemException {
        if (either.isLeft()) {
            throw new JobProblemException((Problem)either.getLeft());
        }
        return (T)either.get();
    }

    private static Path getPath(String val) {
        return Paths.get(val == null ? "." : val, new String[0]);
    }

    private static Value getDateAsStringValue(Date date) {
        try {
            return StringValue.of((String)SOSDate.getDateTimeAsString((Date)date));
        }
        catch (Throwable e) {
            return StringValue.of((String)(date == null ? "" : date.toString()));
        }
    }
}

