/*
 * Decompiled with CFR 0.152.
 */
package com.sos.js7.job.resolver;

import com.sos.commons.util.SOSReflection;
import com.sos.js7.job.JobArgument;
import com.sos.js7.job.JobHelper;
import com.sos.js7.job.OrderProcessStepLogger;
import com.sos.js7.job.resolver.IJobArgumentValueResolver;
import com.sos.js7.job.resolver.StandardBase64Resolver;
import com.sos.js7.job.resolver.StandardEncryptionResolver;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobArgumentValueResolverCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(JobArgumentValueResolverCache.class);
    private static Map<String, Method> METHOD_CACHE = new LinkedHashMap<String, Method>();
    private static final String CUSTOM_RESOLVERS_DIR = "user_lib";
    private static final String CUSTOM_RESOLVERS_JAR_NAME_PATTERN = "(?i)^jobapi-register-.*\\.jar$";

    public static void initialize() {
    }

    private static void cacheStandardResolvers() throws Exception {
        JobArgumentValueResolverCache.cacheResolver(StandardBase64Resolver.class);
        JobArgumentValueResolverCache.cacheResolver(StandardEncryptionResolver.class);
    }

    private static void cacheCustomResolvers() {
        Path dir = JobHelper.getAgentLibDir();
        if (dir == null) {
            return;
        }
        dir = dir.resolve(CUSTOM_RESOLVERS_DIR);
        LOGGER.info("[check custom resolvers dir]" + dir);
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir, (DirectoryStream.Filter<? super Path>)new DirectoryStream.Filter<Path>(){

            @Override
            public boolean accept(Path entry) throws IOException {
                String fileName = entry.getFileName().toString();
                return fileName.matches(JobArgumentValueResolverCache.CUSTOM_RESOLVERS_JAR_NAME_PATTERN);
            }
        });){
            for (Path jar : stream) {
                List classes = SOSReflection.findClassesInJarFile((Path)jar, IJobArgumentValueResolver.class);
                for (Class clazz : classes) {
                    try {
                        JobArgumentValueResolverCache.cacheResolver(clazz);
                    }
                    catch (Throwable e) {
                        LOGGER.error("[" + jar + "][" + clazz + "]" + e.toString(), e);
                    }
                }
            }
        }
        catch (NoSuchFileException e) {
            LOGGER.warn("[" + dir.toAbsolutePath() + "]" + e.toString());
        }
        catch (Throwable e) {
            LOGGER.error("[" + dir.toAbsolutePath() + "]" + e.toString(), e);
        }
    }

    private static void cacheResolver(Class<?> clazz) throws Exception {
        Method getPrefixMethod = clazz.getMethod("getPrefix", new Class[0]);
        if (!getPrefixMethod.getReturnType().equals(String.class)) {
            throw new IllegalArgumentException(clazz + " does not have a valid 'public static String getPrefix()' method");
        }
        Method resolveMethod = clazz.getMethod("resolve", OrderProcessStepLogger.class, List.class, Map.class);
        String prefix = (String)getPrefixMethod.invoke(null, new Object[0]);
        METHOD_CACHE.put(prefix, resolveMethod);
        LOGGER.info("[cached][" + prefix + "]" + clazz.getName());
    }

    private static void checkAssignableFrom(Class<?> clazz) throws Exception {
        if (!IJobArgumentValueResolver.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException(clazz + " does not implement " + IJobArgumentValueResolver.class.getName() + " interface");
        }
    }

    public static Method getResolveMethod(String prefix) {
        return METHOD_CACHE.get(prefix);
    }

    public static String getResolverClassName(String prefix) {
        Method m = JobArgumentValueResolverCache.getResolveMethod(prefix);
        if (m == null) {
            return "unknown";
        }
        return m.getDeclaringClass().getName();
    }

    public static List<String> getResolverPrefixes() {
        return METHOD_CACHE.entrySet().stream().map(e -> (String)e.getKey()).collect(Collectors.toList());
    }

    public static void resolve(String prefix, OrderProcessStepLogger logger, List<JobArgument<?>> argumentsToResolve, Map<String, JobArgument<?>> allArguments) throws Exception {
        METHOD_CACHE.get(prefix).invoke(null, logger, argumentsToResolve, allArguments);
    }

    static {
        LOGGER.info("start...");
        try {
            JobArgumentValueResolverCache.cacheStandardResolvers();
            JobArgumentValueResolverCache.cacheCustomResolvers();
        }
        catch (Throwable e) {
            LOGGER.error(e.toString(), e);
        }
        LOGGER.info("end");
    }
}

