/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.hibernate;

import com.sos.commons.hibernate.SOSHibernateFactory;
import java.sql.DatabaseMetaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SOSHibernateDatabaseMetaData {
    private static final Logger LOGGER = LoggerFactory.getLogger(SOSHibernateDatabaseMetaData.class);
    private static final int MAX_SET_RETRY = 5;
    private static final int ORACLE_MIN_VERSION_SUPPORT_JSON_RETURNING_CLOB = 18;
    private final SOSHibernateFactory.Dbms dbms;
    private String productName;
    private String productVersion;
    private int majorVersion;
    private int minorVersion;
    private boolean supportJsonReturningClob;
    private boolean isSet;
    private int setRetryCounter;

    protected SOSHibernateDatabaseMetaData(SOSHibernateFactory.Dbms dbms) {
        this.dbms = dbms == null ? SOSHibernateFactory.Dbms.UNKNOWN : dbms;
        this.setRetryCounter = 0;
        this.setSupportJsonReturningClob();
    }

    protected void set(DatabaseMetaData metaData) {
        if (this.isSet) {
            return;
        }
        if (metaData == null) {
            ++this.setRetryCounter;
            if (this.setRetryCounter >= 5) {
                this.isSet = true;
            }
            return;
        }
        this.doSet(metaData);
    }

    private void doSet(DatabaseMetaData metaData) {
        this.isSet = true;
        try {
            this.productName = metaData.getDatabaseProductName();
            this.productVersion = metaData.getDatabaseProductVersion();
            this.majorVersion = metaData.getDatabaseMajorVersion();
            this.minorVersion = metaData.getDatabaseMinorVersion();
        }
        catch (Throwable e) {
            LOGGER.warn(String.format("[doSet]%s", e.toString()), e);
        }
        this.setSupportJsonReturningClob();
    }

    private void setSupportJsonReturningClob() {
        this.supportJsonReturningClob = true;
        if (this.dbms.equals((Object)SOSHibernateFactory.Dbms.ORACLE)) {
            this.supportJsonReturningClob = false;
            if (this.majorVersion >= 18) {
                this.supportJsonReturningClob = true;
            }
        }
    }

    public SOSHibernateFactory.Dbms getDbms() {
        return this.dbms;
    }

    public String getProductName() {
        return this.productName;
    }

    public String getProductVersion() {
        return this.productVersion;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public boolean supportJsonReturningClob() {
        return this.supportJsonReturningClob;
    }

    protected boolean isSet() {
        return this.isSet;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("majorVersion=").append(this.majorVersion);
        sb.append(",minorVersion=").append(this.minorVersion);
        sb.append(",productName=").append(this.productName);
        sb.append(",productVersion=").append(this.productVersion);
        sb.append(",supportJsonReturningClob=").append(this.supportJsonReturningClob);
        return sb.toString();
    }
}

