/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.hibernate;

import com.sos.commons.hibernate.SOSHibernate;
import com.sos.commons.hibernate.SOSHibernateDatabaseMetaData;
import com.sos.commons.hibernate.SOSHibernateSession;
import com.sos.commons.hibernate.configuration.SOSHibernateConfigurationResolver;
import com.sos.commons.hibernate.exception.SOSHibernateConfigurationException;
import com.sos.commons.hibernate.exception.SOSHibernateFactoryBuildException;
import com.sos.commons.hibernate.exception.SOSHibernateOpenSessionException;
import com.sos.commons.hibernate.function.date.SOSHibernateSecondsDiff;
import com.sos.commons.hibernate.function.json.SOSHibernateJsonValue;
import com.sos.commons.hibernate.function.regex.SOSHibernateRegexp;
import com.sos.commons.hibernate.type.SOSHibernateJsonType;
import com.sos.commons.util.SOSClassList;
import com.sos.commons.util.SOSClassUtil;
import com.sos.commons.util.SOSReflection;
import com.sos.commons.util.SOSString;
import jakarta.persistence.PersistenceException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.hibernate.SessionFactory;
import org.hibernate.annotations.ColumnTransformer;
import org.hibernate.annotations.Type;
import org.hibernate.cfg.Configuration;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.query.sqm.function.SqmFunctionDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SOSHibernateFactory
implements Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(SOSHibernateFactory.class);
    private static final Logger CONNECTION_POOL_LOGGER = LoggerFactory.getLogger((String)"ConnectionPool");
    private static final long serialVersionUID = 1L;
    private SOSHibernateDatabaseMetaData databaseMetaData;
    private SOSClassList classMapping;
    private Configuration configuration;
    private SessionFactory sessionFactory;
    private Dialect dialect;
    private SOSHibernateConfigurationResolver configurationResolver;
    private Properties configurationProperties;
    private Properties defaultConfigurationProperties;
    private Dbms dbms = Dbms.UNKNOWN;
    private Optional<Path> configFile = Optional.empty();
    private String identifier;
    private String logIdentifier;
    private String currentTimestampSelectString;
    private String currentUTCTimestampSelectString;
    private boolean useDefaultConfigurationProperties = true;
    private boolean readDatabaseMetaData;

    public SOSHibernateFactory() {
        this(SOSHibernateFactory.asPath(null));
    }

    public SOSHibernateFactory(String hibernateConfigFile) {
        this(SOSHibernateFactory.asPath(hibernateConfigFile));
    }

    public SOSHibernateFactory(Path hibernateConfigFile) {
        this.setIdentifier(null);
        this.setConfigFile(hibernateConfigFile);
        this.initClassMapping();
        this.initConfiguration();
    }

    private void initConfiguration() {
        this.defaultConfigurationProperties = new Properties();
        this.defaultConfigurationProperties.put("hibernate.connection.isolation", String.valueOf(2));
        this.defaultConfigurationProperties.put("hibernate.connection.autocommit", "false");
        this.defaultConfigurationProperties.put("hibernate.boot.allow_jdbc_metadata_access", "false");
        this.defaultConfigurationProperties.put("hibernate.jdbc.use_scrollable_resultset", "true");
        this.defaultConfigurationProperties.put("hibernate.current_session_context_class", "jta");
        this.defaultConfigurationProperties.put("jakarta.persistence.validation.mode", "none");
        this.defaultConfigurationProperties.put("hibernate.id.db_structure_naming_strategy", "legacy");
        this.defaultConfigurationProperties.put("hibernate.jpa.compliance.global_id_generators", "false");
        this.configurationProperties = new Properties();
        this.configurationResolver = new SOSHibernateConfigurationResolver();
    }

    public void build() throws SOSHibernateFactoryBuildException {
        this.build(false);
    }

    public void build(boolean readDatabaseMetaData) throws SOSHibernateFactoryBuildException {
        try {
            this.readDatabaseMetaData = readDatabaseMetaData;
            this.createConfiguration();
            this.adjustConfiguration(this.configuration);
            this.showConfigurationProperties();
            this.configurationResolver = null;
            this.adjustAnnotations(this.dbms);
            this.buildSessionFactory();
            if (LOGGER.isDebugEnabled()) {
                String method = SOSHibernate.getMethodName(this.logIdentifier, "build");
                int isolationLevel = this.getTransactionIsolation();
                LOGGER.debug(String.format("%s autoCommit=%s, transactionIsolation=%s", method, this.getAutoCommit(), SOSHibernateFactory.getTransactionIsolationName(isolationLevel)));
            }
        }
        catch (SOSHibernateConfigurationException ex) {
            throw new SOSHibernateFactoryBuildException(ex, this.configFile);
        }
        catch (PersistenceException ex) {
            throw new SOSHibernateFactoryBuildException(ex);
        }
    }

    public void close(SOSHibernateSession session) {
        if (session != null) {
            session.close();
        }
        this.close();
    }

    public void close() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(SOSHibernate.getMethodName(this.logIdentifier, "close"));
        }
        try {
            if (this.sessionFactory != null && !this.sessionFactory.isClosed()) {
                this.sessionFactory.close();
            }
        }
        catch (Throwable e) {
            LOGGER.warn(e.toString(), e);
        }
        this.sessionFactory = null;
    }

    public SOSHibernateSession openSession() throws SOSHibernateOpenSessionException {
        return this.openSession(this.identifier);
    }

    public SOSHibernateSession openSession(String identifier) throws SOSHibernateOpenSessionException {
        SOSHibernateSession session = new SOSHibernateSession(this);
        session.setIdentifier(identifier);
        session.openSession();
        return session;
    }

    public SOSHibernateSession openStatelessSession() throws SOSHibernateOpenSessionException {
        return this.openStatelessSession(this.identifier);
    }

    public SOSHibernateSession openStatelessSession(String identifier) throws SOSHibernateOpenSessionException {
        SOSHibernateSession session = new SOSHibernateSession(this);
        session.setIsStatelessSession(true);
        session.setIdentifier(identifier);
        session.openSession();
        if (CONNECTION_POOL_LOGGER.isDebugEnabled()) {
            CONNECTION_POOL_LOGGER.debug("--------> GET CONNECTION: " + session.getIdentifier() + " (" + SOSClassUtil.getMethodName((int)3) + ") --------");
        }
        return session;
    }

    public SOSHibernateSession getCurrentSession() throws SOSHibernateOpenSessionException {
        return this.getCurrentSession(this.identifier);
    }

    public SOSHibernateSession getCurrentSession(String identifier) throws SOSHibernateOpenSessionException {
        SOSHibernateSession session = new SOSHibernateSession(this);
        session.setIsGetCurrentSession(true);
        session.setIdentifier(identifier);
        session.openSession();
        return session;
    }

    public boolean getAutoCommit() throws SOSHibernateConfigurationException {
        if (this.configuration == null) {
            throw new SOSHibernateConfigurationException("configuration is NULL");
        }
        String p = this.configuration.getProperty("hibernate.connection.autocommit");
        if (SOSString.isEmpty((String)p)) {
            throw new SOSHibernateConfigurationException(String.format("\"%s\" property is not configured ", "hibernate.connection.autocommit"));
        }
        return Boolean.parseBoolean(p);
    }

    public String getSequenceLastValString(String sequenceName) {
        switch (this.dbms) {
            case MSSQL: {
                return "SELECT @@IDENTITY";
            }
            case MYSQL: {
                return "SELECT LAST_INSERT_ID();";
            }
            case ORACLE: {
                return "SELECT " + sequenceName + ".currval FROM DUAL";
            }
            case PGSQL: {
                return "SELECT currval('" + sequenceName + "');";
            }
            case H2: {
                return "SELECT LAST_INSERT_ID();";
            }
        }
        return null;
    }

    public String getCurrentTimestampSelectString() {
        if (this.currentTimestampSelectString == null) {
            switch (this.dbms) {
                case H2: {
                    this.currentTimestampSelectString = "select now()";
                    break;
                }
                case ORACLE: {
                    this.currentTimestampSelectString = "select sysdate from dual";
                    break;
                }
                default: {
                    this.currentTimestampSelectString = this.dialect.getCurrentTimestampSelectString();
                }
            }
        }
        return this.currentTimestampSelectString;
    }

    public String getCurrentUTCTimestampSelectString() {
        if (this.currentUTCTimestampSelectString == null) {
            switch (this.dbms) {
                case H2: {
                    this.currentUTCTimestampSelectString = "select now()";
                    break;
                }
                case MYSQL: {
                    this.currentUTCTimestampSelectString = "select utc_timestamp()";
                    break;
                }
                case ORACLE: {
                    this.currentUTCTimestampSelectString = "select cast(sys_extract_utc(systimestamp) as date) from dual";
                    break;
                }
                case MSSQL: {
                    this.currentUTCTimestampSelectString = "select getutcdate()";
                    break;
                }
                case PGSQL: {
                    this.currentUTCTimestampSelectString = "select timezone('UTC', now())";
                    break;
                }
                default: {
                    this.currentUTCTimestampSelectString = this.getCurrentTimestampSelectString();
                }
            }
        }
        return this.currentUTCTimestampSelectString;
    }

    public int getTransactionIsolation() throws SOSHibernateConfigurationException {
        if (this.configuration == null) {
            throw new SOSHibernateConfigurationException("configuration is NULL");
        }
        String p = this.configuration.getProperty("hibernate.connection.isolation");
        if (SOSString.isEmpty((String)p)) {
            throw new SOSHibernateConfigurationException(String.format("\"%s\" property is not configured ", "hibernate.connection.isolation"));
        }
        return Integer.parseInt(p);
    }

    public boolean isUseDefaultConfigurationProperties() {
        return this.useDefaultConfigurationProperties;
    }

    public String quoteColumn(String columnName) {
        return SOSHibernate.quoteColumn(this.dialect, columnName);
    }

    public void setAutoCommit(boolean commit) {
        this.configurationProperties.put("hibernate.connection.autocommit", String.valueOf(commit));
    }

    public void setConfigFile(Path hibernateConfigFile) {
        if (hibernateConfigFile != null) {
            this.configFile = Optional.of(hibernateConfigFile);
        }
    }

    public void setConfigFile(String hibernateConfigFile) {
        this.setConfigFile(SOSHibernateFactory.asPath(hibernateConfigFile));
    }

    private static Path asPath(String hibernateConfigFile) {
        return hibernateConfigFile == null ? null : Paths.get(hibernateConfigFile, new String[0]);
    }

    public void setConfigurationProperties(Properties properties) {
        if (this.configurationProperties.isEmpty()) {
            this.configurationProperties = properties;
        } else if (properties != null) {
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                this.configurationProperties.setProperty(key, value);
            }
        }
    }

    private void configure() throws SOSHibernateConfigurationException {
        try {
            this.addSQLFunctions();
            if (this.configFile.isPresent()) {
                Path cf = this.configFile.get();
                if (!Files.exists(cf, new LinkOption[0])) {
                    throw new SOSHibernateConfigurationException(String.format("hibernate config file not found: %s", cf.toString()));
                }
                this.configuration.configure(cf.toUri().toURL());
            }
            if (LOGGER.isDebugEnabled()) {
                String method = SOSHibernate.getMethodName(this.logIdentifier, "configure");
                if (this.configFile.isPresent()) {
                    LOGGER.debug(String.format("%s %s", method, this.configFile.get().toAbsolutePath().toString()));
                } else {
                    LOGGER.debug(String.format("%s configure connection without the hibernate file", method));
                }
            }
            this.mapConfigurationProperties();
            this.setDbms(this.configuration.getProperties().getProperty("hibernate.dialect"));
            this.databaseMetaData = new SOSHibernateDatabaseMetaData(this.dbms);
            this.mapDialect(this.dbms);
        }
        catch (MalformedURLException e) {
            throw new SOSHibernateConfigurationException(String.format("exception on get configFile %s as url", this.configFile), e);
        }
        catch (PersistenceException e) {
            throw new SOSHibernateConfigurationException(e);
        }
    }

    private void addSQLFunctions() {
        if (this.configuration != null) {
            this.configuration.addSqlFunction("SOS_JSON_VALUE", (SqmFunctionDescriptor)new SOSHibernateJsonValue(this));
            this.configuration.addSqlFunction("SOS_REGEXP", (SqmFunctionDescriptor)new SOSHibernateRegexp(this));
            this.configuration.addSqlFunction("SOS_SECONDSDIFF", (SqmFunctionDescriptor)new SOSHibernateSecondsDiff(this));
        }
    }

    private void mapConfigurationProperties() {
        this.mapDeprecatedConfigurationProperty("hibernate.connection.driver_class", "jakarta.persistence.jdbc.driver");
        this.mapDeprecatedConfigurationProperty("hibernate.connection.url", "jakarta.persistence.jdbc.url");
        this.mapDeprecatedConfigurationProperty("hibernate.connection.username", "jakarta.persistence.jdbc.user");
        this.mapDeprecatedConfigurationProperty("hibernate.connection.password", "jakarta.persistence.jdbc.password");
    }

    private void mapDeprecatedConfigurationProperty(String deprecatedName, String newName) {
        String val = this.configuration.getProperties().getProperty(deprecatedName);
        if (val != null) {
            this.configuration.getProperties().setProperty(newName, val);
            this.configuration.getProperties().remove(deprecatedName);
        }
    }

    private void mapDialect(Dbms dbms) {
        String dialect;
        if (this.configuration != null && (dialect = this.configuration.getProperties().getProperty("hibernate.dialect")) != null) {
            switch (dbms) {
                case MYSQL: {
                    if (dialect.equals("org.hibernate.dialect.MySQL8Dialect")) break;
                    this.configuration.getProperties().setProperty("hibernate.dialect", SOSHibernate.DEFAULT_DIALECT_MYSQL);
                    break;
                }
                case ORACLE: {
                    this.configuration.getProperties().setProperty("hibernate.dialect", SOSHibernate.DEFAULT_DIALECT_ORACLE);
                    break;
                }
                case PGSQL: {
                    this.configuration.getProperties().setProperty("hibernate.dialect", SOSHibernate.DEFAULT_DIALECT_PGSQL);
                    break;
                }
                case MSSQL: {
                    if (Arrays.asList("org.hibernate.dialect.SQLServer2012Dialect", "org.hibernate.dialect.SQLServer2016Dialect").contains(dialect)) break;
                    this.configuration.getProperties().setProperty("hibernate.dialect", SOSHibernate.DEFAULT_DIALECT_MSSQL);
                    break;
                }
                case H2: {
                    this.configuration.getProperties().setProperty("hibernate.dialect", SOSHibernate.DEFAULT_DIALECT_H2);
                    break;
                }
            }
        }
    }

    public static Dbms getDbms(Path configFile) throws SOSHibernateConfigurationException {
        String dialect = null;
        try {
            Configuration conf = new Configuration();
            conf.configure(configFile.toUri().toURL());
            dialect = conf.getProperties().getProperty("hibernate.dialect");
        }
        catch (MalformedURLException e) {
            throw new SOSHibernateConfigurationException(String.format("exception on get configFile %s as url", configFile), e);
        }
        catch (PersistenceException e) {
            throw new SOSHibernateConfigurationException(e);
        }
        return SOSHibernateFactory.getDbms(dialect);
    }

    public static Dbms getDbms(Dialect dialect) {
        return SOSHibernateFactory.getDbms(dialect == null ? null : dialect.getClass().getSimpleName());
    }

    public static Dbms getDbms(String dialect) {
        Dbms dbms = Dbms.UNKNOWN;
        if (dialect != null) {
            String dialectClassName = dialect.toLowerCase();
            if (dialectClassName.contains("h2")) {
                dbms = Dbms.H2;
            } else if (dialectClassName.contains("sqlserver")) {
                dbms = Dbms.MSSQL;
            } else if (dialectClassName.contains("mysql") || dialectClassName.contains("mariadb")) {
                dbms = Dbms.MYSQL;
            } else if (dialectClassName.contains("oracle")) {
                dbms = Dbms.ORACLE;
            } else if (dialectClassName.contains("postgre")) {
                dbms = Dbms.PGSQL;
            }
        }
        return dbms;
    }

    private void initClassMapping() {
        this.classMapping = new SOSClassList();
    }

    private void createConfiguration() throws SOSHibernateConfigurationException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(SOSHibernate.getMethodName(this.logIdentifier, "createConfiguration"));
        }
        this.configuration = new Configuration();
        this.setConfigurationClassMapping();
        this.setDefaultConfigurationProperties();
        this.configure();
        this.setConfigurationProperties();
        this.configuration = this.configurationResolver.resolve(this.configuration);
    }

    private void buildSessionFactory() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(SOSHibernate.getMethodName(this.logIdentifier, "buildSessionFactory"));
        }
        this.sessionFactory = this.configuration.buildSessionFactory();
        this.dialect = ((SessionFactoryImplementor)this.sessionFactory).getJdbcServices().getDialect();
        if (Dbms.UNKNOWN.equals((Object)this.dbms)) {
            this.setDbms(this.dialect.getClass().getSimpleName());
        }
    }

    private void showConfigurationProperties() {
        String property = this.configuration.getProperty("hibernate.sos.show_configuration_properties");
        if (property != null && property.toLowerCase().equals("true")) {
            String method = SOSHibernate.getMethodName(this.logIdentifier, "showConfigurationProperties");
            for (Map.Entry<Object, Object> entry : this.configuration.getProperties().entrySet()) {
                String key = (String)entry.getKey();
                String value = null;
                value = this.configurationResolver.propertyValueChanged(key) ? this.configurationResolver.getOldValueOrNewPropertyValue(property) : (key.toLowerCase().endsWith("password") ? "***" : (String)entry.getValue());
                LOGGER.info(String.format("%s %s=%s", method, key, value));
            }
        }
    }

    private void setConfigurationClassMapping() {
        if (this.classMapping != null) {
            boolean isTraceEnabled = LOGGER.isTraceEnabled();
            String method = isTraceEnabled ? SOSHibernate.getMethodName(this.logIdentifier, "setConfigurationClassMapping") : "";
            for (Class c : this.classMapping.getClasses()) {
                if (isTraceEnabled) {
                    LOGGER.trace(String.format("%s %s", method, c.getCanonicalName()));
                }
                this.configuration.addAnnotatedClass(c);
            }
        }
    }

    private void setConfigurationProperties() {
        if (this.configurationProperties != null) {
            boolean isTraceEnabled = LOGGER.isTraceEnabled();
            String method = isTraceEnabled ? SOSHibernate.getMethodName(this.logIdentifier, "setConfigurationProperties") : "";
            for (Map.Entry<Object, Object> entry : this.configurationProperties.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                this.configuration.setProperty(key, value);
                if (!isTraceEnabled) continue;
                LOGGER.trace(String.format("%s %s=%s", method, key, value));
            }
        }
    }

    private void setDbms(String dialect) {
        this.dbms = SOSHibernateFactory.getDbms(dialect);
    }

    private void setDefaultConfigurationProperties() {
        if (this.useDefaultConfigurationProperties && this.defaultConfigurationProperties != null) {
            boolean isTraceEnabled = LOGGER.isTraceEnabled();
            String method = isTraceEnabled ? SOSHibernate.getMethodName(this.logIdentifier, "setDefaultConfigurationProperties") : "";
            for (Map.Entry<Object, Object> entry : this.defaultConfigurationProperties.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                if (isTraceEnabled) {
                    LOGGER.trace(String.format("%s %s=%s", method, key, value));
                }
                this.configuration.setProperty(key, value);
            }
        }
    }

    private void adjustAnnotations(Dbms dbms) {
        if (this.classMapping != null && Dbms.H2.equals((Object)dbms)) {
            this.changeJsonAnnotations4H2();
        }
    }

    private void changeJsonAnnotations4H2() {
        for (Class c : this.classMapping.getClasses()) {
            List fields = Arrays.stream(c.getDeclaredFields()).filter(m -> m.isAnnotationPresent(Type.class) && m.getAnnotation(Type.class).value().equals(SOSHibernateJsonType.class)).collect(Collectors.toList());
            if (fields == null || fields.size() <= 0) continue;
            for (Field field : fields) {
                field.setAccessible(true);
                ColumnTransformer ct = field.getAnnotation(ColumnTransformer.class);
                if (ct == null) continue;
                try {
                    SOSReflection.changeAnnotationValue((Annotation)ct, (String)"write", (Object)"? FORMAT JSON");
                }
                catch (Throwable e) {
                    LOGGER.warn(String.format("[%s.%s]%s", c.getSimpleName(), field.getName(), e.toString()), e);
                }
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug(String.format("[ColumnTransformer][%s.%s]%s", c.getSimpleName(), field.getName(), ct.write()));
            }
        }
    }

    protected boolean readDatabaseMetaData() {
        return this.readDatabaseMetaData;
    }

    public static String getTransactionIsolationName(int isolationLevel) throws SOSHibernateConfigurationException {
        switch (isolationLevel) {
            case 0: {
                return "TRANSACTION_NONE";
            }
            case 1: {
                return "TRANSACTION_READ_UNCOMMITTED";
            }
            case 2: {
                return "TRANSACTION_READ_COMMITTED";
            }
            case 4: {
                return "TRANSACTION_REPEATABLE_READ";
            }
            case 8: {
                return "TRANSACTION_SERIALIZABLE";
            }
        }
        throw new SOSHibernateConfigurationException(String.format("invalid transaction isolation level=%s", isolationLevel));
    }

    public void addClassMapping(Class<?> c) {
        this.classMapping.add(c);
    }

    public void addClassMapping(SOSClassList list) {
        this.classMapping.merge((Collection)list.getClasses());
    }

    public void adjustConfiguration(Configuration config) {
    }

    public boolean dbmsIsPostgres() {
        return Dbms.PGSQL.equals((Object)this.dbms);
    }

    public boolean dbmsIsH2() {
        return Dbms.H2.equals((Object)this.dbms);
    }

    public void setIdentifier(String val) {
        this.identifier = val;
        this.logIdentifier = SOSHibernate.getLogIdentifier(this.identifier);
    }

    public void setTransactionIsolation(int level) {
        this.configurationProperties.put("hibernate.connection.isolation", String.valueOf(level));
    }

    public void setUseDefaultConfigurationProperties(boolean val) {
        this.useDefaultConfigurationProperties = val;
    }

    public SOSHibernateDatabaseMetaData getDatabaseMetaData() {
        return this.databaseMetaData;
    }

    public SOSHibernateConfigurationResolver getConfigurationResolver() {
        return this.configurationResolver;
    }

    public SOSClassList getClassMapping() {
        return this.classMapping;
    }

    public Optional<Path> getConfigFile() {
        return this.configFile;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public Properties getConfigurationProperties() {
        return this.configurationProperties;
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public Dbms getDbms() {
        return this.dbms;
    }

    public Properties getDefaultConfigurationProperties() {
        return this.defaultConfigurationProperties;
    }

    public Dialect getDialect() {
        return this.dialect;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public static enum Dbms {
        H2,
        MSSQL,
        MYSQL,
        ORACLE,
        PGSQL,
        UNKNOWN;

    }
}

