/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.hibernate;

import com.sos.commons.hibernate.SOSHibernate;
import com.sos.commons.hibernate.SOSHibernateFactory;
import com.sos.commons.hibernate.SOSHibernateSession;
import com.sos.commons.hibernate.SOSSQLCommandExtractor;
import com.sos.commons.hibernate.common.SOSBatchObject;
import com.sos.commons.hibernate.exception.SOSHibernateException;
import com.sos.commons.hibernate.exception.SOSHibernateSQLCommandExtractorException;
import com.sos.commons.hibernate.exception.SOSHibernateSQLExecutorException;
import com.sos.commons.util.SOSString;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SOSHibernateSQLExecutor
implements Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(SOSHibernateSQLExecutor.class);
    private static final long serialVersionUID = 1L;
    private final SOSHibernateSession session;
    private String logIdentifier;
    private boolean execReturnsResultSet;

    protected SOSHibernateSQLExecutor(SOSHibernateSession sess) {
        this.session = sess;
        this.logIdentifier = SOSHibernate.getLogIdentifier(this.session == null ? null : this.session.getIdentifier());
    }

    public void close(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                rs.getStatement().close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public boolean execute(String ... sqls) throws SOSHibernateException {
        boolean isDebugEnabled = LOGGER.isDebugEnabled();
        String method = isDebugEnabled ? SOSHibernate.getMethodName(this.logIdentifier, "execute") : "";
        boolean result = false;
        Statement stmt = null;
        try {
            stmt = this.getConnection().createStatement();
            this.session.setCurrentStatement(stmt);
            for (String sql : sqls) {
                if (isDebugEnabled) {
                    LOGGER.debug(String.format("%s[%s]", method, sql));
                }
                try {
                    result = stmt.execute(sql);
                }
                catch (SQLException e) {
                    throw new SOSHibernateSQLExecutorException(e, sql);
                }
            }
        }
        catch (SQLException e) {
            throw new SOSHibernateSQLExecutorException(e);
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Throwable throwable) {}
            }
            this.session.resetCurrentStatement();
        }
        return result;
    }

    public int[] executeBatch(List<String> sqls) throws SOSHibernateException {
        int[] result = null;
        if (sqls != null && sqls.size() > 0) {
            result = this.executeBatch(sqls.toArray(new String[sqls.size()]));
        }
        return result;
    }

    public int[] executeBatch(String ... sqls) throws SOSHibernateException {
        boolean isDebugEnabled = LOGGER.isDebugEnabled();
        String method = isDebugEnabled ? SOSHibernate.getMethodName(this.logIdentifier, "executeBatch") : "";
        int[] result = null;
        Statement stmt = null;
        try {
            stmt = this.getConnection().createStatement();
            this.session.setCurrentStatement(stmt);
            for (String sql : sqls) {
                if (isDebugEnabled) {
                    LOGGER.debug(String.format("%s[addBatch][%s]", method, sql));
                }
                try {
                    stmt.addBatch(sql);
                }
                catch (SQLException e) {
                    throw new SOSHibernateSQLExecutorException(e, sql);
                }
            }
            result = stmt.executeBatch();
        }
        catch (SQLException e) {
            throw new SOSHibernateSQLExecutorException(e);
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Throwable throwable) {}
            }
            this.session.resetCurrentStatement();
        }
        return result;
    }

    public int[] executeBatch(String tableName, String sql, Collection<Collection<SOSBatchObject>> rows) throws SOSHibernateException {
        boolean isDebugEnabled = LOGGER.isDebugEnabled();
        String method = isDebugEnabled ? SOSHibernate.getMethodName(this.logIdentifier, "executeBatch") : "";
        int[] result = null;
        Statement stmt = null;
        try {
            if (isDebugEnabled) {
                LOGGER.debug(String.format("%s%s", method, sql));
            }
            Connection conn = this.getConnection();
            Map<String, Integer> columnsMeta = this.getColumnsMeta(conn, tableName);
            stmt = conn.prepareStatement(sql);
            this.session.setCurrentStatement(stmt);
            int i = 0;
            for (Collection<SOSBatchObject> row : rows) {
                ++i;
                for (SOSBatchObject bo : row) {
                    try {
                        stmt.setObject(bo.getIndex(), bo.getValue(), columnsMeta.get(bo.getColumnName().toLowerCase()));
                    }
                    catch (SQLException e2) {
                        throw new SOSHibernateSQLExecutorException(e2, sql);
                    }
                }
                if (isDebugEnabled) {
                    LOGGER.debug(String.format("%s[%s][addBatch]%s", method, i, row.stream().map(e -> SOSString.toString((Object)e)).collect(Collectors.joining(","))));
                }
                stmt.addBatch();
            }
            result = stmt.executeBatch();
        }
        catch (SQLException e3) {
            throw new SOSHibernateSQLExecutorException(e3);
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Throwable throwable) {}
            }
            this.session.resetCurrentStatement();
        }
        return result;
    }

    public Map<String, Integer> getColumnsMeta(Connection connection, String tableName) throws SOSHibernateException {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = connection.createStatement();
            rs = stmt.executeQuery("SELECT * FROM " + tableName + " WHERE 1=0");
            ResultSetMetaData meta = rs.getMetaData();
            int count = meta.getColumnCount();
            for (int i = 1; i <= count; ++i) {
                result.put(meta.getColumnName(i).toLowerCase(), meta.getColumnType(i));
            }
        }
        catch (SQLException e) {
            throw new SOSHibernateSQLExecutorException(e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Throwable throwable) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Throwable throwable) {}
            }
        }
        return result;
    }

    public void executeQuery(String sql) throws SOSHibernateException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("%s[%s]", SOSHibernate.getMethodName(this.logIdentifier, "executeQuery"), sql));
        }
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.getConnection().createStatement();
            this.session.setCurrentStatement(stmt);
            rs = stmt.executeQuery(sql);
        }
        catch (SQLException e) {
            throw new SOSHibernateSQLExecutorException(e, sql);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Throwable throwable) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Throwable throwable) {}
            }
            this.session.resetCurrentStatement();
        }
    }

    public void executeStatements(Path file) throws SOSHibernateException {
        byte[] bytes = null;
        try {
            bytes = Files.readAllBytes(file);
        }
        catch (Throwable e) {
            throw new SOSHibernateSQLExecutorException(String.format("cannot read file %s", file), e);
        }
        this.executeStatements(new String(bytes));
    }

    public void executeStatements(String content) throws SOSHibernateException {
        boolean isDebugEnabled = LOGGER.isDebugEnabled();
        String method = isDebugEnabled ? SOSHibernate.getMethodName(this.logIdentifier, "executeStatements") : "";
        Statement stmt = null;
        String command = null;
        try {
            stmt = this.getConnection().createStatement();
            this.session.setCurrentStatement(stmt);
            List<String> commands = this.getStatements(content);
            for (int i = 0; i < commands.size(); ++i) {
                command = commands.get(i);
                if (SOSHibernateSQLExecutor.isResultListQuery(command, this.execReturnsResultSet)) {
                    if (isDebugEnabled) {
                        LOGGER.debug(String.format("%s[executeQuery][%s]", method, command));
                    }
                    try (ResultSet rs = null;){
                        rs = stmt.executeQuery(command);
                        continue;
                    }
                }
                if (isDebugEnabled) {
                    LOGGER.debug(String.format("%s[executeUpdate][%s]", method, command));
                }
                stmt.executeUpdate(command);
            }
        }
        catch (SQLException e) {
            throw new SOSHibernateSQLExecutorException(e, command);
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Throwable throwable) {}
            }
            this.session.resetCurrentStatement();
        }
    }

    public int executeUpdate(String ... sqls) throws SOSHibernateException {
        boolean isDebugEnabled = LOGGER.isDebugEnabled();
        String method = isDebugEnabled ? SOSHibernate.getMethodName(this.logIdentifier, "executeUpdate") : "";
        int result = 0;
        Statement stmt = null;
        try {
            stmt = this.getConnection().createStatement();
            this.session.setCurrentStatement(stmt);
            for (String sql : sqls) {
                if (isDebugEnabled) {
                    LOGGER.debug(String.format("%s[%s]", method, sql));
                }
                try {
                    result += stmt.executeUpdate(sql);
                }
                catch (SQLException e) {
                    throw new SOSHibernateSQLExecutorException(e, sql);
                }
            }
        }
        catch (SQLException e) {
            throw new SOSHibernateSQLExecutorException(e);
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Throwable throwable) {}
            }
            this.session.resetCurrentStatement();
        }
        return result;
    }

    public int executeUpdateCallableStatement(String sql) throws SOSHibernateException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("%s[%s]", SOSHibernate.getMethodName(this.logIdentifier, "executeUpdateCallableStatement"), sql));
        }
        int result = -1;
        CallableStatement stmt = null;
        try {
            stmt = this.getConnection().prepareCall(sql);
            this.session.setCurrentStatement(stmt);
            result = stmt.executeUpdate();
        }
        catch (SQLException e) {
            throw new SOSHibernateSQLExecutorException(e, sql);
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Throwable throwable) {}
            }
            this.session.resetCurrentStatement();
        }
        return result;
    }

    public byte[] getBlob(String sql) throws SOSHibernateException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("%s[%s]", SOSHibernate.getMethodName(this.logIdentifier, "getBlob"), sql));
        }
        Statement stmt = null;
        ResultSet rs = null;
        byte[] result = new byte[]{};
        try {
            if (SOSString.isEmpty((String)sql)) {
                throw new SOSHibernateSQLExecutorException("missing sql");
            }
            stmt = this.getConnection().createStatement();
            this.session.setCurrentStatement(stmt);
            rs = stmt.executeQuery(sql);
            if (rs.next()) {
                result = rs.getBytes(1);
            }
            if (result == null) {
                byte[] byArray = result;
                return byArray;
            }
        }
        catch (SQLException e) {
            throw new SOSHibernateSQLExecutorException(e, sql);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception exception) {}
            }
            this.session.resetCurrentStatement();
        }
        return result;
    }

    public long getBlob(String sql, Path path) throws SOSHibernateException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("%s[%s]path=%s", SOSHibernate.getMethodName(this.logIdentifier, "getBlob"), sql, path));
        }
        Statement stmt = null;
        ResultSet rs = null;
        InputStream in = null;
        FileOutputStream out = null;
        long result = 0L;
        try {
            if (SOSString.isEmpty((String)sql)) {
                throw new SOSHibernateSQLExecutorException("missing sql");
            }
            if (path == null) {
                throw new SOSHibernateSQLExecutorException("path is null");
            }
            stmt = this.getConnection().createStatement();
            this.session.setCurrentStatement(stmt);
            rs = stmt.executeQuery(sql);
            int len = 0;
            if (rs.next()) {
                in = rs.getBinaryStream(1);
                if (in == null) {
                    long l = result;
                    return l;
                }
                byte[] buff = new byte[1024];
                len = in.read(buff);
                if (len > 0) {
                    out = new FileOutputStream(path.toFile());
                    out.write(buff, 0, len);
                    result += (long)len;
                } else {
                    long l = result;
                    return l;
                }
                while (0 < (len = in.read(buff))) {
                    out.write(buff, 0, len);
                    result += (long)len;
                }
            }
        }
        catch (IOException e) {
            throw new SOSHibernateSQLExecutorException(String.format("can't write to file %s", path), e);
        }
        catch (SQLException e) {
            throw new SOSHibernateSQLExecutorException(e, sql);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception exception) {}
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception exception) {}
            }
            this.session.resetCurrentStatement();
        }
        return result;
    }

    public String getClob(String sql) throws SOSHibernateException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("%s[%s]", SOSHibernate.getMethodName(this.logIdentifier, "getClob"), sql));
        }
        Statement stmt = null;
        ResultSet rs = null;
        Reader in = null;
        StringBuilder result = new StringBuilder();
        try {
            if (SOSString.isEmpty((String)sql)) {
                throw new SOSHibernateSQLExecutorException("missing sql");
            }
            stmt = this.getConnection().createStatement();
            this.session.setCurrentStatement(stmt);
            try {
                rs = stmt.executeQuery(sql);
            }
            catch (SQLException e) {
                throw new SOSHibernateSQLExecutorException(e, sql);
            }
            if (rs.next()) {
                in = rs.getCharacterStream(1);
                if (in == null) {
                    String string = "";
                    return string;
                }
                int bytesRead = in.read();
                if (bytesRead != -1) {
                    result.append((char)bytesRead);
                } else {
                    String string = "";
                    return string;
                }
                while ((bytesRead = in.read()) != -1) {
                    result.append((char)bytesRead);
                }
            }
        }
        catch (IOException e) {
            throw new SOSHibernateSQLExecutorException("exception during read bytes from clob", e);
        }
        catch (SQLException e) {
            throw new SOSHibernateSQLExecutorException(e, sql);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception exception) {}
            }
            this.session.resetCurrentStatement();
        }
        return result.toString();
    }

    public long getClob(String sql, Path path) throws SOSHibernateException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("%s[%s]path=%s", SOSHibernate.getMethodName(this.logIdentifier, "getClob"), sql, path));
        }
        Statement stmt = null;
        ResultSet rs = null;
        Reader in = null;
        OutputStream out = null;
        long result = 0L;
        try {
            if (SOSString.isEmpty((String)sql)) {
                throw new SOSHibernateSQLExecutorException("missing sql");
            }
            if (path == null) {
                throw new SOSHibernateSQLExecutorException("path is null");
            }
            stmt = this.getConnection().createStatement();
            this.session.setCurrentStatement(stmt);
            try {
                rs = stmt.executeQuery(sql);
            }
            catch (SQLException e) {
                throw new SOSHibernateSQLExecutorException(e, sql);
            }
            int bytesRead = 0;
            if (rs.next()) {
                in = rs.getCharacterStream(1);
                if (in == null) {
                    long l = result;
                    return l;
                }
                bytesRead = in.read();
                if (bytesRead != -1) {
                    out = new FileOutputStream(path.toFile());
                    ((FileOutputStream)out).write(bytesRead);
                    ++result;
                } else {
                    long l = result;
                    return l;
                }
                while ((bytesRead = in.read()) != -1) {
                    ((FileOutputStream)out).write(bytesRead);
                    ++result;
                }
            }
        }
        catch (IOException e) {
            throw new SOSHibernateSQLExecutorException(String.format("can't write to file %s", path), e);
        }
        catch (SQLException e) {
            throw new SOSHibernateSQLExecutorException(e, sql);
        }
        finally {
            try {
                out.flush();
            }
            catch (Exception exception) {}
            if (out != null) {
                try {
                    ((FileOutputStream)out).close();
                }
                catch (Exception exception) {}
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception exception) {}
            }
            this.session.resetCurrentStatement();
        }
        return result;
    }

    public ResultSet getResultSet(String sql) throws SOSHibernateException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("%s[%s]", SOSHibernate.getMethodName(this.logIdentifier, "getResultSet"), sql));
        }
        try {
            Statement stmt = this.getConnection().createStatement();
            this.session.setCurrentStatement(stmt);
            ResultSet resultSet = stmt.executeQuery(sql);
            return resultSet;
        }
        catch (SQLException e) {
            throw new SOSHibernateSQLExecutorException(e, sql);
        }
        finally {
            this.session.resetCurrentStatement();
        }
    }

    public List<String> getStatements(Path file) throws SOSHibernateSQLCommandExtractorException, SOSHibernateSQLExecutorException {
        byte[] bytes = null;
        try {
            bytes = Files.readAllBytes(file);
        }
        catch (Throwable e) {
            throw new SOSHibernateSQLExecutorException(String.format("cannot read file %s", file), e);
        }
        return this.getStatements(new String(bytes));
    }

    public List<String> getStatements(String content) throws SOSHibernateSQLCommandExtractorException {
        SOSSQLCommandExtractor extractor = new SOSSQLCommandExtractor(this.session.getFactory().getDbms());
        return extractor.extractCommands(content);
    }

    public Map<String, Object> next(ResultSet rs) throws SOSHibernateSQLExecutorException {
        LinkedHashMap<String, Object> record = new LinkedHashMap<String, Object>();
        try {
            if (rs != null && rs.next()) {
                ResultSetMetaData meta = rs.getMetaData();
                int count = meta.getColumnCount();
                for (int i = 1; i <= count; ++i) {
                    record.put(meta.getColumnName(i).toLowerCase(), rs.getObject(i));
                }
            }
        }
        catch (SQLException e) {
            throw new SOSHibernateSQLExecutorException(e);
        }
        return record;
    }

    public Map<String, String> nextAsStringMap(ResultSet rs) throws SOSHibernateSQLExecutorException {
        LinkedHashMap<String, String> record = new LinkedHashMap<String, String>();
        try {
            if (rs != null && rs.next()) {
                ResultSetMetaData meta = rs.getMetaData();
                int count = meta.getColumnCount();
                for (int i = 1; i <= count; ++i) {
                    String name = meta.getColumnName(i);
                    String value = rs.getString(name);
                    if (SOSString.isEmpty((String)value)) {
                        value = "";
                    }
                    record.put(name.toLowerCase(), value.trim());
                }
            }
        }
        catch (SQLException e) {
            throw new SOSHibernateSQLExecutorException(e);
        }
        return record;
    }

    public void setDefaults() throws SOSHibernateException {
        SOSHibernateFactory.Dbms dbms = this.session.getFactory().getDbms();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("%s dbms=%s", new Object[]{SOSHibernate.getMethodName(this.logIdentifier, "setDefaults"), dbms}));
        }
        switch (dbms) {
            case MSSQL: {
                String dateFormat = "set DATEFORMAT ymd";
                String language = "set LANGUAGE British";
                this.execute(dateFormat, language);
                break;
            }
            case MYSQL: {
                this.execute("SET SESSION SQL_MODE='ANSI_QUOTES'");
                break;
            }
            case ORACLE: {
                String nlsNumericCharacters = "ALTER SESSION SET NLS_NUMERIC_CHARACTERS='.,'";
                String nlsDateFormat = "ALTER SESSION SET NLS_DATE_FORMAT='YYYY-MM-DD HH24:MI:SS'";
                String nlsSort = "ALTER SESSION SET NLS_SORT='BINARY'";
                this.executeBatch(nlsNumericCharacters, nlsDateFormat, nlsSort);
                this.executeUpdateCallableStatement("begin dbms_output.enable(10000); end;");
                break;
            }
            case PGSQL: {
                String lcNumeric = "SELECT set_config('lc_numeric', '', true)";
                String dateStyle = "SELECT set_config('datestyle', 'ISO, YMD', true)";
                String defaultTransactionIsolation = "SELECT set_config('default_transaction_isolation', 'repeatable read', true)";
                this.execute(lcNumeric, dateStyle, defaultTransactionIsolation);
                break;
            }
        }
    }

    public int updateBlob(byte[] data, String tableName, String columnName, String condition) throws SOSHibernateException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("%s tableName=%s, columnName=%s, condition=%s", SOSHibernate.getMethodName(this.logIdentifier, "updateBlob"), tableName, columnName, condition));
        }
        if (data == null || data.length <= 0) {
            throw new SOSHibernateSQLExecutorException("missing data");
        }
        int result = data.length;
        this.updateBlob(new ByteArrayInputStream(data), result, tableName, columnName, condition);
        return result;
    }

    public void updateBlob(InputStream inputStream, int dataLength, String tableName, String columnName, String condition) throws SOSHibernateException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("%s tableName=%s, columnName=%s, condition=%s", SOSHibernate.getMethodName(this.logIdentifier, "updateBlob"), tableName, columnName, condition));
        }
        Statement pstmt = null;
        StringBuilder sql = null;
        try {
            String where;
            if (SOSString.isEmpty((String)tableName)) {
                throw new SOSHibernateSQLExecutorException("missing tableName");
            }
            if (SOSString.isEmpty((String)columnName)) {
                throw new SOSHibernateSQLExecutorException("missing columnName");
            }
            if (inputStream == null) {
                throw new SOSHibernateSQLExecutorException("input stream is null");
            }
            sql = new StringBuilder();
            sql.append("UPDATE ");
            sql.append(tableName);
            sql.append(" SET ").append(columnName).append(" = ? ");
            if (condition != null && !SOSString.isEmpty((String)(where = condition.trim()))) {
                if (where.toUpperCase().startsWith("WHERE")) {
                    sql.append(" ").append(where);
                } else {
                    sql.append(" WHERE ").append(where);
                }
            }
            pstmt = this.getConnection().prepareStatement(sql.toString());
            this.session.setCurrentStatement(pstmt);
            pstmt.setBinaryStream(1, inputStream, dataLength);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            throw new SOSHibernateSQLExecutorException(e, sql == null ? null : sql.toString());
        }
        finally {
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Exception exception) {}
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
            this.session.resetCurrentStatement();
        }
    }

    public int updateBlob(Path path, String tableName, String columnName, String condition) throws SOSHibernateException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("%s path=%s, tableName=%s, columnName=%s, condition=%s", SOSHibernate.getMethodName(this.logIdentifier, "updateBlob"), path, tableName, columnName, condition));
        }
        if (path == null) {
            throw new SOSHibernateSQLExecutorException("path is null");
        }
        File file = path.toFile();
        int result = (int)file.length();
        if (!file.exists()) {
            throw new SOSHibernateSQLExecutorException(String.format("file %s doesn't exist", path));
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
        }
        catch (Throwable e) {
            throw new SOSHibernateSQLExecutorException(String.format("cannot read file %s", file), e);
        }
        this.updateBlob(fis, result, tableName, columnName, condition);
        return result;
    }

    public int updateClob(Path path, String tableName, String columnName, String condition) throws SOSHibernateException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("%s path=%s, tableName=%s, columnName=%s, condition=%s", SOSHibernate.getMethodName(this.logIdentifier, "updateClob"), path, tableName, columnName, condition));
        }
        if (path == null) {
            throw new SOSHibernateSQLExecutorException("path is null");
        }
        File file = path.toFile();
        int result = (int)file.length();
        if (!file.exists()) {
            throw new SOSHibernateSQLExecutorException(String.format("file %s doesn't exist", path));
        }
        FileReader fr = null;
        try {
            fr = new FileReader(file);
        }
        catch (Throwable e) {
            throw new SOSHibernateSQLExecutorException(String.format("cannot read file %s", file), e);
        }
        this.updateClob(fr, result, tableName, columnName, condition);
        return result;
    }

    public void updateClob(Reader reader, int dataLength, String tableName, String columnName, String condition) throws SOSHibernateException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("%s tableName=%s, columnName=%s, condition=%s", SOSHibernate.getMethodName(this.logIdentifier, "updateClob"), tableName, columnName, condition));
        }
        Statement pstmt = null;
        StringBuilder sql = null;
        try {
            String where;
            if (SOSString.isEmpty((String)tableName)) {
                throw new SOSHibernateSQLExecutorException("missing tableName");
            }
            if (SOSString.isEmpty((String)columnName)) {
                throw new SOSHibernateSQLExecutorException("missing columnName");
            }
            if (reader == null) {
                throw new SOSHibernateSQLExecutorException("reader is null");
            }
            sql = new StringBuilder();
            sql.append("UPDATE ");
            sql.append(tableName);
            sql.append(" SET ").append(columnName).append(" = ? ");
            if (condition != null && !SOSString.isEmpty((String)(where = condition.trim()))) {
                if (where.toUpperCase().startsWith("WHERE")) {
                    sql.append(" ").append(where);
                } else {
                    sql.append(" WHERE ").append(where);
                }
            }
            pstmt = this.getConnection().prepareStatement(sql.toString());
            this.session.setCurrentStatement(pstmt);
            pstmt.setCharacterStream(1, reader, dataLength);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            throw new SOSHibernateSQLExecutorException(e, sql == null ? null : sql.toString());
        }
        finally {
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Exception exception) {}
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Throwable throwable) {}
            }
            this.session.resetCurrentStatement();
        }
    }

    public int updateClob(String data, String tableName, String columnName, String condition) throws SOSHibernateException {
        if (SOSString.isEmpty((String)data)) {
            throw new SOSHibernateSQLExecutorException("missing data");
        }
        int result = data.length();
        this.updateClob(new StringReader(data), result, tableName, columnName, condition);
        return result;
    }

    public boolean isExecReturnsResultSet() {
        return this.execReturnsResultSet;
    }

    public void setExecReturnsResultSet(boolean val) {
        this.execReturnsResultSet = val;
    }

    private Connection getConnection() throws SOSHibernateException {
        if (this.session == null) {
            throw new SOSHibernateSQLExecutorException("session is null");
        }
        Connection conn = this.session.getConnection();
        if (conn == null) {
            throw new SOSHibernateSQLExecutorException("SQL connection is null");
        }
        return conn;
    }

    public static boolean isResultListQuery(String sql, boolean execReturnsResultSet) {
        String stmt = sql.toLowerCase();
        return stmt.startsWith("select") || stmt.startsWith("exec") && execReturnsResultSet;
    }

    public static String[] getColumnLabels(ResultSet rs) throws SQLException {
        if (rs == null) {
            return null;
        }
        ResultSetMetaData m = rs.getMetaData();
        if (m == null) {
            return null;
        }
        int count = m.getColumnCount();
        String[] result = new String[count];
        for (int i = 0; i < count; ++i) {
            result[i] = m.getColumnLabel(i + 1);
        }
        return result;
    }

    public static String sqlValueToString(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Clob) {
            return SOSHibernateSQLExecutor.toString((Clob)o);
        }
        return o.toString();
    }

    public static String toString(Clob clob) {
        StringBuilder sb = new StringBuilder();
        try {
            int b;
            Reader reader = clob.getCharacterStream();
            BufferedReader br = new BufferedReader(reader);
            while (-1 != (b = br.read())) {
                sb.append((char)b);
            }
            br.close();
        }
        catch (Throwable e) {
            return e.toString();
        }
        return sb.toString();
    }
}

