/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.hibernate.configuration;

import com.sos.commons.hibernate.configuration.resolver.ISOSHibernateConfigurationResolver;
import com.sos.commons.hibernate.configuration.resolver.SOSHibernateCredentiaStoreResolver;
import com.sos.commons.hibernate.configuration.resolver.SOSHibernateEncryptionResolver;
import com.sos.commons.hibernate.configuration.resolver.SOSHibernateJS7Resolver;
import com.sos.commons.hibernate.exception.SOSHibernateConfigurationException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.hibernate.cfg.Configuration;

public class SOSHibernateConfigurationResolver {
    private final List<ISOSHibernateConfigurationResolver> resolvers = new ArrayList<ISOSHibernateConfigurationResolver>();
    private Map<String, String> result;

    public SOSHibernateConfigurationResolver() {
        this.resolvers.add(new SOSHibernateEncryptionResolver());
        this.resolvers.add(new SOSHibernateJS7Resolver());
        this.resolvers.add(new SOSHibernateCredentiaStoreResolver());
    }

    public Configuration resolve(Configuration configuration) throws SOSHibernateConfigurationException {
        Properties cloned = this.clone(configuration);
        for (ISOSHibernateConfigurationResolver r : this.resolvers) {
            configuration = r.resolve(configuration);
        }
        this.setResult(configuration, cloned);
        return configuration;
    }

    public void addResolver(ISOSHibernateConfigurationResolver resolver) {
        Optional<ISOSHibernateConfigurationResolver> existingInstance = this.resolvers.stream().filter(instance -> instance.getClass().equals(resolver.getClass())).findFirst();
        existingInstance.ifPresentOrElse(instance -> this.resolvers.set(this.resolvers.indexOf(instance), resolver), () -> this.resolvers.add(resolver));
    }

    public boolean propertyValueChanged(String propertyName) {
        return this.result != null && this.result.containsKey(propertyName);
    }

    public String getOldValueOrNewPropertyValue(String propertyName) {
        return this.result == null ? null : this.result.get(propertyName);
    }

    private Properties clone(Configuration configuration) {
        Properties cloned = new Properties();
        configuration.getProperties().stringPropertyNames().forEach(key -> cloned.setProperty((String)key, configuration.getProperties().getProperty((String)key)));
        return cloned;
    }

    private void setResult(Configuration configuration, Properties old) {
        HashSet<String> allKeys = new HashSet<String>(configuration.getProperties().stringPropertyNames());
        allKeys.addAll(old.stringPropertyNames());
        this.result = allKeys.stream().filter(key -> {
            String oldValue = old.getProperty((String)key);
            String newValue = configuration.getProperties().getProperty((String)key);
            return oldValue == null && newValue != null || oldValue != null && newValue == null || oldValue != null && newValue != null && !oldValue.equals(newValue);
        }).collect(Collectors.toMap(key -> key, key -> {
            String oldValue = old.getProperty((String)key);
            return oldValue != null ? oldValue : "***";
        }));
    }
}

