/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.hibernate.configuration.resolver;

import com.sos.commons.hibernate.configuration.resolver.ISOSHibernateConfigurationResolver;
import com.sos.commons.hibernate.exception.SOSHibernateConfigurationException;
import org.hibernate.cfg.Configuration;

public class SOSHibernateJS7Resolver
implements ISOSHibernateConfigurationResolver {
    private static final String JS7_DBMS_URL_PARAMETER = "JS7_DBMS_URL_PARAMETER";
    private static final String JS7_DBMS_USER = "JS7_DBMS_USER";
    private static final String JS7_DBMS_PASSWORD = "JS7_DBMS_PASSWORD";

    @Override
    public Configuration resolve(Configuration configuration) throws SOSHibernateConfigurationException {
        String password;
        String username;
        if (configuration == null) {
            return configuration;
        }
        String url = configuration.getProperty("jakarta.persistence.jdbc.url");
        if (url != null && url.contains("${JS7_DBMS_URL_PARAMETER}")) {
            configuration.setProperty("jakarta.persistence.jdbc.url", this.resolve(url, JS7_DBMS_URL_PARAMETER));
        }
        if ((username = configuration.getProperty("jakarta.persistence.jdbc.user")) != null && username.contains("${JS7_DBMS_USER}")) {
            configuration.setProperty("jakarta.persistence.jdbc.user", this.resolve(username, JS7_DBMS_USER));
        }
        if ((password = configuration.getProperty("jakarta.persistence.jdbc.password")) != null && password.contains("${JS7_DBMS_PASSWORD}")) {
            configuration.setProperty("jakarta.persistence.jdbc.password", this.resolve(password, JS7_DBMS_PASSWORD));
        }
        return configuration;
    }

    private String resolve(String confValue, String key) {
        String envVar = this.getEnvironmentVariable(key);
        if (JS7_DBMS_URL_PARAMETER.equals(key)) {
            envVar = this.normalize(envVar, confValue);
        }
        return confValue.replaceFirst("\\$\\{" + key + "\\}", envVar);
    }

    private String getEnvironmentVariable(String key) {
        String envVar = System.getProperty(this.getSystemPropKey(key));
        if (envVar == null) {
            envVar = System.getenv(key);
        }
        if (envVar == null) {
            envVar = "";
        }
        return envVar;
    }

    private String getSystemPropKey(String key) {
        return key.toLowerCase().replace('_', '.');
    }

    private String normalize(String envVar, String url) {
        int index;
        if (!((String)envVar).isEmpty() && (index = url.indexOf("${JS7_DBMS_URL_PARAMETER}")) > -1) {
            char charBeforeEnvVar;
            char firstCharOfEnvVar = ((String)envVar).charAt(0);
            if (firstCharOfEnvVar == '&' || firstCharOfEnvVar == '?') {
                envVar = ((String)envVar).substring(1);
            }
            if ((charBeforeEnvVar = url.charAt(index - 1)) != '&' && charBeforeEnvVar != '?') {
                envVar = url.contains("?") ? "&" + (String)envVar : "?" + (String)envVar;
            }
        }
        return envVar;
    }
}

