/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.hibernate.type;

import com.sos.commons.hibernate.SOSHibernateFactory;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.usertype.UserType;

public class SOSHibernateJsonType
implements UserType<Object> {
    public static final String COLUMN_TRANSFORMER_WRITE_DEFAULT = "?";
    public static final String COLUMN_TRANSFORMER_WRITE_H2 = "? FORMAT JSON";
    private final int sqlType = 2000;
    private SOSHibernateFactory.Dbms dbms;

    public void nullSafeSet(PreparedStatement st, Object value, int index, SharedSessionContractImplementor session) throws HibernateException, SQLException {
        if (this.dbms == null) {
            this.dbms = SOSHibernateFactory.getDbms(session.getFactory().getJdbcServices().getDialect());
        }
        if (value == null) {
            if (SOSHibernateFactory.Dbms.ORACLE.equals((Object)this.dbms)) {
                st.setNull(index, 2005);
            } else {
                st.setNull(index, 1111);
            }
            return;
        }
        if (SOSHibernateFactory.Dbms.PGSQL.equals((Object)this.dbms)) {
            st.setObject(index, value, 1111);
        } else {
            st.setObject(index, value);
        }
    }

    public Object nullSafeGet(ResultSet rs, int position, SharedSessionContractImplementor session, Object owner) throws HibernateException, SQLException {
        String val = rs.getString(position);
        if (val == null) {
            return null;
        }
        return val;
    }

    public Object deepCopy(Object value) throws HibernateException {
        return value;
    }

    public boolean isMutable() {
        return true;
    }

    public Serializable disassemble(Object value) throws HibernateException {
        return (String)this.deepCopy(value);
    }

    public Object assemble(Serializable cached, Object owner) throws HibernateException {
        return this.deepCopy(cached);
    }

    public Object replace(Object original, Object target, Object owner) throws HibernateException {
        return original;
    }

    public int getSqlType() {
        return 2000;
    }

    public Class returnedClass() {
        return String.class;
    }

    public boolean equals(Object x, Object y) throws HibernateException {
        if (x == null) {
            return y == null;
        }
        return x.equals(y);
    }

    public int hashCode(Object x) throws HibernateException {
        return x.hashCode();
    }
}

