/*
 * Decompiled with CFR 0.152.
 */
package com.sos.JSHelper.Basics;

import com.sos.JSHelper.Exceptions.JobSchedulerException;
import com.sos.JSHelper.Listener.JSListenerClass;
import com.sos.localization.Messages;
import java.io.BufferedWriter;
import java.io.File;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSToolBox
extends JSListenerClass {
    private static final Logger LOGGER = LoggerFactory.getLogger(JSToolBox.class);
    private static final String ENVVAR_SOS_LOCALE = "SOS_LOCALE";
    protected final String EMPTY_STRING = "";
    BufferedWriter objOut = null;
    protected Messages Messages = null;
    protected boolean flgStackTracePrinted = false;

    public JSToolBox() {
    }

    public JSToolBox(String pstrResourceBundleName) {
        this.setMessageResource(pstrResourceBundleName);
    }

    public JSToolBox(String pstrResourceBundleName, String pstrLocale) {
        this.Messages = new Messages(pstrResourceBundleName, new Locale(pstrLocale));
    }

    public Messages getMessageObject() {
        return this.Messages;
    }

    public String getMethodName() {
        try {
            StackTraceElement[] trace = new Throwable().getStackTrace();
            String lineNumber = trace[1].getLineNumber() > 0 ? "(" + trace[1].getLineNumber() + ")" : "";
            return trace[1].getClassName() + "." + trace[1].getMethodName() + lineNumber;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return "";
        }
    }

    public String getClassName() throws Exception {
        StackTraceElement[] trace = new Throwable().getStackTrace();
        return trace[1].getClassName();
    }

    protected void setMessageResource(String pstrResourceBundleName) {
        String strSOSLocale = System.getenv(ENVVAR_SOS_LOCALE);
        this.Messages = strSOSLocale == null ? new Messages(pstrResourceBundleName, Locale.getDefault()) : new Messages(pstrResourceBundleName, new Locale(strSOSLocale));
    }

    protected String makeFullPathName(String pstrPathname, String pstrFileName) {
        String normalizedPathname;
        String strT = pstrFileName;
        if (pstrFileName == null) {
            return "";
        }
        String normalizedFilename = pstrFileName.replace('\\', '/');
        if (!normalizedFilename.startsWith(normalizedPathname = pstrPathname.replace('\\', '/'))) {
            strT = normalizedPathname.endsWith("/") ? pstrPathname + strT : pstrPathname + "/" + strT;
        }
        return strT;
    }

    public String getI18N(String pstrI18NKey) {
        String strM = this.Messages.getMsg(pstrI18NKey);
        strM = pstrI18NKey + ": " + strM;
        return strM;
    }

    public String boolean2String(boolean pflgFlag) {
        String strRet = "true";
        if (!pflgFlag) {
            strRet = "false";
        }
        return strRet;
    }

    public String addSingleQuotes(String pstrS) {
        String strT = "'" + pstrS.replaceAll("'", "''") + "'";
        return strT;
    }

    protected String addQuotes(String pstrS) {
        return "\"" + this.quotes2DoubleQuotes(pstrS) + "\"";
    }

    protected String quotes2DoubleQuotes(String pstrS) {
        String strT = pstrS;
        if (strT != null) {
            strT = pstrS.replaceAll("\"", "\"\"");
        }
        return strT;
    }

    protected double toDouble(String pstrV) throws Exception {
        String conMethodName = "JSListenerClass::toDouble";
        double dblT = 0.0;
        String strT = pstrV.trim();
        int intLen = strT.length();
        if (intLen > 0) {
            if (strT.endsWith("-")) {
                strT = "-" + strT.substring(0, intLen - 1);
            } else if (strT.startsWith("+")) {
                strT = strT.substring(1, intLen);
            } else if (strT.endsWith("+")) {
                strT = strT.substring(0, intLen - 1);
            }
            try {
                dblT = new Double(strT);
            }
            catch (Exception objException) {
                try {
                    NumberFormat numberF = NumberFormat.getNumberInstance(Locale.GERMAN);
                    numberF.setGroupingUsed(false);
                    numberF.setParseIntegerOnly(false);
                    numberF.setMaximumFractionDigits(5);
                    numberF.setMinimumFractionDigits(0);
                    Number number = numberF.parse(strT);
                    dblT = number instanceof Double ? number.doubleValue() : new Double(number.doubleValue()).doubleValue();
                }
                catch (ParseException e) {
                    try {
                        NumberFormat numberF = NumberFormat.getNumberInstance(Locale.US);
                        numberF.setGroupingUsed(false);
                        numberF.setParseIntegerOnly(false);
                        Number number = numberF.parse(strT);
                        dblT = number instanceof Double ? number.doubleValue() : new Double(number.doubleValue()).doubleValue();
                    }
                    catch (ParseException e1) {
                        LOGGER.error(e1.getMessage(), (Throwable)e1);
                        this.signalError("JSListenerClass::toDouble: could not convert '" + strT + "' to double");
                    }
                }
                catch (NumberFormatException e) {
                    this.signalError("JSListenerClass::toDouble: could not convert '" + strT + "' to double");
                    dblT = 0.0;
                }
            }
        }
        return dblT;
    }

    public String creationTimeStamp() {
        return this.getISODate();
    }

    public String creationTimeStamp(String pstrDate) throws Exception {
        return this.creationTimeStamp(pstrDate, "010203");
    }

    public String creationTimeStamp(String pstrDate, String pstrTime) throws Exception {
        String strD = "";
        String strT = "";
        if (!pstrDate.isEmpty() && !pstrTime.isEmpty()) {
            try {
                strD = pstrDate.substring(0, 4) + "-" + pstrDate.substring(4, 6) + "-" + pstrDate.substring(6, 8) + "T";
                strT = pstrTime.substring(0, 2) + ":" + pstrTime.substring(2, 4) + ":" + pstrTime.substring(4, 6);
            }
            catch (RuntimeException e) {
                strD = pstrDate + "T";
                strT = "??:??:??";
            }
        }
        return strD + strT;
    }

    @Override
    public String getDateTimeFormatted(String pstrEditMask) {
        SimpleDateFormat formatter = new SimpleDateFormat(pstrEditMask);
        Calendar now = Calendar.getInstance();
        return formatter.format(now.getTime()).toString();
    }

    public Date now() {
        Calendar now = Calendar.getInstance();
        return now.getTime();
    }

    @Override
    public String getISODate() {
        return this.getDateTimeFormatted("yyyy-MM-dd'T'HH:mm:ss");
    }

    @Override
    public String getTime() {
        return this.getDateTimeFormatted("HH:mm:ss");
    }

    public String getHHIISS() {
        return this.getDateTimeFormatted("HHmmss");
    }

    public String getDate() {
        return this.getDateTimeFormatted("yyyy-MM-dd");
    }

    public String getYYYYMMDD() {
        return this.getDateTimeFormatted("yyyyMMdd");
    }

    public String environmentVariable(String pstrVariableName) {
        String conMethodName = "JSListenerClass::EnvironmentVariable";
        String strValue = null;
        if (this.isNotEmpty(pstrVariableName)) {
            strValue = System.getenv(pstrVariableName);
            if (this.isEmpty(strValue)) {
                strValue = System.getProperty(pstrVariableName);
            }
            if (this.isNotEmpty(strValue)) {
                strValue = this.stripQuotes(strValue);
                this.signalDebug(String.format("%s: %s = %s", "JSListenerClass::EnvironmentVariable", pstrVariableName, strValue));
            }
        }
        return strValue;
    }

    public String stripQuotes(String pstrS) {
        String strR = pstrS;
        if (pstrS.startsWith("\"") && pstrS.endsWith("\"")) {
            strR = pstrS.substring(1, pstrS.length() - 1);
            strR = strR.replaceAll("\"\"", "\"");
        }
        return strR;
    }

    protected boolean isNotEqual(String pstrActual, String pstrNew) {
        Boolean flgT = false;
        if (pstrActual == null && pstrNew == null) {
            flgT = false;
        } else if (pstrActual == null || !pstrActual.equalsIgnoreCase(pstrNew.toString())) {
            flgT = true;
        }
        return flgT;
    }

    public boolean isNotEmpty(String pstrValue) {
        return pstrValue != null && !pstrValue.trim().isEmpty();
    }

    public boolean isNotEmpty(StringBuffer pstrS) {
        return pstrS != null && pstrS.length() > 0;
    }

    protected boolean isEmpty(String pstrFileName) {
        return pstrFileName == null || pstrFileName.length() <= 0;
    }

    public boolean isNotNull(Object pobjObject) {
        return pobjObject != null;
    }

    public boolean isNull(Object pobjObject) {
        return pobjObject == null;
    }

    protected String notNull(String pstrS) {
        if (pstrS == null) {
            return "";
        }
        return pstrS;
    }

    public static final String repeatString(String str, int length) {
        StringBuilder sb = new StringBuilder();
        if (str != null) {
            while (length > 0) {
                sb.append(str);
                --length;
            }
        }
        return sb.toString();
    }

    public void raiseJSException(String pstrExceptionText) throws Exception {
        throw new JobSchedulerException(pstrExceptionText);
    }

    public static void notImplemented() {
        throw new JobSchedulerException("Method/Functionality not implemented presently.");
    }

    public String addFileSeparator(String str) {
        return str.endsWith("/") || str.endsWith("\\") ? str : str + "/";
    }

    public String adjustFileSeparator(String pstrValue) {
        String str = pstrValue;
        if (!str.startsWith("\\\\") && !str.startsWith("//")) {
            str = pstrValue.replaceAll("\\\\", "/");
            str = str.replaceAll("//", "/");
        }
        return str;
    }

    public static URL fileAsURL(File file) {
        URL result = null;
        try {
            result = file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new JobSchedulerException("Error to convert file object to URL.", e);
        }
        return result;
    }

    public static File urlAsFile(URL url) {
        File result = null;
        try {
            result = new File(url.toURI());
        }
        catch (URISyntaxException e) {
            throw new JobSchedulerException("Error to convert URL object to File.", e);
        }
        return result;
    }

    protected String bigInt2String(BigInteger pbigI) {
        if (pbigI != null) {
            long lngT = pbigI.longValue();
            return String.valueOf(lngT);
        }
        return "";
    }

    public boolean string2Bool(String pstrVal) {
        boolean flgT = false;
        if (this.isNotEmpty(pstrVal) && ("1".equals(pstrVal) || "y".equalsIgnoreCase(pstrVal) || "yes".equalsIgnoreCase(pstrVal) || "j".equalsIgnoreCase(pstrVal) || "on".equalsIgnoreCase(pstrVal) || "true".equalsIgnoreCase(pstrVal) || "wahr".equalsIgnoreCase(pstrVal))) {
            flgT = true;
        }
        return flgT;
    }

    public static String escapeHTML(String s) {
        StringBuilder sb = new StringBuilder();
        int n = s.length();
        block45: for (int i = 0; i < n; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    continue block45;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block45;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block45;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block45;
                }
                case '\u00e0': {
                    sb.append("&agrave;");
                    continue block45;
                }
                case '\u00c0': {
                    sb.append("&Agrave;");
                    continue block45;
                }
                case '\u00e2': {
                    sb.append("&acirc;");
                    continue block45;
                }
                case '\u00c2': {
                    sb.append("&Acirc;");
                    continue block45;
                }
                case '\u00e4': {
                    sb.append("&auml;");
                    continue block45;
                }
                case '\u00c4': {
                    sb.append("&Auml;");
                    continue block45;
                }
                case '\u00e5': {
                    sb.append("&aring;");
                    continue block45;
                }
                case '\u00c5': {
                    sb.append("&Aring;");
                    continue block45;
                }
                case '\u00e6': {
                    sb.append("&aelig;");
                    continue block45;
                }
                case '\u00c6': {
                    sb.append("&AElig;");
                    continue block45;
                }
                case '\u00e7': {
                    sb.append("&ccedil;");
                    continue block45;
                }
                case '\u00c7': {
                    sb.append("&Ccedil;");
                    continue block45;
                }
                case '\u00e9': {
                    sb.append("&eacute;");
                    continue block45;
                }
                case '\u00c9': {
                    sb.append("&Eacute;");
                    continue block45;
                }
                case '\u00e8': {
                    sb.append("&egrave;");
                    continue block45;
                }
                case '\u00c8': {
                    sb.append("&Egrave;");
                    continue block45;
                }
                case '\u00ea': {
                    sb.append("&ecirc;");
                    continue block45;
                }
                case '\u00ca': {
                    sb.append("&Ecirc;");
                    continue block45;
                }
                case '\u00eb': {
                    sb.append("&euml;");
                    continue block45;
                }
                case '\u00cb': {
                    sb.append("&Euml;");
                    continue block45;
                }
                case '\u00ef': {
                    sb.append("&iuml;");
                    continue block45;
                }
                case '\u00cf': {
                    sb.append("&Iuml;");
                    continue block45;
                }
                case '\u00f4': {
                    sb.append("&ocirc;");
                    continue block45;
                }
                case '\u00d4': {
                    sb.append("&Ocirc;");
                    continue block45;
                }
                case '\u00f6': {
                    sb.append("&ouml;");
                    continue block45;
                }
                case '\u00d6': {
                    sb.append("&Ouml;");
                    continue block45;
                }
                case '\u00f8': {
                    sb.append("&oslash;");
                    continue block45;
                }
                case '\u00d8': {
                    sb.append("&Oslash;");
                    continue block45;
                }
                case '\u00df': {
                    sb.append("&szlig;");
                    continue block45;
                }
                case '\u00f9': {
                    sb.append("&ugrave;");
                    continue block45;
                }
                case '\u00d9': {
                    sb.append("&Ugrave;");
                    continue block45;
                }
                case '\u00fb': {
                    sb.append("&ucirc;");
                    continue block45;
                }
                case '\u00db': {
                    sb.append("&Ucirc;");
                    continue block45;
                }
                case '\u00fc': {
                    sb.append("&uuml;");
                    continue block45;
                }
                case '\u00dc': {
                    sb.append("&Uuml;");
                    continue block45;
                }
                case '\u00ae': {
                    sb.append("&reg;");
                    continue block45;
                }
                case '\u00a9': {
                    sb.append("&copy;");
                    continue block45;
                }
                case '\u20ac': {
                    sb.append("&euro;");
                    continue block45;
                }
                case ' ': {
                    sb.append("&nbsp;");
                    continue block45;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }
}

