/*
 * Decompiled with CFR 0.152.
 */
package com.sos.JSHelper.DataElements;

import com.sos.JSHelper.DataElements.JSDataElementNumeric;

public class JSDataElementInteger
extends JSDataElementNumeric {
    private int intValue = 0;

    public JSDataElementInteger() {
        super.setTrimValue(true);
    }

    public JSDataElementInteger(String pstrValue) {
        super.setValue(pstrValue);
        super.setTrimValue(true);
        this.getInt();
    }

    public JSDataElementInteger(int pintValue) {
        this.intValue = pintValue;
        super.setTrimValue(true);
        this.setValue(pintValue);
    }

    public JSDataElementInteger(String pPstrValue, String pPstrDescription, int pPintSize, int pPintPos, String pPstrFormatString, String pPstrColumnHeader, String pPstrXMLTagName) {
        super(pPstrValue, pPstrDescription, pPintSize, pPintPos, pPstrFormatString, pPstrColumnHeader, pPstrXMLTagName);
    }

    @Override
    public void setValue(String pstrValue) {
        super.setValue(pstrValue);
        this.getInt();
    }

    public void setValue(int pintValue) {
        this.intValue = pintValue;
        super.setValue(new Integer(pintValue).toString());
    }

    public int getInt() {
        try {
            this.intValue = 0;
            String strT = super.getValue().trim();
            int intLen = strT.length();
            if (intLen > 0) {
                if (strT.endsWith("-")) {
                    strT = "-" + strT.substring(0, intLen - 1);
                } else if (strT.startsWith("+")) {
                    strT = strT.substring(1, intLen);
                } else if (strT.endsWith("+")) {
                    strT = strT.substring(0, intLen - 1);
                }
                this.intValue = Integer.parseInt(strT);
            }
        }
        catch (NumberFormatException e) {
            this.intValue = 0;
        }
        return this.intValue;
    }

    @Override
    public String getFormattedValue() {
        String strFormat = super.getFormatString();
        if (this.isNotEmpty(strFormat.trim())) {
            String strFormatted = String.format("%1$" + strFormat, this.getInt());
            strFormatted = strFormatted.trim();
            if (super.getMaxSize() != 0 && strFormatted.length() > super.getMaxSize()) {
                strFormatted = "";
                for (int i = 0; i < super.getMaxSize(); ++i) {
                    strFormatted = strFormatted + "*";
                }
            }
            return strFormatted;
        }
        return super.getValue();
    }

    @Override
    public void doInit() {
        super.setMaxSize(15);
        super.setFormatString("-,15d");
        super.description("Integer");
        super.columnHeader("Integer");
        super.xmlTagName("Integer");
    }
}

