/*
 * Decompiled with CFR 0.152.
 */
package com.sos.JSHelper.Options;

import com.sos.JSHelper.Logging.SOSHtmlLayout;
import com.sos.JSHelper.Options.JSOptionsClass;
import com.sos.JSHelper.Options.SOSOptionOutFileName;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.FileAppender;
import org.apache.logging.log4j.core.appender.FileManager;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.apache.logging.log4j.core.appender.RollingRandomAccessFileAppender;
import org.apache.logging.log4j.core.appender.rolling.RollingFileManager;
import org.apache.logging.log4j.core.appender.rolling.RollingRandomAccessFileManager;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.layout.HtmlLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.util.SOSString;

public class SOSOptionLogFileName
extends SOSOptionOutFileName {
    private static final long serialVersionUID = 144340120069043974L;
    private static Logger LOGGER = LoggerFactory.getLogger(SOSOptionLogFileName.class);
    private String htmlLogFile = "";
    public String ControlType = "file";

    public SOSOptionLogFileName(JSOptionsClass parent, String key, String description, String value, String defaultValue, boolean mandatory) {
        super(parent, key, description, value, defaultValue, mandatory);
    }

    public void setLogger(Logger log) {
        if (!this.isDirty() || log == null) {
            return;
        }
        try {
            LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
            LoggerConfig config = context.getConfiguration().getLoggerConfig(log.getName());
            boolean update = false;
            for (Map.Entry pair : config.getAppenders().entrySet()) {
                RollingFileAppender a;
                String newFilePattern;
                RollingFileAppender source;
                Appender app = (Appender)pair.getValue();
                if (app == null) continue;
                FileAppender.Builder<?> faBuilder = null;
                RollingFileAppender.Builder<?> rfaBuilder = null;
                RollingRandomAccessFileAppender.Builder<?> rrfaBuilder = null;
                String configuredFilePattern = null;
                if (app instanceof FileAppender) {
                    faBuilder = this.createBuilder((FileAppender)app);
                } else if (app instanceof RollingFileAppender) {
                    source = (RollingFileAppender)app;
                    configuredFilePattern = source.getFilePattern();
                    rfaBuilder = this.createBuilder(source);
                } else if (app instanceof RollingRandomAccessFileAppender) {
                    source = (RollingRandomAccessFileAppender)app;
                    configuredFilePattern = source.getFilePattern();
                    rrfaBuilder = this.createBuilder((RollingRandomAccessFileAppender)source);
                }
                if (faBuilder == null && rfaBuilder == null && rrfaBuilder == null) {
                    LOGGER.debug(String.format("[%s][skip]no File, RollingFile or RollingRandomAccessFile  appender found", app.getName()));
                    continue;
                }
                String fileName = this.getValue();
                if (app.getLayout() instanceof SOSHtmlLayout || app.getLayout() instanceof HtmlLayout) {
                    fileName = this.htmlLogFile = this.getValue().concat(".html");
                }
                app.stop();
                config.removeAppender(app.getName());
                if (faBuilder != null) {
                    faBuilder.withFileName(fileName);
                    FileAppender a2 = faBuilder.build();
                    a2.start();
                    config.addAppender((Appender)a2, Level.INFO, a2.getFilter());
                    config.setLevel(Level.INFO);
                    LOGGER.debug(String.format("[File][%s]%s", a2.getName(), fileName));
                    update = true;
                    continue;
                }
                if (rfaBuilder != null) {
                    rfaBuilder.withFileName(fileName);
                    newFilePattern = this.getNewFilePattern(fileName, configuredFilePattern);
                    if (!SOSString.isEmpty((String)newFilePattern)) {
                        rfaBuilder.withFilePattern(newFilePattern);
                    }
                    a = rfaBuilder.build();
                    a.start();
                    config.addAppender((Appender)a, Level.INFO, a.getFilter());
                    config.setLevel(Level.INFO);
                    LOGGER.debug(String.format("[RollingFile][%s][%s][%s]", a.getName(), fileName, a.getFilePattern()));
                    update = true;
                    continue;
                }
                if (rrfaBuilder == null) continue;
                rrfaBuilder.withFileName(fileName);
                newFilePattern = this.getNewFilePattern(fileName, configuredFilePattern);
                if (!SOSString.isEmpty((String)newFilePattern)) {
                    rrfaBuilder.withFilePattern(newFilePattern);
                }
                a = rrfaBuilder.build();
                a.start();
                config.addAppender((Appender)a, Level.INFO, a.getFilter());
                config.setLevel(Level.INFO);
                LOGGER.debug(String.format("[RollingRandomAccessFile][%s][%s][%s]", a.getName(), fileName, a.getFilePattern()));
                update = true;
            }
            if (update) {
                context.updateLoggers();
            }
        }
        catch (Throwable e) {
            LOGGER.error(e.toString(), e);
        }
    }

    private String getNewFilePattern(String fileName, String configuredFilePattern) {
        if (!SOSString.isEmpty((String)configuredFilePattern)) {
            String[] arr = configuredFilePattern.replaceAll("\\\\", "/").split("/");
            String oldFileNameWithPattern = arr[arr.length - 1];
            int pidx = oldFileNameWithPattern.indexOf("%");
            if (pidx > -1) {
                return fileName.concat(".").concat(oldFileNameWithPattern.substring(pidx));
            }
            pidx = oldFileNameWithPattern.lastIndexOf(".");
            if (pidx > -1) {
                return fileName.concat(oldFileNameWithPattern.substring(pidx));
            }
            return fileName;
        }
        return null;
    }

    private FileAppender.Builder<?> createBuilder(FileAppender source) {
        try {
            FileAppender.Builder b = FileAppender.newBuilder();
            b.setFilter(source.getFilter());
            b.setIgnoreExceptions(source.ignoreExceptions());
            b.setLayout(source.getLayout());
            b.setName(source.getName());
            b.setPropertyArray(source.getPropertyArray());
            b.withAdvertise(false);
            b.withImmediateFlush(source.getImmediateFlush());
            if (source.getManager() != null) {
                b.withAppend(((FileManager)source.getManager()).isAppend());
                b.withBufferSize(((FileManager)source.getManager()).getBufferSize());
                b.withCreateOnDemand(((FileManager)source.getManager()).isCreateOnDemand());
                b.withFileGroup(((FileManager)source.getManager()).getFileGroup());
                b.withFileOwner(((FileManager)source.getManager()).getFileOwner());
                b.withLocking(((FileManager)source.getManager()).isLocking());
            }
            return b;
        }
        catch (Throwable e) {
            LOGGER.error(e.toString(), e);
            return null;
        }
    }

    private RollingFileAppender.Builder<?> createBuilder(RollingFileAppender source) {
        try {
            RollingFileAppender.Builder b = RollingFileAppender.newBuilder();
            b.setFilter(source.getFilter());
            b.setIgnoreExceptions(source.ignoreExceptions());
            b.setLayout(source.getLayout());
            b.setName(source.getName());
            b.setPropertyArray(source.getPropertyArray());
            b.withAdvertise(false);
            b.withFilePattern(source.getFilePattern());
            b.withPolicy(source.getTriggeringPolicy());
            if (source.getManager() != null) {
                b.withAppend(((RollingFileManager)source.getManager()).isAppend());
                b.withBufferSize(((RollingFileManager)source.getManager()).getBufferSize());
                b.withCreateOnDemand(((RollingFileManager)source.getManager()).isCreateOnDemand());
                b.withFileGroup(((RollingFileManager)source.getManager()).getFileGroup());
                b.withFileOwner(((RollingFileManager)source.getManager()).getFileOwner());
                b.withImmediateFlush(source.getImmediateFlush());
                b.withLocking(((RollingFileManager)source.getManager()).isLocking());
                b.withStrategy(((RollingFileManager)source.getManager()).getRolloverStrategy());
            }
            return b;
        }
        catch (Throwable e) {
            LOGGER.error(e.toString(), e);
            return null;
        }
    }

    private RollingRandomAccessFileAppender.Builder<?> createBuilder(RollingRandomAccessFileAppender source) {
        try {
            RollingRandomAccessFileAppender.Builder b = RollingRandomAccessFileAppender.newBuilder();
            b.setFilter(source.getFilter());
            b.setIgnoreExceptions(source.ignoreExceptions());
            b.setLayout(source.getLayout());
            b.setName(source.getName());
            b.setPropertyArray(source.getPropertyArray());
            b.withAdvertise(false);
            b.withFilePattern(source.getFilePattern());
            if (source.getManager() != null) {
                b.withAppend(((RollingRandomAccessFileManager)source.getManager()).isAppend());
                b.withBufferSize(((RollingRandomAccessFileManager)source.getManager()).getBufferSize());
                b.withFileGroup(((RollingRandomAccessFileManager)source.getManager()).getFileGroup());
                b.withFileOwner(((RollingRandomAccessFileManager)source.getManager()).getFileOwner());
                b.withImmediateFlush(source.getImmediateFlush());
                b.withStrategy(((RollingRandomAccessFileManager)source.getManager()).getRolloverStrategy());
                b.withPolicy(((RollingRandomAccessFileManager)source.getManager()).getTriggeringPolicy());
            }
            return b;
        }
        catch (Throwable e) {
            LOGGER.error(e.toString(), e);
            return null;
        }
    }

    public String getHtmlLogFileName() {
        return SOSString.isEmpty((String)this.htmlLogFile) ? "" : this.htmlLogFile;
    }

    public void resetHTMLEntities() {
    }

    public String getContent() {
        return "";
    }
}

