/*
 * Decompiled with CFR 0.152.
 */
package com.sos.JSHelper.Options;

import com.sos.JSHelper.Options.JSOptionsClass;
import com.sos.JSHelper.Options.SOSOptionStringValueList;

public class SOSOptionTransferType
extends SOSOptionStringValueList {
    private static final long serialVersionUID = 1359502923543333601L;
    private TransferTypes type = TransferTypes.local;

    public SOSOptionTransferType(JSOptionsClass parent, String key, String description, String value, String defaultValue, boolean isMandatory) {
        super(parent, key, description, value, defaultValue, isMandatory);
        super.valueList(TransferTypes.getArray());
    }

    public void setValue(TransferTypes val) {
        this.type = val;
        super.setValue(this.type.name());
    }

    public boolean isLocal() {
        this.text2Enum();
        return this.type.equals((Object)TransferTypes.local);
    }

    public boolean isSFTP() {
        this.text2Enum();
        return this.type.equals((Object)TransferTypes.sftp);
    }

    public boolean isSSH() {
        this.text2Enum();
        return this.type.equals((Object)TransferTypes.ssh);
    }

    public boolean isFTP() {
        this.text2Enum();
        return this.type.equals((Object)TransferTypes.ftp);
    }

    public boolean isFTPS() {
        this.text2Enum();
        return this.type.equals((Object)TransferTypes.ftps);
    }

    public boolean isHTTP() {
        this.text2Enum();
        return this.type.equals((Object)TransferTypes.http) || this.type.equals((Object)TransferTypes.https);
    }

    public boolean isWEBDAV() {
        this.text2Enum();
        return this.type.equals((Object)TransferTypes.webdav);
    }

    public boolean isSMB() {
        this.text2Enum();
        return this.type.equals((Object)TransferTypes.smb);
    }

    private void text2Enum() {
        for (TransferTypes enuType : TransferTypes.values()) {
            if (!this.strValue.equalsIgnoreCase(enuType.name())) continue;
            this.type = enuType;
            break;
        }
    }

    public TransferTypes getEnum() {
        this.text2Enum();
        return this.type;
    }

    public static enum TransferTypes {
        local(1),
        ftp(2),
        ftps(3),
        sftp(4),
        http(5),
        https(6),
        webdav(7),
        webdavs(8),
        smb(9),
        ssh(100),
        zip(200),
        mq(300),
        smtp(400),
        imap(500);

        private final int numeric;

        private TransferTypes(int val) {
            this.numeric = val;
        }

        public static String[] getArray() {
            String[] arr = new String[TransferTypes.values().length];
            int i = 0;
            for (TransferTypes type : TransferTypes.values()) {
                arr[i++] = type.name();
            }
            return arr;
        }

        public int numeric() {
            return this.numeric;
        }
    }
}

