/*
 * Decompiled with CFR 0.152.
 */
package com.sos.JSHelper.io.Files;

import com.sos.JSHelper.Listener.JSListener;
import com.sos.JSHelper.io.Files.JSTextFile;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;

public class JSCsvFile
extends JSTextFile {
    private static final long serialVersionUID = 1L;
    private String[] strHeaders = null;
    private String[] strCurrentLine = null;
    private char chrColumnDelimiter = FIELD_DELIMITER;
    private char chrRecordDelimiter = BLOCK_DELIMITER;
    private final char chrValueDelimiter = VALUE_DELIMITER;
    private boolean flgIsNewline;
    private boolean flgIgnoreValueDelimiter = false;
    private boolean flgHeadersWritten = false;
    private boolean flgAlwaysSurroundFielJSithQuotes = true;
    private int lngNoOfFieldsInBuffer = 0;
    private int intFieldCount = 0;
    private int intRecordCount = 0;
    private boolean flgFieldCount = true;
    private boolean flgCheckColumnCount = true;
    public static String END_OF_LINE = new String("END_OF_LINE");
    public static char FIELD_DELIMITER = (char)59;
    public static char BLOCK_DELIMITER = (char)10;
    public static char VALUE_DELIMITER = (char)34;

    public JSCsvFile(String pstrFileName) {
        super(pstrFileName);
    }

    public JSCsvFile(String pstrFileName, JSListener objListener) {
        super(pstrFileName);
        this.registerMessageListener(objListener);
    }

    public JSCsvFile setColumnDelimiter(String pstrColumnDelimiter) {
        this.chrColumnDelimiter = pstrColumnDelimiter.toCharArray()[0];
        return this;
    }

    public char getColumnDelimiter() {
        return this.chrColumnDelimiter;
    }

    public void loadHeaders() throws Exception {
        if (this.strHeaders == null) {
            this.strHeaders = this.readCSVLine();
        }
    }

    public boolean isCheckColumnCount() {
        return this.flgCheckColumnCount;
    }

    public void setCheckColumnCount(boolean pflgCheckColumnCount) {
        this.flgCheckColumnCount = pflgCheckColumnCount;
    }

    public JSCsvFile setHeaders(String[] pstrHeaders) throws Exception {
        this.strHeaders = pstrHeaders;
        this.writeHeaders();
        return this;
    }

    public JSCsvFile setHeaders(ArrayList<String> fields) throws Exception {
        this.strHeaders = new String[fields.size()];
        for (int j = 0; j < fields.size(); ++j) {
            this.strHeaders[j] = fields.get(j);
        }
        this.writeHeaders();
        return this;
    }

    public JSCsvFile writeHeaders() throws Exception {
        if (!this.flgHeadersWritten && this.getNoOfCharsInBuffer() <= 0L) {
            this.append(this.strHeaders);
            this.flgHeadersWritten = true;
        }
        return this;
    }

    public String[] getHeaders() {
        return this.strHeaders;
    }

    public String[] readCSVLine() throws IOException {
        ArrayList<String> list = new ArrayList<String>();
        String str = null;
        int intColumnCount = 0;
        ++this.intRecordCount;
        while ((str = this.readCSVField()) != null) {
            if (END_OF_LINE.equalsIgnoreCase(str) && intColumnCount == this.intFieldCount) {
                this.flgFieldCount = false;
                break;
            }
            if (this.flgFieldCount) {
                ++this.intFieldCount;
            }
            ++intColumnCount;
            if (END_OF_LINE.equalsIgnoreCase(str)) {
                list.add("");
                break;
            }
            list.add(str);
        }
        if (intColumnCount != this.intFieldCount && this.flgCheckColumnCount) {
            this.message("WARN: problem in record " + this.intRecordCount + " - " + this.intFieldCount + " columns expected, but the record contains " + intColumnCount);
        }
        if (list.isEmpty() || intColumnCount != this.intFieldCount && this.flgCheckColumnCount) {
            return null;
        }
        return list.toArray(new String[0]);
    }

    public String readCSVField() throws IOException {
        if (this.flgIsNewline) {
            this.flgIsNewline = false;
            return END_OF_LINE;
        }
        StringBuilder stbBuilder = new StringBuilder();
        boolean flgFieldIsQuoted = false;
        int intLast = -1;
        int ch = this.getReader().read();
        if (ch == -1) {
            return null;
        }
        if (ch == this.chrValueDelimiter && !this.flgIgnoreValueDelimiter) {
            flgFieldIsQuoted = true;
        } else {
            if (ch == this.chrRecordDelimiter && !flgFieldIsQuoted) {
                return END_OF_LINE;
            }
            if (ch == this.chrColumnDelimiter && !flgFieldIsQuoted) {
                return "";
            }
            stbBuilder.append((char)ch);
        }
        while ((ch = this.getReader().read()) != -1) {
            if (ch == this.chrRecordDelimiter && !flgFieldIsQuoted) {
                int intL = stbBuilder.length();
                if (intL > 1 && stbBuilder.charAt(stbBuilder.length() - 1) == '\r') {
                    String strB = stbBuilder.substring(0, stbBuilder.length() - 1);
                    stbBuilder = new StringBuilder(strB);
                    ++this.lngNoOfLinesRead;
                }
                this.flgIsNewline = true;
                break;
            }
            if (flgFieldIsQuoted && ch == this.chrValueDelimiter) {
                if (intLast == ch) {
                    intLast = -1;
                    stbBuilder.append(this.chrValueDelimiter);
                    continue;
                }
                intLast = ch;
                continue;
            }
            if (ch == this.chrColumnDelimiter && (!flgFieldIsQuoted || intLast == this.chrValueDelimiter)) break;
            stbBuilder.append((char)ch);
        }
        return this.removeNewLineChar(stbBuilder);
    }

    private String removeNewLineChar(StringBuilder pstrB) {
        String strB = pstrB.toString();
        int intL = pstrB.length();
        if (intL > 1 && pstrB.charAt(--intL) == '\r') {
            strB = pstrB.substring(1, pstrB.length());
        }
        return strB;
    }

    public String readCSVField(String pstrColumnName) throws Exception {
        if (this.strHeaders == null) {
            this.loadHeaders();
        }
        if (this.strCurrentLine == null) {
            this.nextBlock();
            if (this.strCurrentLine == null) {
                return null;
            }
        }
        int idx = -1;
        for (int i = 0; i < this.strHeaders.length; ++i) {
            if (!pstrColumnName.equalsIgnoreCase(this.strHeaders[i])) continue;
            idx = i;
        }
        String strFieldValue = null;
        if (idx != -1) {
            strFieldValue = this.strCurrentLine[idx];
            this.strCurrentLine = null;
        } else {
            this.message(String.format("ColumnName '%1$s' not found in Headers.", pstrColumnName));
        }
        return strFieldValue;
    }

    public boolean nextBlock() throws IOException {
        this.strCurrentLine = this.readCSVLine();
        return this.strCurrentLine != null;
    }

    public JSCsvFile append(Object[] fields) throws Exception {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < fields.length; ++i) {
            builder.append(this.maskSpecialChars(String.valueOf(fields[i])));
            if (i >= fields.length - 1) continue;
            builder.append(this.chrColumnDelimiter);
        }
        this.write(builder.toString());
        return this;
    }

    public JSCsvFile append(Vector<String> fields) throws Exception {
        StringBuilder builder = new StringBuilder();
        int intSize = fields.size();
        for (int i = 0; i < intSize; ++i) {
            builder.append(this.maskSpecialChars(String.valueOf(fields.elementAt(i))));
            if (i >= intSize - 1) continue;
            builder.append(this.chrColumnDelimiter);
        }
        this.write(builder.toString());
        return this;
    }

    public JSCsvFile append(Iterator<String> fields) throws Exception {
        StringBuilder builder = new StringBuilder();
        while (fields.hasNext()) {
            String elem = fields.next();
            builder.append(this.maskSpecialChars(elem));
            if (!fields.hasNext()) continue;
            builder.append(this.chrColumnDelimiter);
        }
        this.write(builder.toString());
        return this;
    }

    public JSCsvFile addCellValues(Object[] fields) throws Exception {
        for (Object field : fields) {
            this.addCellValue(String.valueOf(field));
        }
        return this;
    }

    public JSCsvFile addCellValues(Iterator<String> fields) throws Exception {
        this.append(fields);
        return this;
    }

    @Override
    public JSCsvFile newLine() throws Exception {
        super.newLine();
        this.lngNoOfFieldsInBuffer = 0;
        return this;
    }

    public JSCsvFile addCellValue(String pstrS) throws Exception {
        if (this.getNoOfCharsInBuffer() > 0L || this.lngNoOfFieldsInBuffer > 0) {
            this.outChar(this.chrColumnDelimiter);
        }
        this.outString(this.maskSpecialChars(pstrS));
        ++this.lngNoOfFieldsInBuffer;
        return this;
    }

    private String maskSpecialChars(String strT) {
        boolean flgSurroundWithQuotes = false;
        String strDelim = String.valueOf(this.chrValueDelimiter);
        int iPos = strT.indexOf(this.chrValueDelimiter);
        if (iPos >= 0) {
            strT = strT.replace(strDelim, strDelim + strDelim);
            flgSurroundWithQuotes = true;
        }
        if (!strT.isEmpty() && this.flgAlwaysSurroundFielJSithQuotes) {
            flgSurroundWithQuotes = true;
        }
        if (flgSurroundWithQuotes || strT.indexOf(this.chrColumnDelimiter) > 0 || strT.indexOf(13) > 0 || strT.indexOf(10) > 0) {
            strT = strDelim + strT + strDelim;
        }
        return strT;
    }

    public boolean isAlwaysSurroundFielJSithQuotes() {
        return this.flgAlwaysSurroundFielJSithQuotes;
    }

    public JSCsvFile setAlwaysSurroundFielJSithQuotes(boolean pflgAlwaysSurroundFielJSithQuotes) throws Exception {
        this.flgAlwaysSurroundFielJSithQuotes = pflgAlwaysSurroundFielJSithQuotes;
        return this;
    }

    public boolean isIgnoreValueDelimiter() {
        return this.flgIgnoreValueDelimiter;
    }

    public JSCsvFile setIgnoreValueDelimiter(boolean pflgIgnoreValueDelimiter) throws Exception {
        this.flgIgnoreValueDelimiter = pflgIgnoreValueDelimiter;
        return this;
    }

    public void setRecordDelimiter(char pchrRecordDelimiter) {
        this.chrRecordDelimiter = pchrRecordDelimiter;
    }

    public void write(String[] pstrCells) throws Exception {
        String strT = "";
        for (int i = 0; i < pstrCells.length; ++i) {
            pstrCells[i] = pstrCells[i] == null ? "" : this.adjustCsvValue(pstrCells[i]);
            strT = strT + pstrCells[i] + FIELD_DELIMITER;
        }
        if (this.bufWriter == null) {
            this.getWriter();
        }
        this.bufWriter.write(strT);
    }

    public void writeLine(String[] pstrCells) throws Exception {
        this.write(pstrCells);
        this.writeLine("");
    }

    public String adjustCsvValue(String pstrV) {
        String strT = pstrV;
        if (pstrV.indexOf(FIELD_DELIMITER) > 0) {
            strT = VALUE_DELIMITER + strT + VALUE_DELIMITER;
        }
        return strT;
    }
}

