/*
 * Decompiled with CFR 0.152.
 */
package com.sos.JSHelper.io.Files;

import com.sos.JSHelper.Basics.JSToolBox;
import com.sos.JSHelper.DataElements.JSDataElementDate;
import com.sos.JSHelper.DataElements.JSDataElementTimeStampISO;
import com.sos.JSHelper.Exceptions.JobSchedulerException;
import com.sos.JSHelper.Listener.JSListener;
import com.sos.JSHelper.Options.SOSOptionFolderName;
import com.sos.i18n.annotation.I18NResourceBundle;
import com.sos.localization.Messages;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.util.SOSGZip;

@I18NResourceBundle(baseName="com_sos_JSHelper_Messages", defaultLocale="en")
public class JSFile
extends File
implements JSListener {
    protected String strFileName;
    protected File fleFile;
    protected FileReader fleFileReader;
    protected BufferedReader bufReader;
    protected long lngNoOfLinesRead = 0L;
    protected String strCharSet4OutputFile = null;
    protected String strCharSet4InputFile = null;
    protected BufferedWriter bufWriter = null;
    protected boolean flgIsAppendMode = false;
    private static final Logger LOGGER = LoggerFactory.getLogger(JSFile.class);
    private static final String ConDefaultExtension4BackupFile = ".bak";
    private static final long serialVersionUID = -1430552107244301112L;
    private final char[] charArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private FileWriter fleFileWriter = null;
    private StringBuffer strRecordBuffer;
    private String strPushBackBuffer = "";
    private long lngNoOfLinesWritten = 0L;
    private long lngNoOfCharsInBuffer = 0L;
    private RandomAccessFile randomFile = null;
    private FileLock fleLock = null;
    private boolean flgFileIsLocked = false;
    private boolean flgIsExclusive = false;
    private JSFile fleExclusiveFile = null;
    private String strExclusiveFootPrint = "";
    private boolean flgIsZipfile = false;
    private Messages Messages = null;
    private JSListener JSListener;
    public static final String conPropertySOS_JSFILE_PREFIX_4_TEMPFILE = "sos.jsfile.prefix.4.tempfile";
    public static final String conPropertySOS_JSFILE_EXTENSION_4_TEMPFILE = "sos.jsfile.extension.4.tempfile";
    public static final String conPropertySOS_JSFILE_EXTENSION_4_EXCLUSIVEFILE = "sos.jsfile.extension.4.exclusivefile";
    public static final String conPropertySOS_JSFILE_EXTENSION_4_BACKUPFILE = "sos.jsfile.extension.4.backupfile";
    public SOSOptionFolderName BackupFolderName = new SOSOptionFolderName(null, "BackupFolderName", "Name of Folder for Backup of this file", "", "", false);
    final String JSH_E_0010 = "JSH_E_0010";
    final String JSH_E_0020 = "JSH_E_0020";
    final String JSH_E_0040 = "JSH_E_0040";
    final String JSH_E_0050 = "JSH_E_0050";
    final String JSH_E_0060 = "JSH_E_0060";
    final String JSH_E_0070 = "JSH_E_0070";
    final String JSH_E_0090 = "JSJ_E_0090";
    final String JSH_E_0140 = "JSH_E_0140";
    final String JSH_I_0010 = "JSH_I_0010";
    final String JSH_I_0020 = "JSH_I_0020";
    final String JSH_I_0030 = "JSH_I_0030";
    final String JSH_I_0040 = "JSH_I_0040";
    final String JSH_I_0060 = "JSH_I_0060";
    final String JSH_I_0070 = "JSH_I_0070";
    final String JSH_I_0080 = "JSH_I_0080";
    final String JSH_I_0090 = "JSH_I_0090";
    final String JSH_I_0100 = "JSH_I_0100";
    final String JSH_I_0110 = "JSH_I_0110";
    final String JSH_I_0120 = "JSH_I_0120";
    final String JSH_I_0130 = "JSH_I_0130";
    String JSH_I_0150 = "JSH_I_0150";

    public JSFile(String pstrFileAndPathName) {
        super(pstrFileAndPathName.replace("file:/", ""));
        this.strFileName = pstrFileAndPathName;
        this.doInit();
    }

    public JSFile(File parent, String child) {
        super(parent, child);
        this.strFileName = this.getAbsolutePath();
        this.doInit();
    }

    public JSFile(String parent, String child) {
        super(parent, child);
        this.doInit();
    }

    public JSFile(URI pobjUri) throws MalformedURLException {
        super(pobjUri);
        this.doInit();
        this.strFileName = pobjUri.toURL().getFile();
    }

    private void doInit() {
        try {
            this.strFileName = this.getAbsolutePath();
            this.fleFile = this;
            int i = this.strFileName.indexOf("//");
            if (i > 0) {
                if (this.strFileName.startsWith("local:")) {
                    this.strFileName = this.strFileName.replace("local:", "file:");
                }
                URL objURL = new URL(this.strFileName);
                this.strFileName = objURL.getFile();
                LOGGER.info(objURL.getFile());
                LOGGER.info(objURL.getPath());
            } else {
                this.strFileName = this.getAbsolutePath();
            }
            JSToolBox objT = new JSToolBox("com_sos_JSHelper_Messages");
            this.Messages = objT.getMessageObject();
        }
        catch (Exception e) {
            LOGGER.error("doInit()", (Throwable)e);
        }
    }

    public String createZipFile(String pstrPathName) {
        String gzipFilename = this.addFileSeparator(pstrPathName) + this.getName().concat(".gz");
        try {
            File gzipFile = new File(gzipFilename);
            SOSGZip.compressFile((File)this, (File)gzipFile);
            gzipFile.setLastModified(this.lastModified());
            LOGGER.debug(String.format("file %1$s compressed to %2$s", this.getAbsolutePath(), gzipFilename));
        }
        catch (Exception e) {
            String strT = String.format("Error during compress for file %1$s", gzipFilename);
            LOGGER.error(strT);
            throw new JobSchedulerException(strT, e);
        }
        return gzipFilename;
    }

    public String addFileSeparator(String str) {
        return str.endsWith("/") || str.endsWith("\\") ? str : str + "/";
    }

    public void setZipFile(boolean pflgIsZipFile) {
        this.flgIsZipfile = pflgIsZipFile;
    }

    protected BufferedReader getReader() throws IOException {
        if (this.bufReader == null) {
            if (this.checkExclusiveDeny()) {
                throw new JobSchedulerException(this.Messages.getMsg("JSH_E_0070", this.strFileName, this.strExclusiveFootPrint));
            }
            if (this.randomFile != null) {
                this.fleFileReader = new FileReader(this.randomFile.getFD());
            } else if (this.isZipFile()) {
                GZIPInputStream objGZ = new GZIPInputStream(new FileInputStream(this));
                this.bufReader = this.strCharSet4InputFile != null ? new BufferedReader(new InputStreamReader((InputStream)objGZ, this.strCharSet4InputFile)) : new BufferedReader(new InputStreamReader(objGZ));
            } else {
                this.fleFileReader = new FileReader(this);
                this.bufReader = this.strCharSet4InputFile == null ? new BufferedReader(this.fleFileReader) : new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this), this.strCharSet4InputFile));
            }
            LOGGER.debug(this.Messages.getMsg("JSH_I_0090", this.strFileName, this.strCharSet4InputFile));
        }
        return this.bufReader;
    }

    public boolean isZipFile() {
        boolean flgRet = false;
        if (this.flgIsZipfile || this.strFileName.toLowerCase().endsWith(".gz") || this.strFileName.toLowerCase().endsWith(".zip")) {
            flgRet = true;
        }
        return flgRet;
    }

    public void setCharSet4InputFile(String pstrCharSet4InputFile) {
        this.strCharSet4InputFile = pstrCharSet4InputFile;
    }

    public String getCharSet4InputFile() {
        return this.strCharSet4InputFile;
    }

    public String copyTimeStamp() throws Exception {
        try {
            String strNewFileName = null;
            String strTimeStamp = this.getTimeStamp();
            int i = this.strFileName.lastIndexOf(".");
            strNewFileName = i > 0 ? this.strFileName.substring(0, i) + "-" + strTimeStamp + this.strFileName.substring(i) : this.strFileName + "-" + strTimeStamp;
            this.copy(strNewFileName);
            return strNewFileName;
        }
        catch (Exception e) {
            throw new JobSchedulerException("CopyTimeStamp Error", e);
        }
    }

    public String createBackup() {
        String strExtension4BackupFile = System.getProperty(conPropertySOS_JSFILE_EXTENSION_4_BACKUPFILE, ConDefaultExtension4BackupFile);
        return this.doCreateBackUp(strExtension4BackupFile);
    }

    public String createBackup(String pstrExtension4BackupFile) throws Exception {
        return this.doCreateBackUp(pstrExtension4BackupFile);
    }

    private String doCreateBackUp(String pstrExtension4BackupFileName) {
        String strNewFileName = "";
        String strBackupFolderName = this.BackupFolderName.getValue();
        strNewFileName = !strBackupFolderName.isEmpty() ? strBackupFolderName + this.getName() + pstrExtension4BackupFileName : this.strFileName + pstrExtension4BackupFileName;
        try {
            this.copy(strNewFileName);
        }
        catch (Exception e) {
            throw new JobSchedulerException("problems with createbackup " + e.getMessage(), e);
        }
        LOGGER.debug(this.Messages.getMsg("JSH_I_0120", strNewFileName));
        return strNewFileName;
    }

    private String getTimeStamp() {
        Locale currentLocale = new Locale("de", "DE");
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd-H-mm-ss", currentLocale);
        return formatter.format(new Date());
    }

    public boolean isOlderThan(long plngCompareTo) {
        boolean flgR = false;
        long interval = System.currentTimeMillis() - this.lastModified();
        if (interval > plngCompareTo) {
            flgR = true;
        }
        return flgR;
    }

    public JSFile move(String pstrNewFileName) throws Exception {
        JSFile RetVal = null;
        File fleNewFile = new File(pstrNewFileName);
        if (fleNewFile.exists()) {
            LOGGER.debug(this.Messages.getMsg("JSH_I_0130", fleNewFile.getAbsoluteFile()));
            fleNewFile.delete();
        }
        this.copy(pstrNewFileName);
        try {
            this.delete();
            LOGGER.info(this.Messages.getMsg("JSH_I_0090", this.getAbsoluteFile()));
        }
        catch (Exception e) {
            LOGGER.error(this.Messages.getMsg("JSJ_E_0090", this.getName()));
            throw e;
        }
        return RetVal;
    }

    public void renameTimeStamp() {
    }

    public void mustExist() throws Exception {
        if (!this.exists()) {
            String s = this.Messages.getMsg("JSH_E_0140", this.strFileName);
            LOGGER.debug(s);
            throw new Exception(s);
        }
    }

    public boolean getAppendMode() {
        return this.flgIsAppendMode;
    }

    public JSFile setAppendMode(boolean pflgIsAppendMode) {
        this.flgIsAppendMode = pflgIsAppendMode;
        return this;
    }

    protected BufferedWriter getWriter() throws IOException {
        if (this.bufWriter == null) {
            if (this.checkExclusiveDeny()) {
                throw new IOException(String.format("JSH_E_0070", this.strFileName, this.strExclusiveFootPrint));
            }
            this.fleFileWriter = new FileWriter((File)this, this.flgIsAppendMode);
            if (this.strCharSet4OutputFile == null) {
                if (this.isZipFile()) {
                    GZIPOutputStream objGZ = new GZIPOutputStream(new FileOutputStream(this));
                    this.bufWriter = this.strCharSet4OutputFile != null ? new BufferedWriter(new OutputStreamWriter((OutputStream)objGZ, this.strCharSet4OutputFile)) : new BufferedWriter(new OutputStreamWriter(objGZ));
                } else {
                    this.bufWriter = new BufferedWriter(this.fleFileWriter);
                    LOGGER.debug(this.Messages.getMsg("JSH_I_0060", this.strFileName));
                }
            } else {
                this.bufWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this), this.strCharSet4OutputFile));
                LOGGER.debug(this.Messages.getMsg("JSH_I_0070", this.strFileName, this.strCharSet4InputFile));
            }
        }
        return this.bufWriter;
    }

    public boolean isExclusive() {
        return this.flgIsExclusive;
    }

    public JSFile newLine() throws Exception {
        this.writeLine("");
        this.lngNoOfCharsInBuffer = 0L;
        return this;
    }

    public long getNoOfCharsInBuffer() {
        return this.lngNoOfCharsInBuffer;
    }

    public JSFile outChar(char pchrC) throws IOException {
        this.bufWriter.write(pchrC);
        ++this.lngNoOfCharsInBuffer;
        return this;
    }

    public void outString(String pstrLine) throws Exception {
        if (this.bufWriter == null) {
            this.getWriter();
        }
        this.bufWriter.write(pstrLine);
        this.lngNoOfCharsInBuffer += (long)pstrLine.length();
    }

    public void write(String pstrLine) throws Exception {
        this.writeLine(pstrLine);
    }

    public JSFile writeLine(String pstrLine) throws IOException {
        if (this.bufWriter == null) {
            this.getWriter();
        }
        String strBuff = pstrLine + System.getProperty("line.separator");
        if (this.randomFile == null) {
            this.bufWriter.write(strBuff);
            this.bufWriter.flush();
        } else {
            this.randomFile.writeBytes(strBuff);
        }
        ++this.lngNoOfLinesWritten;
        return this;
    }

    public void writeLine() throws IOException, Exception {
        this.writeLine("");
    }

    public StringBuffer getLine() {
        StringBuffer strSB = new StringBuffer();
        try {
            if (!this.strPushBackBuffer.isEmpty()) {
                strSB.append(this.strPushBackBuffer);
                this.strPushBackBuffer = "";
                this.strRecordBuffer = strSB;
            } else {
                String strT;
                if (this.bufReader == null) {
                    this.getReader();
                }
                if ((strT = this.bufReader.readLine()) != null) {
                    ++this.lngNoOfLinesRead;
                    this.strRecordBuffer = strSB = new StringBuffer(strT);
                } else {
                    this.bufReader.close();
                    this.bufReader = null;
                    strSB = null;
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("GetLine() " + e.getMessage(), (Throwable)e);
            strSB = null;
        }
        return strSB;
    }

    public void setPushBack() {
        this.strPushBackBuffer = this.strRecordBuffer.toString();
    }

    public void copy(JSFile pobjTargetFile) {
        try {
            this.copy(pobjTargetFile.getAbsolutePath());
        }
        catch (JobSchedulerException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JobSchedulerException(e);
        }
    }

    public void copy(String pstrTargetFileName) throws Exception {
        String conMethodName = "JSFile::copy";
        File infile = new File(this.strFileName);
        if (!infile.getAbsoluteFile().exists()) {
            this.signalError(String.format("%1$s: File '%2$s' not exist. copy not possible", "JSFile::copy", this.strFileName));
            return;
        }
        File outfile = new File(pstrTargetFileName);
        if (infile.getCanonicalPath().equals(outfile.getCanonicalPath())) {
            this.message(String.format("%3$s: File '%1$s' is equal to '%2$s'. copy is useless", this.strFileName, pstrTargetFileName, "JSFile::copy"));
            return;
        }
        try {
            FileOutputStream out = new FileOutputStream(outfile);
            try {
                FileInputStream in = new FileInputStream(infile);
                this.executeCopy(in, out);
            }
            catch (FileNotFoundException e) {
                this.signalError(String.format("%1$s: File '%2$s' not exist. can not copy to '%3$s'", "JSFile::copy", this.strFileName, pstrTargetFileName));
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            this.signalError(this.Messages.getMsg("JSH_E_0060", "JSFile::copy", this.getName(), pstrTargetFileName));
        }
        LOGGER.debug(this.Messages.getMsg("JSH_I_0080", this.strFileName, pstrTargetFileName, "JSFile::copy"));
    }

    public void replaceWith(String strReplaceWhatAsRegEx, String strReplaceWith) throws Exception {
        String conMethodName = "JSFile::ReplaceWith";
        File infile = this.fleFile;
        if (!infile.exists()) {
            this.signalError(String.format("%1$s: File '%2$s' not exist. nothing to do", "JSFile::ReplaceWith", this.strFileName));
            return;
        }
        File fleTempfile = File.createTempFile("JSFile", ".tmp");
        try {
            FileInputStream in = new FileInputStream(infile);
            FileOutputStream out = new FileOutputStream(fleTempfile);
            this.executeReplace(in, out, strReplaceWhatAsRegEx, strReplaceWith);
            this.fleFile.delete();
            in = new FileInputStream(fleTempfile);
            out = new FileOutputStream(infile);
            this.executeCopy(in, out);
            fleTempfile.delete();
        }
        catch (FileNotFoundException e) {
            this.signalError(String.format("%1$s: File '%2$s' not exist. nothing to do", "JSFile::ReplaceWith", this.strFileName));
        }
        catch (Exception e) {
            this.signalError(String.format("%1$s: replace not succesfull for file '%2$s' ", "JSFile::ReplaceWith", this.getName()));
        }
        this.message(String.format("%1$s: Replacing in File '%2$s' done ", "JSFile::ReplaceWith", this.strFileName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeReplace(FileInputStream in, FileOutputStream out, String strReplaceWhatAsRegEx, String strReplaceWith) throws IOException {
        int intBuffsize = 4096;
        FileInputStream fileInputStream = in;
        synchronized (fileInputStream) {
            FileOutputStream fileOutputStream = out;
            synchronized (fileOutputStream) {
                int bytesRead;
                byte[] buffer = new byte[4096];
                while ((bytesRead = in.read(buffer)) != -1) {
                    if (bytesRead < 4096) {
                        byte[] tmpB = new byte[bytesRead];
                        tmpB = buffer;
                        buffer = new byte[bytesRead];
                        for (int i = 0; i < bytesRead; ++i) {
                            buffer[i] = tmpB[i];
                        }
                    }
                    String strLine = new String(buffer);
                    strLine = strLine.replaceAll(strReplaceWhatAsRegEx, strReplaceWith);
                    byte[] outB = new byte[4096 + strReplaceWith.length()];
                    outB = strLine.getBytes();
                    out.write(outB, 0, strLine.length());
                }
            }
        }
        in.close();
        out.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long in2out(FileInputStream in, FileOutputStream out) throws IOException {
        long lngBytesCopies = 0L;
        FileInputStream fileInputStream = in;
        synchronized (fileInputStream) {
            FileOutputStream fileOutputStream = out;
            synchronized (fileOutputStream) {
                int bytesRead;
                byte[] buffer = new byte[256];
                while ((bytesRead = in.read(buffer)) != -1) {
                    out.write(buffer, 0, bytesRead);
                    lngBytesCopies += (long)bytesRead;
                }
            }
        }
        return lngBytesCopies;
    }

    private long executeCopyWOClose(FileInputStream in, FileOutputStream out) throws IOException {
        return this.in2out(in, out);
    }

    private long executeCopy(FileInputStream in, FileOutputStream out) throws IOException {
        long lngBytesCopied = this.in2out(in, out);
        in.close();
        out.close();
        return lngBytesCopied;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeCopy(FileInputStream in, PrintStream out) throws IOException {
        FileInputStream fileInputStream = in;
        synchronized (fileInputStream) {
            PrintStream printStream = out;
            synchronized (printStream) {
                int bytesRead;
                byte[] buffer = new byte[1024];
                while ((bytesRead = in.read(buffer)) != -1) {
                    out.write(buffer, 0, bytesRead);
                }
            }
        }
        in.close();
    }

    public String file2String() {
        return this.getContent();
    }

    public String getContent() {
        BufferedReader fin;
        String strB = "";
        try {
            fin = this.getReader();
        }
        catch (IOException e1) {
            throw new JobSchedulerException(e1.getMessage(), e1);
        }
        int lngFileSize = 0;
        try {
            int bytesRead;
            char[] buffer = new char[4096];
            while ((bytesRead = fin.read(buffer)) != -1) {
                lngFileSize += bytesRead;
                strB = strB + new String(buffer);
            }
        }
        catch (IOException e) {
            LOGGER.error("getContent() - " + e.getMessage(), (Throwable)e);
            throw new JobSchedulerException("Error in JSFile", e);
        }
        finally {
            try {
                if (fin != null) {
                    fin.close();
                    fin = null;
                }
            }
            catch (IOException e) {
                fin = null;
            }
        }
        return strB.substring(0, lngFileSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpAscii(PrintStream out) {
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(this.strFileName);
            this.executeCopy(fin, out);
        }
        catch (IOException e) {
            LOGGER.error("dumpAscii(PrintStream) - " + e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (fin != null) {
                    fin.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpAscii(FileOutputStream out) {
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(this.strFileName);
            this.executeCopy(fin, out);
        }
        catch (IOException e) {
            LOGGER.error("dumpAscii(FileOutputStream) - " + e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (fin != null) {
                    fin.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public String byte2String(byte[] content) {
        StringBuilder buffer = new StringBuilder(content.length * 2);
        for (byte element : content) {
            buffer.append(this.charArray[(0xF0 & element) >> 4]);
            buffer.append(this.charArray[0xF & element]);
        }
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpDecimal(String filename) {
        FileInputStream fin = null;
        byte[] buffer = new byte[16];
        boolean end = false;
        try {
            fin = new FileInputStream(filename);
            while (!end) {
                int bytesRead;
                int r;
                for (bytesRead = 0; bytesRead < buffer.length; bytesRead += r) {
                    r = fin.read(buffer, bytesRead, buffer.length - bytesRead);
                    if (r != -1) continue;
                    end = true;
                    break;
                }
                for (int i = 0; i < bytesRead; ++i) {
                    int dec = buffer[i];
                    if (dec < 0) {
                        dec = 256 + dec;
                    }
                    if (dec < 10) {
                        LOGGER.debug("dumpDecimal(String) - 00" + dec + " ");
                        continue;
                    }
                    if (dec < 100) {
                        LOGGER.debug("dumpDecimal(String) - 0" + dec + " ");
                        continue;
                    }
                    LOGGER.debug("dumpDecimal(String) - " + dec + " ");
                }
                LOGGER.debug("dumpDecimal(String)");
            }
        }
        catch (IOException e) {
            LOGGER.error("dumpDecimal(String) - " + e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (fin != null) {
                    fin.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpHex(PrintStream out) {
        BufferedReader fin = null;
        char[] buffer = new char[24];
        boolean end = false;
        try {
            fin = this.getReader();
            while (!end) {
                int bytesRead;
                int r;
                for (bytesRead = 0; bytesRead < buffer.length; bytesRead += r) {
                    r = fin.read(buffer, bytesRead, buffer.length - bytesRead);
                    if (r != -1) continue;
                    end = true;
                    break;
                }
                for (int i = 0; i < bytesRead; ++i) {
                    int hex = buffer[i];
                    if (hex < 0) {
                        hex = 256 + hex;
                    }
                    if (hex >= 16) {
                        out.print(Integer.toHexString(hex) + " ");
                        continue;
                    }
                    out.print("0" + Integer.toHexString(hex) + " ");
                }
                out.println();
            }
        }
        catch (IOException e) {
            LOGGER.error("dumpHex(PrintStream) - " + e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (fin != null) {
                    fin.close();
                    fin = null;
                }
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public void message(String pstrMsg) {
        if (this.JSListener != null) {
            this.JSListener.message(pstrMsg);
        } else {
            LOGGER.debug("message(String) - " + pstrMsg);
        }
    }

    @Deprecated
    public void registerMessageListener(JSListener l) {
        this.JSListener = l;
    }

    public void signalAbort(String strS) {
        String strT = " ###ProgramAbort### ";
        strT = strT + strS + strS;
        LOGGER.error(strT);
        throw new JobSchedulerException(strT);
    }

    public void signalInfo(String strS) {
        LOGGER.info(strS);
    }

    public void signalError(String strS) {
        String strT = " ### Error ### ";
        strT = strT + strS + strS;
        LOGGER.error(strT);
        throw new JobSchedulerException(strT);
    }

    public void close() throws IOException {
        String conMethodName = "JSFile::close";
        if (this.bufWriter != null) {
            this.bufWriter.flush();
            this.bufWriter.close();
            this.bufWriter = null;
            NumberFormat fmt = NumberFormat.getInstance();
            fmt.setGroupingUsed(true);
            String strT = this.Messages.getMsg("JSH_I_0020", this.fleFile.getAbsoluteFile(), fmt.format(this.fleFile.length()), "JSFile::close");
            LOGGER.debug(strT);
            LOGGER.debug(this.Messages.getMsg("JSH_I_0030", this.strFileName, this.lngNoOfLinesWritten, "JSFile::close"));
        } else if (this.bufReader != null) {
            this.bufReader.close();
            this.bufReader = null;
            LOGGER.debug(this.Messages.getMsg("JSH_I_0040", this.strFileName, this.lngNoOfLinesRead, "JSFile::close"));
        }
        this.doUnlock();
        this.doReleaseExclusive();
    }

    public static String createTempFileName() {
        String strTempFileNameExtension = System.getProperty(conPropertySOS_JSFILE_EXTENSION_4_TEMPFILE, ".tmp");
        String strTempFileNamePrefix = System.getProperty(conPropertySOS_JSFILE_PREFIX_4_TEMPFILE, "SOS_");
        String strTempFileName = null;
        try {
            File objF = File.createTempFile(strTempFileNamePrefix, strTempFileNameExtension);
            objF.deleteOnExit();
            strTempFileName = objF.getAbsoluteFile().getAbsolutePath();
            strTempFileName = strTempFileName.replaceAll("\\\\", "/");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return strTempFileName;
    }

    public static JSFile createTempFile() {
        String strTempFileName = JSFile.createTempFileName();
        JSFile tempFile = new JSFile(strTempFileName);
        tempFile.deleteOnExit();
        return tempFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long appendFile(String pstrFileName) throws Exception {
        long lngBytesWritten;
        block16: {
            String conMethodName = "JSFile::AppendFile";
            lngBytesWritten = 0L;
            FileInputStream in = null;
            FileOutputStream out = null;
            String strFileN = this.getAbsolutePath();
            File objFile2Append = new File(strFileN);
            if (!objFile2Append.getAbsoluteFile().exists()) {
                this.signalError(this.Messages.getMsg("JSH_E_0010", "JSFile::AppendFile", strFileN));
                return -1L;
            }
            JSFile tempFile = JSFile.createTempFile();
            try {
                File AFile;
                block15: {
                    out = new FileOutputStream(tempFile);
                    try {
                        AFile = new File(pstrFileName);
                        if (!AFile.getAbsoluteFile().exists()) {
                            this.signalError(this.Messages.getMsg("JSH_E_0010", "JSFile::AppendFile", pstrFileName));
                            tempFile.delete();
                            long l = -1L;
                            return l;
                        }
                        if (!AFile.getAbsoluteFile().getAbsolutePath().equalsIgnoreCase(strFileN)) break block15;
                    }
                    catch (FileNotFoundException e) {
                        this.signalError(this.Messages.getMsg("JSH_E_0040", "JSFile::AppendFile", pstrFileName, strFileN));
                        break block16;
                    }
                    catch (Exception e) {
                        if (in != null) {
                            in.close();
                        }
                        out.close();
                        throw e;
                    }
                    this.signalError(this.Messages.getMsg("JSH_E_0020", "JSFile::AppendFile", strFileN, pstrFileName));
                    tempFile.delete();
                    long l = -1L;
                    return l;
                }
                in = new FileInputStream(objFile2Append);
                lngBytesWritten += this.executeCopyWOClose(in, out);
                in.close();
                in = new FileInputStream(AFile);
                lngBytesWritten += this.executeCopyWOClose(in, out);
                in.close();
                out.close();
                this.message(this.Messages.getMsg("JSH_I_0010", "JSFile::AppendFile", pstrFileName, strFileN));
                objFile2Append.delete();
                tempFile.renameTo(objFile2Append);
                tempFile = null;
                long l = lngBytesWritten;
                return l;
            }
            catch (Exception e) {
                LOGGER.error("AppendFile(String) " + e.getMessage(), (Throwable)e);
                this.signalError(this.Messages.getMsg("JSH_E_0050", "JSFile::AppendFile", this.getName(), pstrFileName));
            }
            finally {
                if (tempFile != null) {
                    tempFile.delete();
                    tempFile = null;
                }
            }
        }
        return lngBytesWritten;
    }

    public JSFile send2FtpServer(HashMap<String, String> settings) throws Exception {
        return this;
    }

    public boolean compare(JSFile pfleFile) throws Exception {
        int char2;
        int char1;
        BufferedReader objReader1 = this.getReader();
        BufferedReader objReader2 = pfleFile.getReader();
        if (pfleFile.length() != this.length()) {
            return false;
        }
        do {
            if ((char1 = objReader1.read()) != (char2 = objReader2.read())) {
                return false;
            }
            if (char1 != -1 || char2 != -1) continue;
            return true;
        } while (char1 != -1 && char2 != -1);
        return false;
    }

    public boolean compare(String pstrFile2Compare) throws IOException, Exception {
        return this.compare(new JSFile(pstrFile2Compare));
    }

    public void write(StringBuffer pstrLine) throws Exception {
        this.write(pstrLine.toString());
    }

    public boolean doLock(String pstrAccessMode) throws Exception {
        this.randomFile = new RandomAccessFile(this, pstrAccessMode);
        FileChannel channel = this.randomFile.getChannel();
        FileLock fleLock = null;
        try {
            fleLock = channel.tryLock();
        }
        catch (OverlappingFileLockException e) {
            this.flgFileIsLocked = true;
        }
        catch (Exception e) {
            LOGGER.error("doLock(String) " + e.getMessage(), (Throwable)e);
            throw new JobSchedulerException("doLock(String) " + e.getMessage(), e);
        }
        if (fleLock == null) {
            this.flgFileIsLocked = false;
            this.randomFile = null;
        } else {
            this.flgFileIsLocked = true;
        }
        if (this.flgFileIsLocked) {
            String JSH_I_0160 = "JSH_I_0160";
            this.message(String.format(JSH_I_0160, this.strFileName));
        }
        return this.flgFileIsLocked;
    }

    public boolean doLock() throws Exception {
        return this.doLock("rw");
    }

    public boolean doUnlock() throws IOException {
        if (this.randomFile != null) {
            try {
                if (this.fleLock != null) {
                    this.fleLock.release();
                    this.fleLock = null;
                }
                this.randomFile.getChannel().close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.randomFile = null;
            this.flgFileIsLocked = false;
            this.message(String.format(this.JSH_I_0150, this.strFileName));
        }
        return true;
    }

    public boolean isLocked() {
        boolean flgIsLocked = false;
        if (this.randomFile != null) {
            flgIsLocked = this.flgFileIsLocked;
        }
        return flgIsLocked;
    }

    public boolean setExclusive(boolean pflgIsExclusive) throws IOException {
        if (this.flgIsExclusive && !pflgIsExclusive) {
            this.doReleaseExclusive();
            return this.flgIsExclusive;
        }
        this.flgIsExclusive = pflgIsExclusive;
        if (this.flgIsExclusive && !this.checkExclusiveDeny()) {
            InetAddress ia = InetAddress.getLocalHost();
            String strUserName = System.getProperty("user.name");
            JSDataElementTimeStampISO tstIso = new JSDataElementTimeStampISO(new JSDataElementDate(new Date()));
            String strValues = this.strFileName + ";" + strUserName + ";" + tstIso.getFormattedValue() + ";" + ia.getHostAddress();
            this.fleExclusiveFile.writeLine(strValues);
            LOGGER.debug(this.Messages.getMsg("JSH_I_0110", strValues));
            this.fleExclusiveFile.close();
        }
        return this.flgIsExclusive;
    }

    private boolean checkExclusiveDeny() throws IOException {
        String conMethodName = "JSFile::checkExclusiveDeny";
        boolean flgExclusiveDeny = false;
        String strExclusiveFileNameExtension = System.getProperty(conPropertySOS_JSFILE_EXTENSION_4_EXCLUSIVEFILE, "~");
        this.fleExclusiveFile = new JSFile(this.strFileName + strExclusiveFileNameExtension);
        if (this.fleExclusiveFile.exists()) {
            this.strExclusiveFootPrint = this.fleExclusiveFile.file2String();
            if (!this.strExclusiveFootPrint.isEmpty()) {
                this.message(String.format("%1$s - Footprint is %2$s", "JSFile::checkExclusiveDeny", this.strExclusiveFootPrint));
                String[] strP = this.strExclusiveFootPrint.split(";");
                if (!strP[1].equalsIgnoreCase(System.getProperty("user.name"))) {
                    this.fleExclusiveFile.close();
                    this.fleExclusiveFile = null;
                    flgExclusiveDeny = true;
                }
            }
        }
        return flgExclusiveDeny;
    }

    private void doReleaseExclusive() {
        this.flgIsExclusive = false;
        if (this.fleExclusiveFile != null) {
            this.fleExclusiveFile.delete();
            this.fleExclusiveFile = null;
        }
    }

    public String toXml() {
        String strXml = String.format("<file name='%1$s' size='%2$d' modificationdate='%3$s' />", this.getAbsolutePath(), this.fleFile.length(), new Date(this.fleFile.lastModified()));
        return strXml;
    }

    public static final String getTempdir() {
        return System.getProperty("java.io.tmpdir");
    }

    public String getUniqueFileName() {
        String strUniqueFileName = this.strFileName;
        String strE = this.getFileExtensionName();
        if (this.exists()) {
            int i = 2;
            while (true) {
                String strN = "(" + String.valueOf(i) + ")";
                strUniqueFileName = strE.isEmpty() ? this.strFileName + strN : this.strFileName.replaceFirst(strE, strN + strE);
                if (!new File(strUniqueFileName).exists()) break;
                ++i;
            }
        }
        return strUniqueFileName;
    }

    public String removeFileNameExtension() {
        int extensionIndex;
        String filename = this.strFileName;
        int lastSeparatorIndex = this.strFileName.lastIndexOf(separator);
        if (lastSeparatorIndex != -1) {
            filename = this.strFileName.substring(lastSeparatorIndex + 1);
        }
        if ((extensionIndex = filename.lastIndexOf(".")) != -1) {
            filename = filename.substring(0, extensionIndex);
        }
        return filename;
    }

    public String getFileExtensionName() {
        String strRet = "";
        int intIdx = this.strFileName.lastIndexOf(".");
        if (intIdx == -1) {
            return "";
        }
        int intFL = this.strFileName.length();
        int intExtensionLength = this.strFileName.length() - intIdx;
        strRet = this.strFileName.substring(intFL - intExtensionLength, intFL);
        return strRet;
    }

    public String getCharSet4OutputFile() {
        return this.strCharSet4OutputFile;
    }

    public void setCharSet4OutputFile(String strCharSet4OutputFile) {
        this.strCharSet4OutputFile = strCharSet4OutputFile;
    }
}

