/*
 * Decompiled with CFR 0.152.
 */
package com.sos.JSHelper.io;

import com.sos.JSHelper.Exceptions.JobSchedulerException;
import com.sos.JSHelper.Options.SOSOptionTime;
import com.sos.JSHelper.io.FileComparatorAge;
import com.sos.JSHelper.io.FileComparatorName;
import com.sos.JSHelper.io.FileComparatorSize;
import com.sos.JSHelper.io.SOSFilelistFilter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SOSFileSystemOperations {
    protected static final Logger LOGGER = LoggerFactory.getLogger(SOSFileSystemOperations.class);
    public static final int CREATE_DIR = 1;
    public static final int GRACIOUS = 2;
    public static final int NOT_OVERWRITE = 4;
    public static final int RECURSIVE = 8;
    public static final int REMOVE_DIR = 16;
    public static final int WIPE = 32;
    public List<File> lstResultList = null;
    final int BUFF_SIZE = 100000;
    final byte[] buffer = new byte[100000];

    protected abstract String getActionName();

    protected abstract boolean handleOneFile(File var1, File var2, boolean var3, boolean var4) throws Exception;

    public boolean canWrite(String file) throws Exception {
        File filename = new File(file);
        return this.canWrite(filename, null, 0);
    }

    public boolean canWrite(String file, String fileSpec) throws Exception {
        File filename = new File(file);
        return this.canWrite(filename, fileSpec, 2);
    }

    public boolean canWrite(String file, String fileSpec, int fileSpecFlags) throws Exception {
        File filename = new File(file);
        return this.canWrite(filename, fileSpec, fileSpecFlags);
    }

    public boolean canWrite(File file) throws Exception {
        return this.canWrite(file, null, 0);
    }

    public boolean canWrite(File file, String fileSpec) throws Exception {
        return this.canWrite(file, fileSpec, 2);
    }

    public boolean canWrite(File file, String fileSpec, int fileSpecFlags) throws Exception {
        LOGGER.debug("arguments for canWrite:");
        LOGGER.debug("argument file=" + file.toString());
        LOGGER.debug("argument fileSpec=" + fileSpec);
        String msg = "";
        if (this.has(fileSpecFlags, 128)) {
            msg = msg + "CANON_EQ";
        }
        if (this.has(fileSpecFlags, 2)) {
            msg = msg + "CASE_INSENSITIVE";
        }
        if (this.has(fileSpecFlags, 4)) {
            msg = msg + "COMMENTS";
        }
        if (this.has(fileSpecFlags, 32)) {
            msg = msg + "DOTALL";
        }
        if (this.has(fileSpecFlags, 8)) {
            msg = msg + "MULTILINE";
        }
        if (this.has(fileSpecFlags, 64)) {
            msg = msg + "UNICODE_CASE";
        }
        if (this.has(fileSpecFlags, 1)) {
            msg = msg + "UNIX_LINES";
        }
        LOGGER.debug("argument fileSpecFlags=" + msg);
        String filename = file.getPath();
        filename = this.substituteAllDate(filename);
        file = new File(filename);
        if (!file.exists()) {
            LOGGER.info("checking file " + file.getAbsolutePath() + ": no such file or directory");
            return true;
        }
        if (!file.isDirectory()) {
            LOGGER.info(String.format("checking the file '%1$s' :: file exists", file.getCanonicalPath()));
            boolean writable = false;
            try {
                RandomAccessFile f = new RandomAccessFile(file.getAbsolutePath(), "rw");
                f.close();
                writable = true;
            }
            catch (Exception f) {
                // empty catch block
            }
            if (!writable) {
                LOGGER.info("file " + file.getCanonicalPath() + ": cannot be written ");
                return false;
            }
            return true;
        }
        if (fileSpec == null || fileSpec.isEmpty()) {
            LOGGER.info("checking file " + file.getCanonicalPath() + ": directory exists");
            return true;
        }
        Vector<File> fileList = this.getFilelist(file.getPath(), fileSpec, fileSpecFlags, false, 0L, 0L, -1L, -1L, 0, 0);
        if (fileList.isEmpty()) {
            LOGGER.info("checking file " + file.getCanonicalPath() + ": directory contains no files matching " + fileSpec);
            return false;
        }
        LOGGER.info("checking file " + file.getCanonicalPath() + ": directory contains " + fileList.size() + " file(s) matching " + fileSpec);
        for (int i = 0; i < fileList.size(); ++i) {
            File checkFile = (File)fileList.get(i);
            LOGGER.info("found " + checkFile.getCanonicalPath());
            boolean writable = false;
            try {
                RandomAccessFile f = new RandomAccessFile(file.getAbsolutePath(), "rw");
                f.close();
                writable = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (writable) continue;
            LOGGER.info("file " + checkFile.getCanonicalPath() + ": cannot be written ");
            return false;
        }
        this.lstResultList = fileList;
        return true;
    }

    public boolean existsFile(String file) throws Exception {
        File filename = new File(file);
        return this.existsFile(filename, null, 0);
    }

    public boolean existsFile(String file, String fileSpec) throws Exception {
        File filename = new File(file);
        return this.existsFile(filename, fileSpec, 2);
    }

    public boolean existsFile(String file, String fileSpec, int fileSpecFlags) throws Exception {
        File filename = new File(file);
        return this.existsFile(filename, fileSpec, fileSpecFlags);
    }

    public boolean existsFile(String file, String fileSpec, int fileSpecFlags, String minFileAge, String maxFileAge, String minFileSize, String maxFileSize, int skipFirstFiles, int skipLastFiles) throws Exception {
        File filename = new File(file);
        return this.existsFile(filename, fileSpec, fileSpecFlags, minFileAge, maxFileAge, minFileSize, maxFileSize, skipFirstFiles, skipLastFiles);
    }

    public boolean existsFile(String file, String fileSpec, int fileSpecFlags, String minFileAge, String maxFileAge, String minFileSize, String maxFileSize, int skipFirstFiles, int skipLastFiles, int minNumOfFiles, int maxNumOfFiles) throws Exception {
        File filename = new File(file);
        return this.existsFile(filename, fileSpec, fileSpecFlags, minFileAge, maxFileAge, minFileSize, maxFileSize, skipFirstFiles, skipLastFiles, minNumOfFiles, maxNumOfFiles);
    }

    public boolean existsFile(File file) throws Exception {
        return this.existsFile(file, null, 0);
    }

    public boolean existsFile(File file, String fileSpec) throws Exception {
        return this.existsFile(file, fileSpec, 2);
    }

    public boolean existsFile(File file, String fileSpec, int fileSpecFlags) throws Exception {
        return this.existsFile(file, fileSpec, fileSpecFlags, "0", "0", "-1", "-1", 0, 0);
    }

    public boolean existsFile(File file, String fileSpec, int fileSpecFlags, String minFileAge, String maxFileAge, String minFileSize, String maxFileSize, int skipFirstFiles, int skipLastFiles) throws Exception {
        return this.existsFile(file, fileSpec, fileSpecFlags, minFileAge, maxFileAge, minFileSize, maxFileSize, skipFirstFiles, skipLastFiles, -1, -1);
    }

    public boolean existsFile(File file, String fileSpec, int fileSpecFlags, String minFileAge, String maxFileAge, String minFileSize, String maxFileSize, int skipFirstFiles, int skipLastFiles, int minNumOfFiles, int maxNumOfFiles) throws Exception {
        long minAge = 0L;
        long maxAge = 0L;
        long minSize = -1L;
        long maxSize = -1L;
        LOGGER.debug("arguments for existsFile:");
        LOGGER.debug("argument file=" + file.toString());
        LOGGER.debug("argument fileSpec=" + fileSpec);
        String msg = "";
        if (this.has(fileSpecFlags, 128)) {
            msg = msg + "CANON_EQ";
        }
        if (this.has(fileSpecFlags, 2)) {
            msg = msg + "CASE_INSENSITIVE";
        }
        if (this.has(fileSpecFlags, 4)) {
            msg = msg + "COMMENTS";
        }
        if (this.has(fileSpecFlags, 32)) {
            msg = msg + "DOTALL";
        }
        if (this.has(fileSpecFlags, 8)) {
            msg = msg + "MULTILINE";
        }
        if (this.has(fileSpecFlags, 64)) {
            msg = msg + "UNICODE_CASE";
        }
        if (this.has(fileSpecFlags, 1)) {
            msg = msg + "UNIX_LINES";
        }
        LOGGER.debug("argument fileSpecFlags=" + msg);
        LOGGER.debug("argument minFileAge=" + minFileAge);
        LOGGER.debug("argument maxFileAge=" + maxFileAge);
        minAge = this.calculateFileAge(minFileAge);
        maxAge = this.calculateFileAge(maxFileAge);
        LOGGER.debug("argument minFileSize=" + minFileSize);
        LOGGER.debug("argument maxFileSize=" + maxFileSize);
        minSize = this.calculateFileSize(minFileSize);
        maxSize = this.calculateFileSize(maxFileSize);
        LOGGER.debug("argument skipFirstFiles=" + skipFirstFiles);
        LOGGER.debug("argument skipLastFiles=" + skipLastFiles);
        LOGGER.debug("argument minNumOfFiles=" + minNumOfFiles);
        LOGGER.debug("argument maxNumOfFiles=" + maxNumOfFiles);
        if (skipFirstFiles < 0) {
            throw new JobSchedulerException("[" + skipFirstFiles + "] is no valid value for skipFirstFiles");
        }
        if (skipLastFiles < 0) {
            throw new JobSchedulerException("[" + skipLastFiles + "] is no valid value for skipLastFiles");
        }
        if (skipFirstFiles > 0 && skipLastFiles > 0) {
            throw new JobSchedulerException("skip only either first files or last files");
        }
        if ((skipFirstFiles > 0 || skipLastFiles > 0) && minAge == 0L && maxAge == 0L && minSize == -1L && maxSize == -1L) {
            throw new JobSchedulerException("missed constraint for file skipping (minFileAge, maxFileAge, minFileSize, maxFileSize)");
        }
        String filename = file.getPath();
        file = new File(filename = this.substituteAllDate(filename));
        if (!file.exists()) {
            LOGGER.info("checking file " + file.getAbsolutePath() + ": no such file or directory");
            return false;
        }
        if (!file.isDirectory()) {
            long interval;
            LOGGER.info("checking file " + file.getCanonicalPath() + ": file exists");
            long currentTime = System.currentTimeMillis();
            if (minAge > 0L) {
                interval = currentTime - file.lastModified();
                if (interval < 0L) {
                    throw new JobSchedulerException("Cannot filter by file age. File [" + file.getCanonicalPath() + "] was modified in the future.");
                }
                if (interval < minAge) {
                    LOGGER.info("checking file age " + file.lastModified() + ": minimum age required is " + minAge);
                    return false;
                }
            }
            if (maxAge > 0L) {
                interval = currentTime - file.lastModified();
                if (interval < 0L) {
                    throw new JobSchedulerException("Cannot filter by file age. File [" + file.getCanonicalPath() + "] was modified in the future.");
                }
                if (interval > maxAge) {
                    LOGGER.info("checking file age " + file.lastModified() + ": maximum age required is " + maxAge);
                    return false;
                }
            }
            if (minSize > -1L && minSize > file.length()) {
                LOGGER.info("checking file size " + file.length() + ": minimum size required is " + minFileSize);
                return false;
            }
            if (maxSize > -1L && maxSize < file.length()) {
                LOGGER.info("checking file size " + file.length() + ": maximum size required is " + maxFileSize);
                return false;
            }
            if (skipFirstFiles > 0 || skipLastFiles > 0) {
                LOGGER.info("file skipped");
                return false;
            }
            this.lstResultList = new Vector<File>();
            this.lstResultList.add(file);
            return true;
        }
        if (fileSpec == null || fileSpec.isEmpty()) {
            LOGGER.info("checking file " + file.getCanonicalPath() + ": directory exists");
            return true;
        }
        Vector<File> fileList = this.getFilelist(file.getPath(), fileSpec, fileSpecFlags, false, minAge, maxAge, minSize, maxSize, skipFirstFiles, skipLastFiles);
        if (fileList.isEmpty()) {
            LOGGER.info("checking file " + file.getCanonicalPath() + ": directory contains no files matching " + fileSpec);
            return false;
        }
        LOGGER.info("checking file " + file.getCanonicalPath() + ": directory contains " + fileList.size() + " file(s) matching " + fileSpec);
        for (int i = 0; i < fileList.size(); ++i) {
            File checkFile = (File)fileList.get(i);
            LOGGER.info("found " + checkFile.getCanonicalPath());
        }
        if (minNumOfFiles >= 0 && fileList.size() < minNumOfFiles) {
            LOGGER.info("found " + fileList.size() + " files, minimum expected " + minNumOfFiles + " files");
            return false;
        }
        if (maxNumOfFiles >= 0 && fileList.size() > maxNumOfFiles) {
            LOGGER.info("found " + fileList.size() + " files, maximum expected " + maxNumOfFiles + " files");
            return false;
        }
        this.lstResultList = fileList;
        return true;
    }

    public boolean removeFile(File file) throws Exception {
        return this.removeFile(file, ".*", 0, 2, "0", "0", "-1", "-1", 0, 0, "name", "asc");
    }

    public boolean removeFile(File file, int flags) throws Exception {
        return this.removeFile(file, ".*", flags, 2, "0", "0", "-1", "-1", 0, 0, "name", "asc");
    }

    public boolean removeFile(File file, String fileSpec) throws Exception {
        return this.removeFile(file, fileSpec, 0, 2, "0", "0", "-1", "-1", 0, 0, "name", "asc");
    }

    public boolean removeFile(File file, String fileSpec, int flags) throws Exception {
        return this.removeFile(file, fileSpec, flags, 2, "0", "0", "-1", "-1", 0, 0, "name", "asc");
    }

    public boolean removeFile(File file, String fileSpec, int flags, int fileSpecFlags) throws Exception {
        return this.removeFile(file, fileSpec, flags, fileSpecFlags, "0", "0", "-1", "-1", 0, 0, "name", "asc");
    }

    public boolean removeFile(File file, String fileSpec, int flags, int fileSpecFlags, String minFileAge, String maxFileAge, String minFileSize, String maxFileSize, int skipFirstFiles, int skipLastFiles, String sortCriteria, String sortOrder) throws Exception {
        int nrOfRemovedObjects = this.removeFileCnt(file, fileSpec, flags, fileSpecFlags, minFileAge, maxFileAge, minFileSize, maxFileSize, skipFirstFiles, skipLastFiles, sortCriteria, sortOrder);
        return nrOfRemovedObjects > 0;
    }

    private void removeFileNio(File f) {
        Path path = FileSystems.getDefault().getPath(f.getAbsolutePath(), new String[0]);
        try {
            Files.delete(path);
        }
        catch (NoSuchFileException x) {
            throw new JobSchedulerException(path + "no exists");
        }
        catch (DirectoryNotEmptyException x) {
            throw new JobSchedulerException(path + "directory not empty");
        }
        catch (IOException x) {
            throw new JobSchedulerException(path + "file permission issue");
        }
    }

    public int removeFileCnt(File file, String fileSpec, int flags, int fileSpecFlags, String minFileAge, String maxFileAge, String minFileSize, String maxFileSize, int skipFirstFiles, int skipLastFiles, String sortCriteria, String sortOrder) throws Exception {
        List<File> fileList;
        this.lstResultList = new Vector<File>();
        int nrOfRemovedFiles = 0;
        int nrOfRemovedDirectories = 0;
        long minAge = 0L;
        long maxAge = 0L;
        long minSize = -1L;
        long maxSize = -1L;
        boolean recursive = this.has(flags, 8);
        boolean gracious = this.has(flags, 2);
        boolean wipe = this.has(flags, 32);
        boolean remove_dir = this.has(flags, 16);
        LOGGER.debug("arguments for removeFile:");
        LOGGER.debug("argument file=" + file);
        LOGGER.debug("argument fileSpec=" + fileSpec);
        String msg = "";
        if (this.has(flags, 2)) {
            msg = msg + "GRACIOUS ";
        }
        if (this.has(flags, 8)) {
            msg = msg + "RECURSIVE ";
        }
        if (this.has(flags, 16)) {
            msg = msg + "REMOVE_DIR ";
        }
        if (this.has(flags, 32)) {
            msg = msg + "WIPE ";
        }
        LOGGER.debug("argument flags=" + msg);
        msg = "";
        if (this.has(fileSpecFlags, 128)) {
            msg = msg + "CANON_EQ ";
        }
        if (this.has(fileSpecFlags, 2)) {
            msg = msg + "CASE_INSENSITIVE ";
        }
        if (this.has(fileSpecFlags, 4)) {
            msg = msg + "COMMENTS ";
        }
        if (this.has(fileSpecFlags, 32)) {
            msg = msg + "DOTALL ";
        }
        if (this.has(fileSpecFlags, 8)) {
            msg = msg + "MULTILINE ";
        }
        if (this.has(fileSpecFlags, 64)) {
            msg = msg + "UNICODE_CASE ";
        }
        if (this.has(fileSpecFlags, 1)) {
            msg = msg + "UNIX_LINES ";
        }
        LOGGER.debug("argument fileSpecFlags=" + msg);
        LOGGER.debug("argument minFileAge=" + minFileAge);
        LOGGER.debug("argument maxFileAge=" + maxFileAge);
        minAge = this.calculateFileAge(minFileAge);
        maxAge = this.calculateFileAge(maxFileAge);
        LOGGER.debug("argument minFileSize=" + minFileSize);
        LOGGER.debug("argument maxFileSize=" + maxFileSize);
        minSize = this.calculateFileSize(minFileSize);
        maxSize = this.calculateFileSize(maxFileSize);
        LOGGER.debug("argument skipFirstFiles=" + skipFirstFiles);
        LOGGER.debug("argument skipLastFiles=" + skipLastFiles);
        if (skipFirstFiles < 0) {
            throw new JobSchedulerException("[" + skipFirstFiles + "] is no valid value for skipFirstFiles");
        }
        if (skipLastFiles < 0) {
            throw new JobSchedulerException("[" + skipLastFiles + "] is no valid value for skipLastFiles");
        }
        if (skipFirstFiles > 0 && skipLastFiles > 0) {
            throw new JobSchedulerException("skip only either first files or last files");
        }
        if ((skipFirstFiles > 0 || skipLastFiles > 0) && minAge == 0L && maxAge == 0L && minSize == -1L && maxSize == -1L) {
            throw new JobSchedulerException("missed constraint for file skipping (minFileAge, maxFileAge, minFileSize, maxFileSize)");
        }
        if (!file.exists()) {
            if (gracious) {
                LOGGER.info("cannot remove file: file does not exist: " + file.getCanonicalPath());
                return 0;
            }
            throw new JobSchedulerException("file does not exist: " + file.getCanonicalPath());
        }
        if (file.isDirectory()) {
            if (!file.canRead()) {
                throw new JobSchedulerException("directory is not readable: " + file.getCanonicalPath());
            }
            LOGGER.info("remove [" + fileSpec + "] from " + file.getCanonicalPath() + (recursive ? " (recursive)" : ""));
            fileList = this.getFilelist(file.getPath(), fileSpec, fileSpecFlags, this.has(flags, 8), minAge, maxAge, minSize, maxSize, 0, 0);
        } else {
            fileList = new Vector<File>();
            fileList.add(file);
            fileList = this.filelistFilterAge(fileList, minAge, maxAge);
            fileList = this.filelistFilterSize(fileList, minSize, maxSize);
            if (skipFirstFiles > 0 || skipLastFiles > 0) {
                fileList.clear();
            }
        }
        if (sortCriteria.equalsIgnoreCase("age")) {
            fileList.sort(new FileComparatorAge());
        } else if (sortCriteria.equalsIgnoreCase("size")) {
            fileList.sort(new FileComparatorSize());
        } else {
            fileList.sort(new FileComparatorName());
        }
        for (int i = skipFirstFiles; i < fileList.size() - skipLastFiles; ++i) {
            File currentFile = fileList.get(i);
            this.lstResultList.add(currentFile);
            LOGGER.info("remove file " + currentFile.getCanonicalPath());
            if (wipe) {
                if (!this.wipe(currentFile)) {
                    throw new JobSchedulerException("cannot remove file: " + currentFile.getCanonicalPath());
                }
            } else {
                this.removeFileNio(currentFile);
            }
            ++nrOfRemovedFiles;
        }
        if (remove_dir) {
            int firstSize = this.listFolders(file.getPath(), ".*", 0, recursive).size();
            if (recursive) {
                this.recDeleteEmptyDir(file, fileSpec, fileSpecFlags);
            } else {
                Vector<File> list = this.listFolders(file.getPath(), fileSpec, fileSpecFlags);
                for (int i = 0; i < list.size(); ++i) {
                    File f = list.get(i);
                    if (!f.isDirectory()) continue;
                    if (!f.canRead()) {
                        throw new JobSchedulerException("directory is not readable: " + f.getCanonicalPath());
                    }
                    if (f.list().length == 0) {
                        this.removeFileNio(f);
                        LOGGER.info("remove directory " + f.getPath());
                        continue;
                    }
                    LOGGER.debug("directory [" + f.getCanonicalPath() + "] cannot be removed because it is not empty");
                    String lst = f.list()[0];
                    for (int n = 1; n < f.list().length; ++n) {
                        lst = lst + ", " + f.list()[n];
                    }
                    LOGGER.debug("          contained files " + f.list().length + ": " + lst);
                }
            }
            nrOfRemovedDirectories = firstSize - this.listFolders(file.getPath(), ".*", 0, recursive).size();
        }
        msg = "";
        if (remove_dir) {
            msg = nrOfRemovedDirectories == 1 ? " + 1 directory removed" : " + " + nrOfRemovedDirectories + " directories removed";
        }
        LOGGER.info(nrOfRemovedFiles + " file(s) removed" + msg);
        return nrOfRemovedFiles + nrOfRemovedDirectories;
    }

    public Vector<File> listFolders(String folder, String regexp, int flag, boolean withSubFolder) throws Exception {
        Vector<File> filelist = new Vector<File>();
        File file = null;
        File[] subDir = null;
        file = new File(folder);
        subDir = file.listFiles();
        filelist.addAll(this.listFolders(folder, regexp, flag));
        if (withSubFolder) {
            for (File element : subDir) {
                if (!element.isDirectory()) continue;
                filelist.addAll(this.listFolders(element.getPath(), regexp, flag, true));
            }
        }
        return filelist;
    }

    public Vector<File> listFolders(String folder, String regexp, int flag) throws Exception {
        Vector<File> filelist = new Vector<File>();
        if (folder == null || folder.isEmpty()) {
            throw new FileNotFoundException("empty directory not allowed!!");
        }
        File f = new File(folder);
        if (!f.exists()) {
            throw new FileNotFoundException("directory does not exist: " + folder);
        }
        filelist = new Vector();
        File[] files = f.listFiles(new SOSFilelistFilter(regexp, flag));
        for (int i = 0; i < files.length; ++i) {
            if (".".equals(files[i].getName()) || "..".equals(files[i].getName())) continue;
            filelist.add(files[i]);
        }
        return filelist;
    }

    private boolean recDeleteEmptyDir(File dir, String fileSpec, int fileSpecFlags) throws Exception {
        if (dir.isDirectory()) {
            if (!dir.canRead()) {
                throw new JobSchedulerException("directory is not readable: " + dir.getCanonicalPath());
            }
        } else {
            return false;
        }
        File[] list = dir.listFiles();
        if (list.length == 0) {
            return true;
        }
        Pattern p = Pattern.compile(fileSpec, fileSpecFlags);
        for (File element : list) {
            File f = element;
            if (this.recDeleteEmptyDir(f, fileSpec, fileSpecFlags)) {
                if (!p.matcher(f.getName()).matches()) continue;
                this.removeFileNio(f);
                LOGGER.info("remove directory " + f.getPath());
                continue;
            }
            if (!f.isDirectory()) continue;
            LOGGER.debug("directory [" + f.getCanonicalPath() + "] cannot be removed because it is not empty");
            String lst = f.list()[0];
            for (int n = 1; n < f.list().length; ++n) {
                lst = lst + ", " + f.list()[n];
            }
            LOGGER.debug("          contained files " + f.list().length + ": " + lst);
        }
        return dir.list().length == 0;
    }

    public boolean removeFile(String file) throws Exception {
        return this.removeFile(new File(file));
    }

    public boolean removeFile(String file, int flags) throws Exception {
        return this.removeFile(new File(file), flags);
    }

    public boolean removeFile(String file, String fileSpec) throws Exception {
        return this.removeFile(new File(file), fileSpec);
    }

    public boolean removeFile(String file, String fileSpec, int flags) throws Exception {
        return this.removeFile(new File(file), fileSpec, flags);
    }

    public boolean removeFile(String file, String fileSpec, int flags, int fileSpecFlags) throws Exception {
        return this.removeFile(new File(file), fileSpec, flags, fileSpecFlags);
    }

    public boolean removeFile(String file, String fileSpec, int flags, int fileSpecFlags, String minFileAge, String maxFileAge, String minFileSize, String maxFileSize, int skipFirstFiles, int skipLastFiles, String sortCriteria, String sortOrder) throws Exception {
        return this.removeFile(new File(file), fileSpec, flags, fileSpecFlags, minFileAge, maxFileAge, minFileSize, maxFileSize, skipFirstFiles, skipLastFiles, sortCriteria, sortOrder);
    }

    public int removeFileCnt(String file, String fileSpec, int flags, int fileSpecFlags, String minFileAge, String maxFileAge, String minFileSize, String maxFileSize, int skipFirstFiles, int skipLastFiles, String sortCriteria, String sortOrder) throws Exception {
        return this.removeFileCnt(new File(file), fileSpec, flags, fileSpecFlags, minFileAge, maxFileAge, minFileSize, maxFileSize, skipFirstFiles, skipLastFiles, sortCriteria, sortOrder);
    }

    public boolean copyFile(File source, File dest) throws Exception {
        return this.copyFile(source, dest, false);
    }

    public boolean copyFile(File source, File target, int flags) throws Exception {
        return this.copyFile(source, target, ".*", flags, 2, null, null, "0", "0", "-1", "-1", 0, 0, "name", "asc");
    }

    public boolean copyFile(File source, File target, String fileSpec) throws Exception {
        return this.copyFile(source, target, fileSpec, 0, 2, null, null, "0", "0", "-1", "-1", 0, 0, "name", "asc");
    }

    public boolean copyFile(File source, File target, String fileSpec, int flags) throws Exception {
        return this.copyFile(source, target, fileSpec, flags, 2, null, null, "0", "0", "-1", "-1", 0, 0, "name", "asc");
    }

    public boolean copyFile(File source, String fileSpec, int flags, int fileSpecFlags, String replacing, String replacement) throws Exception {
        return this.copyFile(source, null, fileSpec, flags, fileSpecFlags, replacing, replacement, "0", "0", "-1", "-1", 0, 0, "name", "asc");
    }

    public boolean copyFile(File source, File target, String fileSpec, int flags, int fileSpecFlags, String replacing, String replacement) throws Exception {
        return this.copyFile(source, target, fileSpec, flags, fileSpecFlags, replacing, replacement, "0", "0", "-1", "-1", 0, 0, "name", "asc");
    }

    public boolean copyFile(File source, File target, String fileSpec, int flags, int fileSpecFlags, String replacing, String replacement, String minFileAge, String maxFileAge, String minFileSize, String maxFileSize, int skipFirstFiles, int skipLastFiles, String sortCriteria, String sortOrder) throws Exception {
        String mode = "copy";
        return this.transferFile(source, target, fileSpec, flags, fileSpecFlags, replacing, replacement, minFileAge, maxFileAge, minFileSize, maxFileSize, skipFirstFiles, skipLastFiles, sortCriteria, sortOrder, mode);
    }

    public boolean copyFile(String source, String target) throws Exception {
        File sourceFile = new File(source);
        File targetFile = target == null ? null : new File(target);
        return this.copyFile(sourceFile, targetFile);
    }

    public boolean copyFile(String source, String target, int flags) throws Exception {
        File sourceFile = new File(source);
        File targetFile = target == null ? null : new File(target);
        return this.copyFile(sourceFile, targetFile, flags);
    }

    public boolean copyFile(String source, String target, String fileSpec) throws Exception {
        File sourceFile = new File(source);
        File targetFile = target == null ? null : new File(target);
        return this.copyFile(sourceFile, targetFile, fileSpec);
    }

    public boolean copyFile(String source, String target, String fileSpec, int flags) throws Exception {
        File sourceFile = new File(source);
        File targetFile = target == null ? null : new File(target);
        return this.copyFile(sourceFile, targetFile, fileSpec, flags);
    }

    public boolean copyFile(String source, String target, String fileSpec, int flags, int fileSpecFlags) throws Exception {
        File sourceFile = new File(source);
        File targetFile = target == null ? null : new File(target);
        return this.copyFile(sourceFile, targetFile, fileSpec, flags, fileSpecFlags, null, null, "0", "0", "-1", "-1", 0, 0, "name", "asc");
    }

    public boolean copyFile(String source, String fileSpec, int flags, int fileSpecFlags, String replacing, String replacement) throws Exception {
        File sourceFile = new File(source);
        return this.copyFile(sourceFile, fileSpec, flags, fileSpecFlags, replacing, replacement);
    }

    public boolean copyFile(String source, String target, String fileSpec, int flags, int fileSpecFlags, String replacing, String replacement) throws Exception {
        File sourceFile = new File(source);
        File targetFile = target == null ? null : new File(target);
        return this.copyFile(sourceFile, targetFile, fileSpec, flags, fileSpecFlags, replacing, replacement);
    }

    public boolean copyFile(String source, String target, String fileSpec, int flags, int fileSpecFlags, String replacing, String replacement, String minFileAge, String maxFileAge, String minFileSize, String maxFileSize, int skipFirstFiles, int skipLastFiles) throws Exception {
        File sourceFile = new File(source);
        File targetFile = target == null ? null : new File(target);
        return this.copyFile(sourceFile, targetFile, fileSpec, flags, fileSpecFlags, replacing, replacement, minFileAge, maxFileAge, minFileSize, maxFileSize, skipFirstFiles, skipLastFiles, "name", "asc");
    }

    public int copyFileCnt(String source, String target, String fileSpec, int flags, int fileSpecFlags, String replacing, String replacement, String minFileAge, String maxFileAge, String minFileSize, String maxFileSize, int skipFirstFiles, int skipLastFiles, String sortCriteria, String sortOrder) throws Exception {
        File sourceFile = new File(source);
        File targetFile = target == null ? null : new File(target);
        return this.transferFileCnt(sourceFile, targetFile, fileSpec, flags, fileSpecFlags, replacing, replacement, minFileAge, maxFileAge, minFileSize, maxFileSize, skipFirstFiles, skipLastFiles, sortCriteria, sortOrder);
    }

    public boolean renameFile(File source, File target) throws Exception {
        return this.renameFile(source, target, ".*", 0, 2, null, null, "0", "0", "-1", "-1", 0, 0, "name", "asc");
    }

    public boolean renameFile(File source, File target, int flags) throws Exception {
        return this.renameFile(source, target, ".*", flags, 2, null, null, "0", "0", "-1", "-1", 0, 0, "name", "asc");
    }

    public boolean renameFile(File source, File target, String fileSpec) throws Exception {
        return this.renameFile(source, target, fileSpec, 0, 2, null, null, "0", "0", "-1", "-1", 0, 0, "name", "asc");
    }

    public boolean renameFile(File source, File target, String fileSpec, int flags) throws Exception {
        return this.renameFile(source, target, fileSpec, flags, 2, null, null, "0", "0", "-1", "-1", 0, 0, "name", "asc");
    }

    public boolean renameFile(File source, File target, String fileSpec, int flags, int fileSpecFlags) throws Exception {
        return this.renameFile(source, target, fileSpec, flags, fileSpecFlags, null, null, "0", "0", "-1", "-1", 0, 0, "name", "asc");
    }

    public boolean renameFile(File source, File target, String fileSpec, String replacing, String replacement) throws Exception {
        return this.renameFile(source, target, fileSpec, 0, 2, replacing, replacement, "0", "0", "-1", "-1", 0, 0, "name", "asc");
    }

    public boolean renameFile(File source, File target, String fileSpec, int flags, String replacing, String replacement) throws Exception {
        return this.renameFile(source, target, fileSpec, flags, 2, replacing, replacement, "0", "0", "-1", "-1", 0, 0, "name", "asc");
    }

    public boolean renameFile(File source, String fileSpec, int flags, int fileSpecFlags, String replacing, String replacement) throws Exception {
        return this.renameFile(source, null, fileSpec, flags, fileSpecFlags, replacing, replacement, "0", "0", "-1", "-1", 0, 0, "name", "asc");
    }

    public boolean renameFile(File source, File target, String fileSpec, int flags, int fileSpecFlags, String replacing, String replacement) throws Exception {
        return this.renameFile(source, target, fileSpec, flags, fileSpecFlags, replacing, replacement, "0", "0", "-1", "-1", 0, 0, "name", "asc");
    }

    public boolean renameFile(File source, File target, String fileSpec, int flags, int fileSpecFlags, String replacing, String replacement, String minFileAge, String maxFileAge, String minFileSize, String maxFileSize, int skipFirstFiles, int skipLastFiles, String sortCriteria, String sortOrder) throws Exception {
        String mode = "rename";
        return this.transferFile(source, target, fileSpec, flags, fileSpecFlags, replacing, replacement, minFileAge, maxFileAge, minFileSize, maxFileSize, skipFirstFiles, skipLastFiles, sortCriteria, sortOrder, mode);
    }

    public boolean renameFile(String source, String target) throws Exception {
        File sourceFile = new File(source);
        File targetFile = target == null ? null : new File(target);
        return this.renameFile(sourceFile, targetFile);
    }

    public boolean renameFile(String source, String target, int flags) throws Exception {
        File sourceFile = new File(source);
        File targetFile = target == null ? null : new File(target);
        return this.renameFile(sourceFile, targetFile, flags);
    }

    public boolean renameFile(String source, String target, String fileSpec) throws Exception {
        File sourceFile = new File(source);
        File targetFile = target == null ? null : new File(target);
        return this.renameFile(sourceFile, targetFile, fileSpec);
    }

    public boolean renameFile(String source, String target, String fileSpec, int flags) throws Exception {
        File sourceFile = new File(source);
        File targetFile = target == null ? null : new File(target);
        return this.renameFile(sourceFile, targetFile, fileSpec, flags);
    }

    public boolean renameFile(String source, String target, String fileSpec, int flags, int fileSpecFlags) throws Exception {
        File sourceFile = new File(source);
        File targetFile = target == null ? null : new File(target);
        return this.renameFile(sourceFile, targetFile, fileSpec, flags, fileSpecFlags);
    }

    public boolean renameFile(String source, String target, String fileSpec, String replacing, String replacement) throws Exception {
        File sourceFile = new File(source);
        File targetFile = target == null ? null : new File(target);
        return this.renameFile(sourceFile, targetFile, fileSpec, replacing, replacement);
    }

    public boolean renameFile(String source, String target, String fileSpec, int flags, String replacing, String replacement) throws Exception {
        File sourceFile = new File(source);
        File targetFile = target == null ? null : new File(target);
        return this.renameFile(sourceFile, targetFile, fileSpec, flags, replacing, replacement);
    }

    public boolean renameFile(String source, String target, String fileSpec, int flags, int fileSpecFlags, String replacing, String replacement) throws Exception {
        File sourceFile = new File(source);
        File targetFile = target == null ? null : new File(target);
        return this.renameFile(sourceFile, targetFile, fileSpec, flags, fileSpecFlags, replacing, replacement);
    }

    public boolean renameFile(String source, String target, String fileSpec, int flags, int fileSpecFlags, String replacing, String replacement, String minFileAge, String maxFileAge, String minFileSize, String maxFileSize, int skipFirstFiles, int skipLastFiles, String sortCriteria, String sortOrder) throws Exception {
        File sourceFile = new File(source);
        File targetFile = target == null ? null : new File(target);
        return this.renameFile(sourceFile, targetFile, fileSpec, flags, fileSpecFlags, replacing, replacement, minFileAge, maxFileAge, minFileSize, maxFileSize, skipFirstFiles, skipLastFiles, sortCriteria, sortOrder);
    }

    public int renameFileCnt(String source, String target, String fileSpec, int flags, int fileSpecFlags, String replacing, String replacement, String minFileAge, String maxFileAge, String minFileSize, String maxFileSize, int skipFirstFiles, int skipLastFiles, String sortCriteria, String sortOrder) throws Exception {
        File sourceFile = new File(source);
        File targetFile = target == null ? null : new File(target);
        return this.transferFileCnt(sourceFile, targetFile, fileSpec, flags, fileSpecFlags, replacing, replacement, minFileAge, maxFileAge, minFileSize, maxFileSize, skipFirstFiles, skipLastFiles, sortCriteria, sortOrder);
    }

    private boolean transferFile(File source, File target, String fileSpec, int flags, int fileSpecFlags, String replacing, String replacement, String minFileAge, String maxFileAge, String minFileSize, String maxFileSize, int skipFirstFiles, int skipLastFiles, String sortCriteria, String sortOrder, String mode) throws Exception {
        int nrOfTransferedFiles = this.transferFileCnt(source, target, fileSpec, flags, fileSpecFlags, replacing, replacement, minFileAge, maxFileAge, minFileSize, maxFileSize, skipFirstFiles, skipLastFiles, sortCriteria, sortOrder);
        return nrOfTransferedFiles > 0;
    }

    private int transferFileCnt(File source, File target, String fileSpec, int flags, int fileSpecFlags, String replacing, String replacement, String minFileAge, String maxFileAge, String minFileSize, String maxFileSize, int skipFirstFiles, int skipLastFiles, String sortCriteria, String sortOrder) throws Exception {
        String targetFilename;
        int nrOfTransferedFiles = 0;
        boolean replace = false;
        long minAge = 0L;
        long maxAge = 0L;
        long minSize = -1L;
        long maxSize = -1L;
        this.lstResultList = new Vector<File>();
        if (sortCriteria == null || sortCriteria.isEmpty()) {
            sortCriteria = "name";
        }
        if (sortOrder == null || sortOrder.isEmpty()) {
            sortOrder = "asc";
        }
        boolean create_dir = this.has(flags, 1);
        boolean gracious = this.has(flags, 2);
        boolean overwrite = !this.has(flags, 4);
        LOGGER.debug(this.getActionName() + "arguments:");
        LOGGER.debug("argument source=" + source.toString());
        if (target != null) {
            LOGGER.debug("argument target=" + target.toString());
        }
        LOGGER.debug("argument fileSpec=" + fileSpec);
        String msg = "";
        if (this.has(flags, 1)) {
            msg = msg + "CREATE_DIR ";
        }
        if (this.has(flags, 2)) {
            msg = msg + "GRACIOUS ";
        }
        if (this.has(flags, 4)) {
            msg = msg + "NOT_OVERWRITE ";
        }
        if (this.has(flags, 8)) {
            msg = msg + "RECURSIVE ";
        }
        if ("".equals(msg)) {
            msg = "0";
        }
        LOGGER.debug("argument flags=" + msg);
        msg = "";
        if (this.has(fileSpecFlags, 128)) {
            msg = msg + "CANON_EQ ";
        }
        if (this.has(fileSpecFlags, 2)) {
            msg = msg + "CASE_INSENSITIVE ";
        }
        if (this.has(fileSpecFlags, 4)) {
            msg = msg + "COMMENTS ";
        }
        if (this.has(fileSpecFlags, 32)) {
            msg = msg + "DOTALL ";
        }
        if (this.has(fileSpecFlags, 8)) {
            msg = msg + "MULTILINE ";
        }
        if (this.has(fileSpecFlags, 64)) {
            msg = msg + "UNICODE_CASE ";
        }
        if (this.has(fileSpecFlags, 1)) {
            msg = msg + "UNIX_LINES ";
        }
        if ("".equals(msg)) {
            msg = "0";
        }
        LOGGER.debug("argument fileSpecFlags=" + msg);
        LOGGER.debug("argument replacing=" + replacing);
        LOGGER.debug("argument replacement=" + replacement);
        LOGGER.debug("argument minFileAge=" + minFileAge);
        LOGGER.debug("argument maxFileAge=" + maxFileAge);
        minAge = this.calculateFileAge(minFileAge);
        maxAge = this.calculateFileAge(maxFileAge);
        LOGGER.debug("argument minFileSize=" + minFileSize);
        LOGGER.debug("argument maxFileSize=" + maxFileSize);
        minSize = this.calculateFileSize(minFileSize);
        maxSize = this.calculateFileSize(maxFileSize);
        LOGGER.debug("argument skipFirstFiles=" + skipFirstFiles);
        LOGGER.debug("argument skipLastFiles=" + skipLastFiles);
        if (skipFirstFiles < 0) {
            throw new JobSchedulerException("[" + skipFirstFiles + "] is no valid value for skipFirstFiles");
        }
        if (skipLastFiles < 0) {
            throw new JobSchedulerException("[" + skipLastFiles + "] is no valid value for skipLastFiles");
        }
        if (replacing != null || replacement != null) {
            if (replacing == null) {
                throw new JobSchedulerException("replacing cannot be null if replacement is set");
            }
            if (replacement == null) {
                throw new JobSchedulerException("replacement cannot be null if replacing is set");
            }
            if (!"".equals(replacing)) {
                try {
                    Pattern.compile(replacing);
                }
                catch (PatternSyntaxException pse) {
                    throw new JobSchedulerException("invalid pattern '" + replacing + "'");
                }
                replace = true;
            }
        }
        if (!source.exists()) {
            if (gracious) {
                LOGGER.info(nrOfTransferedFiles + " file(s) renamed");
                return nrOfTransferedFiles;
            }
            throw new JobSchedulerException("file or directory does not exist: " + source.getCanonicalPath());
        }
        if (!source.canRead()) {
            throw new JobSchedulerException("file or directory is not readable: " + source.getCanonicalPath());
        }
        if (target != null) {
            targetFilename = this.substituteAllDate(target.getPath());
            targetFilename = this.substituteAllDirectory(targetFilename, source.getPath());
            target = new File(targetFilename);
        }
        if (create_dir && target != null && !target.exists()) {
            if (target.mkdirs()) {
                LOGGER.info("create target directory " + target.getCanonicalPath());
            } else {
                throw new JobSchedulerException("cannot create directory " + target.getCanonicalPath());
            }
        }
        List<File> list = null;
        if (source.isDirectory()) {
            if (target != null) {
                if (!target.exists()) {
                    throw new JobSchedulerException("directory does not exist: " + target.getCanonicalPath());
                }
                if (!target.isDirectory()) {
                    throw new JobSchedulerException("target is no directory: " + target.getCanonicalPath());
                }
            }
            list = this.getFilelist(source.getPath(), fileSpec, fileSpecFlags, this.has(flags, 8), minAge, maxAge, minSize, maxSize, 0, 0);
        } else {
            list = new Vector<File>();
            list.add(source);
            list = this.filelistFilterAge(list, minAge, maxAge);
            list = this.filelistFilterSize(list, minSize, maxSize);
            if (skipFirstFiles > 0 || skipLastFiles > 0) {
                list.clear();
            }
        }
        if (sortCriteria.equalsIgnoreCase("age")) {
            list.sort(new FileComparatorAge());
        } else if (sortCriteria.equalsIgnoreCase("size")) {
            list.sort(new FileComparatorSize());
        } else {
            list.sort(new FileComparatorName());
        }
        if (sortOrder.equalsIgnoreCase("desc")) {
            Collections.reverse(list);
        }
        for (int i = skipFirstFiles; i < list.size() - skipLastFiles; ++i) {
            String root;
            File sourceFile = list.get(i);
            this.lstResultList.add(sourceFile);
            if (target != null) {
                if (target.isDirectory()) {
                    root = source.isDirectory() ? source.getPath() : source.getParent();
                    targetFilename = target.getPath() + sourceFile.getPath().substring(root.length());
                } else {
                    targetFilename = target.getPath();
                }
            } else if (source.isDirectory()) {
                root = source.isDirectory() ? source.getPath() : source.getParent();
                targetFilename = source.getPath() + sourceFile.getPath().substring(root.length());
            } else {
                targetFilename = source.getParent() + "/" + sourceFile.getName();
            }
            File targetFile = new File(targetFilename);
            try {
                if (replace) {
                    targetFilename = targetFile.getName();
                    targetFilename = this.replaceGroups(targetFilename, replacing, replacement);
                    targetFilename = this.substituteAllDate(targetFilename);
                    targetFilename = this.substituteAllFilename(targetFilename, targetFile.getName());
                    targetFile = new File(targetFile.getParent() + "/" + targetFilename);
                }
            }
            catch (Exception re) {
                throw new JobSchedulerException("replacement error in file " + targetFilename + ": " + re.getMessage());
            }
            File dir = new File(targetFile.getParent());
            if (!dir.exists()) {
                if (dir.mkdirs()) {
                    LOGGER.info("create directory " + dir.getCanonicalPath());
                } else {
                    throw new JobSchedulerException("cannot create directory " + dir.getCanonicalPath());
                }
            }
            if (!this.handleOneFile(sourceFile, targetFile, overwrite, gracious)) continue;
            ++nrOfTransferedFiles;
        }
        LOGGER.info(this.getActionName() + nrOfTransferedFiles + " file(s)");
        return nrOfTransferedFiles;
    }

    private List<File> filelistFilterAge(List<File> filelist, long minAge, long maxAge) throws Exception {
        long interval;
        File file;
        int i;
        Vector<File> newlist;
        long currentTime = System.currentTimeMillis();
        if (minAge != 0L) {
            newlist = new Vector<File>();
            for (i = 0; i < filelist.size(); ++i) {
                file = filelist.get(i);
                interval = currentTime - file.lastModified();
                if (interval < 0L) {
                    throw new JobSchedulerException("Cannot filter by file age. File [" + file.getCanonicalPath() + "] was modified in the future.");
                }
                if (interval < minAge) continue;
                newlist.add(file);
            }
            filelist = newlist;
        }
        if (maxAge != 0L) {
            newlist = new Vector();
            for (i = 0; i < filelist.size(); ++i) {
                file = filelist.get(i);
                interval = currentTime - file.lastModified();
                if (interval < 0L) {
                    throw new JobSchedulerException("Cannot filter by file age. File [" + file.getCanonicalPath() + "] was modified in the future.");
                }
                if (interval > maxAge) continue;
                newlist.add(file);
            }
            filelist = newlist;
        }
        return filelist;
    }

    private List<File> filelistFilterSize(List<File> filelist, long minSize, long maxSize) throws Exception {
        File file;
        int i;
        Vector<File> newlist;
        if (minSize > -1L) {
            newlist = new Vector<File>();
            for (i = 0; i < filelist.size(); ++i) {
                file = filelist.get(i);
                if (file.length() < minSize) continue;
                newlist.add(file);
            }
            filelist = newlist;
        }
        if (maxSize > -1L) {
            newlist = new Vector();
            for (i = 0; i < filelist.size(); ++i) {
                file = filelist.get(i);
                if (file.length() > maxSize) continue;
                newlist.add(file);
            }
            filelist = newlist;
        }
        return filelist;
    }

    private List<File> filelistSkipFiles(List<File> filelist, int skipFirstFiles, int skipLastFiles, String sorting) throws Exception {
        if ("sort_size".equals(sorting)) {
            filelist.sort(new FileComparatorSize());
        } else if ("sort_age".equals(sorting)) {
            filelist.sort(new FileComparatorAge());
        }
        return filelist;
    }

    public Vector<File> listFiles(String folder, String regexp, int flag, boolean withSubFolder) throws Exception {
        Vector<File> filelist = new Vector<File>();
        File file = null;
        File[] subDir = null;
        file = new File(folder);
        subDir = file.listFiles();
        filelist.addAll(this.listFiles(folder, regexp, flag));
        if (withSubFolder) {
            for (File element : subDir) {
                if (!element.isDirectory()) continue;
                filelist.addAll(this.listFiles(element.getPath(), regexp, flag, true));
            }
        }
        return filelist;
    }

    public Vector<File> listFiles(String folder, String regexp, int flag) throws Exception {
        File[] files;
        Vector<File> filelist = new Vector<File>();
        if (folder == null || folder.isEmpty()) {
            throw new FileNotFoundException("empty directory not allowed!!");
        }
        File f = new File(folder);
        if (!f.exists()) {
            throw new FileNotFoundException("directory does not exist: " + folder);
        }
        filelist = new Vector();
        for (File file : files = f.listFiles(new SOSFilelistFilter(regexp, flag))) {
            if (!file.isFile()) continue;
            filelist.add(file);
        }
        return filelist;
    }

    private Vector<File> getFilelist(String folder, String regexp, int flag, boolean withSubFolder, long minFileAge, long maxFileAge, long minFileSize, long maxFileSize, int skipFirstFiles, int skipLastFiles) throws Exception {
        Vector<File> filelist = new Vector<File>();
        List<Object> temp = new Vector();
        File file = null;
        File[] subDir = null;
        file = new File(folder);
        subDir = file.listFiles();
        temp = this.listFiles(folder, regexp, flag);
        temp = this.filelistFilterAge(temp, minFileAge, maxFileAge);
        temp = this.filelistFilterSize(temp, minFileSize, maxFileSize);
        if ((minFileSize != -1L || maxFileSize != -1L) && minFileAge == 0L && maxFileAge == 0L) {
            temp = this.filelistSkipFiles(temp, skipFirstFiles, skipLastFiles, "sort_size");
        } else if (minFileAge != 0L || maxFileAge != 0L) {
            temp = this.filelistSkipFiles(temp, skipFirstFiles, skipLastFiles, "sort_age");
        }
        filelist.addAll(temp);
        if (withSubFolder) {
            for (File element : subDir) {
                if (!element.isDirectory()) continue;
                filelist.addAll(this.getFilelist(element.getPath(), regexp, flag, true, minFileAge, maxFileAge, minFileSize, maxFileSize, skipFirstFiles, skipLastFiles));
            }
        }
        return filelist;
    }

    private long calculateFileAge(String fileage) throws Exception {
        long age = 0L;
        if (fileage == null || fileage.trim().isEmpty()) {
            return 0L;
        }
        if (fileage.indexOf(":") == -1) {
            if (!fileage.matches("[\\d]+")) {
                throw new JobSchedulerException("[" + fileage + "] is no valid file age");
            }
            return Long.parseLong(fileage) * 1000L;
        }
        if (!fileage.matches("^[\\d].*[\\d]$")) {
            throw new JobSchedulerException("[" + fileage + "] is no valid file age");
        }
        String[] timeArray = fileage.split(":");
        if (timeArray.length > 3) {
            throw new JobSchedulerException("[" + fileage + "] is no valid file age");
        }
        for (int i = 0; i < timeArray.length; ++i) {
            if (timeArray[i].matches("[\\d]+")) continue;
            throw new JobSchedulerException("[" + fileage + "] is no valid file age");
        }
        long hours = Long.parseLong(timeArray[0]);
        long minutes = Long.parseLong(timeArray[1]);
        long seconds = 0L;
        if (timeArray.length > 2) {
            seconds = Long.parseLong(timeArray[2]);
        }
        age = hours * 3600000L + minutes * 60000L + seconds * 1000L;
        return age;
    }

    private long calculateFileSize(String filesize) throws Exception {
        long size;
        if (filesize == null || filesize.trim().isEmpty()) {
            return -1L;
        }
        if (filesize.matches("-1")) {
            return -1L;
        }
        if (filesize.matches("[\\d]+")) {
            size = Long.parseLong(filesize);
        } else if (filesize.matches("^[\\d]+[kK][bB]$")) {
            size = Long.parseLong(filesize.substring(0, filesize.length() - 2)) * 1024L;
        } else if (filesize.matches("^[\\d]+[mM][bB]$")) {
            size = Long.parseLong(filesize.substring(0, filesize.length() - 2)) * 1024L * 1024L;
        } else if (filesize.matches("^[\\d]+[gG][bB]$")) {
            size = Long.parseLong(filesize.substring(0, filesize.length() - 2)) * 1024L * 1024L * 1024L;
        } else {
            throw new JobSchedulerException("[" + filesize + "] is no valid file size");
        }
        return size;
    }

    private String substituteFirstFilename(String targetFilename, String original) throws Exception {
        Matcher matcher = Pattern.compile("\\[filename:([^\\]]*)\\]").matcher(targetFilename);
        if (matcher.find()) {
            if ("".equals(matcher.group(1))) {
                targetFilename = targetFilename.replaceFirst("\\[filename:\\]", original);
            } else if ("lowercase".equals(matcher.group(1))) {
                targetFilename = targetFilename.replaceFirst("\\[filename:lowercase\\]", original.toLowerCase());
            } else if ("uppercase".equals(matcher.group(1))) {
                targetFilename = targetFilename.replaceFirst("\\[filename:uppercase\\]", original.toUpperCase());
            }
        }
        return targetFilename;
    }

    private String substituteAllFilename(String targetFilename, String original) throws Exception {
        String temp = this.substituteFirstFilename(targetFilename, original);
        while (!targetFilename.equals(temp)) {
            targetFilename = temp;
            temp = this.substituteFirstFilename(targetFilename, original);
        }
        return temp;
    }

    private String substituteFirstDate(String targetFilename) throws Exception {
        String conVarName = "[date:";
        try {
            int posEnd;
            int posBegin;
            if (targetFilename.matches("(.*)(\\[date:)([^\\]]*)(\\])(.*)") && (posBegin = targetFilename.indexOf("[date:")) > -1 && (posEnd = targetFilename.indexOf("]", posBegin + 6)) > -1) {
                String strDateMask = targetFilename.substring(posBegin + 6, posEnd);
                if (strDateMask.isEmpty()) {
                    strDateMask = SOSOptionTime.dateTimeFormat;
                }
                String strDateTime = SOSOptionTime.getCurrentTimeAsString(strDateMask);
                String strT = (posBegin > 0 ? targetFilename.substring(0, posBegin) : "") + strDateTime;
                if (targetFilename.length() > posEnd) {
                    strT = strT + targetFilename.substring(posEnd + 1);
                }
                targetFilename = strT;
            }
            return targetFilename;
        }
        catch (Exception e) {
            throw new RuntimeException("error substituting [date:]: " + e.getMessage());
        }
    }

    private String substituteAllDate(String targetFilename) throws Exception {
        String temp = this.substituteFirstDate(targetFilename);
        while (!targetFilename.equals(temp)) {
            targetFilename = temp;
            temp = this.substituteFirstDate(targetFilename);
        }
        return temp;
    }

    private String substituteFirstDirectory(String target, String source) throws Exception {
        try {
            File sourceFile = new File(source);
            if (!sourceFile.isDirectory()) {
                source = sourceFile.getParent();
            }
            source = source.replaceAll("\\\\", "/");
            target = target.replaceAll("\\\\", "/");
            Pattern p = Pattern.compile("\\[directory:(-[\\d]+|[\\d]*)\\]");
            Matcher m = p.matcher(target);
            if (m.find()) {
                String substitute = "";
                if (m.group(1).isEmpty() || "0".equals(m.group(1)) || "-0".equals(m.group(1))) {
                    substitute = source;
                } else {
                    int absDepth;
                    int depth = Integer.valueOf(m.group(1));
                    StringTokenizer st = new StringTokenizer(source, "/");
                    int n = absDepth = depth < 0 ? -depth : depth;
                    if (absDepth >= st.countTokens()) {
                        substitute = source;
                    } else {
                        String[] dirs = new String[st.countTokens()];
                        int n2 = 0;
                        while (st.hasMoreTokens()) {
                            dirs[n2++] = st.nextToken();
                        }
                        if (depth > 0) {
                            while (depth > 0) {
                                substitute = dirs[--depth] + "/" + substitute;
                            }
                        } else if (depth < 0) {
                            while (depth < 0) {
                                substitute = substitute + dirs[dirs.length + depth++] + "/";
                            }
                        }
                    }
                }
                if (substitute.charAt(substitute.length() - 1) == '/') {
                    substitute = substitute.substring(0, substitute.length() - 1);
                }
                target = target.replaceFirst("\\[directory:[^\\]]*\\]", substitute);
            }
            return target;
        }
        catch (Exception e) {
            throw new JobSchedulerException("error substituting [directory]: " + e.getMessage());
        }
    }

    private String substituteAllDirectory(String target, String source) throws Exception {
        String temp = this.substituteFirstDirectory(target, source);
        while (!target.equals(temp)) {
            target = temp;
            temp = this.substituteFirstDirectory(target, source);
        }
        return temp;
    }

    public String replaceGroups(String input, String replacing, String replacements) throws Exception {
        if (replacements == null) {
            throw new RuntimeException("replacements missing: 0 replacements defined");
        }
        return this.replaceGroups(input, replacing, replacements.split(";"));
    }

    public String replaceGroups(String pstrSourceString, String replacing, String[] replacements) throws Exception {
        String result = "";
        if (replacements == null) {
            throw new RuntimeException("replacements missing: 0 replacements defined");
        }
        Pattern p = Pattern.compile(replacing);
        Matcher m = p.matcher(pstrSourceString);
        if (!m.find()) {
            return pstrSourceString;
        }
        int intGroupCount = m.groupCount();
        if (replacements.length < intGroupCount) {
            throw new RuntimeException("replacements missing: " + replacements.length + " replacement(s) defined but " + intGroupCount + " groups found");
        }
        if (intGroupCount == 0) {
            result = pstrSourceString.substring(0, m.start()) + replacements[0] + pstrSourceString.substring(m.end());
        } else {
            int index = 0;
            for (int i = 1; i <= intGroupCount; ++i) {
                String strRepl;
                int intStart = m.start(i);
                if (intStart >= 0 && !(strRepl = replacements[i - 1].trim()).isEmpty()) {
                    if (strRepl.contains("\\")) {
                        strRepl = strRepl.replaceAll("\\\\-", "");
                        for (int j = 1; j <= intGroupCount; ++j) {
                            strRepl = strRepl.replaceAll("\\\\" + j, m.group(j));
                        }
                    }
                    result = result + pstrSourceString.substring(index, intStart) + strRepl;
                }
                index = m.end(i);
            }
            result = result + pstrSourceString.substring(index);
        }
        return result;
    }

    private boolean has(int flags, int f) {
        return (flags & f) > 0;
    }

    public String getReplacementFilename(String input, String replacing, String replacements) throws Exception {
        String targetFilename = input;
        targetFilename = this.replaceGroups(targetFilename, replacing, replacements.split(";"));
        targetFilename = this.substituteAllDate(targetFilename);
        targetFilename = this.substituteAllFilename(targetFilename, input);
        return targetFilename;
    }

    private boolean wipe(File file) {
        try {
            RandomAccessFile rwFile = new RandomAccessFile(file, "rw");
            byte[] bytes = new byte[(int)rwFile.length()];
            int i = 0;
            while ((bytes[i++] = (byte)rwFile.read()) != -1) {
            }
            rwFile.seek(0L);
            for (i = 0; i < bytes.length; ++i) {
                bytes[i] = (byte)(Math.random() * 10.0 % 9.0);
            }
            rwFile.write(bytes);
            rwFile.close();
            LOGGER.debug("Deleting file");
            boolean rc = file.delete();
            LOGGER.debug("rc: " + rc);
            return rc;
        }
        catch (Exception e) {
            LOGGER.warn("Failed to wipe file: " + e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public boolean copyFile(File source, File dest, boolean append) throws Exception {
        InputStream in = null;
        OutputStream out = null;
        try {
            block11: {
                if (LOGGER != null) {
                    LOGGER.debug("Copying file " + source.getAbsolutePath() + " with buffer of " + 100000 + " bytes");
                }
                in = new FileInputStream(source);
                out = new FileOutputStream(dest, append);
                while (true) {
                    byte[] byArray = this.buffer;
                    // MONITORENTER : this.buffer
                    int amountRead = in.read(this.buffer);
                    if (amountRead == -1) {
                        // MONITOREXIT : byArray
                        if (LOGGER != null) {
                            break;
                        }
                        break block11;
                    }
                    out.write(this.buffer, 0, amountRead);
                    // MONITOREXIT : byArray
                }
                LOGGER.debug("File " + source.getAbsolutePath() + " with buffer of " + 100000 + " bytes");
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
        }
    }
}

