/*
 * Decompiled with CFR 0.152.
 */
package com.sos.i18n;

import com.sos.i18n.LoggerLocale;
import com.sos.i18n.Msg;
import java.util.Locale;

public abstract class Logger {
    public static final String SYSPROP_DUMP_STACK_TRACES = "i18nlog.dump-stack-traces";
    public static final String SYSPROP_DUMP_LOG_KEYS = "i18nlog.dump-keys";
    private static boolean s_dumpStackTraces;
    private static boolean s_dumpKeys;
    private Msg.BundleBaseName m_baseBundleName;
    private Locale m_locale;

    public static boolean getDumpStackTraces() {
        return s_dumpStackTraces;
    }

    public static void setDumpStackTraces(boolean flag) {
        s_dumpStackTraces = flag;
    }

    public static boolean getDumpLogKeys() {
        return s_dumpKeys;
    }

    public static void setDumpLogKeys(boolean flag) {
        s_dumpKeys = flag;
    }

    public Logger(String name, Msg.BundleBaseName basename, Locale locale) {
        this.createLogObject(name);
        this.m_baseBundleName = basename;
        this.m_locale = locale;
    }

    public Logger(Class clazz, Msg.BundleBaseName basename, Locale locale) {
        this.createLogObject(clazz);
        this.m_baseBundleName = basename;
        this.m_locale = locale;
    }

    public Logger(String name, Msg.BundleBaseName basename) {
        this(name, basename, null);
    }

    public Logger(Class clazz, Msg.BundleBaseName basename) {
        this(clazz, basename, null);
    }

    public Logger(String name, Locale locale) {
        this(name, null, locale);
    }

    public Logger(Class clazz, Locale locale) {
        this(clazz, null, locale);
    }

    public Logger(String name) {
        this(name, null, null);
    }

    public Logger(Class clazz) {
        this(clazz, null, null);
    }

    public Msg.BundleBaseName getBaseBundleName() {
        return this.m_baseBundleName;
    }

    public Locale getLocale() {
        if (this.m_locale != null) {
            return this.m_locale;
        }
        return LoggerLocale.getLogLocale();
    }

    public Msg getMsg(String key, Object ... varargs) {
        return Msg.createMsg(this.getBaseBundleName(), this.getLocale(), key, varargs);
    }

    public String getMsgString(String key, Object ... varargs) {
        return this.getMsg(key, varargs).toString();
    }

    public abstract boolean isFatalEnabled();

    public abstract boolean isErrorEnabled();

    public abstract boolean isWarnEnabled();

    public abstract boolean isInfoEnabled();

    public abstract boolean isDebugEnabled();

    public abstract boolean isTraceEnabled();

    public abstract Msg fatal(Throwable var1, String var2, Object ... var3);

    public abstract Msg fatal(String var1, Object ... var2);

    public abstract Msg error(Throwable var1, String var2, Object ... var3);

    public abstract Msg error(String var1, Object ... var2);

    public abstract Msg warn(Throwable var1, String var2, Object ... var3);

    public abstract Msg warn(String var1, Object ... var2);

    public abstract Msg info(Throwable var1, String var2, Object ... var3);

    public abstract Msg info(String var1, Object ... var2);

    public abstract Msg debug(Throwable var1, String var2, Object ... var3);

    public abstract Msg debug(String var1, Object ... var2);

    public abstract Msg trace(Throwable var1, String var2, Object ... var3);

    public abstract Msg trace(String var1, Object ... var2);

    protected abstract void createLogObject(Class var1);

    protected abstract void createLogObject(String var1);

    static {
        try {
            s_dumpStackTraces = Boolean.getBoolean(SYSPROP_DUMP_STACK_TRACES);
        }
        catch (Exception e) {
            s_dumpStackTraces = false;
        }
        try {
            s_dumpKeys = Boolean.parseBoolean(System.getProperty(SYSPROP_DUMP_LOG_KEYS, "true"));
        }
        catch (Exception e) {
            s_dumpKeys = true;
        }
    }
}

