/*
 * Decompiled with CFR 0.152.
 */
package com.sos.graphviz;

import com.sos.graphviz.ClusterSubgraph;
import com.sos.graphviz.Edge;
import com.sos.graphviz.GlobalNodeProperties;
import com.sos.graphviz.GraphProperties;
import com.sos.graphviz.GraphvizObject;
import com.sos.graphviz.GraphvizObjectWithId;
import com.sos.graphviz.IGraphvizObject;
import com.sos.graphviz.Node;
import com.sos.graphviz.Subgraph;
import com.sos.graphviz.enums.RankType;
import com.sos.graphviz.enums.Shape;
import com.sos.graphviz.properties.GraphvizEnumProperty;
import com.sos.graphviz.properties.GraphvizProperty;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Graph
extends GraphvizObjectWithId
implements IGraphvizObject {
    private static final Logger LOGGER = LoggerFactory.getLogger(Graph.class);
    private static final String SHORTCUT_GRAPH = "G";
    private static final String PLACEHOLDER = "%id%";
    private static final String PROLOG = "digraph %id% {";
    private static final String PROLOG_SUBGRAPH = "subgraph %id% {";
    private static final String EPILOG = "}";
    private static final Pattern NON_WORD_PATTERN = Pattern.compile("\\s|\\W");
    private final GraphvizProperty fontsize = new GraphvizEnumProperty("fontsize");
    private final GraphProperties graphProperties = new GraphProperties();
    private final List<Node> nodeList = new ArrayList<Node>();
    private final List<Edge> edgeList = new ArrayList<Edge>();
    private final List<Subgraph> subgraphList = new ArrayList<Subgraph>();
    private GlobalNodeProperties globalNodeProperties = new GlobalNodeProperties(Shape.box);

    protected Graph(String subGraphId) {
        super(subGraphId, PROLOG_SUBGRAPH.replace(PLACEHOLDER, subGraphId), EPILOG);
        this.init();
    }

    public Graph() {
        super(SHORTCUT_GRAPH, PROLOG.replace(PLACEHOLDER, SHORTCUT_GRAPH), EPILOG);
        this.init();
    }

    @Override
    public GraphvizObject getProperties() {
        return this.graphProperties;
    }

    public void init() {
        this.edgeList.clear();
        this.nodeList.clear();
        this.subgraphList.clear();
    }

    protected String getQuoted(String pstrVal) {
        return "\"" + pstrVal.trim() + "\"";
    }

    public GlobalNodeProperties getGlobalNodeProperties() {
        return this.globalNodeProperties;
    }

    protected void setGlobalNodeProperties(GlobalNodeProperties globalNodeProperties) {
        this.globalNodeProperties = globalNodeProperties;
    }

    public Node getNodeOrNull(String id) {
        String quotedId = this.getQuoted(id);
        if (this.nodeList.isEmpty()) {
            LOGGER.debug("The graph {} contains no nodes.", (Object)this.getId());
        }
        Node result = null;
        for (Node n : this.nodeList) {
            if (!n.getId().equals(quotedId)) continue;
            result = n;
            break;
        }
        return result;
    }

    public Node getNodeOrNullInAllGraphs(String id) {
        Node result;
        block1: {
            Subgraph s;
            result = this.getNodeOrNull(id);
            if (result != null) break block1;
            Iterator<Subgraph> iterator = this.subgraphList.iterator();
            while (iterator.hasNext() && (result = (s = iterator.next()).getNodeOrNullInAllGraphs(id)) == null) {
            }
        }
        return result;
    }

    @Override
    public String getContent() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getProlog());
        sb.append(this.getMainContent());
        return sb.toString();
    }

    protected String getProlog() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.graphProperties.getSource());
        sb.append(this.globalNodeProperties.getSource());
        return sb.toString();
    }

    protected String getMainContent() {
        StringBuilder sb = new StringBuilder();
        Iterator<Node> nit = this.nodeList.iterator();
        for (Subgraph s : this.subgraphList) {
            sb.append(s.getSource());
        }
        while (nit.hasNext()) {
            Node n = nit.next();
            sb.append(n.getSource());
        }
        for (Edge e : this.edgeList) {
            sb.append(e.getSource());
        }
        return sb.toString();
    }

    public Node newNode(String node) {
        String quotedNode = this.getQuoted(node);
        Node n = new Node(quotedNode);
        this.nodeList.add(n);
        return n;
    }

    public Edge newEdge(Node nodeFrom, Node nodeTo) {
        Edge e = new Edge(nodeFrom, nodeTo);
        this.edgeList.add(e);
        return e;
    }

    public Edge newEdge(String from, String to) {
        Node nodeFrom = this.getNodeOrNull(from);
        Node nodeTo = this.getNodeOrNull(to);
        if (nodeFrom == null) {
            nodeFrom = this.newNode(from);
        }
        if (nodeTo == null) {
            nodeTo = this.newNode(to);
        }
        Edge e = new Edge(nodeFrom, nodeTo);
        this.edgeList.add(e);
        return e;
    }

    public Subgraph newSubgraph(String subgraphId, RankType rankType) {
        Subgraph s = new Subgraph(subgraphId, rankType, this);
        this.subgraphList.add(s);
        return s;
    }

    public Subgraph newSubgraph(String subgraphId) {
        return this.newSubgraph(subgraphId, RankType.same);
    }

    public ClusterSubgraph newClusterSubgraph(String subgraphId) {
        Matcher m = NON_WORD_PATTERN.matcher(subgraphId);
        String replacedSubgraphId = subgraphId;
        if (m.find()) {
            replacedSubgraphId = m.replaceAll("");
            LOGGER.warn("Subgraph label must not contain non word characters - all non word characters replaced.");
        }
        ClusterSubgraph s = new ClusterSubgraph(replacedSubgraphId, this);
        this.subgraphList.add(s);
        return s;
    }

    public GraphProperties getGraphProperties() {
        return this.graphProperties;
    }

    public String getFontsize() {
        return (String)this.fontsize.getValue();
    }

    public void setFontsize(String pstrFontSize) {
        this.fontsize.setValue(pstrFontSize);
    }
}

