/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.vfs.common.proxy.http;

import com.sos.commons.util.SOSString;
import com.sos.commons.vfs.common.proxy.Proxy;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.Base64;
import org.apache.commons.io.IOUtils;

public class HttpProxySocket
extends Socket {
    private final Proxy proxy;

    public HttpProxySocket(Proxy proxy) throws UnknownHostException, IOException {
        this.proxy = proxy;
    }

    @Override
    public void connect(SocketAddress endpoint, int timeout) throws IOException {
        super.connect(this.proxy.getProxy().address(), this.proxy.getConnectTimeout());
        String basicAuth = null;
        if (!SOSString.isEmpty((String)this.proxy.getUser())) {
            basicAuth = new String(Base64.getEncoder().encode(new String(this.proxy.getUser() + ":" + this.proxy.getPassword()).getBytes()));
        }
        InetSocketAddress address = (InetSocketAddress)endpoint;
        OutputStream out = this.getOutputStream();
        IOUtils.write((String)String.format("CONNECT %s:%s HTTP/1.0\r\n", address.getHostName(), address.getPort()), (OutputStream)out, (Charset)this.proxy.getCharset());
        if (basicAuth != null) {
            IOUtils.write((String)"Proxy-Authorization: Basic ", (OutputStream)out, (Charset)this.proxy.getCharset());
            IOUtils.write((String)basicAuth, (OutputStream)out, (Charset)this.proxy.getCharset());
        }
        IOUtils.write((String)"\r\n", (OutputStream)out, (Charset)this.proxy.getCharset());
        IOUtils.write((String)"\r\n", (OutputStream)out, (Charset)this.proxy.getCharset());
        out.flush();
        InputStream in = this.getInputStream();
        String response = new LineNumberReader(new InputStreamReader(in)).readLine();
        if (response == null) {
            throw new SocketException(String.format("[%s]missing response", ((InetSocketAddress)this.proxy.getProxy().address()).getHostName()));
        }
        if (!response.contains("200")) {
            throw new SocketException(String.format("[%s][invalid response]%s", ((InetSocketAddress)this.proxy.getProxy().address()).getHostName(), response));
        }
        in.skip(in.available());
    }
}

