/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.vfs.ssh;

import com.sos.commons.credentialstore.CredentialStoreArguments;
import com.sos.commons.exception.SOSMissingDataException;
import com.sos.commons.exception.SOSNoSuchFileException;
import com.sos.commons.exception.SOSRequiredArgumentMissingException;
import com.sos.commons.util.SOSString;
import com.sos.commons.util.common.SOSArgument;
import com.sos.commons.util.common.SOSCommandResult;
import com.sos.commons.util.common.SOSEnv;
import com.sos.commons.util.common.SOSTimeout;
import com.sos.commons.vfs.common.AProvider;
import com.sos.commons.vfs.common.AProviderArguments;
import com.sos.commons.vfs.common.CredentialStoreResolver;
import com.sos.commons.vfs.common.proxy.Proxy;
import com.sos.commons.vfs.common.proxy.ProxySocketFactory;
import com.sos.commons.vfs.exception.SOSAuthenticationFailedException;
import com.sos.commons.vfs.ssh.common.SSHProviderArguments;
import com.sos.commons.vfs.ssh.common.SSHProviderUtil;
import com.sos.commons.vfs.ssh.common.SSHServerInfo;
import com.sos.commons.vfs.ssh.exception.SOSSFTPClientNotInitializedException;
import com.sos.commons.vfs.ssh.exception.SOSSSHCommandExitViolentlyException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.SocketFactory;
import net.schmizz.keepalive.KeepAliveProvider;
import net.schmizz.sshj.Config;
import net.schmizz.sshj.DefaultConfig;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.Service;
import net.schmizz.sshj.common.IOUtils;
import net.schmizz.sshj.common.SSHException;
import net.schmizz.sshj.connection.channel.direct.Session;
import net.schmizz.sshj.connection.channel.direct.Signal;
import net.schmizz.sshj.sftp.FileAttributes;
import net.schmizz.sshj.sftp.FileMode;
import net.schmizz.sshj.sftp.RemoteResourceInfo;
import net.schmizz.sshj.sftp.Response;
import net.schmizz.sshj.sftp.SFTPClient;
import net.schmizz.sshj.sftp.SFTPException;
import net.schmizz.sshj.transport.TransportException;
import net.schmizz.sshj.transport.verification.HostKeyVerifier;
import net.schmizz.sshj.transport.verification.PromiscuousVerifier;
import net.schmizz.sshj.userauth.UserAuthException;
import net.schmizz.sshj.userauth.keyprovider.KeyProvider;
import net.schmizz.sshj.userauth.method.AuthKeyboardInteractive;
import net.schmizz.sshj.userauth.method.AuthMethod;
import net.schmizz.sshj.userauth.method.AuthPassword;
import net.schmizz.sshj.userauth.method.AuthPublickey;
import net.schmizz.sshj.userauth.method.ChallengeResponseProvider;
import net.schmizz.sshj.userauth.method.PasswordResponseProvider;
import net.schmizz.sshj.xfer.FileSystemFile;
import net.schmizz.sshj.xfer.LocalDestFile;
import net.schmizz.sshj.xfer.LocalSourceFile;

public class SSHProvider
extends AProvider<SSHProviderArguments> {
    private Config config;
    private SSHClient sshClient;
    private SFTPClient sftpClient;
    private Map<String, Session.Command> commands = new ConcurrentHashMap<String, Session.Command>();
    private SSHServerInfo serverInfo;
    private String serverVersion;

    public SSHProvider(SSHProviderArguments args) throws Exception {
        this(args, null);
    }

    public SSHProvider(SSHProviderArguments args, CredentialStoreArguments csArgs) throws Exception {
        super(args, csArgs);
        if (csArgs != null && CredentialStoreResolver.resolve(this.getArguments(), new SOSArgument[]{((SSHProviderArguments)((Object)this.getArguments())).getPassphrase()})) {
            CredentialStoreResolver.resolveAttachment(this.getArguments(), ((SSHProviderArguments)((Object)this.getArguments())).getAuthFile());
        }
    }

    @Override
    public void connect() throws Exception {
        if (SOSString.isEmpty((String)((String)((SSHProviderArguments)((Object)this.getArguments())).getHost().getValue()))) {
            throw new Exception("missing host");
        }
        this.createSSHClient();
        this.sshClient.connect((String)((SSHProviderArguments)((Object)this.getArguments())).getHost().getValue(), ((Integer)((SSHProviderArguments)((Object)this.getArguments())).getPort().getValue()).intValue());
        this.authenticate();
        this.setKeepAlive();
        this.serverVersion = this.sshClient.getTransport().getServerVersion();
        this.createSFTPClient();
    }

    @Override
    public boolean isConnected() {
        if (this.sshClient == null) {
            return false;
        }
        return this.sshClient.isConnected();
    }

    @Override
    public void disconnect() {
        this.commands = new ConcurrentHashMap<String, Session.Command>();
        if (this.sftpClient != null) {
            try {
                this.sftpClient.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.sftpClient = null;
            }
        }
        if (this.sshClient != null) {
            try {
                this.sshClient.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.sshClient = null;
            }
        }
    }

    @Override
    public void createDirectory(String path) throws Exception {
        if (this.sftpClient == null) {
            throw new SOSSFTPClientNotInitializedException();
        }
        if (SOSString.isEmpty((String)path)) {
            throw new SOSMissingDataException("path");
        }
        this.sftpClient.mkdir(path);
    }

    @Override
    public void createDirectories(String path) throws Exception {
        if (this.sftpClient == null) {
            throw new SOSSFTPClientNotInitializedException();
        }
        if (SOSString.isEmpty((String)path)) {
            throw new SOSMissingDataException("path");
        }
        this.sftpClient.mkdirs(path);
    }

    @Override
    public void delete(String path) throws Exception {
        if (this.sftpClient == null) {
            throw new SOSSFTPClientNotInitializedException();
        }
        if (SOSString.isEmpty((String)path)) {
            throw new SOSMissingDataException("path");
        }
        try {
            path = this.sftpClient.canonicalize(path);
        }
        catch (SFTPException e) {
            this.throwException(e, path);
        }
        FileAttributes attr = this.getFileAttributes(path);
        switch (attr.getType()) {
            case DIRECTORY: {
                this.deleteDirectories(path);
                break;
            }
            case REGULAR: {
                this.sftpClient.rm(path);
                break;
            }
        }
    }

    private void throwException(SFTPException e, String msg) throws Exception {
        Response.StatusCode sc = e.getStatusCode();
        if (sc != null && (sc.equals((Object)Response.StatusCode.NO_SUCH_FILE) || sc.equals((Object)Response.StatusCode.NO_SUCH_PATH))) {
            throw new SOSNoSuchFileException(msg, (Throwable)e);
        }
        throw e;
    }

    @Override
    public boolean deleteIfExists(String path) throws Exception {
        try {
            this.delete(path);
            return true;
        }
        catch (SOSNoSuchFileException e) {
            return false;
        }
    }

    private void deleteDirectories(String path) throws Exception {
        if (SOSString.isEmpty((String)path)) {
            throw new SOSMissingDataException("path");
        }
        LinkedList<RemoteResourceInfo> toRemove = new LinkedList<RemoteResourceInfo>();
        this.dirInfo(this.sftpClient, path, toRemove, true);
        while (!toRemove.isEmpty()) {
            RemoteResourceInfo resource = (RemoteResourceInfo)toRemove.pop();
            if (resource.isDirectory()) {
                this.sftpClient.rmdir(resource.getPath());
                continue;
            }
            if (!resource.isRegularFile()) continue;
            this.sftpClient.rm(resource.getPath());
        }
        this.sftpClient.rmdir(path);
    }

    @Override
    public void rename(String oldpath, String newpath) throws Exception {
        if (this.sftpClient == null) {
            throw new SOSSFTPClientNotInitializedException();
        }
        if (SOSString.isEmpty((String)oldpath) || SOSString.isEmpty((String)newpath)) {
            throw new SOSMissingDataException("oldpath or newpath");
        }
        try {
            oldpath = this.sftpClient.canonicalize(oldpath);
        }
        catch (SFTPException e) {
            this.throwException(e, oldpath);
        }
        this.sftpClient.rename(oldpath, newpath);
    }

    @Override
    public boolean exists(String path) {
        try {
            FileAttributes attr;
            if (!SOSString.isEmpty((String)path) && (attr = this.getFileAttributes(path)) != null) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    @Override
    public boolean isFile(String path) {
        return this.is(path, FileMode.Type.REGULAR);
    }

    @Override
    public boolean isDirectory(String path) {
        return this.is(path, FileMode.Type.DIRECTORY);
    }

    @Override
    public long getSize(String path) throws Exception {
        try {
            FileAttributes attr = this.getFileAttributes(path);
            if (attr != null) {
                return attr.getSize();
            }
        }
        catch (SFTPException e) {
            this.throwException(e, path);
        }
        return -1L;
    }

    @Override
    public long getModificationTime(String path) throws Exception {
        if (SOSString.isEmpty((String)path)) {
            throw new SOSMissingDataException("path");
        }
        try {
            FileAttributes attr = this.getFileAttributes(path);
            if (attr != null) {
                return attr.getMtime();
            }
        }
        catch (SFTPException e) {
            this.throwException(e, path);
        }
        return -1L;
    }

    private void setProxy() {
        Proxy proxy = ((SSHProviderArguments)((Object)this.getArguments())).getProxy();
        if (proxy != null) {
            this.sshClient.setSocketFactory((SocketFactory)((Object)new ProxySocketFactory(proxy)));
        }
    }

    public void put(String source, String target, int perm) throws Exception {
        this.put(source, target);
        this.sftpClient.chmod(target, perm);
    }

    public void put(String source, String target) throws Exception {
        if (this.sftpClient == null) {
            throw new SOSSFTPClientNotInitializedException();
        }
        this.sftpClient.put((LocalSourceFile)new FileSystemFile(source), target);
    }

    public void get(String source, String target) throws Exception {
        if (this.sftpClient == null) {
            throw new SOSSFTPClientNotInitializedException();
        }
        this.sftpClient.get(this.sftpClient.canonicalize(source), (LocalDestFile)new FileSystemFile(target));
    }

    @Override
    public SOSCommandResult executeCommand(String command) {
        return this.executeCommand(command, null, null);
    }

    @Override
    public SOSCommandResult executeCommand(String command, SOSTimeout timeout) {
        return this.executeCommand(command, timeout, null);
    }

    @Override
    public SOSCommandResult executeCommand(String command, SOSEnv env) {
        return this.executeCommand(command, null, env);
    }

    @Override
    public SOSCommandResult executeCommand(String command, SOSTimeout timeout, SOSEnv env) {
        SOSCommandResult result = new SOSCommandResult(command);
        if (this.sshClient == null) {
            return result;
        }
        String uuid = this.getUUID();
        try (Session session = this.sshClient.startSession();){
            if (((Boolean)((SSHProviderArguments)((Object)this.getArguments())).getSimulateShell().getValue()).booleanValue()) {
                session.allocateDefaultPTY();
            }
            result.setCommand(this.handleEnvs(command, session, env));
            try (Session.Command cmd = session.exec(result.getCommand());){
                this.commands.put(uuid, cmd);
                result.setStdOut(IOUtils.readFully((InputStream)cmd.getInputStream()).toString());
                result.setStdErr(IOUtils.readFully((InputStream)cmd.getErrorStream()).toString());
                if (timeout == null) {
                    cmd.join();
                } else {
                    cmd.join(timeout.getInterval(), timeout.getTimeUnit());
                }
                result.setExitCode(cmd.getExitStatus());
                if (result.getExitCode() == null && cmd.getExitSignal() != null) {
                    throw new SOSSSHCommandExitViolentlyException(cmd.getExitSignal(), cmd.getExitErrorMessage());
                }
            }
        }
        catch (Throwable e) {
            result.setException(e);
        }
        this.resetCommand(uuid);
        return result;
    }

    private synchronized String getUUID() {
        return UUID.randomUUID().toString();
    }

    public SOSCommandResult cancelCommands() {
        SOSCommandResult r = null;
        if (this.commands != null && this.commands.size() > 0) {
            r = new SOSCommandResult("Signal.KILL");
            Iterator<Map.Entry<String, Session.Command>> iterator = this.commands.entrySet().iterator();
            while (iterator.hasNext()) {
                try {
                    Session.Command command = iterator.next().getValue();
                    command.signal(Signal.KILL);
                    r.setExitCode(command.getExitStatus());
                }
                catch (SSHException e) {
                    r.setException((Throwable)e);
                }
                iterator.remove();
            }
        }
        return r;
    }

    private void resetCommand(String uuid) {
        this.commands.remove(uuid);
    }

    public SSHServerInfo getServerInfo() {
        if (this.serverInfo == null) {
            this.serverInfo = new SSHServerInfo(this.serverVersion, this.executeCommand("uname"));
        }
        return this.serverInfo;
    }

    private FileAttributes getFileAttributes(String path) throws Exception {
        if (this.sftpClient == null) {
            throw new SOSSFTPClientNotInitializedException();
        }
        if (SOSString.isEmpty((String)path)) {
            throw new SOSMissingDataException("path");
        }
        return this.sftpClient.stat(path);
    }

    public SSHClient getSSHClient() {
        return this.sshClient;
    }

    private void createSSHClient() throws Exception {
        this.setConfig();
        this.setKeepAliveProvider();
        this.sshClient = new SSHClient(this.config);
        this.setHostKeyVerifier();
        this.setCompression();
        this.setRemoteCharset();
        this.setTimeout();
        this.setProxy();
    }

    private void createSFTPClient() throws Exception {
        if (this.sshClient == null || !((AProviderArguments.Protocol)((Object)((SSHProviderArguments)((Object)this.getArguments())).getProtocol().getValue())).equals((Object)AProviderArguments.Protocol.SFTP)) {
            return;
        }
        this.sftpClient = this.sshClient.newSFTPClient();
    }

    private void setConfig() {
        this.config = new DefaultConfig();
    }

    private void setKeepAliveProvider() {
        if (!((SSHProviderArguments)((Object)this.getArguments())).getServerAliveInterval().isEmpty()) {
            this.config.setKeepAliveProvider(KeepAliveProvider.KEEP_ALIVE);
        }
    }

    private void setKeepAlive() {
        if (!((SSHProviderArguments)((Object)this.getArguments())).getServerAliveInterval().isEmpty()) {
            this.sshClient.getConnection().getKeepAlive().setKeepAliveInterval(((Integer)((SSHProviderArguments)((Object)this.getArguments())).getServerAliveInterval().getValue()).intValue());
        }
    }

    private void setHostKeyVerifier() throws IOException {
        if (((Boolean)((SSHProviderArguments)((Object)this.getArguments())).getStrictHostkeyChecking().getValue()).booleanValue()) {
            if (((SSHProviderArguments)((Object)this.getArguments())).getHostkeyLocation().isEmpty()) {
                this.sshClient.loadKnownHosts();
            } else {
                this.sshClient.loadKnownHosts(((Path)((SSHProviderArguments)((Object)this.getArguments())).getHostkeyLocation().getValue()).toFile());
            }
        } else {
            this.sshClient.addHostKeyVerifier((HostKeyVerifier)new PromiscuousVerifier());
        }
    }

    private void setCompression() throws TransportException {
        if (((Boolean)((SSHProviderArguments)((Object)this.getArguments())).getUseZlibCompression().getValue()).booleanValue()) {
            this.sshClient.useCompression();
        }
    }

    private void setRemoteCharset() throws TransportException {
        this.sshClient.setRemoteCharset((Charset)((SSHProviderArguments)((Object)this.getArguments())).getRemoteCharset().getValue());
    }

    private void setTimeout() {
        this.sshClient.setTimeout(((SSHProviderArguments)((Object)this.getArguments())).getSocketTimeoutAsMs().intValue());
        this.sshClient.setConnectTimeout(((SSHProviderArguments)((Object)this.getArguments())).getConnectTimeoutAsMs().intValue());
    }

    private void authenticate() throws Exception {
        if (!((SSHProviderArguments)((Object)this.getArguments())).getPreferredAuthentications().isEmpty()) {
            this.usePreferredAuthentications();
        } else if (!((SSHProviderArguments)((Object)this.getArguments())).getRequiredAuthentications().isEmpty()) {
            this.useRequiredAuthentications();
        } else {
            this.useAuthMethodAuthentication();
        }
    }

    private void usePreferredAuthentications() throws Exception {
        LinkedList<Object> methods = new LinkedList<Object>();
        for (SSHProviderArguments.AuthMethod am : (List)((SSHProviderArguments)((Object)this.getArguments())).getPreferredAuthentications().getValue()) {
            switch (am) {
                case PUBLICKEY: {
                    methods.add(this.getAuthPublickey());
                    break;
                }
                case PASSWORD: {
                    methods.add(this.getAuthPassword());
                    break;
                }
                case KEYBOARD_INTERACTIVE: {
                    methods.add(this.getAuthKeyboardInteractive());
                }
            }
        }
        this.sshClient.auth((String)((SSHProviderArguments)((Object)this.getArguments())).getUser().getValue(), methods);
    }

    private void useRequiredAuthentications() throws Exception {
        for (SSHProviderArguments.AuthMethod am : (List)((SSHProviderArguments)((Object)this.getArguments())).getRequiredAuthentications().getValue()) {
            switch (am) {
                case PUBLICKEY: {
                    this.partialAuthentication((AuthMethod)this.getAuthPublickey());
                    break;
                }
                case PASSWORD: {
                    this.partialAuthentication((AuthMethod)this.getAuthPassword());
                    break;
                }
                case KEYBOARD_INTERACTIVE: {
                    this.partialAuthentication((AuthMethod)this.getAuthKeyboardInteractive());
                }
            }
        }
    }

    private void partialAuthentication(AuthMethod method) throws SOSAuthenticationFailedException, UserAuthException, TransportException {
        if (!this.sshClient.getUserAuth().authenticate((String)((SSHProviderArguments)((Object)this.getArguments())).getUser().getValue(), (Service)this.sshClient.getConnection(), method, this.sshClient.getTransport().getTimeoutMs()) && !this.sshClient.getUserAuth().hadPartialSuccess()) {
            throw new SOSAuthenticationFailedException();
        }
    }

    private void useAuthMethodAuthentication() throws Exception {
        if (((SSHProviderArguments)((Object)this.getArguments())).getAuthMethod().getValue() == null) {
            throw new SOSRequiredArgumentMissingException(((SSHProviderArguments)((Object)this.getArguments())).getAuthMethod().getName());
        }
        AuthPublickey method = null;
        switch ((SSHProviderArguments.AuthMethod)((Object)((SSHProviderArguments)((Object)this.getArguments())).getAuthMethod().getValue())) {
            case PUBLICKEY: {
                method = this.getAuthPublickey();
                break;
            }
            case PASSWORD: {
                method = this.getAuthPassword();
                break;
            }
            case KEYBOARD_INTERACTIVE: {
                method = this.getAuthKeyboardInteractive();
            }
        }
        this.sshClient.auth((String)((SSHProviderArguments)((Object)this.getArguments())).getUser().getValue(), new AuthMethod[]{method});
    }

    private AuthPassword getAuthPassword() throws SOSRequiredArgumentMissingException, UserAuthException, TransportException {
        if (((SSHProviderArguments)((Object)this.getArguments())).getPassword().isEmpty()) {
            throw new SOSRequiredArgumentMissingException(((SSHProviderArguments)((Object)this.getArguments())).getPassword().getName());
        }
        return new AuthPassword(SSHProviderUtil.getPasswordFinder((String)((SSHProviderArguments)((Object)this.getArguments())).getPassword().getValue()));
    }

    private AuthKeyboardInteractive getAuthKeyboardInteractive() throws SOSRequiredArgumentMissingException, UserAuthException, TransportException {
        if (((SSHProviderArguments)((Object)this.getArguments())).getPassword().isEmpty()) {
            throw new SOSRequiredArgumentMissingException(((SSHProviderArguments)((Object)this.getArguments())).getPassword().getName());
        }
        return new AuthKeyboardInteractive((ChallengeResponseProvider)new PasswordResponseProvider(SSHProviderUtil.getPasswordFinder((String)((SSHProviderArguments)((Object)this.getArguments())).getPassword().getValue())));
    }

    private AuthPublickey getAuthPublickey() throws Exception {
        KeyProvider keyProvider = null;
        if (((SSHProviderArguments)((Object)this.getArguments())).getKeepassDatabase() != null && ((SSHProviderArguments)((Object)this.getArguments())).getKeepassDatabaseEntry() != null && !SOSString.isEmpty((String)((SSHProviderArguments)((Object)this.getArguments())).getKeepassAttachmentPropertyName())) {
            keyProvider = SSHProviderUtil.getKeyProviderFromKeepass(this.sshClient, (SSHProviderArguments)((Object)this.getArguments()));
        } else {
            if (SOSString.isEmpty((String)((String)((SSHProviderArguments)((Object)this.getArguments())).getAuthFile().getValue()))) {
                throw new SOSRequiredArgumentMissingException(((SSHProviderArguments)((Object)this.getArguments())).getAuthFile().getName());
            }
            Path authFile = Paths.get((String)((SSHProviderArguments)((Object)this.getArguments())).getAuthFile().getValue(), new String[0]);
            keyProvider = ((SSHProviderArguments)((Object)this.getArguments())).getPassphrase().isEmpty() ? this.sshClient.loadKeys(authFile.toFile().getCanonicalPath()) : this.sshClient.loadKeys(authFile.toFile().getCanonicalPath(), (String)((SSHProviderArguments)((Object)this.getArguments())).getPassphrase().getValue());
        }
        return new AuthPublickey(keyProvider);
    }

    private String handleEnvs(String command, Session session, SOSEnv env) throws Exception {
        if (env == null) {
            return command;
        }
        if (env.getGlobalEnvs() != null && env.getGlobalEnvs().size() > 0) {
            for (Map.Entry entry : env.getGlobalEnvs().entrySet()) {
                try {
                    session.setEnvVar((String)entry.getKey(), (String)entry.getValue());
                }
                catch (Throwable e) {
                    throw new Exception(String.format("[can't set ssh session environment variable][%s=%s]%s", entry.getKey(), entry.getValue(), e.toString()), e);
                }
            }
        }
        if (env.getLocalEnvs() != null && env.getLocalEnvs().size() > 0) {
            this.getServerInfo();
            StringBuilder envs = new StringBuilder();
            for (Map.Entry entry : env.getLocalEnvs().entrySet()) {
                if (this.serverInfo.hasWindowsShell()) {
                    envs.append(String.format("set %s=%s&", entry.getKey(), entry.getValue()));
                    continue;
                }
                envs.append(String.format("export \"%s=%s\";", entry.getKey(), entry.getValue()));
            }
            command = envs.toString() + (String)command;
        }
        return command;
    }

    private void dirInfo(SFTPClient client, String path, Deque<RemoteResourceInfo> result, boolean recursive) throws Exception {
        List infos = client.ls(path);
        for (RemoteResourceInfo resource : infos) {
            result.push(resource);
            if (!recursive || !resource.isDirectory()) continue;
            this.dirInfo(client, resource.getPath(), result, recursive);
        }
    }

    private boolean is(String path, FileMode.Type type) {
        try {
            FileAttributes attr = this.getFileAttributes(path);
            if (attr != null) {
                return type.equals((Object)attr.getType());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }
}

