/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.vfs.ssh.common;

import com.sos.commons.util.SOSString;
import com.sos.commons.util.common.SOSCommandResult;
import java.lang.invoke.CallSite;
import java.util.ArrayList;

public class SSHServerInfo {
    private final String serverVersion;
    private final SOSCommandResult commandResult;
    private String os = OS.UNKNOWN.name();
    private Shell shell = Shell.UNKNOWN;

    public SSHServerInfo(String serverVersion, SOSCommandResult commandResult) {
        this.serverVersion = serverVersion;
        this.commandResult = commandResult;
        this.analyze();
    }

    private void analyze() {
        if (this.commandResult == null) {
            return;
        }
        if (this.commandResult.getExitCode() == null) {
            if (this.commandResult.getStdErr().length() > 0) {
                this.os = OS.WINDOWS.name();
            } else {
                this.analyzeServerVersion();
            }
            return;
        }
        switch (this.commandResult.getExitCode()) {
            case 0: {
                String stdOut = this.commandResult.getStdOut().trim();
                if (stdOut.matches("(?i).*(linux|darwin|aix|hp-ux|solaris|sunos|freebsd).*")) {
                    this.os = stdOut;
                    this.shell = Shell.UNIX;
                    break;
                }
                if (stdOut.matches("(?i).*cygwin.*")) {
                    this.os = OS.WINDOWS.name();
                    this.shell = Shell.CYGWIN;
                    break;
                }
                this.analyzeServerVersion();
                this.shell = Shell.UNIX;
                break;
            }
            case 1: 
            case 9009: {
                this.os = OS.WINDOWS.name();
                this.shell = Shell.WINDOWS;
                break;
            }
            case 127: {
                this.os = OS.WINDOWS.name();
                this.shell = Shell.CYGWIN;
                break;
            }
            default: {
                this.analyzeServerVersion();
                this.shell = Shell.UNKNOWN;
            }
        }
    }

    private void analyzeServerVersion() {
        if (!SOSString.isEmpty((String)this.serverVersion) && this.serverVersion.toUpperCase().contains(OS.WINDOWS.name())) {
            this.os = OS.WINDOWS.name();
        }
    }

    public String getOS() {
        return this.os;
    }

    public Shell getShell() {
        return this.shell;
    }

    public SOSCommandResult getCommandResult() {
        return this.commandResult;
    }

    public String getServerVersion() {
        return this.serverVersion;
    }

    public boolean hasWindowsShell() {
        return this.shell.equals((Object)Shell.WINDOWS);
    }

    public String toString() {
        ArrayList<CallSite> l = new ArrayList<CallSite>();
        if (this.serverVersion != null) {
            l.add((CallSite)((Object)("Identity=" + this.serverVersion)));
        }
        l.add((CallSite)((Object)("OS=" + this.os)));
        l.add((CallSite)((Object)("Shell=" + this.shell.name())));
        StringBuilder result = new StringBuilder("Server ");
        result.append(String.join((CharSequence)", ", l));
        if (this.commandResult.hasError(false)) {
            result.append(" (");
            result.append(this.commandResult.getCommand());
            if (this.commandResult.getExitCode() != null && this.commandResult.getExitCode() > 0) {
                result.append(" exitCode=").append(this.commandResult.getExitCode());
            }
            if (this.commandResult.getException() != null) {
                result.append(" ").append(this.commandResult.getException().toString());
            }
            result.append(")");
        }
        return result.toString();
    }

    public static enum OS {
        UNKNOWN,
        UNIX,
        WINDOWS;

    }

    public static enum Shell {
        UNKNOWN,
        UNIX,
        WINDOWS,
        CYGWIN;

    }
}

