/*
 * Decompiled with CFR 0.152.
 */
package com.sos.xml;

import com.sos.exception.SOSDoctypeException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLBuilder {
    private Element root;

    public XMLBuilder(String name) {
        this.root = DocumentHelper.createElement((String)name);
    }

    public Element getRoot() {
        return this.root;
    }

    public static Element create(String name) {
        return new XMLBuilder(name).getRoot();
    }

    public static Document parse(String xmlString) throws DocumentException, SAXException, IOException, SOSDoctypeException {
        return XMLBuilder.parse(new StringReader(xmlString));
    }

    public static Document parse(Reader reader) throws DocumentException, SAXException, IOException, SOSDoctypeException {
        Document doc;
        SAXReader saxReader = XMLBuilder.createSaxReader();
        try {
            doc = saxReader.read(reader);
        }
        catch (DocumentException e) {
            Throwable nested = e.getCause();
            if (nested != null && SAXParseException.class.isInstance(nested) && nested.getMessage().toUpperCase().contains("DOCTYPE")) {
                throw new SOSDoctypeException("A DOCTYPE was passed into the XML document", e);
            }
            if (nested != null && IOException.class.isInstance(nested)) {
                throw new IOException("IOException occurred, XXE may still possible: " + e.getMessage(), e);
            }
            throw e;
        }
        return doc;
    }

    public static Document parse(InputStream stream) throws DocumentException, SAXException, IOException {
        Document doc;
        SAXReader saxReader = XMLBuilder.createSaxReader();
        try {
            doc = saxReader.read(stream);
        }
        catch (DocumentException e) {
            Throwable nested = e.getCause();
            if (nested != null && SAXParseException.class.isInstance(nested) && nested.getMessage().toUpperCase().contains("DOCTYPE")) {
                throw new SAXException("A DOCTYPE was passed into the XML document", (Exception)((Object)e));
            }
            if (nested != null && IOException.class.isInstance(nested)) {
                throw new IOException("IOException occurred, XXE may still possible: " + e.getMessage(), e);
            }
            throw e;
        }
        return doc;
    }

    public Element addElement(String name) {
        return this.root.addElement(name);
    }

    public Element addAttribute(String key, String value) {
        return this.root.addAttribute(key, value);
    }

    public void add(Element elem) {
        this.root.add(elem);
    }

    public String asXML() {
        return this.root.asXML();
    }

    public static SAXReader createSaxReader() throws SAXException {
        SAXReader saxReader = new SAXReader();
        saxReader.setIncludeExternalDTDDeclarations(false);
        saxReader.setIncludeInternalDTDDeclarations(false);
        saxReader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        saxReader.setFeature("http://xml.org/sax/features/external-general-entities", false);
        saxReader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        saxReader.setEntityResolver((publicId, systemId) -> new InputSource(new StringReader("")));
        saxReader.setValidation(false);
        saxReader.setStripWhitespaceText(true);
        saxReader.setIgnoreComments(true);
        return saxReader;
    }
}

