/*
 * Decompiled with CFR 0.152.
 */
package sos.xml;

import com.sos.exception.SOSDoctypeException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.file.Path;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.xpath.CachedXPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import sos.util.SOSClassUtil;

public class SOSXMLXPath
extends CachedXPathAPI {
    private Document document = null;
    private Element root = null;
    private Node node = null;

    public SOSXMLXPath(StringBuffer xmlStr) throws Exception {
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            docFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            docFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            docFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            docFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            docFactory.setXIncludeAware(false);
            docFactory.setExpandEntityReferences(false);
            docFactory.setNamespaceAware(false);
            docFactory.setValidating(false);
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            docBuilder.setEntityResolver((publicId, systemId) -> new InputSource(new StringReader("")));
            this.document = docBuilder.parse(new InputSource(new StringReader(xmlStr.toString())));
            this.root = this.document.getDocumentElement();
        }
        catch (SAXException e) {
            if (e.getMessage().toUpperCase().contains("DOCTYPE")) {
                throw new SOSDoctypeException("A DOCTYPE was passed into the XML document", e);
            }
            throw e;
        }
        catch (IOException e) {
            throw new IOException("IOException occurred, XXE may still possible: " + e.getMessage(), e);
        }
    }

    public SOSXMLXPath(String filename) throws Exception {
        try {
            InputSource in = new InputSource(new FileInputStream(filename));
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            docFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            docFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            docFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            docFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            docFactory.setXIncludeAware(false);
            docFactory.setExpandEntityReferences(false);
            docFactory.setNamespaceAware(false);
            docFactory.setValidating(false);
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            docBuilder.setEntityResolver((publicId, systemId) -> new InputSource(new StringReader("")));
            this.document = docBuilder.parse(in);
            this.root = this.document.getDocumentElement();
        }
        catch (SAXException e) {
            if (e.getMessage().toUpperCase().contains("DOCTYPE")) {
                throw new SOSDoctypeException("A DOCTYPE was passed into the XML document", e);
            }
            throw e;
        }
        catch (IOException e) {
            throw new IOException("IOException occurred, XXE may still possible: " + e.getMessage(), e);
        }
    }

    public SOSXMLXPath(Path filename) throws Exception {
        try {
            InputSource in = new InputSource(new FileInputStream(filename.toFile()));
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            docFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            docFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            docFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            docFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            docFactory.setXIncludeAware(false);
            docFactory.setExpandEntityReferences(false);
            docFactory.setNamespaceAware(false);
            docFactory.setValidating(false);
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            docBuilder.setEntityResolver((publicId, systemId) -> new InputSource(new StringReader("")));
            this.document = docBuilder.parse(in);
            this.root = this.document.getDocumentElement();
        }
        catch (SAXException e) {
            if (e.getMessage().toUpperCase().contains("DOCTYPE")) {
                throw new SOSDoctypeException("A DOCTYPE was passed into the XML document", e);
            }
            throw e;
        }
        catch (IOException e) {
            throw new IOException("IOException occurred, XXE may still possible: " + e.getMessage(), e);
        }
    }

    public SOSXMLXPath(InputStream stream) throws Exception {
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            docFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            docFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            docFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            docFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            docFactory.setXIncludeAware(false);
            docFactory.setExpandEntityReferences(false);
            docFactory.setNamespaceAware(false);
            docFactory.setValidating(false);
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            docBuilder.setEntityResolver((publicId, systemId) -> new InputSource(new StringReader("")));
            this.document = docBuilder.parse(stream);
            this.root = this.document.getDocumentElement();
        }
        catch (SAXException e) {
            if (e.getMessage().toUpperCase().contains("DOCTYPE")) {
                throw new SOSDoctypeException("A DOCTYPE was passed into the XML document", e);
            }
            throw e;
        }
        catch (IOException e) {
            throw new IOException("IOException occurred, XXE may still possible: " + e.getMessage(), e);
        }
    }

    public SOSXMLXPath(InputStream stream, boolean xInclude) throws Exception {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance("org.apache.xerces.jaxp.DocumentBuilderFactoryImpl", ((Object)((Object)this)).getClass().getClassLoader());
            dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            dbf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            dbf.setFeature("http://xml.org/sax/features/external-general-entities", false);
            dbf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            dbf.setExpandEntityReferences(false);
            dbf.setNamespaceAware(true);
            dbf.setXIncludeAware(xInclude);
            DocumentBuilder docBuilder = dbf.newDocumentBuilder();
            docBuilder.setEntityResolver((publicId, systemId) -> new InputSource(new StringReader("")));
            this.document = docBuilder.parse(stream);
            this.root = this.document.getDocumentElement();
        }
        catch (SAXException e) {
            if (e.getMessage().toUpperCase().contains("DOCTYPE")) {
                throw new SOSDoctypeException("A DOCTYPE was passed into the XML document", e);
            }
            throw e;
        }
        catch (IOException e) {
            throw new IOException("IOException occurred, XXE may still possible: " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new Exception(SOSClassUtil.getMethodName() + ": " + e.toString());
        }
    }

    public Node selectSingleNode(String xpathExpression) throws Exception {
        return this.selectSingleNode(this.document.getDocumentElement(), xpathExpression);
    }

    public String selectSingleNodeValue(String xpathExpression) throws Exception {
        return this.selectSingleNodeValue(this.document.getDocumentElement(), xpathExpression);
    }

    public String selectSingleNodeValue(String xpathExpression, String default_) throws Exception {
        return this.selectSingleNodeValue(this.document.getDocumentElement(), xpathExpression, default_);
    }

    public String selectSingleNodeValue(Node context, String xpathExpression) throws Exception {
        Node node = this.selectSingleNode(context, xpathExpression);
        if (node != null) {
            return this.getNodeText(node);
        }
        return null;
    }

    public String selectSingleNodeValue(Node context, String xpathExpression, String default_) throws Exception {
        Node node = this.selectSingleNode(context, xpathExpression);
        if (node != null) {
            return this.getNodeText(node);
        }
        return default_;
    }

    public NodeList selectNodeList(String xpathExpression) throws Exception {
        return this.selectNodeList(this.document.getDocumentElement(), xpathExpression);
    }

    public String selectDocumentText(String xpathExpression) throws Exception {
        return this.selectDocumentText(this.document.getDocumentElement(), xpathExpression);
    }

    public String selectDocumentText(Node context, String xpathExpression) throws Exception {
        return this.selectDocumentText(context, xpathExpression, false);
    }

    public String selectDocumentText(Node context, String xpathExpression, boolean withXMLDeclaration) throws Exception {
        Node node = this.selectSingleNode(context, xpathExpression);
        if (node == null) {
            return "";
        }
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        Document document = docBuilder.newDocument();
        document.appendChild(document.importNode(node, true));
        return this.selectDocumentText(document, withXMLDeclaration);
    }

    public String selectDocumentText(Document document, boolean withXMLDeclaration) throws Exception {
        StringWriter sw = null;
        try {
            sw = new StringWriter();
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", withXMLDeclaration ? "yes" : "no");
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.transform(new DOMSource(document), new StreamResult(sw));
            String string = sw.toString();
            return string;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (sw != null) {
                try {
                    sw.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public Document getDocument() throws Exception {
        return this.document;
    }

    public Element getElement() throws Exception {
        return (Element)this.node;
    }

    public String getNodeText(Node node) {
        String strRet = "";
        if (null != node) {
            NodeList children = node.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node item = children.item(i);
                switch (item.getNodeType()) {
                    case 3: 
                    case 4: {
                        strRet = strRet + item.getNodeValue();
                    }
                }
            }
        }
        return strRet;
    }

    public Element getRoot() {
        return this.root;
    }
}

