/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jade.db;

import com.sos.hibernate.classes.DbItem;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

@Entity
@Table(name="YADE_FILES")
@SequenceGenerator(name="YADE_FI_ID_SEQ", sequenceName="YADE_FI_ID_SEQ", allocationSize=1)
public class DBItemYadeFiles
extends DbItem
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String YADE_FILES_SEQUENCE = "YADE_FI_ID_SEQ";
    private Long id;
    private Long transferId;
    private Long interventionTransferId;
    private String sourcePath;
    private String targetPath;
    private Long size;
    private Date modificationDate;
    private Integer state;
    private String errorCode;
    private String errorMessage;
    private String integrityHash;
    private Date modified;

    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="YADE_FI_ID_SEQ")
    @Column(name="[ID]", nullable=false)
    public Long getId() {
        return this.id;
    }

    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="YADE_FI_ID_SEQ")
    @Column(name="[ID]", nullable=false)
    public void setId(Long id) {
        this.id = id;
    }

    @Column(name="[TRANSFER_ID]", nullable=false)
    public Long getTransferId() {
        return this.transferId;
    }

    @Column(name="[TRANSFER_ID]", nullable=false)
    public void setTransferId(Long transferId) {
        this.transferId = transferId;
    }

    @Column(name="[INTERVENTION_TRANSFER_ID]", nullable=true)
    public Long getInterventionTransferId() {
        return this.interventionTransferId;
    }

    @Column(name="[INTERVENTION_TRANSFER_ID]", nullable=true)
    public void setInterventionTransferId(Long interventionTransferId) {
        this.interventionTransferId = interventionTransferId;
    }

    @Column(name="[SOURCE_PATH]", nullable=false)
    public String getSourcePath() {
        return this.sourcePath;
    }

    @Column(name="[SOURCE_PATH]", nullable=false)
    public void setSourcePath(String sourcePath) {
        this.sourcePath = sourcePath;
    }

    @Column(name="[TARGET_PATH]", nullable=true)
    public String getTargetPath() {
        return this.targetPath;
    }

    @Column(name="[TARGET_PATH]", nullable=true)
    public void setTargetPath(String targetPath) {
        this.targetPath = targetPath;
    }

    @Column(name="[SIZE]", nullable=true)
    public Long getSize() {
        return this.size;
    }

    @Column(name="[SIZE]", nullable=true)
    public void setSize(Long size) {
        this.size = size;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="[MODIFICATION_DATE]", nullable=true)
    public Date getModificationDate() {
        return this.modificationDate;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="[MODIFICATION_DATE]", nullable=true)
    public void setModificationDate(Date modificationDate) {
        this.modificationDate = modificationDate;
    }

    @Column(name="[STATE]", nullable=false)
    public Integer getState() {
        return this.state;
    }

    @Column(name="[STATE]", nullable=false)
    public void setState(Integer state) {
        this.state = state;
    }

    @Column(name="[ERROR_CODE]", nullable=true)
    public String getErrorCode() {
        return this.errorCode;
    }

    @Column(name="[ERROR_CODE]", nullable=true)
    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    @Column(name="[ERROR_MESSAGE]", nullable=true)
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Column(name="[ERROR_MESSAGE]", nullable=true)
    public void setErrorMessage(String errorMessage) {
        this.errorMessage = DBItemYadeFiles.normalizeErrorMessage(errorMessage);
    }

    @Transient
    public static String normalizeErrorMessage(String val) {
        return DBItemYadeFiles.normalizeValue((String)val, (int)4000);
    }

    @Column(name="[INTEGRITY_HASH]", nullable=true)
    public String getIntegrityHash() {
        return this.integrityHash;
    }

    @Column(name="[INTEGRITY_HASH]", nullable=true)
    public void setIntegrityHash(String integrityHash) {
        this.integrityHash = integrityHash;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="[MODIFIED]", nullable=false)
    public Date getModified() {
        return this.modified;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="[MODIFIED]", nullable=false)
    public void setModified(Date modified) {
        this.modified = modified;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.transferId).append((Object)this.sourcePath).toHashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof DBItemYadeFiles)) {
            return false;
        }
        DBItemYadeFiles rhs = (DBItemYadeFiles)other;
        return new EqualsBuilder().append((Object)this.transferId, (Object)rhs.transferId).append((Object)this.sourcePath, (Object)rhs.sourcePath).isEquals();
    }
}

